<?php

class rhc_advent_shortcode {
	function __construct(){
		add_filter('calendarize_atts', array( &$this, 'calendarize_atts'), 10, 3 );
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'),10,2);
	}
	
	function calendarize_atts( $atts, $content, $code ){
		if( isset( $atts['advent_start'] ) && !empty( $atts['advent_start']  ) ){
			$atts['advent']='1';
			$atts['post_type']=RHCADVENT_POST_TYPE;
			
			$class = isset( $atts['advent_animation'] ) ? $atts['advent_animation'] : '';
			$class = empty($class) ? 'advent_default' : sprintf('advent_%s',$class);
			if( isset( $atts['class'] ) ){
				$atts['class'] .= ' ' . $class;
			}else{
				$atts['class'] = $class;
			}
		}
		
		return $atts;
	}
	
	function get_calendarize_args_options( $options, $atts ){
		if( isset( $atts['advent'] ) && '1'==$atts['advent'] ){
			foreach( array('advent_start','advent_end','gotodate') as $field ){
				if( isset( $atts[$field] ) ){
					$drr = explode('-', $atts[$field]);
					if( 3==count($drr) ){
						$atts[$field] = date('Y-m-d', mktime( 0,0,0,$drr[1], $drr[2], $drr[0] ) );
					}
				}
			}
			foreach( $options->modes as $mode_index => $mode ){
				//remove automatic map button
				$options->modes[$mode_index]['options']->header->right = str_replace( ',rhc_gmap', '', $options->modes[$mode_index]['options']->header->right );

				//goto advent date
				if( !isset( $atts['gotodate'] ) ){
					$atts['gotodate'] = $atts['advent_start'];
					$options->modes[$mode_index]['options']->gotodate = $atts['gotodate'];
				}	
				
				$options->modes[$mode_index]['options']->advent = $this->get_advent_options( $atts );				
			}
/*			
			echo "<pre>";
			print_r($atts);
			print_r($options);
			echo "</pre>";	
*/			
			wp_enqueue_style( 'rhcadvent' );
			wp_enqueue_script( 'rhcadvent' );
		}
	
		return $options;
	}
	
	function get_advent_options( $atts ){
		global $rhc_plugin;
		
		$end = isset( $atts['advent_end'] ) ? $atts['advent_end'] : date('Y-m-d', mktime(0,0,0,12,25,date('Y')) ) ;
	
		$o = (object)array(
			'start' 		=> $atts['advent_start'],
			'end'			=> $end
		);
		
		$fields = array(
			'close_seconds',
			'color',
			'background_color',
			'images'
		);
		
		foreach( $fields as $field ){
			$option_name = 'advent_' . $field;
			if( isset( $atts[ $option_name ] ) ){
				$o->$field = $atts[ $option_name ];
			}else{
				$o->$field = $rhc_plugin->get_option( $option_name, '', true );
			}
		}
		
		$o->close_seconds = intval( $o->close_seconds );
		
		foreach( array('color','background_color') as $field ){
			$o->$field = '#'==$o->$field ? '' : $o->$field ;
		}
		
		return $o;
	}
}

?>