<?php 

class rhc_advent_options {
	var $id;
	function __construct($plugin_id='rhc'){
		$this->id = $plugin_id;
		add_filter("pop-options_{$this->id}",array(&$this,'options'),10,1);	
		add_action('pop_handle_save',array(&$this,'pop_handle_save'),50,1);		
	}
	
	function pop_handle_save(){
		if( isset( $_POST['advent_restore_images'] ) ){
			global $rhc_plugin;
			$images = $this->get_bundled_images();
			$rhc_plugin->update_option('advent_images', implode(',',$images));
		}
	}
	
	function options( $t ){
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhc-advent'; 
		$t[$i]->label 		= __('Advent Item','rhcadvent');
		$t[$i]->right_label	= __('Advent Item options','rhcadvent');
		$t[$i]->page_title	= __('Advent Item','rhcadvent');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array();	

		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Advent post type','rhcadvent')
			);

		$t[$i]->options[] =	(object)array(
				'id'			=> 'rhc-advent-slug',
				'type' 			=> 'text',
				'label'			=> __('Advent item post type slug','rhcadvent'),
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Default settings','rhcadvent')
			);
			
		$t[$i]->options[] = (object)array(
				'id'	=> 'advent_color',
				'type'	=> 'farbtastic',
				'label'	=> __('Text color','rhcadvent'),
				'save_option'=>true,
				'load_option'=>true
			);
			
		$t[$i]->options[] = (object)array(
				'id'	=> 'advent_background_color',
				'type'	=> 'farbtastic',
				'label'	=> __('Background color','rhcadvent'),
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[] =	(object)array(
				'id'			=> 'advent_close_seconds',
				'type' 			=> 'range',
				'min'			=> 0,
				'max'			=> 20,
				'step'			=> 1,
				'default'		=>0,				
				'label'			=> __('Close seconds','rhcadvent'),
				'description'	=> __('Leave empty or zero to never close it.  Choose a positive value in seconds to return the overlay to its closed state after the set amount.','rhcadvent'),
				'save_option'=>true,
				'load_option'=>true
			);
			
		$arr = $this->get_bundled_images();

		$t[$i]->options[] = (object)array(
				'id'	=> 'advent_images',
				'type'	=> 'textarea',
				'label'	=> __('Overlay images','rhcadvent'),
				'description' => __('Add comma separated image urls to use as overlay images.  If not enough images are added, the script will loop throught the provided ones.','rhcadvent'),
				'default'	=> implode(',',$arr),
				'el_properties' => array('class'=>'widefat','rows'=>'10'),
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[] = (object)array(
				'id'	=> 'advent_restore_images',
				'type'	=> 'checkbox',
				'label'	=> __('Restore bundled overlay images','rhcadvent'),
				'save_option'=>false,
				'load_option'=>false
			);
		
		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Advent item access','rhcadvent')
			);

		$t[$i]->options[] =	(object)array(
				'id'			=> 'rhc-advent-capability',
				'type' 			=> 'select',
				'label'			=> __('Capability required to manage','rhcadvent'),
				'description'	=> __('If you change this option to manage_advent, you also need to go to the Feature access tab to specify what roles have this capability.','rhcadvent'),
				'options'		=> array(
					'manage_options' => 'manage_options',
					'manage_advent' => 'manage_advent'
				),
				'default'		=> 'manage_options',
				'save_option'=>true,
				'load_option'=>true
			);



		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
					
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcadvent'),
				'class' => 'button-primary'
			);
		
		return $t;
	}
	
	function get_bundled_images(){
		$arr = array();
		for( $a=1; $a<=25 ; $a++ ){
			$arr[] = sprintf( RHCADVENT_URL.'css/images/%d@2x.png',
				$a
			 );
		}

		return $arr;	
	}
}


?>