<?php

/**
Plugin Name: Advent Calendar for Calendarize It!
Plugin URI: http://calendarize.it/add-on/advent-calendar/
Description: Advent Calendar for Calendarize It!
Version: 1.0.2.75185
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/
 
define('RHCADVENT_POST_TYPE', 'advent'); 
 
if(defined('RHCADVENT_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhcadvent') );

if(defined('RHC_ADDON_PATH')){ //for addon version
//if( false ){
	define('RHCADVENT_PATH', 	trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCADVENT_URL", 	trailingslashit(RHC_ADDON_URL . dirname($addon)) );

	require RHCADVENT_PATH.'includes/pluggable.php';
	$language_path = rh_getRelativePath( WP_PLUGIN_DIR, RHCADVENT_PATH ) . 'languages/';
	define('RHCADVENT_LANGUAGE', $language_path);	
}else{
	define('RHCADVENT_PATH', 	plugin_dir_path(__FILE__) ); 
	define("RHCADVENT_URL", 	plugin_dir_url(__FILE__) );
	define('RHCADVENT_LANGUAGE', RHCADVENT_PATH.'languages/');
	
	require RHCADVENT_PATH.'includes/pluggable.php';
} 

class plugin_rhc_advent_calendar {
	function __construct(  $args=array()  ){
		$defaults = array(
			'options_capability'				=> 'manage_options'
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------	
		$this->handle_mandatory_options();
		
		add_action('plugins_loaded',array(&$this,'plugins_loaded_9'),9);
	}
	
	function rhc_scripts_admin_and_frontend(){
		if( !$this->rhc_active() ) return;
		global $rhc_plugin;

		wp_register_style( 'rhcadvent', RHCADVENT_URL.'css/rhcadvent.css', array(),'1.0.0.2', $rhc_plugin->in_footer );
		wp_register_script( 'rhcadvent', RHCADVENT_URL.'js/rhcadvent.js', array(),'1.0.0.2', $rhc_plugin->in_footer );
	}
	
	function handle_mandatory_options(){
		if( !$this->rhc_active() ) return;
		if( is_admin() ){
			global $rhc_plugin;
			$post_types = $rhc_plugin->get_option('post_types', array(), true);
			if( !in_array( RHCADVENT_POST_TYPE, $post_types ) ){
				$post_types[] = RHCADVENT_POST_TYPE;
				$rhc_plugin->update_option( 'post_types', $post_types );	
				
				//--dbox
				$dbox_post_types = $rhc_plugin->get_option('dbox_post_types', array(), true);
				if( !in_array( RHCADVENT_POST_TYPE, $dbox_post_types ) ){
					$dbox_post_types[] = RHCADVENT_POST_TYPE;
					$rhc_plugin->update_option( 'dbox_post_types', $dbox_post_types );
				}	
				
				//--automatic boxes
				$rhc_plugin->update_option( 'enable_cctpl_' . RHCADVENT_POST_TYPE , '1' );
						
				//--cap
				$WP_Roles = new WP_Roles();	
				$WP_Roles->add_cap( RHC_ADMIN_ROLE, 'manage_advent' );
			}		
		}
	}
	
	function plugins_loaded_9(){
		if( !$this->rhc_active() ) return;
		load_plugin_textdomain('rhcadvent', null, RHCAEW_LANGUAGE );
		
		global $rhc_plugin;
		
		$plugins_loaded_hook = '1'==$rhc_plugin->get_option('ignore_wordpress_standard',false,true)?'plugins_loaded':'after_setup_theme';		
		add_action($plugins_loaded_hook,array(&$this,'plugins_loaded'));	
		
		add_action( 'rhc_scripts_admin_and_frontend', array( &$this, 'rhc_scripts_admin_and_frontend' ) );		
	}
	
	function plugins_loaded(){
		if( !$this->rhc_active() ) return;
		global $rhc_plugin;
		
		require RHCADVENT_PATH.'includes/class.rhc_advent_shortcode.php';
		new rhc_advent_shortcode();
		
		require_once RHCADVENT_PATH.'includes/class.rhc_post_type_advent.php';  
		new rhc_post_type_advent(array(
			'post_type' 		=> RHCADVENT_POST_TYPE,
			'slug'				=> $rhc_plugin->get_option('rhc-advent-slug', 	RHCADVENT_POST_TYPE, true ),
			'advent_capability' => $rhc_plugin->get_option('rhc-advent-capability', 'manage_options', true )
		));

		if(is_admin()){
		
			do_action('rh-php-commons');	
			
			require RHCADVENT_PATH.'includes/class.rhc_advent_options.php';
			new rhc_advent_options( 'rhc', $this->options_capability, false );	
		}		
	}	
	
	function rhc_active(){
		return defined('RHC_VERSION');
	}	
} 

new plugin_rhc_advent_calendar();

?>