<?php
/*
Template Name: Image expands
Template Type: widget_upcoming_events
*/

if( defined('RHP_PATH') ){
	global $rhp_plugin;
	$settings = array(
		'enable_facebook'	=> $rhp_plugin->get_option('enable_facebook','1',true),
		'enable_twitter'	=> $rhp_plugin->get_option('enable_twitter','1',true),
		'enable_linkedin'	=> $rhp_plugin->get_option('enable_linkedin','1',true),
		'enable_google'		=> $rhp_plugin->get_option('enable_google','1',true)		
	);
}else{
	$settings = array(
		'enable_facebook'	=> false,
		'enable_twitter'	=> false,
		'enable_linkedin'	=> false,
		'enable_google'		=> false		
	);
} 

global $rhc_plugin;
$settings['taxonomy_links'] = intval( $rhc_plugin->get_option( 'taxonomy_links', '1', true ) ) ;
?>
    <div class="rhc-event-item rhc-widget-upcoming-item rhc-accordion-widget-item"  data-css_clear="opacity" style="opacity:0;">
        <div class="rhc-widget-header">
        	<div class="rhc-widget-image " data-post_meta_styles="fc_color" data-post_meta_format="background-color: %s;">
        		<img class="rhc_top_image-img-src" />
        	</div>
            <div class="rhc-widget-date-title">
                <div class="rhc-widget-date-cont" data-post_meta_styles="fc_color" data-post_meta_format="background-color: %s;">
                    <div class="rhc-date-hold">
                        <div class="rhc-start-month rhc-date-start">MMM</div>
                        <div class="rhc-start-daynumber rhc-date-start">dd</div>
                    </div>
                </div>
                <div class="rhc-title-info">
                	<a class="rhc-event-title rhc-title-link" href="#"></a>
                	<div class="rhc-title">[TITLE]</div>
                    <div class="rhc-time-location">
                        <div class="time rhc-allday-hidden"><span class="rhc-icon-time"></span><span class="rhc-widget-time"></span></div>
						<div class="venue-loop"
							data-tterm_loop="<?php echo RHC_VENUE;?>"
							data-rnoe="rnoe">
							<div class="location" 
								data-tterm="<?php echo RHC_VENUE;?>" 
								data-fields="name,term_link" 
								<?php if($settings['taxonomy_links']):?>
								data-format="<?php echo esc_attr('<a href="%2$s"><span class="rhc-icon-location"></span><span>%1$s</span></a>')?>"
								<?php else: ?>
								data-format="<?php echo esc_attr('<div class="auw-venue-holder"><span class="rhc-icon-location"></span><span>%1$s</span></div>')?>"
								<?php endif; ?>
								data-empty_fields="term_link"
								data-empty_format="<?php echo esc_attr('<span class="rhc-icon-location"></span><span>%1$s</span>')?>"
								data-rnoe="rnoe">
							</div>
						</div>                        
                        
                    </div>
                </div>
            </div>
        </div>
        <div class="rhc-widget-body">
        	<div class="rhc-event-details rhc-description-empty">
                <h3><?php _e('Event Details','rhcauw');?></h3>
                <p class="rhc-description"></p>
            </div>
            <div class="rhc-event-date-time">
                <h3><?php _e('Time of Event','rhcauw')?></h3>
                <div class="rhc-start-event">
                    <h4><?php _e('Start','rhcauw')?></h4>
                    <div class="rhc-day rhc-widget-date"><!--[Nothing can be placed here, parser replaces it]--></div>
                    <div class="rhc-hour rhc-allday-hidden"><span class="rhc-icon-time"></span><span class="rhc-widget-time"><!--[Nothing can be placed here, parser replaces it]--></span></div>                               
                </div>
                <div class="rhc-end-event">
                    <h4><?php _e('End','rhcauw')?></h4> 
                    <div class="rhc-day rhc-widget-end-date"></div>
                    <div class="rhc-hour rhc-allday-hidden"><span class="rhc-icon-time"></span><span class="rhc-widget-end-time"></span></div>  
                </div>
            </div>
            <div class="rhc-tax-group" data-rnoe="rnoe">           
                <div class="rhc-organizer-group" data-rnoe="rnoe">
					<div class="rhc-organizer" data-tterm_loop="<?php echo RHC_ORGANIZER?>" data-rnoe="rnoe"">
						<h3 data-taxonomy="<?php echo RHC_ORGANIZER?>" data-field="singular_name">[ORG SINGULAR NAME]</h3>
						<p><strong data-tterm="<?php echo RHC_ORGANIZER;?>">[TERM NAME]</strong></p>
						<p data-tterm_meta="<?php echo RHC_ORGANIZER;?>" data-fields="phone" data-format="%s" data-rnoe="rnoe">[PHONE]</p>
						<p data-tterm_meta="<?php echo RHC_ORGANIZER;?>" data-fields="website,website_nofollow,websitelabel" data-format="<?php echo esc_attr('<a href="%s" %s>%s</a>')?>" data-rnoe="rnoe">[WEBSITE LINE]</p>	
					</div>
                </div>
                <div class="rhc-venue-group" data-rnoe="rnoe">
					<div class="rhc-venue-details" data-tterm_loop="<?php echo RHC_VENUE?>" data-rnoe="rnoe">
						<h3 data-taxonomy="<?php echo RHC_VENUE?>" data-field="singular_name">[VENUE SINGULAR NAME]</h3> 
						<div class="rhc-venue-term-name" 
							data-tterm="<?php echo RHC_VENUE;?>" 
							data-fields="name,term_link" 
							<?php if($settings['taxonomy_links']):?>
							data-format="<?php echo esc_attr('<a href="%2$s"><span class="rhc-icon-location"></span><strong>%1$s</strong></a>')?>"
							<?php else: ?>
							data-format="<?php echo esc_attr('<div class="auw-venue-holder"><span class="rhc-icon-location"></span><strong>%1$s</strong></div>')?>"
							<?php endif; ?>
							data-empty_fields="term_link"
							data-empty_format="<?php echo esc_attr('<span class="rhc-icon-location"></span><strong>%1$s</strong>')?>"
							data-rnoe="rnoe">
						</div>  
						 <div class="venue-address" data-rnoe="rnoe">
							<span data-tterm_meta="<?php echo RHC_VENUE;?>" data-fields="address" data-rnoe="rnoe"></span>
							<span data-tterm_meta="<?php echo RHC_VENUE;?>" data-fields="city,state,zip" data-format="%1$s, %2$s %3$s" data-rnoe="rnoe"></span>		
							<span data-tterm_meta="<?php echo RHC_VENUE;?>" data-fields="country" data-rnoe="rnoe"></span>	
						</div>
					</div>
                </div>
             </div>            
			<div class="rhc-gmap" 
				data-type="interactive"
				data-gmap_taxonomy="<?php echo RHC_VENUE;?>" 
				data-size="300x150" 
				data-zoom="15" 
				data-maptype="ROADMAP" 
				data-ratio="4:3"
				data-rnoe="rnoe"
				>
			</div>            
            <div class="rhc-map-social-buttons">
                <div class="rhc-left-buttons">                    
					<?php if( $settings['enable_facebook'] ): ?>
					<a class="rhc-icon-facebook" title="<?php _e('Share on Facebook','rhcauw')?>" style="display: inline;" href="javascript:void(0);"></a>	
					<?php endif; ?>
					<?php if( $settings['enable_twitter'] ): ?>
					<a class="rhc-icon-twitter" title="<?php _e('Share on Twitter','rhcauw')?>" style="display: inline;" href="javascript:void(0);"></a>							
					<?php endif; ?>
					<?php if( $settings['enable_linkedin'] ): ?>
					<a class="rhc-icon-linkedin" title="<?php _e('Share on LinkedIn','rhcauw')?>" style="display: inline;" href="javascript:void(0);"></a>							
					<?php endif; ?>
					<?php if( $settings['enable_google'] ): ?>
					<a class="rhc-icon-googleplus" title="<?php _e('Share on Google+','rhcauw')?>" style="display: inline;" href="javascript:void(0);"></a>	
					<?php endif; ?>                          
                </div>
                <div class="rhc-right-buttons">                    
					<a class="rhc-icon-map" alt="<?php _e('View Google Map','rhcauw')?>" title="<?php _e('View Google Map','rhcauw')?>" style="display: inline;"></a>
					<a class="rhc-icon-ical" title="<?php _e('Add to your calendar','rhcauw') ?>"></a>                    
                </div>
            </div>
        </div>
     </div>