<?php

class timetable_no_vscroll {
	function __construct(){		
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'), 99, 2);
		add_filter('get_calendarize_args_output',array(&$this,'get_calendarize_args_output'), 99, 1);
		if(is_admin()){
			add_action('admin_head',array(&$this,'head'));
		}else{
			add_action('wp_head',array(&$this,'head'));
		}	
	}	
	
	function get_calendarize_args_options($options,$atts){
		if( isset( $atts['timetable'] ) && !empty( $atts['timetable'] ) ){
			foreach($options->modes as $i => $m){
				$options->modes[$i]['options']->viewDisplay = 'tt_fc_no_vertical_scroll_bar';
			}		
		}
		return $options;
	}
	
	function get_calendarize_args_output($out){
		$method_name='tt_fc_no_vertical_scroll_bar';
		$out = str_replace('"'.$method_name.'"',$method_name,$out);
		return $out;
	}
	
	function head(){
?>
<style>
.rhcalendar.rhc-timetable.not-widget.rhc_holder div.fc-view.fc-agenda > div > div:last-child {
height:auto !important;
}
</style>
<script type="text/javascript">
function tt_fc_no_vertical_scroll_bar(view){
	var h;
	
	if ( view.name == "agendaWeek" || view.name == 'agendaDay' ) {
	    h = 99999;	
	} else {
		h = NaN;
	}
	jQuery(this).fullCalendar('option', 'contentHeight', h);
}
</script>
<?php	
	}
}