<?php

class plugin_rhc_timetable {
	var $in_footer = false;
	function __construct(  $args=array()  ){
		$defaults = array(
			'options_capability'				=> 'manage_options'
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------	
		global $rhc_plugin;
		
		//called at class.rhc_styles_and_script.php from rhc plugin.
		if('1'==$rhc_plugin->get_option('in_footer',false,true)){
			$this->in_footer = true;
		}		

		//---
		add_action('plugins_loaded',array(&$this,'plugins_loaded_9'),9);
		
		$this->handle_mandatory_options();
		
		if('1'==$rhc_plugin->get_option('tt_add_author','1',true)){
			add_filter( 'rhc_get_events_set', array( &$this, 'rhc_get_events_set' ), 10, 3 );
		}
		
	}

	function rhc_get_events_set( $events, $args, $request ){
//file_put_contents( ABSPATH.'tt.log', time()."\n" );
		if( is_array( $events ) && count( $events ) > 0 ){
			foreach( $events as $i => $e ){
				if( isset( $e['local_id'] ) && $e['local_id'] > 0 ){
					$post_id = $e['local_id'];
					$author_id = get_post_field( 'post_author', $post_id );
					$author_name = get_the_author_meta( 'display_name', $author_id );

					if( isset( $e['terms'] ) && is_array( $e['terms'] ) ){
					
					}else{
						$e['terms'] = array();
					}
					//--
					$tmp = (object)array(
						'term_id'			=> -1,
						'taxonomy'			=> 'core_author',
						'taxonomy_label'	=> __('Author','rhctimetable'),
						'name'				=> $author_name,
						'url'				=> get_author_posts_url( $author_id )
					);
					$events[$i]['terms'][] = $tmp;					
				}				
			}
		}
		
		return $events;
	}

	function handle_mandatory_options(){

		if( is_admin() ){
			global $rhc_plugin;
			$post_types = $rhc_plugin->get_option('post_types', array(), true);
			if( !in_array( RHCTIMETABLE_POST_TYPE, $post_types ) ){
				$post_types[] = RHCTIMETABLE_POST_TYPE;
				$rhc_plugin->update_option( 'post_types', $post_types );	
				
				//--dbox
				$dbox_post_types = $rhc_plugin->get_option('dbox_post_types', array(), true);
				if( !in_array( RHCTIMETABLE_POST_TYPE, $dbox_post_types ) ){
					$dbox_post_types[] = RHCTIMETABLE_POST_TYPE;
					$rhc_plugin->update_option( 'dbox_post_types', $dbox_post_types );
				}	
				
				//--calendar
				$post_types = $rhc_plugin->get_option('calendar_post_types', array(), true);
				if( !in_array( RHCTIMETABLE_POST_TYPE, $post_types ) ){
					$post_types[] = RHCTIMETABLE_POST_TYPE;
					$rhc_plugin->update_option( 'calendar_post_types', $post_types );
				}	
				
				//--organizer
				$post_types = $rhc_plugin->get_option('organizer_post_types', array(), true);
				if( !in_array( RHCTIMETABLE_POST_TYPE, $post_types ) ){
					$post_types[] = RHCTIMETABLE_POST_TYPE;
					$rhc_plugin->update_option( 'organizer_post_types', $post_types );
				}	
				
				//--venue
				$post_types = $rhc_plugin->get_option('venue_post_types', array(), true);
				if( !in_array( RHCTIMETABLE_POST_TYPE, $post_types ) ){
					$post_types[] = RHCTIMETABLE_POST_TYPE;
					$rhc_plugin->update_option( 'venue_post_types', $post_types );
				}					
				
				//--automatic boxes
				$rhc_plugin->update_option( 'enable_cctpl_' . RHCTIMETABLE_POST_TYPE , '1' );
						
				//--cap
				$WP_Roles = new WP_Roles();	
				$WP_Roles->add_cap( RHC_ADMIN_ROLE, 'manage_rhc_timetable' );
			}		
		}
	}
	
	function plugins_loaded_9(){
		load_plugin_textdomain('rhctimetable', null, RHCTIMETABLE_LANGUAGE );

		global $rhc_plugin;
		
		$plugins_loaded_hook = '1'==$rhc_plugin->get_option('ignore_wordpress_standard',false,true)?'plugins_loaded':'after_setup_theme';		
		add_action($plugins_loaded_hook,array(&$this,'plugins_loaded'));	
		
		add_action( 'rhc_scripts_admin_and_frontend', array( &$this, 'rhc_scripts_admin_and_frontend' ), 10 );	
		
		//called in class.shortcode_calendarize.php
		add_action( 'rhc_calendarize_shortcode', array( &$this, 'rhc_calendarize_shortcode' ) );
		//called at class.shortcode_calendarize.php, allows inserting a template inside the rhc_holder
		add_filter( 'calendarizeit_rhcalendar', array( &$this, 'calendarizeit_rhcalendar' ), 10, 5 );		
		
		//change the default view for the backend screen.
		add_filter('rhc_bop_options', array(&$this,'rhc_bop_options'), 20, 1 );	
	}

	function rhc_bop_options( $options ){
		global $rhc_plugin, $typenow;
		if( $typenow==RHCTIMETABLE_POST_TYPE ){
			$options->defaultView 		= $rhc_plugin->get_option('timtetable_backend_defaultview','agendaWeek',true);
		}	
		return $options;
	}
	
	function plugins_loaded(){
		global $rhc_plugin;
		
		require RHCTT_PATH.'includes/class.shortcode_rhc_timetable.php';
		new shortcode_rhc_timetable();
		
		require_once RHCTT_PATH.'includes/class.rhc_post_type_rhc_timetable.php';  
		new rhc_post_type_rhc_timetable(array(
			'post_type' 			=> RHCTIMETABLE_POST_TYPE,
			'slug'					=> $rhc_plugin->get_option('rhc-timetable-slug', 	RHCTIMETABLE_POST_TYPE, true ),
			'timetable_capability' 	=> $rhc_plugin->get_option('rhc-timetable-capability', 'manage_options', true )
		));	
		
		if( 1 == intval( $rhc_plugin->get_option( 'tt_no_vscroll', '1', true ) ) ){
			require_once RHCTT_PATH.'includes/class.timetable_no_vscroll.php';  
			new timetable_no_vscroll();
		}
		
		if(is_admin()){
		
			do_action('rh-php-commons');	
			
			require RHCTT_PATH.'includes/class.rhc_timetable_options.php';
			new rhc_timetable_options( 'rhc', $this->options_capability, false );	
		}	
		
		add_filter('calendarize_atts', array( &$this, 'calendarize_atts'), 10, 3 );		
	}
	
	function calendarize_atts( $atts, $content, $code ){
		if( isset( $atts['timetable'] ) && !empty( $atts['timetable'] ) ){	
			if( !isset( $atts['post_type'] ) ){
				$atts['post_type'] = RHCTIMETABLE_POST_TYPE;
			}		
		}	
		
		return $atts;
	}
		
	function rhc_calendarize_shortcode(){
		wp_enqueue_style( 'rhc-timetable' );
		wp_enqueue_script( 'rhc-timetable' );
	}
	
	function rhc_scripts_admin_and_frontend(){
		wp_register_style( 'rhc-timetable', RHCTT_URL . 'css/timetable.css', array(), '1.0.0.4', $this->in_footer );
		wp_register_script( 'rhc-timetable', RHCTT_URL . 'js/timetable.js', array( 'calendarize' ), '1.0.0.4', $this->in_footer );
	}
	
	function calendarizeit_rhcalendar( $output, $rhc_options, $atts, $content, $code){
		if( isset( $atts['timetable'] ) && !empty( $atts['timetable'] ) ){					
			$file = $atts['timetable'];
			$file = str_replace('.','', $file);
			$file = str_replace('/','', $file);
			$file = str_replace('\\','', $file);
			$filename = RHCTT_PATH.'templates/'.$file.'.php';

			if( file_exists( $filename ) ){
				global $rhc_plugin;
				
				$time_format = isset( $atts['timetable_time_format'] ) ? $atts['timetable_time_format'] : '' ;
				$time_format = empty( $time_format ) ? $rhc_plugin->get_option( 'cal_rhc_sc_time_format', 'h:mm tt', true ) : $time_format ;
			
				if( in_array( $file, array('timetable_b','swap_time_title_b') ) ){
					$time_format = sprintf('%s-{%s}',$time_format,$time_format);				
				}
				
				if( isset( $atts['adv_timetable_time_format'] ) ){
					$time_format = $atts['adv_timetable_time_format'];
				}
			
				ob_start();
				include $filename;
				$output.=ob_get_contents();
				ob_end_clean();			
			}
		}
			
		return $output;
	}
}