<?php
/*
Plugin Name: Timetable for Calendarize it!
Plugin URI: http://calendarize.it/add-ons/calendarize-it-timetable/
Description: Provides a timetable layout for your events in Calendarize it!
Version: 1.0.1.83146
Author: Alberto Lau (RightHere LLC)
Author URI: http://calendarize.it/add-ons/calendarize-it-timetable/
*/

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

if(defined('RHCTT_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhctimetable') );
if( RHC_VERSION<'4.4.5' ) throw new Exception( __('Timetable for Calendarize it! requires a version greater than 4.4.6.','rhctimetable') );

define( 'RHCTT_VERSION', '1.0.1' );

define('RHCTIMETABLE_POST_TYPE', 'rhc-timetable'); 

if ( defined( 'RHC_ADDON_PATH' ) && isset( $addon ) && ! strpos( __FILE__, 'plugins' ) ) {
	// For addon version.
	define( 'RHCTT_PATH', trailingslashit( RHC_ADDON_PATH . dirname( $addon ) ) ); 
	define( 'RHCTT_URL', trailingslashit( RHC_ADDON_URL . dirname( $addon ) ) );	
	
	require RHCTT_PATH.'includes/pluggable.php';
	$language_path = rh_getRelativePath( WP_PLUGIN_DIR, RHCTT_PATH ) . 'languages/';
	define('RHCTIMETABLE_LANGUAGE', $language_path);		
} else {
	// For plugin version.
	define( 'RHCTT_PATH', plugin_dir_path( __FILE__ ) );
	define( 'RHCTT_URL', plugin_dir_url( __FILE__ ) );
	define( 'RHCTIMETABLE_LANGUAGE', RHCTT_PATH.'languages/');
	
	require RHCTT_PATH.'includes/pluggable.php';	
}

/**
 * The core plugin class.
 */
require_once RHCTT_PATH . 'includes/class.plugin_rhc_timetable.php';
new plugin_rhc_timetable();

?>