jQuery( document ).ready(function( $ ) {
	'use strict';

	var $form = $( 'form' );
	var $formAddTag = $( '#addtag' );
	var $image = $( '.image' );
	var $imageInput = $image.find( '#term-image' );
	
	function selectImage( element, ajax ) {
		var fileFrame;

		if ( fileFrame ) {
			fileFrame.open();
			
			return;
		}

		fileFrame = wp.media({
			title: rhc_taxonomy_images.select,
			button: {
				text: rhc_taxonomy_images.use
			},
			multiple: false
		});

		fileFrame.on( 'select', function() {
			var attachment = fileFrame.state().get( 'selection' ).first().toJSON();

			if ( ajax ) {
				var args = {
					action: 'set-term-image',
					term_id: element.data( 'term' ),
					attachment_id: attachment.id,
					taxonomy: element.data( 'taxonomy' )
				};

				setPinner( element, true );

				$.post( ajaxurl, args, function( response ) {
					if ( response.MSG === 'OK' ) {
						element.parent().prepend( response.HTML );
						element.invertButtonValue();
						setPinner( element, false );
					}
				}, 'json');
			} else {
				var image = '<div class="term-image-box"><img src="' + attachment.url + '" alt="" class="term-image">';
				element.before( image );
				$imageInput.val( attachment.id );
				element.invertButtonValue();
			}
		});

		fileFrame.open();
	}

	function deleteImage( element, ajax ) {
		if ( ajax ) {
			var args = {
				action: 'del-term-image',
				term_id: element.data( 'term' ),
				taxonomy: element.data( 'taxonomy' )
			};

			setPinner( element, true );

			$.post( ajaxurl, args, function( response ) {
				if ( response.MSG == 'OK' ) {
					element.parent().find( '.term-image-box' ).remove();
					element.invertButtonValue();
					setPinner( element, false );				
				}
			}, 'json' );
		} else {
			element.parent().find( '.term-image-box' ).remove();
			$imageInput.val( '' );
			element.invertButtonValue();
		}
	}

	function setPinner( element, status ) {
		var $td = element.closest( 'td' );
		
		if ( status ) {
			$td.fadeTo( 'slow', '0.5' );
		} else {
			$td.fadeTo( 'slow', '1' );
		}
	}

	$.fn.invertButtonValue = function( label_add, label_del ) {
		label_add = ( label_add ) ? label_add : rhc_taxonomy_images.add;
		label_del = ( label_del ) ? label_del : rhc_taxonomy_images.delete;

		if ( this.data( 'action' ) === 'add' ) {
			this.data( 'action', 'delete' ).text( label_del );
		} else {
			this.data( 'action', 'add' ).text( label_add );
		}
	}

	$form.on( 'click', '.image-handle-button', function() {
		var $this = $( this );
		var action = $this.data( 'action' );
		var ajax = ( $this.data( 'ajax' ) ) ? true : false;
		
		if ( action === 'add' ) {
			selectImage( $this, ajax );
		} else if ( action === 'delete' ) {
			deleteImage( $this, ajax );
		}
	});

	if ( $formAddTag.length ) {
		$.ajaxPrefilter(function( options ) {
			var data = options.data;
			var $button = $formAddTag.find( '.image-handle-button' );
			var action = $button.data( 'action' );

			if ( data.indexOf( 'action=add-tag' ) !== -1 && action === 'delete' ) {
				$button.trigger( 'click' );
			}
		});
	}
});