<?php
/*
Plugin Name: Taxonomy Images for Calendarize it!
Plugin URI: http://calendarize.it/add-ons/taxonomy-images/
Description: Taxonomy Images for Calendarize it! allows you to easily assign images to Terms.
Version: 1.0.4.75071
Author: Maxim Levikov (RightHere LLC)
Author URI: http://calendarize.it/add-ons/taxonomy-images/
*/

if (! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

if ( defined( 'RHCTI_PATH' ) ) {
	throw new Exception ( __( 'A duplicate of this add-on/plugin is already active.', 'rhc' ) );
}

define( 'RHCTI_VERSION', '1.0.4' );

if ( defined( 'RHC_ADDON_PATH' ) && isset( $addon ) && ! strpos( __FILE__, 'plugins' ) ) {
	define( 'RHCTI_PATH', trailingslashit( RHC_ADDON_PATH . dirname( $addon ) ) ); 
	define( 'RHCTI_URL', trailingslashit( RHC_ADDON_URL . dirname( $addon ) ) );
	define( 'RHCTI_LANGUAGE', plugin_righthere_calendar::get_relative_path( WP_PLUGIN_DIR, RHCTI_PATH ) . 'languages/' );
} else {
	define( 'RHCTI_PATH', plugin_dir_path( __FILE__ ) );
	define( 'RHCTI_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'Calendarize_It_Taxonomy_Images' ) ) {
	require_once RHCTI_PATH . 'includes/class-rhc-taxonomy-images.php';
}

global $rhc_taxonomy_images;

if ( ! $rhc_taxonomy_images ) {
	$rhc_taxonomy_images = RHC_Taxonomy_Images::get_instance(  array( 'addon' => $addon ) );
}
