<?php

/**
Plugin Name: Event Color by Calendar for Calendarize It!
Plugin URI: http://plugins.righthere.com/calendarize-it/
Description: Provides the option to color code events by any Calendarize It! taxonomy.
Version: 1.1.5.62303
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/

if(defined('RHCTC_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCTC_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCTC_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCTC_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCTC_URL", plugin_dir_url(__FILE__) );
} 
 
class plugin_rhc_taxonomy_color {
	function plugin_rhc_taxonomy_color(){		
		global $rhc_plugin;
		$init_hook = '1'==$rhc_plugin->get_option('ignore_wordpress_standard',false,true)?'setup_theme':'init';
		add_action($init_hook,array(&$this,'init'),5);//custom tax executes on 20
		add_action($init_hook,array(&$this,'init_linked'),15);//custom tax executes on 20
		
		add_filter( 'rhc_supe_get_events', array( &$this, 'rhc_supe_get_events' ), 10, 2 );
	}	
	
	function rhc_supe_get_events( $events, $args ){
		if( empty( $events ) ) return $events;
		//args('args','atts','json_feed','date','date_end')
		$post_types = array();
		foreach( $events as $e ){
			if( $e->ID > 0 ){
				if( !in_array( $e->post_type, $post_types ) ){
					$post_types[]=$e->post_type;
				}
			}
		}
		
		if( empty( $post_types ) ) return $events;
		
		$taxonomies = array( RHC_CALENDAR, RHC_ORGANIZER, RHC_VENUE );
		
		foreach( $post_types as $post_type ) {
		
			$arr = get_object_taxonomies(array('post_type'=>$post_type),'objects');
			if( !empty( $arr ) ){
				$post_type_taxonomies = array_keys( $arr );
				foreach( $post_type_taxonomies as $taxonomy ){
					if( !in_array( $taxonomy, $taxonomies ) ){
						$taxonomies[] = $taxonomy;
					}
				}			
			}
		}
		
		
		foreach( $events as $event_index => $e ){
			if( !isset( $e->meta['fc_color'] ) || empty( $e->meta['fc_color'] ) || '#'==trim( $e->meta['fc_color'] ) ){
				//find and replace with a taxonomy color.
				try {
					if( empty( $e->taxonomies ) ) continue; //event has no taxonomy terms, nothing to search.
					foreach( $taxonomies as $taxonomy ){					
						foreach( $e->taxonomies as $event_taxonomy ){							
							if( $taxonomy == $event_taxonomy->name ){
								if( empty( $event_taxonomy->terms ) ) continue;							
								foreach( $event_taxonomy->terms as $term ){
									if( !empty($term->meta) && !empty( $term->meta['background_color'] ) ){				
										if( '#' == $term->meta['background_color'] ) continue;
										$e->meta['fc_color'] = $term->meta['background_color'];
										
										if( isset( $term->meta['color'] ) && !empty($term->meta['color']) && '#'!=$term->meta['color'] ){
											$e->meta['fc_text_color'] = $term->meta['color'];
										}
										break 3;
									}	
								}							
							}
						}
					}
				}catch( Exception $ex ){
				
				}
			}
		}

		return $events;
	}
	
	function init(){
		//----
		$default_taxonomies = array(
			RHC_CALENDAR 	=> __('Calendar','rhc'),
			RHC_ORGANIZER	=> __('Organizer','rhc'),
			RHC_VENUE		=> __('Venues','rhc')
		);
		
		$rhc_taxonomies = apply_filters('rhc-taxonomies',$default_taxonomies);	
		//----		

		//--- link to default taxonomies
		if(is_array($rhc_taxonomies) && count($rhc_taxonomies)>0 ){
			foreach($rhc_taxonomies as $taxonomy => $label){
				add_filter(  sprintf('rhc_%s_meta', $taxonomy), array(&$this,'rhc_calendar_meta'),10,1);
				add_action( $taxonomy . '_pre_edit_form', array(&$this,'calendar_pre_edit_form'), 10, 2);			
			}
		}

		add_action('add_tag_form_pre', array(&$this,'add_tag_form_pre'), 10, 1);
		
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'),10,2);		
	}
	
	function init_linked(){
		global $rhc_plugin;
		$linked_taxonomies = $rhc_plugin->get_option('taxonomies',array(),true);
		if(is_array($linked_taxonomies) && count($linked_taxonomies)>0 ){
			foreach($linked_taxonomies as $taxonomy ){
				if( taxonomy_exists($taxonomy) ){
					new custom_taxonomy_with_meta(
						$taxonomy,
						null,
						null,
						$this->rhc_calendar_meta(array()),
						RHC_PATH
					);			
				
					add_action( $taxonomy . '_pre_edit_form', array(&$this,'calendar_pre_edit_form'), 10, 2);					
				}
			}
		}		
	}
	
	function rhc_calendar_meta($fields){
		$fields = is_array($fields)?$fields:array();
		$fields[]=	(object)array(
				'label'			=> __('Event colors','rhctc'),
				'type'			=> 'subtitle'
		);		
		$fields[]=(object)array(
				'id'	=> 'color',
				'label'	=> __('Text color','rhctc'),
				'el_properties' => array('class'=>'rhc_wp_colorpicker')
		);
		$fields[]=(object)array(
				'id'	=> 'background_color',
				'label'	=> __('Background color','rhctc'),
				'el_properties' => array('class'=>'rhc_wp_colorpicker')
		);
		return $fields;
	}
	
	function add_tag_form_pre(){
		$this->head();
	}
	
	function calendar_pre_edit_form(){
		$this->head();
	}
	
	function head(){
		global $tax;
		
		wp_print_styles( 'wp-color-picker' );
		wp_print_scripts( 'wp-color-picker' );
?>
<style>
.form-field .wp-picker-container input {
width:auto;
}
</style>
<script type='text/javascript'>
jQuery(document).ready(function($){
    $('.rhc_wp_colorpicker').wpColorPicker();
});
</script>
<?php		
	}
	
	function get_calendarize_args_options($options,$atts){
		foreach($options->modes as $type => $mode){
			$options->modes[$type]['options']->taxonomycolor = '1';
		}		
		return $options;
	}
}

new plugin_rhc_taxonomy_color();

require 'class.rhc_color_key_shortcode.php';
new rhc_color_key_shortcode();
?>