<?php

/**
 *
 *
 * @version $Id$
 * @copyright 2003
 **/
class rhp_settings {
	var $added_rules;
	function __construct($plugin_id='rhp'){
		$this->id = $plugin_id;
		add_filter("pop-options_{$this->id}",array(&$this,'options'),10,1);
		add_action('pop_handle_save',array(&$this,'pop_handle_save'),50,1);

		add_action('admin_init',array(&$this,'admin_init'));
	}

	function admin_init(){

	}


	function pop_handle_save($pop){
		global $rhp_plugin;
		if($rhp_plugin->options_varname!=$pop->options_varname)return;
	}

	function options($t){
		global $rhp_plugin;
		//----
		$i = count($t);
		//-- General settings -----------------------
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhp-general';
		$t[$i]->label 		= __('General settings','rhp');
		$t[$i]->right_label	= __('General settings','rhp');
		$t[$i]->page_title	= __('General settings','rhp');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Enable Sliding Panels','rhp')
			),
			(object)array(
				'id'		=> 'enable_sliding_panels',
				'label'		=> __('Enable Sliding Panels','rhp'),
				'type'		=> 'yesno',
				'default'	=> '1',
				'hidegroup'	=> '#modal_login_group',
				'description'=> __('Choose yes to activate Sliding Panels.','rhp'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array('type'	=> 'clear'),

			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhp'),
				'class' => 'button-primary'
			)
		);

		//--Labels -----------------------
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhp-label';
		$t[$i]->label 		= __('Labels','rhp');
		$t[$i]->right_label	= __('Labels','rhp');
		$t[$i]->page_title	= __('Labels','rhp');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array(
			(object)array(
				'id'		=> 'rhp_btn_label',
				'type'		=> 'text',
				'label'		=> __('Button label','rhp'),
				'options'	=> '',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'rhp_title',
				'type'		=> 'text',
				'label'		=> __('Panel title','rhp'),
				'options'	=> '',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array('type'	=> 'clear'),

			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhp'),
				'class' => 'button-primary'
			)
		);
		//-------------------------

		//--Style settings -----------------------
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhp-style-settings';
		$t[$i]->label 		= __('Style settings','rhp');
		$t[$i]->right_label	= __('Style settings','rhp');
		$t[$i]->page_title	= __('Style settings','rhp');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Choose a Panel style','rhp')
			),
			(object)array(
				'id'		=> 'sliding_panels_style',
				'type'		=> 'radio',
				'options'	=> array('showLeft' => __('Left Reveal','rhp')),
				'el_properties'	=> array(),
				'description'	=> __('Reveal will slide out a panel over the main content.','rhp'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'sliding_panels_style',
				'type'		=> 'radio',
				'options'	=> array('showRight' => __('Right Reveal','rhp')),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'sliding_panels_style',
				'type'		=> 'radio',
				'options'	=> array('showLeftPush' => __('Left Push','rhp')),
				'el_properties'	=> array(),
				'description'	=>__('Push will slide panel displacing the main content.','rhp'),
				'save_option'=>true,
				'load_option'=>true
			),

			(object)array(
				'id'		=> 'sliding_panels_style',
				'type'		=> 'radio',
				'options'	=> array('showRightPush' => __('Right Push','rhp')),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),

			(object)array('type'	=> 'clear'),

			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhp'),
				'class' => 'button-primary'
			)
		);

		//-------------------------
		//--Panel Items -----------------------
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhp-panel-items';
		$t[$i]->label 		= __('Panel Items','rhp');
		$t[$i]->right_label	= __('Panel Items','rhp');
		$t[$i]->page_title	= __('Panel Items','rhp');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Built in sharing links','rhp')
			),
			(object)array(
				'id'		=> 'enable_facebook',
				'label'		=> __('Enable facebook','rhp'),
				'type'		=> 'yesno',
				'default'	=> '1',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'enable_twitter',
				'label'		=> __('Enable Twitter','rhp'),
				'type'		=> 'yesno',
				'default'	=> '1',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'enable_linkedin',
				'label'		=> __('Enable LinkedIn','rhp'),
				'type'		=> 'yesno',
				'default'	=> '1',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'enable_google',
				'label'		=> __('Enable Google','rhp'),
				'type'		=> 'yesno',
				'default'	=> '1',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Custom links ', 'rhp')
			),
			(object)array(
				'id'	=> 'panel_cust_links',
				'type'=>'div_start'
			),
			(object)array(
				'id'		=> 'custom_link_text1', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'label'		=> __('Link Text ', 'rhp'),
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_url1', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'label'		=> __('Link URL ', 'rhp'),
				'el_properties'	=> array(),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_text2', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'label'		=> __('Link Text ', 'rhp'),
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_url2', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'label'		=> __('Link URL ', 'rhp'),
				'el_properties'	=> array(),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_text3', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'label'		=> __('Link Text ', 'rhp'),
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'label'		=> __('Link Text ', 'rhp'),
				'el_properties'	=> array(),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_url3', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				'label'		=> __('Link URL ', 'rhp'),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_text4', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				'label'		=> __('Link Text', 'rhp'),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_url4', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				'label'		=> __('Link URL', 'rhp'),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_text5', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				'label'		=> __('Link Text', 'rhp'),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'custom_link_url5', // 'sliding_panel_cust_items',
				'type'		=> 'text',
				'options'	=> '',//array('1' => __('Custom links', 'rhp')),
				'el_properties'	=> array(),
				'label'		=> __('Link URL', 'rhp'),
				//'hidegroup'	=> '#panel_cust_links',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'	=> 'panel_cust_links',
				'type'=>'div_end'
			),

			(object)array('type'	=> 'clear'),

			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhp'),
				'class' => 'button-primary'
			)
		);
		//-------------------------
		//--Facebook App settings -----------------------
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rhp-facebook-settings';
		$t[$i]->label 		= __('Facebook Settings','rhp');
		$t[$i]->right_label	= __('Facebook Settings','rhp');
		$t[$i]->page_title	= __('Facebook Settings','rhp');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Facebook Application Settings','rhp')
			),
			(object)array(
				'id'		=> 'rhp_facebook_app_id',
				'label'		=> __('App ID','rhp'),
				'type'		=> 'text',
				'el_properties'	=> array('class'=>'text-width-full'),
				'description'	=> __('This is your Application ID generated by Facebook', 'rhp'),
				'save_option'	=>true,
				'load_option'	=>true
			),
			// (object)array(
			// 	'id'		=> 'use_facebook_feed',
			// 	'label'		=> __('Use Facebook Feed Style','rhp'),
			// 	'type'		=> 'yesno',
			// 	'default'	=> '1',
			// 	'description'=> __('You can share your events to Facebook as a Feed style story or an Open Graph story. Normally, Feed style is fine. Use Open Graph if you know what you\'re doing.', 'rhp'),
			// 	'el_properties'	=> array(),
			// 	'save_option'=>true,
			// 	'load_option'=>true
			// ),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhl'),
				'class' => 'button-primary'
			)
		);
		//-------------------------
		return $t;
	}


	function custom_links(){
	?>
		<div class="pt-option pt-option-extra-links">
			<ul class="extra-links-holder">
				<?php for($i =1; $i <= 10; $i++) : ?>
				<li class="extra-link-item">
					<h3 class="option-title sidebar-name open">
						<span><?php _e('Link Item ' . $i, 'rhp'); ?></span>
					</h3>
					<div class="inside option-content open">
						<div class="rhp-inp-showon">
							<label for="link-<?php echo $i; ?>"><?php _e('Link Text: ', 'rhp'); ?></label>
							<input type="text" id="link-<?php echo $i; ?>" name="rhp-linktext[]"/>
						</div>
						<div class="rhp-inp-showon">
							<label for="link_href<?php echo $i; ?>"><?php _e('Link URL: ', 'rhp'); ?></label>
							<input type="text" id="link_href<?php echo $i; ?>" name="rhp-linkhref[]" />
						</div>
					</div>
				</li>
				<?php endfor; ?>
			</ul>
		</div>
	<?php

	}


}
?>
