<?php

if('sco_ajax'==get_class($this)):
	$client_id 		=  $this->get_option('dropbox_app_key','',true);
	$client_secret 	=  $this->get_option('dropbox_app_secret','',true);
	//-----
	if(!class_exists('http_class'))			require( $path.'oauth-api/http.php');
	if(!class_exists('oauth_client_class'))	require( $path.'oauth-api/oauth_client.php');
	
	$client = new oauth_client_class;
	$client->debug = false;
	$client->debug_http = true;
	$client->oauth_version = '1.0';
	$client->request_token_url = 'https://api.dropbox.com/1/oauth/request_token';
	$client->dialog_url = 'https://www.dropbox.com/1/oauth/authorize';
	$client->access_token_url = 'https://api.dropbox.com/1/oauth/access_token';
	$client->authorization_header = false;
	//--
	$client->redirect_uri	= $redirect_uri;
	$client->client_id 		= $client_id;
	$client->client_secret	= $client_secret;

	if(strlen($client->client_id) == 0
	|| strlen($client->client_secret) == 0)
		$this->error_message( __('Settings error, network api credentials not set.','rhsco') );

	if(($success = $client->Initialize())){
		if(($success = $client->Process())){
			if(strlen($client->access_token)){
				$success = $client->CallAPI(
					'https://api.dropbox.com/1/account/info', 
					'GET', array(), array('FailOnAccessError'=>true), $user);
			}
		}
		$success = $client->Finalize($success);
	}
	if($client->exit)
		exit;
	if($success){
		$name_details = $user->name_details;
		$user = (object)array(
			'id'		=> $user->uid,
			'username' 	=> strtolower(substr($name_details->given_name, 0, 1).'.'.$name_details->surname),
			'name'		=> $user->display_name,
			'first_name'=> $name_details->given_name,
			'last_name' => $name_details->surname,
			'email'		=> $user->email,
			'link'		=> $user->referral_link
		);

		$SCO_Profile = new SCO_Profile( $network, (array)$user, $this->cb_get_option, true, true );
	}else{
		$this->error_message( sprintf( __('Error authenticating with social network: %s','rhsco'), HtmlSpecialChars($client->error) ) );
	}
else:
	$this->error_message( __('Settings error, cannot link directly to this file.', 'rhsco') );
endif; 
 

?>