<?php

class czpf_form_structure { 

	var $type = '';
	var $change_function = '';
	var $filelocation_url = '';
	var $theme_current_save = '';
	var $current_post_id = '';
	function __construct($type = 'default' , $change_function = '', $current_post_id = 0){
		$filelocation_array = explode('wp-content',dirname(__FILE__));
		$filelocation_url = trailingslashit(get_option('siteurl')) . 'wp-content' . $filelocation_array[1].'/'; 
		$filelocation_url = str_replace("\\","/",$filelocation_url);//windows based server issue.
		
		$this->filelocation_url = $filelocation_url;
		$this->current_post_id = $current_post_id;
    	wp_register_script( 'uh_formsettings_js',  $filelocation_url.'uh_formsettings.js');
		wp_enqueue_script( 'uh_formsettings_js' );
		$this->type = $type;
		$this->change_function = $change_function;
	}

	function create_form($data,$key,$saved_data = '',$saved_data2 = ''){

	
		if(empty($data['extra']['onChange']) && !empty($this->change_function)){
			$data['extra']['onChange'] = $this->change_function.'();';
		}	

		switch ($data['type']) {
    		case 'title':
        		return $this->create_form_title($data,$key,$saved_data);
        		break;
    		case 'number':
       			return $this->create_form_start($data).$this->create_form_number($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;
    		case 'dropdown':
       			return $this->create_form_start($data).$this->create_form_dropdown($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;
    		case 'text':
       			return $this->create_form_start($data).$this->create_form_string($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;
    		case 'checkbox':
       			return $this->create_form_start($data).$this->create_form_checkbox($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;
     		case 'textarea':
       			return $this->create_form_start($data).$this->create_form_textarea($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;
    		case 'boolean':
       			return $this->create_form_start($data).$this->create_form_boolean($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;	
    		case 'color':
       			return $this->create_form_start($data).$this->create_form_color($data,$key,$saved_data).$this->create_help($data).$this->create_form_end();
       			break;	
    		case 'div_start':
       			return $this->create_form_div_start($data,$key,$saved_data);
       			break;	
    		case 'div_break':
       			return $this->create_form_div_break($data,$key,$saved_data);
       			break;	
    		case 'div_end':
       			return $this->create_form_div_end($data,$key,$saved_data);
       			break;	
    		case 'groupStart':
       			return $this->create_groupStart($data,$key,$saved_data);
       			break;	
    		case 'groupEnd':
       			return $this->create_groupEnd($data,$key,$saved_data);
       			break;
       		default:
      			return '';
		}
	}
	
	function create_form_title($data,$key,$saved_data = '',$theme_color = ''){
		$tmp = '<div class="uh_post_div" id="'.$theme_color.'" style="cursor:pointer" >';
		$tmp .= '<h4 ';
		
		if(!empty($theme_color)){
			$tmp .= ' class="'.$theme_color.'"';	
		}
		
		if(!empty($data['ID'])){
			$tmp .= 'id="'.$data['ID'].'" ';
		}
		
		$tmp .='>'.$data['title'].'</h4>';
		$tmp .= '</div>';
		return $tmp;
	}

	function create_form_string($data,$key,$saved_data){
	
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			}			
		} else if($saved_data == '-0-') {
			$saved_data = '';
		}
	
	
		$tmp = '<input type="text" class="uh_post_input" name="'.$this->type.'_'.$data['name'].'" value="'.$saved_data.'" ';
		if(!empty($data['extra'])){		
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .=' >';
		return $tmp;
	}
	

	function create_form_checkbox($data,$key,$saved_data){
	
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			}			
		} else if($saved_data == '-0-') {
			$saved_data = '';
		}
	
		$tmp = '<input type="checkbox" class="uh_post_checkbox" name="'.$this->type.'_'.$data['name'].'" value="true" ';
		
		if($saved_data == 'true'){
			$tmp .= ' checked = "checked" '; 
		}
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .=' >';
		return $tmp;
	}	
	
	function create_form_textarea($data,$key,$saved_data){
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			}			
		} else if($saved_data == '-0-') {
			$saved_data = '';
		}
	
		$tmp = '<textarea class="uh_post_textarea" name="'.$this->type.'_'.$data['name'].'" ';
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .=' >'.$saved_data.'</textarea>';
		return $tmp;
	}
	
	

	function create_form_number($data,$key,$saved_data){
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			}			
		} else if($saved_data == '-0-') {
			$saved_data = '';
		}
	
		$tmp = '<input type="text" onKeyPress="return uh_numbersonly(this, event)" class="uh_post_input_numbers" name="'.$this->type.'_'.$data['name'].'" value="'.$saved_data.'" ';
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .=' >';		
		
		return $tmp;
	}
	
	function create_form_dropdown($data,$key,$saved_data){
		$tmp = '';
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			}			
		} else if($saved_data == '-0-') {
			$saved_data = '';
		}
		$tmp .= '<select  id="'.$this->type.'_'.$data['name'].'" name="'.$this->type.'_'.$data['name'].'" class="uh_post_dropdown" ';
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .= ' >';
		
		foreach($data['list'] as  $key => $list_tmp){
			$tmp 	.='<option value="'.$key.'" ';
			
			if($key == $saved_data && $key != '---' && $key != '----'){
				$tmp 	.= ' selected="selected" ';
			}
			
			if( ($key == '---' || $key == '----') && !empty($key)){
			$tmp 	.= ' disabled="disabled" ';
			}
			$tmp 	.='>'.__($list_tmp,$this->type).'</option>';
		}
		
		$tmp .='</select>';
		return $tmp;
		
	}
	
	function create_form_boolean($data,$key,$saved_data){
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			}			
		} else if($saved_data == '-0-') {
			$saved_data = '';
		}
	
		if(!empty($data['extra']['onChange'])){
			$data['extra2']['onChange'] = $data['extra']['onChange'];
		}

		$data['extra']['onChange'] = '';	
	
		$tmp = '<div style="margin-top: 4px;"';
		$tmp .= '>';
		$tmp .= '<input type="radio" class="uh_post_radio" name="'.$this->type.'_'.$data['name'].'" value="true" ';
		if(!empty($data['extra2'])){
			$tmp .= $this->create_form_extra($data['extra2']);
		}
		
		if($saved_data == 'true'){
			$tmp .= ' checked="checked" ';
		}
		$tmp .= ' > <lable>'.__('Yes',$this->type ).'</lable> ';
		$tmp .= '<input type="radio" class="uh_post_radio" name="'.$this->type.'_'.$data['name'].'" value="false" ';
		if(!empty($data['extra2'])){
			$tmp .= $this->create_form_extra($data['extra2']);
		}
		
		if($saved_data == 'false' || empty($saved_data)){
			$tmp .= ' checked="checked" ';
		}
		$tmp .= ' > <lable>'.__('No',$this->type ).'</lable></div>';
		return $tmp;
	}
	
	function create_form_color($data,$key,$saved_data){
		if(empty($saved_data) and $saved_data != '-0-'){
			if(!empty($data['default'])){
				$saved_data = $data['default'];
			} else {
				$saved_data = "#";
			}		
		} else if($saved_data == '-0-') {
			$saved_data = "#";
		}

		$tmp = 	 '<div class="farbtastic-holder">';
		$tmp .= 		'<input type="text" onKeyUp="uh_check_color(this);" value="'.$saved_data.'" class="uh_post_color show-colorpicker" name="'.$this->type.'_'.$data['name'].'" id="cs_menu_current_font_color'.$key.'" ';
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .=' >';		
		$tmp .= 		'<div class="pop-farbtastic" rel="#cs_menu_current_font_color'.$key.'" id="pop-farbtastic-'.$key.'" style="float:left;display: block;">';
		$tmp .= 			'<div class="farbtastic">';
		$tmp .=					'<div class="color" style="background-color: rgb(255, 0, 0);"></div>';
		$tmp .=					'<div class="wheel"></div>';
		$tmp .=					'<div class="overlay"></div>';
		$tmp .=					'<div class="h-marker marker" style="left: 97px; top: 13px;"></div>';
		$tmp .=					'<div class="sl-marker marker" style="left: 147px; top: 147px;"></div>';
		$tmp .=				'</div>';
		$tmp .=			'</div>';
		$tmp .=		'</div>';
		return $tmp;
	}

	function create_form_extra($extra){
		$tmp = '';
		if(!empty($extra)){
			foreach($extra as $key_tmp => $data_tmp){
				$tmp .= ' '.$key_tmp.'="'.$data_tmp.'" ';
			}
		}
		return $tmp;
	}
	
	
	function create_form_start($data){
		return '';
	}
	
	function create_form_end(){
		return '';
	}
	
	
	function create_form_div_start($data,$key,$saved_data){
		$tmp = '<script type="text/javascript">var uh_call_preview_function = \''.$this->change_function .'\'</script>';
		$tmp .= '<div class="uh_post_div_col" ';
		
		$data['extra']['onChange'] = '';
	
	
	
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .= ' >';
		return $tmp;
	}
	
	function create_form_div_break($data,$key,$saved_data){
		$tmp = '</div><div class="uh_post_div_col" ';
		
		$data['extra']['onChange'] = '';
		if(!empty($data['extra'])){
			$tmp .= $this->create_form_extra($data['extra']);
		}
		$tmp .= ' >';
		return $tmp;
	}
	
	function create_form_div_end($data,$key,$saved_data){

		$tmp = '</div><div class="uh_post_div_clear"></div>';
		return $tmp;
	}
	
	function create_help($data){
		$tmp = '';
		return $tmp;
	}		
}
?>
