<?php
class czpf_class_object_controler  {

	var $tmp_return_data = '';
	var $location = '';
	var $czpf_container = '';
	var $czpf_middlecontainer = '';
	var $czpf_show_hide = '';
	var $extraobject = '';
	var $user_id;
	var $check_up_user_id;
	var $tmp_backend_data_check = '';
	var $row_type_list_array = array('12','2_10','4_8','6_6','4_4_4','3_8_1','2_8_2','3_6_3','3_3_3_3','2_2_2_2_2_2','8_4','10_2','2_2_2_6');

	// -----------------------------------
	// init
	// -----------------------------------


	function __construct($tmp_location){
		$this->location = $tmp_location;
		$this->czpf_container = get_option('czpf_container', '');	
		$this->user_id = get_current_user_id();

		if(!empty($_GET['ID'])){
			$this->check_up_user_id = $_GET['ID'];
		}		

		if(empty($this->check_up_user_id) and !empty($this->user_id) ){
			$this->check_up_user_id = $this->user_id;
			
		}

		if(!empty($this->czpf_container )){
			$this->czpf_container  = json_decode(urldecode($this->czpf_container ),true);
		}
	}
	
	// -----------------------------------
	// Access functions
	// -----------------------------------
	
	function generate_object($tmp,$value = '',$backend = false){
		$get_obj = $this->get_object($tmp);
		return $this->generate_bytype($get_obj,$value,$backend);	
	}
	
	
	function get_object($tmp){
		return $this->all_objects($tmp);
	}
	
	
	function generate_list($data,$backend = false){
	
		if(empty($this->check_up_user_id)){
			return __('Please login to view this page.','rhc');
		}
	
	
		if($backend){
			$this->tmp_return_data = '<ul>';				
		}
		$this->generate_list_level($this->$data,$backend);
		if($backend){
			$this->tmp_return_data .= '</ul>';
		}
		return $this->tmp_return_data;
	}
	
	function generate_list_bottomcontainer($data,$backend = false){

		if(empty($this->check_up_user_id)){
			return '';
		}
		
		
		if(empty($this->check_up_user_id)){
			return '';
		}
		$this->tmp_return_data = '';
		$this->generate_list_bottomcontainer_topmenu($data,$backend);
		
		$get = $this->extraobject;
		
		
		
		$this->tmp_return_data .= '<div class="extrainfo '.$get.'">';
		$this->extra_generate_list($get,'list',10);
		$this->tmp_return_data .= '</div>';
		
		return $this->tmp_return_data;
	}
	
	
	// -----------------------------------
	// generate functions
	// -----------------------------------
	
	function generate_list_level($this_objce,$backend = false,$tmp_type = false){
		foreach($this_objce as $tmp_key => $tmp_data){
			$tmp_check = explode('_', $tmp_key);
			
			
			if(is_array($tmp_data) && $tmp_check[0] == 'stretchobject'){			
				if($backend){
					$this->tmp_return_data .= '<li id="row">';
				}
				
				$this->tmp_return_data .= '<div class="rowobject">';
				
				if($backend){
					$this->tmp_return_data .= '<span class="contolepanel_remove czpficon-minus"></span></span>';
				}
				
				$this->generate_list_level($tmp_data,$backend,true);
				$this->tmp_return_data .= '<span class="clear"></span></div>';
				
				if($backend){
					$this->tmp_return_data .= '</li>';
				}
				
			} else if(is_array($tmp_data) && $tmp_check[0] == 'rowobject'){
				if($backend){
					$this->tmp_return_data .= '<li id="row">';
				}
				
				$this->tmp_return_data .= '<div class="rowobject">';
				
				if($backend){
				
					$this->tmp_return_data .= '<span class="contolepanel dragemove"><span class="contolepanel_box">';
					
					foreach ($this->row_type_list_array as $l_k => $l_d){
						
						$this->tmp_return_data .= '<a data-type="'.$l_d.'" class="colums colums_'.$l_d;
						
						if((empty($tmp_check[1]) && $l_k == 0) or (!empty($tmp_check[1]) && $tmp_check[1] == $l_k)){
							$this->tmp_return_data .= ' active';
						}
						
						$this->tmp_return_data .= '"></a>';
	
					}
					$this->tmp_return_data .= '</span><span class="contolepanel_remove czpficon-minus"></span></span>';
				}
				
				$this->generate_list_level($tmp_data,$backend,true);
				$this->tmp_return_data .= '<span class="clear"></span></div>';
				
				if($backend){
					$this->tmp_return_data .= '</li>';
				}
				
			} else if(is_array($tmp_data) && $tmp_check[0] == 'single'){	
				$this->tmp_return_data .= '<div class="singleobject col-'.($backend==true?'xs':'front').'-'.$tmp_check[1].'">';
				if($backend){
					$this->tmp_return_data .= '<span class="add_object top" onclick="czpf_add_object_show(this,\'top\')"></span><ul>';
				}
				$this->generate_list_level($tmp_data,$backend,true);
				if($backend){
					$this->tmp_return_data .= '</ul><span class="add_object bottom" onclick="czpf_add_object_show(this,\'bottom\')"></span>';
				}
				$this->tmp_return_data .= '</div>';
			} else {
				$this->tmp_return_data .= $this->generate_object($tmp_data['id'],$tmp_data,$backend);
			}
		}
		
	    if($tmp_type){
	    	 //$this->tmp_return_data .= '<span class="clear"></span>';
		    //$this->tmp_return_data .= '</div>';
	    }
	}
	

	function generate_list_objects($this_objce,$backend = false){
		$tmp_return = '';
		if(!empty($this_objce)){
			foreach($this_objce as $tmp_key => $tmp_data){
				$tmp_return .= $this->generate_object($tmp_data['id'],$tmp_data,$backend);
			}
		}
		
		return $tmp_return;
	}
	
	function generate_bytype($get_obj,$value,$backend){
		$return_data = '';
		
		if(!empty($value['formobject_lockdown'])){
			$get_obj['form_objects'] = array($value['formobject_lockdown']);
		}

		if ( is_array( $get_obj['form_objects'] ) ) {
			foreach ( $get_obj['form_objects'] as $tmp ) {
				$return_data_tmp = '';
				$return_style_tmp = '';
				$return_class_tmp = '';
				$return_onclick_tmp = '';
				$return_array = array();
				
				if($get_obj['id'] == 'avatar'){
					$return_array['url'] = $get_obj['default'];
					$return_array['width'] = '175px';
					$return_array['height'] = '175px';
				}
				$return_array['object_icon'] = '';
				$return_array['formobject_lockdown'] = $tmp;
				$return_array['editable'] = true;
				


				$return_array['public'] = true;
				
				if(!empty($get_obj['defaulticon'])){
					$return_array['object_icon'] = $get_obj['defaulticon']; 
				}
					
					
				$return_data_tmp  .= '<div id="'.($backend == true?'backend':'frontend').'" style="display:none">';
					
				$tmp_controle = $get_obj['controle_back'];
			
				foreach($tmp_controle  as $tmpbk){
					if(!empty($value) && !empty($value[$tmpbk])){
						$return_array[$tmpbk] = $value[$tmpbk];
					}
					$return_data_tmp .= $this->generate_valuebar($tmpbk,$return_array);
				}		
				$return_data_tmp .= '</div>';
					
					
				if(!in_array('editable', $get_obj['controle_back'])){
					$return_array['editable'] = false;
				}	
					
				if($get_obj['id'] =='space'){
					$return_array['public'] = '1';
				}			

				if(!$backend){
				
					if($get_obj['id'] =='space'){
						$return_array['object_icon'] = 'no-icon';
						$return_array['public'] = '1';
					}	
					
					if($get_obj['id'] =='label'){
						$return_array['editable'] = '-';
					}	
					
					if($get_obj['id'] == 'status_show'){
						$return_array['editable'] = 1;
					}
					
					$this->tmp_backend_data_check = '';
				
				
					$return_data_tmp .= '<span class="icon_extra '.$return_array['object_icon'].'"></span>';
					$return_data_tmp .=$this->get_content_data($return_array,$get_obj);
					
					if(!empty($return_array['editable']) && $return_array['editable'] !='-' && !empty($this->user_id) && !empty($this->check_up_user_id) && $this->user_id == $this->check_up_user_id){
					
						if($get_obj['id'] == 'avatar'){
							$return_data_tmp .= '<span class="editble czpficon-pencil"><span id="avatarchange"></span></span>';
						} else if($get_obj['id'] == 'custom'){
						
							if(!empty($return_array['save'])){
								$return_data_tmp .= '<span onclick="czpf_fn_edit_object(this,\''.$return_array['save'].'\',\''.$get_obj['savepoint'].'\')" class="editble czpficon-pencil"></span>';
							}

						} else {
							$return_data_tmp .= '<span onclick="czpf_fn_edit_object(this,\''.$get_obj['save'].'\',\''.$get_obj['savepoint'].'\')" class="editble czpficon-pencil"></span>';				
						}

					}
				} else {
				
					if($get_obj['id'] == 'custom'){
						$return_data_tmp .= '<div id="add_object"><span class="'.$get_obj['defaulticon'].'"></span><span>'.$get_obj['name'].'<br>( '.$tmp.' )</span></div>';	
					} else {
						$return_data_tmp .= '<div id="add_object"><span class="'.$get_obj['defaulticon'].'"></span><span>'.$get_obj['name'].'</span></div>';
					}
				

					$return_data_tmp .= '<div id="show_object" class="dragemove">';
					
						if(!empty($return_array['object_icon'])){
							$return_data_tmp .= '<span class="icon_extra '.$return_array['object_icon'].'"></span>';
						} else {
							$return_data_tmp .= '<span class="icon_extra icon_'.$tmp.'"></span>';
						}
		
						$return_data_tmp .= '<span class="subtext">'.$get_obj['name'].' <span class="subsubtext">';
					
						if(!empty($return_array['value']) && ($get_obj['id'] == 'custom' or $get_obj['id'] == 'label' or $get_obj['id'] == 'title' or $get_obj['id'] == 'description')){
							$return_data_tmp .= ': '.$return_array['value'];
						}

						$return_data_tmp .= '</span></span>';
						
					$return_data_tmp .= '</div>';
					$return_data_tmp .= '<div onclick="czpf_remove_object(this);return false;" class="icon_minus"></div>';	
					if(!empty($get_obj['controle_back']) && $get_obj['controle_back'][0] != ''){
						$return_data_tmp .= '<div onclick="czpf_fn_settings(this);return false;" class="icon_settings"></div>';	
					}
			
				}
				
				if(!empty($return_array) && !empty($return_array['editable'])){
					$return_class_tmp .= ' czpf_editble '; 
				}
				
				if(!empty($return_array) && !empty($return_array['url'])){
				
					$return_array['url'] = $this->get_avatar_url($return_array['url'] ,450);
				
					$return_style_tmp .= 'background-image:url(\''.$return_array['url'].'\');';
				}
				if(!empty($return_array) && !empty($return_array['width']) && $return_array['width'] != 'px' && $return_array['width'] != '%'){
					if($get_obj['id'] == 'avatar'){
						$return_style_tmp .= 'width:100%;';
					} else {
						$return_style_tmp .= 'width:'.$return_array['width'].';';
					}
					
				}
				
				if(!empty($return_array) && !empty($return_array['height']) && $return_array['height'] != 'px' && $return_array['height'] != '%'){
					$return_style_tmp .= 'height:'.$return_array['height'].';';
				}
				
				
				if(!empty($return_array) && !empty($return_array['class_object'])){
					$return_class_tmp .= ' ' . $return_array['class_object'] . ' ';
				}
				$tmp_link = '';
				
				if(($get_obj['id'] == 'twitter' or $get_obj['id'] == 'linkedin' or $get_obj['id'] == 'googleplus' or $get_obj['id'] == 'facebook')){
					global $czpf_plugin;
				
					if(((empty($czpf_plugin->api_keys['facebook_app_id']))  && $get_obj['id'] == 'facebook') || 
					   ((empty($czpf_plugin->api_keys['linkedin_app_key'])) && $get_obj['id'] == 'linkedin') || 
					   ((empty($czpf_plugin->api_keys['googleplus_apiKey']) || empty($czpf_plugin->api_keys['googleplus_clientId'])) && $get_obj['id'] == 'googleplus') || 
					   ((empty($czpf_plugin->api_keys['twitter_key']) || empty($czpf_plugin->api_keys['twitter_secret'])) && $get_obj['id'] == 'twitter') ){
					   		$tmp_link = '';
						   	$return_class_tmp .= ' czpf_deativate ';
						   	$return_array['public'] = '-';
					} else {
						$tmp_social_save = get_user_meta($this->check_up_user_id, $get_obj['save'], true);
						if(!empty($tmp_social_save)){
							$return_class_tmp .= ' czpf_active_white ';
							$tmp_link = $tmp_social_save;
						}					
					
						if(!empty($this->user_id) && !empty($this->check_up_user_id) && $this->user_id == $this->check_up_user_id){
							$return_class_tmp .= ' czpf_editble ';
							
							$return_onclick_tmp = 'czpf_fn_social_showbox(this,\''.$get_obj['id'].'\');';
						} else {
							if(!empty($tmp_social_save)){
								$return_onclick_tmp = 'czpf_fn_social_link(this);';
							}
						}
					}
				}
				
				if(!empty($return_array) && !empty($return_array['round_object']) && $return_array['round_object'] != '-'){
					$return_class_tmp .= ' czpf_round '; 
				}
				
				if($backend){
					$return_style_tmp = '';
				}
				
				if($get_obj['id'] == 'avatar' && !empty($this->user_id) && !empty($this->check_up_user_id) && $this->user_id != $this->check_up_user_id){
					$return_data_tmp2 = '<div onclick="czpf_friend_check(this,'.$this->user_id.','.$this->check_up_user_id.',false)" ';
					$return_data_tmp2 .= 'class="czpf_avatar_overlay ob_s_c data-icon ';
					
					
					$friends_lists = get_user_meta($this->user_id, 'friends_list', true);
					if(!empty($friends_lists)){
						if(empty($friends_lists[$this->check_up_user_id]) or $friends_lists[$this->check_up_user_id] == 'requests' ){
							$return_data_tmp2 .= ' fui-heart ';
						} else {
							$return_data_tmp2 .= ' czpficon-heart-broken ';
						}
					} else {
						$return_data_tmp2 .= ' fui-heart ';
					}
					
					if(!empty($return_array) && !empty($return_array['round_object']) && $return_array['round_object'] != '-'){
						$return_data_tmp2 .= ' czpf_round'; 
					}					
					$return_data_tmp2 .= '"></div>';
				} else {
					$return_data_tmp2 = '';
				}
				
				if(!empty($return_onclick_tmp)){
					$return_onclick_tmp = 'onclick="'.$return_onclick_tmp.'"';
				}
		
				$return_data_tmp = $return_data_tmp2.'<div data-link="'.$tmp_link.'" data-obj="'.$get_obj['id'].'" '.$return_onclick_tmp.' class="czpf_'.$get_obj['id'].' ob_s_c '.$return_class_tmp.'" style="'.$return_style_tmp.'">'.$return_data_tmp.'</div>';
				
				
				if(!$backend && (empty($this->user_id) || empty($this->check_up_user_id) || $this->user_id != $this->check_up_user_id) && empty($this->tmp_backend_data_check) && $get_obj['id'] != 'avatar'){
					$return_array['public'] = '-';
				}
				
				if($get_obj['id'] == 'status_show'){
					$return_array['public'] = '-';
				}
				
				
				if($backend || (!$backend && $return_array['public'] != '-') || (!empty($this->user_id) && !empty($this->check_up_user_id) && $this->user_id == $this->check_up_user_id)){
					$return_data .= ($backend == true?$this->generate_backend_li($return_data_tmp,$get_obj['id'],$return_class_tmp,$return_style_tmp):$return_data_tmp);
				}
			}
		}

		return $return_data;
	}
	
	function get_content_data($tmp_value,$tmp_object){
		global $wpdb;
		$tmp_return = '';
		$tmp_return2 = '';
		if(!empty($tmp_value)){
		
			if(!empty($tmp_object['id']) && $tmp_object['id'] == 'full_name'){
				$tmp_return .= get_user_meta($this->check_up_user_id, 'first_name', true) . ' '; 
				$tmp_return .= get_user_meta($this->check_up_user_id, 'last_name', true); 
				
				if(empty($tmp_return) || $tmp_return == ' ' || $tmp_return == ''){
					$user_info = get_userdata($this->check_up_user_id);
					$tmp_return .= $user_info->display_name;
				}
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'groupsteams'){	
					$tmp_sql = "SELECT p1.ID,p1.post_title FROM {$wpdb->prefix}rhc_groups_teams as u1, {$wpdb->prefix}posts as p1 WHERE u1.userID = ".$this->check_up_user_id." and u1.status = 2 and u1.postID = p1.ID order by p1.post_title";			
					$sqldata = $wpdb->get_results($tmp_sql);
					
					
					if(!empty($sqldata)){
						foreach($sqldata as $d_tmp){
							$tmp_check= $this->generate_link_to_groupid($d_tmp->ID);
							$tmp_return .= '<a href="'.$tmp_check.'" target="_blank">'.$d_tmp->post_title.'</a><br>';
						}
					}
				
						
				
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'custom'){
				if(!empty($tmp_object['savepoint']) && !empty($tmp_value['save']) && $tmp_object['savepoint'] == 'options'){
					$tmp_return .= get_option( $tmp_value['save'], '' ); 
				} else if(!empty($tmp_object['savepoint']) && !empty($tmp_value['save'])){
				   $tmp_return .= get_user_meta($this->check_up_user_id, $tmp_value['save'], true); 
				}	 

				
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] != 'avatar'){
				if(!empty($tmp_object['save']) && $tmp_object['savepoint'] == 'users'){
					$tmp_return .= $wpdb->get_var( "SELECT ".$tmp_object['save']." FROM $wpdb->users where ID=".$this->check_up_user_id );
				} else if($tmp_object['savepoint'] == 'usermeta'){
					$tmp_return .=  get_user_meta($this->check_up_user_id, $tmp_object['save'], true);
					
				} else if($tmp_object['savepoint'] == 'options'){
				   $tmp_return .=  get_option( $tmp_object['save'], '' );
				}
			}
			
			
			$tmp_return2 = '<div id="user_show">';
			
			if(!empty($tmp_value['value']) && empty($tmp_return) && $tmp_object['id'] == 'label'){
				$tmp_return2 .= $tmp_value['value'];
			} else if(!empty($tmp_value['value']) && empty($tmp_return)){
				$tmp_return2 .= '<span class="default_data">'.$tmp_value['value'].'</span>';
			} else if(empty($tmp_return) && $tmp_object['id'] == 'status_show' ){
				$tmp_return2 .= __('Public','rhc');
			} else if(empty($tmp_return) && $tmp_object['id'] != 'avatar' ){
				$tmp_return2 .= '<span class="default_data">'.$tmp_object['default'].'</span>';
			} else if($tmp_object['id'] != 'avatar') {
				$tmp_return2 .= $tmp_return;
			}
			
			$tmp_return2 .= '</div>';
			
			$tmp_return2 .= '<div id="czpf_edit_box" class="czpf_edit_box">';
			
			
			
			
			if(!empty($tmp_object['id']) && $tmp_object['id'] == 'lang'){
					$languash =  array(__('Afar','rhc'),
									 __('Abkhaz','rhc'),
									 __('Avestan','rhc'),
									 __('Afrikaans','rhc'),
									 __('Akan','rhc'),
									 __('Amharic','rhc'),
									 __('Aragonese','rhc'),
									 __('Arabic','rhc'), 
									 __('Assamese','rhc'),
									 __('Avaric','rhc'),
									 __('Aymara','rhc'),
									 __('Azerbaijani','rhc'),
									 __('Bashkir','rhc'),
									 __('Belarusian','rhc'),
									 __('Bulgarian','rhc'),
									 __('Bihari','rhc'),
									 __('Bislama','rhc'),
									 __('Bambara','rhc'),
									 __('Bengali','rhc'),
									 __('Tibetan Standard, Tibetan, Central','rhc'),
									 __('Breton','rhc'),
									 __('Bosnian','rhc'),
									 __('Chechen','rhc'),
									 __('Chamorro','rhc'),
									 __('Corsican','rhc'),
									 __('Cree','rhc'),
									 __('Old Church Slavonic','rhc'),
									 __('Chuvash','rhc'),
									 __('Welsh','rhc'),
									 __('Danish','rhc'),
									 __('German','rhc'),
									 __('Dzongkha','rhc'),
									 __('Ewe','rhc'),
									 __('Greek, Modern','rhc'),
									 __('English','rhc'),
									 __('Estonian','rhc'),
									 __('Basque','rhc'),
									 __('Persian','rhc'),
									 __('Finnish','rhc'),
									 __('Fijian','rhc'),
									 __('Faroese','rhc'),
									 __('French','rhc'),
									 __('Western Frisian','rhc'),
									 __('Irish','rhc'),
									 __('Galician','rhc'),
									 __('Guarana­','rhc'),
									 __('Gujarati','rhc'),
									 __('Manx','rhc'),
									 __('Hausa','rhc'),
									 __('Hebrew (modern)','rhc'),
									 __('Hindi','rhc'),__('Hiri Motu','rhc'),
									 __('Croatian','rhc'),
									 __('Hungarian','rhc'),
									 __('Armenian','rhc'),
									 __('Herero','rhc'),
									 __('Interlingua','rhc'),
									 __('Indonesian','rhc'),
									 __('Interlingue','rhc'),
									 __('Igbo','rhc'),
									 __('Nuosu','rhc'),
									 __('Inupiaq','rhc'),
									 __('Ido','rhc'),									 									 
									 __('Icelandic','rhc'),
									 __('Italian','rhc'),
									 __('Inuktitut','rhc'),
									 __('Japanese (ja)','rhc'),
									 __('Javanese (jv)','rhc'),
									 __('Georgian','rhc'),
									 __('Kongo','rhc'),
									 __('Kikuyu, Gikuyu','rhc'),
									 __('Kwanyama,Kuanyama','rhc'),
									 __('Kazakh','rhc'),
									 __('Kalaallisut,Greenlandic','rhc'),
									 __('Khmer','rhc'),
									 __('Kannada','rhc'),
									 __('Korean','rhc'),
									 __('Kanuri','rhc'),
									 __('Kashmiri','rhc'),
									 __('Kurdish','rhc'),
									 __('Komi','rhc'),
									 __('Cornish','rhc'),
									 __('Kirghiz, Kyrgyz','rhc'),
									 __('Latin','rhc'),
									 __('Luxembourgish, Letzeburgesch','rhc'),
									 __('Luganda','rhc'),
									 __('Limburgish, Limburgan, Limburger','rhc'),
									 __('Lingala','rhc'),
									 __('Lao','rhc'),
									 __('Lithuanian','rhc'),
									 __('Luba-Katanga','rhc'),								 
									 __('Latvian','rhc'),
									 __('Malagasy','rhc'),
									 __('Marshallese','rhc'),
									 __('Maori','rhc'),
									 __('Macedonian','rhc'),
									 __('Malayalam','rhc'),
									 __('Mongolian','rhc'),
									 __('Malay','rhc'),
									 __('Maltese','rhc'),
									 __('Burmese','rhc'),
									 __('Nauru','rhc'),
									 __('Norwegian Bokmaal','rhc'),
									 __('North Ndebele','rhc'),
									 __('Nepali','rhc'),
									 __('Ndonga','rhc'),
									 __('Dutch','rhc'),
									 __('Norwegian','rhc'),
									 __('South Ndebele','rhc'),
									 __('Navajo, Navaho','rhc'),
									 __('Occitan','rhc'),
									 __('Ojibwe, Ojibwa','rhc'),
									 __('Oromo','rhc'),
									 __('Oriya','rhc'),
									 __('Ossetian, Ossetic','rhc'),
									 __('Panjabi, Punjabi','rhc'),
									 __('Pali','rhc'),
									 __('Polish','rhc'),
									 __('Portuguese','rhc'),
									 __('Quechua','rhc'),
									 __('Romansh','rhc'),
									 __('Kirundi','rhc'),
									 __('Romanian, Moldavian, Moldovan','rhc'),
									 __('Russian','rhc'),
									 __('Kinyarwanda','rhc'),
									 __('Sanskrit','rhc'),
									 __('Sardinian','rhc'),
									 __('Sindhi','rhc'),
									 __('Northern Sami','rhc'),
									 __('Sinhala, Sinhalese','rhc'),
									 __('Slovak','rhc'),
									 __('Slovene','rhc'),
									 __('Samoan','rhc'),
									 __('Shona','rhc'),
									 __('Somali','rhc'),
									 __('Albanian','rhc'),
									 __('Serbian','rhc'),
									 __('Swati','rhc'),
									 __('Southern Sotho','rhc'),
									 __('Sundanese','rhc'),
									 __('Swedish','rhc'),
									 __('Swahili','rhc'),
									 __('Tamil','rhc'),
									 __('Telugu','rhc'),
									 __('Tajik','rhc'),
									 __('Thai','rhc'),
									 __('Tigrinya','rhc'),
									 __('Turkmen','rhc'),
									 __('Tagalog','rhc'),
									 __('Tswana','rhc'),
									 __('Tonga (Tonga Islands)','rhc'),
									 __('Turkish','rhc'),
									 __('Tsonga','rhc'),
									 __('Tatar','rhc'),
									 __('Twi','rhc'),
									 __('Tahitian','rhc'),
									 __('Uighur, Uyghur','rhc'),
									 __('Ukrainian','rhc'),
									 __('Urdu','rhc'),
									 __('Uzbek','rhc'),
									 __('Venda','rhc'),
									 __('Vietnamese','rhc'),
									 __('Walloon','rhc'),
									 __('Wolof','rhc'),
									 __('Xhosa','rhc'),
									 __('Yiddish','rhc'),
									 __('Yoruba','rhc'),
									 __('Zhuang, Chuang','rhc'),
									 __('Chinese','rhc'),
									 __('Zulu','rhc'));
					
				asort($languash);	
				$tmp_list_str = implode('","', $languash);
					
								
			
				$tmp_return2 .= '<input id="user_edit" type="text" data-items="2" data-provide="typeahead" data-source=\'["'.$tmp_list_str.'"]\' value="'.$tmp_return.'" />';
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'state'){
			$states = array('',' ','  ',
							__('Alabama','rhc'),
							__('Alaska','rhc'),
							__('Arizona','rhc'),
							__('Arkansas','rhc'),
							__('California','rhc'),
							__('Colorado','rhc'),
							__('Connecticut','rhc'),
							__('Delaware','rhc'),
							__('Florida','rhc'),
							__('Georgia','rhc'),
							__('Hawaii','rhc'),
							__('Idaho','rhc'),
							__('Illinois','rhc'),
							__('Indiana','rhc'),
							__('Iowa','rhc'),
							__('Kansas','rhc'),
							__('Kentucky','rhc'),
							__('Louisiana','rhc'),
							__('Maine','rhc'),
							__('Maryland','rhc'),
							__('Massachusetts','rhc'),
							__('Michigan','rhc'),
							__('Minnesota','rhc'),
							__('Mississippi','rhc'),
							__('Missouri','rhc'),
							__('Montana','rhc'),
							__('Nebraska','rhc'),
							__('Nevada','rhc'),
							__('New Hampshire','rhc'),
							__('New Jersey','rhc'),
							__('New Mexico','rhc'),
							__('New York','rhc'),
							__('North Carolina','rhc'),
							__('North Dakota','rhc'),
							__('Ohio','rhc'),
							__('Oklahoma','rhc'),
							__('Oregon','rhc'),
							__('Pennsylvania','rhc'),
							__('Rhode Island','rhc'),
							__('South Carolina','rhc'),
							__('South Dakota','rhc'),
							__('Tennessee','rhc'),
							__('Texas','rhc'),
							__('Utah','rhc'),
							__('Vermont','rhc'),
							__('Virginia','rhc'),
							__('Washington','rhc'),
							__('West Virginia','rhc'),
							__('Wisconsin','rhc'),
							__('Wyoming','rhc'),
							__('Washington DC','rhc'),
							__('Puerto Rico','rhc'),
							__('U.S. Virgin Islands','rhc'),
							__('American Samoa','rhc'),
							__('Guam','rhc'),
							__('Northern Mariana Islands','rhc'),
							__('Alberta','rhc'),
							__('British Columbia','rhc'),
							__('Manitoba','rhc'),
							__('New Brunswick','rhc'),
							__('Newfoundland and Labrador','rhc'),
							__('Nova Scotia','rhc'),
							__('Ontario ','rhc'),
							__('Prince Edward Island','rhc'),
							__('Quebec','rhc'),
							__('Saskatchewan','rhc'),
							__('Northwest Territories','rhc'),
							__('Nunavut','rhc'),
							__('Yukon Territory','rhc')
							);
				asort($states);	
			
				$tmp_list_str_states = implode('","', $states);
			
			
				$tmp_return2 .= '<input id="user_edit" type="text" data-items="2" data-provide="typeahead" data-source=\'["'.$tmp_list_str_states.'"]\' value="'.$tmp_return.'" />';
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'contry'){
			
				$countries = array(__("Afghanistan","rhc"),__("Albania","rhc"),__("Algeria","rhc"),__("American Samoa","rhc"),__("Andorra","rhc"),__("Angola","rhc"),__("Anguilla","rhc"),__("Antarctica","rhc"),__("Antigua and Barbuda","rhc"),__("Argentina","rhc"),__("Armenia","rhc"),__("Aruba","rhc"),__("Australia","rhc"),__("Austria","rhc"),__("Azerbaijan","rhc"),__("Bahamas","rhc"),__("Bahrain","rhc"),__("Bangladesh","rhc"),__("Barbados","rhc"),__("Belarus","rhc"),__("Belgium","rhc"),__("Belize","rhc"),__("Benin","rhc"),__("Bermuda","rhc"),__("Bhutan","rhc"),__("Bolivia","rhc"),__("Bosnia and Herzegowina","rhc"),__("Botswana","rhc"),__("Bouvet Island","rhc"),__("Brazil","rhc"),__("British Indian Ocean Territory","rhc"),__("Brunei Darussalam","rhc"),__("Bulgaria","rhc"),__("Burkina Faso","rhc"),__("Burundi","rhc"),__("Cambodia","rhc"),__("Cameroon","rhc"),__("Canada","rhc"),__("Cape Verde","rhc"),__("Cayman Islands","rhc"),__("Central African Republic","rhc"),__("Chad","rhc"),__("Chile","rhc"),__("China","rhc"),__("Christmas Island","rhc"),__("Cocos (Keeling) Islands","rhc"),__("Colombia","rhc"),__("Comoros","rhc"),__("Congo","rhc"),__("Congo, the Democratic Republic of the","rhc"),__("Cook Islands","rhc"),__("Costa Rica","rhc"),__("Cote dIvoire","rhc"),__("Croatia (Hrvatska)","rhc"),__("Cuba","rhc"),__("Cyprus","rhc"),__("Czech Republic","rhc"),__("Denmark","rhc"),__("Djibouti","rhc"),__("Dominica","rhc"),__("Dominican Republic","rhc"),__("East Timor","rhc"),__("Ecuador","rhc"),__("Egypt","rhc"),__("El Salvador","rhc"),__("Equatorial Guinea","rhc"),__("Eritrea","rhc"),__("Estonia","rhc"),__("Ethiopia","rhc"),__("Falkland Islands (Malvinas)","rhc"),__("Faroe Islands","rhc"),__("Fiji","rhc"),__("Finland","rhc"),__("France","rhc"),__("Gabon","rhc"),__("Gambia","rhc"),__("Georgia","rhc"),__("Germany","rhc"),__("Ghana","rhc"),__("Gibraltar","rhc"),__("Greece","rhc"),__("Greenland","rhc"),__("Grenada","rhc"),__("Guadeloupe","rhc"),__("Guam","rhc"),__("Guatemala","rhc"),__("Guinea","rhc"),__("Guinea-Bissau","rhc"),__("Guyana","rhc"),__("Haiti","rhc"),__("Heard and Mc Donald Islands","rhc"),__("Holy See (Vatican City State)","rhc"),__("Honduras","rhc"),__("Hong Kong","rhc"),__("Hungary","rhc"),__("Iceland","rhc"),__("India","rhc"),__("Indonesia","rhc"),__("Iran (Islamic Republic of)","rhc"),__("Iraq","rhc"),__("Ireland","rhc"),__("Israel","rhc"),__("Italy","rhc"),__("Jamaica","rhc"),__("Japan","rhc"),__("Jordan","rhc"),__("Kazakhstan","rhc"),__("Kenya","rhc"),__("Kiribati","rhc"),__("Korea, Democratic Peoples Republic of","rhc"),__("Korea, Republic of","rhc"),__("Kuwait","rhc"),__("Kyrgyzstan","rhc"),__("Lao, Peoples Democratic Republic","rhc"),__("Latvia","rhc"),__("Lebanon","rhc"),__("Lesotho","rhc"),__("Liberia","rhc"),__("Libyan Arab Jamahiriya","rhc"),__("Liechtenstein","rhc"),__("Lithuania","rhc"),__("Luxembourg","rhc"),__("Macau","rhc"),__("Macedonia, The Former Yugoslav Republic of","rhc"),__("Madagascar","rhc"),__("Malawi","rhc"),__("Malaysia","rhc"),__("Maldives","rhc"),__("Mali","rhc"),__("Malta","rhc"),__("Marshall Islands","rhc"),__("Martinique","rhc"),__("Mauritania","rhc"),__("Mauritius","rhc"),__("Mayotte","rhc"),__("Mexico","rhc"),__("Micronesia, Federated States of","rhc"),__("Moldova, Republic of","rhc"),__("Monaco","rhc"),__("Mongolia","rhc"),__("Montserrat","rhc"),__("Morocco","rhc"),__("Mozambique","rhc"),__("Myanmar","rhc"),__("Namibia","rhc"),__("Nauru","rhc"),__("Nepal","rhc"),__("Netherlands","rhc"),__("Netherlands Antilles","rhc"),__("New Caledonia","rhc"),__("New Zealand","rhc"),__("Nicaragua","rhc"),__("Niger","rhc"),__("Nigeria","rhc"),__("Niue","rhc"),__("Norfolk Island","rhc"),__("Northern Mariana Islands","rhc"),__("Norway","rhc"),__("Oman","rhc"),__("Pakistan","rhc"),__("Palau","rhc"),__("Panama","rhc"),__("Papua New Guinea","rhc"),__("Paraguay","rhc"),__("Peru","rhc"),__("Philippines","rhc"),__("Pitcairn","rhc"),__("Poland","rhc"),__("Portugal","rhc"),__("Puerto Rico","rhc"),__("Qatar","rhc"),__("Reunion","rhc"),__("Romania","rhc"),__("Russian Federation","rhc"),__("Rwanda","rhc"),__("Saint Kitts and Nevis","rhc"),__("Saint Lucia","rhc"),__("Saint Vincent and the Grenadines","rhc"),__("Samoa","rhc"),__("San Marino","rhc"),__("Sao Tome and Principe","rhc"),__("Saudi Arabia","rhc"),__("Senegal","rhc"),__("Seychelles","rhc"),__("Sierra Leone","rhc"),__("Singapore","rhc"),__("Slovakia (Slovak Republic)","rhc"),__("Slovenia","rhc"),__("Solomon Islands","rhc"),__("Somalia","rhc"),__("South Africa","rhc"),__("South Georgia and the South Sandwich Islands","rhc"),__("Spain","rhc"),__("Sri Lanka","rhc"),__("St. Helena","rhc"),__("St. Pierre and Miquelon","rhc"),__("Sudan","rhc"),__("Suriname","rhc"),__("Svalbard and Jan Mayen Islands","rhc"),__("Swaziland","rhc"),__("Sweden","rhc"),__("Switzerland","rhc"),__("Syrian Arab Republic","rhc"),__("Taiwan, Province of China","rhc"),__("Tajikistan","rhc"),__("Tanzania, United Republic of","rhc"),__("Thailand","rhc"),__("Togo","rhc"),__("Tokelau","rhc"),__("Tonga","rhc"),__("Trinidad and Tobago","rhc"),__("Tunisia","rhc"),__("Turkey","rhc"),__("Turkmenistan","rhc"),__("Turks and Caicos Islands","rhc"),__("Tuvalu","rhc"),__("Uganda","rhc"),__("Ukraine","rhc"),__("United Arab Emirates","rhc"),__("United Kingdom","rhc"),__("United States","rhc"),__("Uruguay","rhc"),__("Uzbekistan","rhc"),__("Vanuatu","rhc"),__("Venezuela","rhc"),__("Vietnam","rhc"),__("Virgin Islands (British)","rhc"),__("Virgin Islands (U.S.)","rhc"),__("Wallis and Futuna Islands","rhc"),__("Western Sahara","rhc"),__("Yemen","rhc"),__("Yugoslavia","rhc"),__("Zambia","rhc"),__("Zimbabwe","rhc"),__("USA","rhc"));
			asort($countries);	
			
			$tmp_list_str = implode('","', $countries);
			
			
				$tmp_return2 .= '<input id="user_edit" type="text" data-items="2" data-provide="typeahead" data-source=\'["'.$tmp_list_str.'"]\' value="'.$tmp_return.'" />';
			
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'status_show'){
				$tmp_return2 .= '<select id="user_edit" >';
					$tmp_return2 .= '<option '.($tmp_return == __('public','rhc')?'selected="selected"':'').' value="'.__('public','rhc').'">'.__('Public','rhc').'</option>';
					$tmp_return2 .= '<option '.($tmp_return == __('private','rhc')?'selected="selected"':'').' value="'.__('private','rhc').'">'.__('Private','rhc').'</option>';	
				$tmp_return2 .= '</select>';
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'sex'){
				$tmp_return2 .= '<select id="user_edit" >';
			
				$tmp_return2 .= '<option '.($tmp_return == __('Male','rhc')?'selected="selected"':'').' value="'.__('Male','rhc').'">'.__('Male','rhc').'</option>';
				$tmp_return2 .= '<option '.($tmp_return == __('Female','rhc')?'selected="selected"':'').' value="'.__('Female','rhc').'">'.__('Female','rhc').'</option>';
				
				$tmp_return2 .= '</select>';

			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'age'){
				$random = rand(5, 15);
			
				$time_format = get_option('date_format');
				if(empty($time_format)){
					$time_format = 'd MM, yy';
				} else {
					$time_format = str_replace(array('F','j','Y','m','d','l'), array('MM','d','yy','mm','dd','DD'), $time_format);
				}
				
				
				
				
				
			
				$tmp_return2 .= '<input id="age_'.$random.'" type="text" value="'.$tmp_return.'">';
				
				$tmp_return2 .= '<script> setTimeout( function(){jQuery(\'#age_'.$random.'\').not(\'.hasDatePicker\').datepicker({beforeShow: function(input, inst) {jQuery(\'#ui-datepicker-div\').addClass(\'div_czpf\');},changeMonth: true,changeYear: true,dateFormat: "'.$time_format.'"});}, 2000 );</script>';
				
							
			} else if(!empty($tmp_object['id']) && $tmp_object['id'] == 'description'){
			
				$tmp_return2 .= '<div class="toolbar_item bold czpficon-bold" onclick="czpf_replace_textarea(this);"></div>';
				$tmp_return2 .= '<div class="toolbar_item italic czpficon-italic" onclick="czpf_replace_textarea(this);"></div>';
				$tmp_return2 .= '<div class="toolbar_item link czpficon-link2" onclick="czpf_replace_textarea(this);"></div>';
				$tmp_return2 .= '<div class="toolbar_item em czpficon-font-size" onclick="czpf_replace_textarea(this);"></div>';				
				$tmp_return2 .= '<div class="toolbar_item sub czpficon-subscript" onclick="czpf_replace_textarea(this);"></div>';
				$tmp_return2 .= '<div class="toolbar_item sup czpficon-superscript" onclick="czpf_replace_textarea(this);"></div>';
			
				$tmp_return2 .= '<textarea  id="user_edit">'.$tmp_return.'</textarea> ';
			} else {
				$tmp_return2 .= '<input id="user_edit" value="'.$tmp_return.'">';
			
			}
			
			$this->tmp_backend_data_check = $tmp_return;
			
			
			$tmp_return2 .= '</div>';
		}
	
		return $tmp_return2;
		
	}
	
	function generate_valuebar($tmp_name,$value){
		$tmp_value = '';
		if(!empty($value) && !empty($value[$tmp_name])){
			$tmp_value = $value[$tmp_name];
		}

		return '<input id="'.$tmp_name.'" type="hidden" value="'.$tmp_value.'">';

	}
	
	function generate_backend_li($obj,$objname,$objclass,$objstyle){
		return '<li id="'.$objname.'" style="'.$objstyle.'" class="'.$objclass.'">'.$obj.'</li>';
	}
	
	
	function generate_list_bottomcontainer_topmenu($czpf_advancede,$backend){
		global $wpdb,$post,$rhc_rating_plugin;
	
		$this->tmp_return_data .= '<div class="buttombuttontop col-'.($backend==true?'xs':'front').'-12">';
		$tmp_array = array('show_friends'=>__('Friends','rhc'),'show_postevents'=>__('Posts & Comments','rhc'),'show_pastevents'=>__('Past Events','rhc'),'show_upcoming'=>__('Upcoming Events','rhc'),'show_rating'=>__('Ratings & Reviews','rhc'));
		$czpf_order_array = get_option('czpf_sort_order', '');
		$tmp_count = 0;
		$tmp_avg = 0;
		$tmp_array_bk = array();
		
		foreach($czpf_order_array as $tmp_d){
		
			if($tmp_d == 'show_postevents' and (!empty($czpf_advancede['show_comment']) or !empty($czpf_advancede['show_post']))){
				$tmp_array_bk[$tmp_count] = $tmp_d;
				$tmp_count++;
			} else if(!empty($czpf_advancede) && !empty($czpf_advancede[$tmp_d])){
				$tmp_array_bk[$tmp_count] = $tmp_d;
				$tmp_count++;
			}
		}
		
		
		if($tmp_count > 0){
			$tmp_avg = 12/$tmp_count;
		}
		
		if($tmp_count == 5){
			$tmp_avg = '2-4';
		}
		
		$user_info = get_userdata($this->check_up_user_id);
		$email_check = '';
		$tmp_facebook = get_user_meta($this->check_up_user_id, 'facebook_email_czpf', true);
		$tmp_googleplus = get_user_meta($this->check_up_user_id, 'googleplus_email_czpf', true);
		$tmp_linkedin = get_user_meta($this->check_up_user_id, 'linkedin_email_czpf', true);
		$tmp_twitter = get_user_meta($this->check_up_user_id, 'twitter_email_czpf', true);
		
		if(!empty($tmp_facebook)){
			$email_check .= "'".$tmp_facebook."',";
		}
		if(!empty($tmp_googleplus)){
			$email_check .= "'".$tmp_googleplus."',";
		}
		if(!empty($tmp_linkedin)){
			$email_check .= "'".$tmp_linkedin."',";
		}
		if(!empty($tmp_twitter)){
			$email_check .= "'".$tmp_twitter."',";
		}
		
		$email_check .= "'".$user_info->user_email ."'";
			
			

		
		
		for($i=0;$i<$tmp_count;$i++){
				
			$tmp_var_count = 0;	
				
				
			if($tmp_array_bk[$i] == 'show_rating') {
				$tmp_var_count = 0;	
				if(defined('RHCRATING_URL')){
					$settings = get_option('rhc_rating_options');
					
					$icon_count = 5;
					if(!empty($settings['rating_icon_numbers'])){
						$icon_count = (int)$settings['rating_icon_numbers'];
					}
					if(!empty($settings['rating_icon_type'])){
						$icon_type = $settings['rating_icon_type'];

						if ( $icon_type == 'faces' ) {
							$icon_count = 7;
						}
					}

					$get_list_sql = "SELECT count(*) FROM {$wpdb->prefix}rhc_rating WHERE ".($settings['rating_accept_inputs'] == true ? ' `show`=1 and' : '')." email in (".$email_check.") and rating <= ".$icon_count. " order by cDate DESC limit 1";
					$get_list_date = $wpdb->get_var($get_list_sql);
					if(!empty($get_list_date)){
						$tmp_var_count += $get_list_date;
					}
				}
			} else if($tmp_array_bk[$i] == 'show_pastevents') {
				$tmp_var_count = 0;	
				$sql1 = "SELECT count(*) FROM {$wpdb->prefix}rhc_rsvp where email in (".$email_check.")  and event_date < '".date('YmdHms').",".date('Ymd')."000000' ORDER BY event_date DESC limit 1";
				$sqldata1 = $wpdb->get_var($sql1);
				
				if(!empty($sqldata1)){
					$tmp_var_count += $sqldata1;
				}
				
			} else if($tmp_array_bk[$i] == 'show_upcoming') {
				$tmp_var_count = 0;	
				$sql2 = "SELECT count(*) FROM {$wpdb->prefix}rhc_rsvp where email in (".$email_check.")  and event_date > '".date('YmdHms').",".date('Ymd')."000000' ORDER BY event_date ASC limit 1";
				$sqldata2 = $wpdb->get_var($sql2);

				if(!empty($sqldata2)){
					$tmp_var_count += $sqldata2;
				}
			} else if($tmp_array_bk[$i] == 'show_postevents'){
				$tmp_var_count = 0;		
				if(!empty($czpf_advancede['show_post'])){		
					$args = array(
					   'posts_per_page' => 1,
					   'author' => $this->check_up_user_id,
					   'post_type' => 'post',
					   'post_status' => 'publish'
					);
					$myquery = new WP_Query($args);
					if(!empty($myquery) && !empty($myquery->found_posts)){
						$tmp_var_count += $myquery->found_posts-1;
					}
				}
				
								
				
				if(!empty($czpf_advancede['show_comment'])){
				
					$tmp_sql9 = "SELECT count(*) as comment_approved FROM {$wpdb->comments} as k1, {$wpdb->posts} as k2 WHERE k1.user_id = ".$this->check_up_user_id." and k1.comment_approved = 1 and k1.comment_post_ID = k2.ID and k2.post_type in ('post','page') group by k1.user_id";
					
					$count = $wpdb->get_results($tmp_sql9 , ARRAY_A );				
												
					if(!empty($count[0]['comment_approved']) && $count[0]['comment_approved'] > 0){
						$tmp_var_count += $count[0]['comment_approved'];
					};	
				}					
										
			} else if($tmp_array_bk[$i] == 'show_friends'){
				$friends_lists = get_user_meta($this->check_up_user_id, 'friends_list', true);
				if(!empty($friends_lists)){
					foreach($friends_lists as $key => $friends_list){
						$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94,$key);
						if($friends_list == 'ok'){
							$tmp_var_count++;
						}
					}
				}						
			}

		
		
			$this->tmp_return_data .= '<div class="buttombutton col-'.($backend==true?'xs':'front').'-'.$tmp_avg.'"><span class="iconbar-unread numbercount '.$tmp_array_bk[$i].'_icon" data-count="'.$tmp_var_count.'">0</span><a data-userid="'.$this->check_up_user_id.'" href="#" id="'.$tmp_array_bk[$i].'" onclick="czpf_bottom_button(this,\''.$tmp_array_bk[$i].'\','.$this->check_up_user_id.');return false;"><div class="button_'.$tmp_array_bk[$i];
			
			if($i==0) {
				$this->tmp_return_data .= ' active';
				$this->extraobject = $tmp_array_bk[$i];
			}
			
			
			$this->tmp_return_data .= '">';
			
			
			if($tmp_array_bk[$i] == 'show_postevents' && empty($czpf_advancede['show_comment']) && !empty($czpf_advancede['show_post'])){
				$this->tmp_return_data .= __('Posts','rhc');
			} else if($tmp_array_bk[$i] == 'show_postevents' && !empty($czpf_advancede['show_comment']) && empty($czpf_advancede['show_post'])){
				$this->tmp_return_data .= __('Comments','rhc');
			} else {
				$this->tmp_return_data .= $tmp_array[$tmp_array_bk[$i]];
			}			
			
			
			
			$this->tmp_return_data .= '</div></a></div>';
		}
		
		
		
		$this->tmp_return_data .= '</div>';
	}
	
	
	// -----------------------------------
	// other functions
	// -----------------------------------
	
	
	function desc_excerpt($text = '', $length = 50, $symbole = ' ...' ) {
		$text = strip_tags($text);
		if(strlen($text) > $length){
			return substr($text, 0, $length) . $symbole;
		}
		
		return $text;
	}
	
	function get_avatar_url($default,$size = 150, $defualt_id_email = ''){
		$avatar_url = '';
		if(empty($defualt_id_email)){
			$defualt_id_email = $this->check_up_user_id;
		}		
		
		if(is_numeric($defualt_id_email)){
			$avatar_url = get_user_meta($defualt_id_email,'avatar_url',true);
		}
		
		
		if(!empty($avatar_url) && is_array($avatar_url)){
			if(file_exists($avatar_url['backend'])){
				return $avatar_url['frontend'];
			}
			
		}


		$default = preg_replace("/https:/i", "http:", $default);
	
		$urldata = get_avatar($defualt_id_email , $size, $default);
		 
		preg_match('/< *img[^>]*src *= *["\']?([^"\']*)/i',$urldata, $matches);
		
		
		if(empty($matches['1'])){
			preg_match("/<img.+src=(\')(?P<src>.+)(\')+>/i",$urldata, $matches);
		}
		
		
		return (!empty($matches['1'])== true ? $matches['1'] : '');
		
		
	}

	function bottomcontainer_check($czpf_advancede){
		if(!empty($czpf_advancede)){
			if(!empty($czpf_advancede['show_friends']) || 
			   !empty($czpf_advancede['show_pastevents']) ||
			   !empty($czpf_advancede['show_upcoming']) ||
			   !empty($czpf_advancede['show_postevents']) ||
			   !empty($czpf_advancede['show_rating']) ){
				return true;
			}
		}
		return false;
	}

	
	function checkvalue($this_objce){
		if(is_string($this_objce)){
			return !empty($this->$this_objce);
		} else {
			return !empty($this_objce);
		}
	}
	
	function generate_link_to_id($type_id){
		global $czpf_plugin,$wpdb;
		$return_url = $czpf_plugin->get_profil_url();
		
		
		if(!empty($czpf_plugin->permalink_structur) && empty($czpf_plugin->czpf_advancede['use_smart_permalink'])){
			$return_url .= '/';
			$tmp = $wpdb->get_results("SELECT w2.ID,w2.display_name FROM $wpdb->users as w1,$wpdb->users as w2 where w1.ID = ".$type_id." and w1.display_name = w2.display_name");

			if(!empty($tmp)){
				foreach($tmp as $t_k => $t_d){
					if($t_d->ID == $type_id){
						$t_d->display_name = str_replace(' ', '-', $t_d->display_name);
						$return_url .= urlencode($t_d->display_name);
						
						if($t_k > 0){
							$return_url .= '-'. $t_k;
						}
						break;
					}
				}
			}
		} else {
			if (strpos($return_url,'?') !== false) {
				$return_url .= "&ID=".$type_id;
			} else {
				$return_url .= "?ID=".$type_id;
			}
		}
		
		return $return_url; 
	}
	
	function generate_link_to_groupid($type_id){
		global $czpf_plugin,$wpdb;
		$return_url = $czpf_plugin->get_group_url();
		
		if(!empty($czpf_plugin->permalink_structur) && empty($czpf_plugin->czpf_advancede['use_smart_permalink'])){
			$return_url .= '/';
			
			$page_data = get_page($type_id);
			if(!empty($page_data) && $page_data->post_status == 'publish' && !empty($czpf_plugin->permalink_structur)){
				$return_url .= $page_data->post_name;
			}			
		} else {
			if (strpos($return_url,'?') !== false) {
				$return_url .= "&ID=".$type_id;
			} else {
				$return_url .= "?ID=".$type_id;
			}
		}
		
		return $return_url; 
	}
	
	
	
	function add_to_current_link($type_id){
		global $czpf_plugin;
		$return_url = $czpf_plugin->get_profil_url();
		
		if (strpos($return_url,'?') !== false) {
			$return_url .= "&ID=".$this->check_up_user_id;
		} else {
			$return_url .= "?ID=".$this->check_up_user_id;
		}
		
		if(!empty($type_id)){
			foreach($type_id as $d_key => $d_data){
				$return_url .= '&';
				$return_url .= $d_key .'=' .$d_data;
			}
		}
		
		return $return_url; 
	}
	

	
	
	// -----------------------------------
	// Generate list
	// -----------------------------------
	
	function generate_groups_count($settings){
		$tmp_return = '';
		$count_posts = wp_count_posts('groupsteams');

		$numbers = 10;
		if(!empty($settings['groups_limit'])){
			$numbers = $settings['groups_limit']; 
		} 

		$tmp_return .= '<div class="counter" id="counter" style="display:none">'.$count_posts->publish.'</div>';
		$tmp_return .= '<div class="counter" id="nrprcounter" style="display:none">'.$numbers.'</div>';
		
		return $tmp_return;
	}	
	
	
	function generate_memebers_count($settings){
		$tmp_return = '';
		$tmp_r = count_users();

		$numbers = 10;
		if(!empty($settings['members_limit'])){
			$numbers = $settings['members_limit']; 
		} 
		$count_tmp = 0;
		
		if(!empty($settings['members_roles'])){
			$user_roles = $settings['members_roles'];
			$user_roles = explode('|',$settings['members_roles']);
			
			foreach($user_roles as $tmp_d){
				if(!empty($tmp_r['avail_roles'][$tmp_d])){
					$count_tmp += $tmp_r['avail_roles'][$tmp_d];
				}
			}
		} else {
			$user_roles = '';
		}
		
		

		if(!empty($user_roles)){
			$tmp_return .= '<div class="counter" id="counter" style="display:none">'.$count_tmp.'</div>';
		} else {
			$tmp_return .= '<div class="counter" id="counter" style="display:none">'.$tmp_r['total_users'].'</div>';
		}
		
		$tmp_return .= '<div class="counter" id="nrprcounter" style="display:none">'.$numbers.'</div>';
		
		return $tmp_return;
	}
	
	
	function generate_group_friends($tmp_post_id,$tmp_post_aurther) {
		global $wpdb;
		$return_data = '';
		$tmp_ok = array();
		$tmp_requests = array();
		 	$tmp_reguest = $wpdb->get_col("SELECT g1.userID FROM {$wpdb->prefix}rhc_groups_teams as g1, {$wpdb->prefix}users as u1 WHERE g1.postID = ".$_REQUEST['ID']." and g1.status=1 and g1.userID = u1.ID order by g1.cDate");



			if($tmp_post_aurther == $this->user_id ){
				foreach($tmp_reguest as $d_tmp){
					$tmpuser_info = get_userdata($d_tmp);
					$tmpdisplay_name = __('No name','rhc');
					if(!empty($tmpuser_info) and !empty($tmpuser_info->data) and !empty($tmpuser_info->data->display_name)){
						$tmpdisplay_name = $tmpuser_info->data->display_name;
					}
					$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94,$d_tmp);	
					
					$return_data .= '<div class="commentboxs avataitem pending" style="display:none;margin-top:100px;"><div class="avataritem_container" ><div class="show_link czpficon-link2" onclick="czpf_gotolink(\''.$this->generate_link_to_id($d_tmp).'\');"></div><div class="remove_heart czpficon-uni6C" onclick="czpf_group_request_remove(this,'.$_REQUEST['ID'].','.$d_tmp.')"></div><div class="show_heart czpficon-uniE2A4" onclick="czpf_group_request_approved(this,'.$_REQUEST['ID'].','.$d_tmp.')"></div><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name.'</div></div></div></div>';	
				}
				
			}
			
			
			$tmp_ok = $wpdb->get_col("SELECT g1.userID FROM {$wpdb->prefix}rhc_groups_teams as g1 , wp_users as u1  WHERE g1.postID = ".$_REQUEST['ID']." and g1.status=2 and g1.userID = u1.ID order by g1.cDate");
					
	
						
			if(!empty($return_data)){
				$return_data = '<div class="boxes" id="requestmembers"><h2>'.__('Pending Members','rhc').'</h2>'.$return_data . '<div class="clear"></div></div>';
			}

			
			if(!empty($return_data)){
				$return_data .= '<div class="boxes" id="approvemembers"><h2>'.__('Members','rhc').'</h2>';
			} else {
				$return_data .= '<div>';
			}

			if(in_array($this->user_id , $tmp_reguest)){
				$return_data .= '<div class="commentboxs avataitem join" style="display:none;margin-top:100px;"><a onclick="return false;" href="#"><div class="img_avatar_obj">'.__('Pending','rhc').'</div></a></div>';	
			} else if((!in_array($this->user_id , $tmp_reguest) && !in_array($this->user_id , $tmp_ok)) && is_user_logged_in()){
				$return_data .= '<div class="commentboxs avataitem join" style="display:none;margin-top:100px;"><a onclick="czpf_group_request_add(this,'.$_REQUEST['ID'].','.$this->user_id.');return false;" href="#"><div class="img_avatar_obj">'.__('Join','rhc').'</div></a></div>';
			}



			if(!empty($tmp_ok)){
				if($this->user_id != 0 && in_array($this->user_id, $tmp_ok)){
					$tmpuser_info = get_userdata($this->user_id);
					$tmpdisplay_name = __('No name','rhc');
					if(!empty($tmpuser_info) and !empty($tmpuser_info->data) and !empty($tmpuser_info->data->display_name)){
						$tmpdisplay_name = $tmpuser_info->data->display_name;
					}
					$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94,$this->user_id);	
					
					$return_data .= '<div class="commentboxs avataitem" style="display:none;margin-top:100px;"><div class="avataritem_container" ><div class="show_link czpficon-link2" onclick="czpf_gotolink(\''.$this->generate_link_to_id($this->user_id).'\');"></div><div class="show_heart czpficon-uni6C" onclick="czpf_group_request_remove(this,'.$_REQUEST['ID'].','.$this->user_id.')"></div><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name.'</div></div></div></div>';
				}
			
				
				foreach($tmp_ok as $d_tmp){
					if($d_tmp != $this->user_id){
						$tmpuser_info = get_userdata($d_tmp);
						$tmpdisplay_name = __('No name','rhc');
						if(!empty($tmpuser_info) and !empty($tmpuser_info->data) and !empty($tmpuser_info->data->display_name)){
							$tmpdisplay_name = $tmpuser_info->data->display_name;
						}
						$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94,$d_tmp);	
						
						
						if($tmp_post_aurther == $this->user_id &&  $tmp_post_aurther != $d_tmp){
							$return_data .= '<div class="commentboxs avataitem" style="display:none;margin-top:100px;"><div class="avataritem_container" ><div class="show_link czpficon-link2" onclick="czpf_gotolink(\''.$this->generate_link_to_id($d_tmp).'\');"></div><div class="show_heart czpficon-uni6C" onclick="czpf_group_request_remove(this,'.$_REQUEST['ID'].','.$d_tmp.')"></div><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name.'</div></div></div></div>';
						} else {
							$return_data .= '<div class="commentboxs avataitem" style="display:none;margin-top:100px;"><a href="'.$this->generate_link_to_id($d_tmp).'"><div class="avataritem_container" ><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name.'</div></div></div></a></div>';						
						}	
					}
				}
				
				
			}	
			
			$return_data .= '<div class="clear"></div></div>';	
			
			
		
		return $return_data;
	}
	

	
	
	
	
	function generate_groups($data_list = 'list', $sort = ''){
		global $wpdb;
		$this->tmp_return_data = '';
			$settings = get_option('czpf_advancede');
			
			$numbers = 10;
			if(!empty($settings['groups_limit'])){
				$numbers = $settings['groups_limit']; 
			} 
		
			if(empty($_REQUEST['paged'])){
				$_REQUEST['paged'] = 1;
			}
			
		
			$tmp_sql = '';
			if($sort=='alphabetical'){
				$tmp_sql = "SELECT u1.ID,u1.post_title,post_content FROM {$wpdb->prefix}posts as u1 WHERE u1.post_type = 'groupsteams' and u1.post_status='publish' order by u1.post_title ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
			} else if($sort=='mostusers'){
				$tmp_sql = "SELECT u1.ID,u1.post_title,post_content,( SELECT count(m.id) FROM {$wpdb->prefix}rhc_groups_teams as m,{$wpdb->prefix}users us1 WHERE m.status = 2 and m.userID = us1.ID and m.postID = u1.ID group by m.postID) as usercount FROM {$wpdb->prefix}posts as u1 WHERE u1.post_type = 'groupsteams' and u1.post_status='publish' order by usercount DESC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
			}

			$sqldata = $wpdb->get_results($tmp_sql);


			if(!empty($sqldata)){
				foreach($sqldata as $user){
					$contant_tmp = $user->post_content;
					if(!empty($contant_tmp)){
						$contant_tmp = strip_tags($contant_tmp);
						$contant_tmp = substr($contant_tmp,0, 200);
					}
					$this->tmp_return_data .= '<div class="commentboxs" style="display:none;margin-top:100px;">';

						
						$this->tmp_return_data .= '<a href="'.$this->generate_link_to_groupid($user->ID).'">';
							$tmp = '';
							
							if(has_post_thumbnail( $user->ID )){
								
								$tmp = wp_get_attachment_image_src(get_post_thumbnail_id($user->ID),  'large-feature');
								$tmp = $tmp[0];
								
							}
							
							if(empty($tmp)){
								$tmp = RHCCZPF_URL . 'images/group_default.jpg';
							}
							
							$this->tmp_return_data .= '<div class="czpf_top" style="background-image:url(\''.$tmp.'\');"></div>';
							
						
						$this->tmp_return_data .= '<div class="czpf_bottom"><h2>'.$user->post_title.'</h2></div>';
						$this->tmp_return_data .= '</a>';
					$this->tmp_return_data .= '</div>';
				}
			} else {
				if($data_list == 'list'){
					$this->tmp_return_data .= __('No teams or groups has been created.','rhc');
				} 
			}

		return $this->tmp_return_data;
	}

	
	
	function generate_memebers($data_list = 'list', $sort = ''){
		global $wpdb;
		$this->tmp_return_data = '';
			$settings = get_option('czpf_advancede');
			
			$numbers = 10;
			if(!empty($settings['members_limit'])){
				$numbers = $settings['members_limit']; 
			} 
		
			if(empty($_REQUEST['paged'])){
				$_REQUEST['paged'] = 1;
			}
			
		
			$tmp_sql = '';
			if($sort=='alphabetical' or $sort=='groups'){
				if(empty($settings['members_roles'])){
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name FROM {$wpdb->prefix}users as u1 WHERE  1 order by display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as m ON m.user_id = u1.ID WHERE m.meta_key = 'editdate' AND m.meta_value > 0 order by display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
					
				} else {
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as m ON m.user_id = u1.ID WHERE m.meta_key = 'wp_capabilities' AND m.meta_value REGEXP '".$settings['members_roles']."' order by u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as m ON m.user_id = u1.ID INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID WHERE m.meta_key = 'wp_capabilities' AND m.meta_value REGEXP '".$settings['members_roles']."' and mm.meta_key = 'editdate' AND mm.meta_value > 0 order by u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
				}	
			} else if($sort=='mostratings'){
				if(empty($settings['members_roles'])){
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rating as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 where 1 order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rating as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID WHERE mm.meta_key = 'editdate' AND mm.meta_value > 0 order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
				} else {
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rating as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID WHERE mm.meta_key = 'wp_capabilities' AND mm.meta_value REGEXP '".$settings['members_roles']."' order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rating as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID WHERE mm.meta_key = 'wp_capabilities' AND mm.meta_value REGEXP '".$settings['members_roles']."' and mmm.meta_key = 'editdate' AND mmm.meta_value > 0  order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
				}		
			} else if($sort=='mostrsvpupcoming'){
				if(empty($settings['members_roles'])){
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date >= '".date('YmdHms').",".date('Ymd')."000000' group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 where 1 order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date >= '".date('YmdHms').",".date('Ymd')."000000' group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID  where mmm.meta_key = 'editdate' AND mmm.meta_value > 0  order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
		
				} else {
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date > '".date('YmdHms').",".date('Ymd')."000000'  group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID WHERE mm.meta_key = 'wp_capabilities' AND mm.meta_value REGEXP '".$settings['members_roles']."' order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date > '".date('YmdHms').",".date('Ymd')."000000'  group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID WHERE mm.meta_key = 'wp_capabilities' AND mm.meta_value REGEXP '".$settings['members_roles']."' and m.meta_key = 'editdate' AND m.meta_value > 0 order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;					
					}
				}		
			} else if($sort=='mostrsvppastevents'){
				if(empty($settings['members_roles'])){
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date < '".date('YmdHms').",".date('Ymd')."000000' group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 where 1 order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
						} else {
							$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date < '".date('YmdHms').",".date('Ymd')."000000' group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID  where mmm.meta_key = 'editdate' AND mmm.meta_value > 0  order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
						}
				} else {
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date < '".date('YmdHms').",".date('Ymd')."000000' group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID WHERE mm.meta_key = 'wp_capabilities' AND mm.meta_value REGEXP '".$settings['members_roles']."' order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(k1.postID) as counts FROM {$wpdb->prefix}rhc_rsvp as k1,{$wpdb->prefix}usermeta as m WHERE (k1.email = u1.user_email COLLATE utf8_general_ci and m.umeta_id = 1) or ( m.user_id = u1.ID and  m.meta_key in ('facebook_email_czpf','googleplus_email_czpf','linkedin_email_czpf','twitter_email_czpf') and k1.email = m.meta_value COLLATE utf8_general_ci) and k1.answer = 1 and k1.event_date < '".date('YmdHms').",".date('Ymd')."000000' group by k1.postID limit 1) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as mm ON mm.user_id = u1.ID INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID WHERE mm.meta_key = 'wp_capabilities' AND mm.meta_value REGEXP '".$settings['members_roles']."' and mmm.meta_key = 'editdate' AND mmm.meta_value > 0 order by countss DESC,u1.display_name ASC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
				}		
			} else if($sort=='mostpost'){
				if(empty($settings['members_roles'])){
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(*) as counts FROM {$wpdb->prefix}posts as k1 WHERE  k1.post_status = 'publish' and k1.post_author = u1.ID ) as 'countss' FROM {$wpdb->prefix}users as u1 WHERE  1 order by countss DESC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(*) as counts FROM {$wpdb->prefix}posts as k1 WHERE  k1.post_status = 'publish' and k1.post_author = u1.ID ) as 'countss' FROM {$wpdb->prefix}users as u1  INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID WHERE mmm.meta_key = 'editdate' AND mmm.meta_value > 0 order by countss DESC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
				} else {
					if(empty($settings['hide_member_with_no_data'])){
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(*) as counts FROM {$wpdb->prefix}posts as k1 WHERE  k1.post_status = 'publish' and k1.post_author = u1.ID ) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as m ON m.user_id = u1.ID WHERE m.meta_key = 'wp_capabilities' AND m.meta_value REGEXP '".$settings['members_roles']."' order by countss DESC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					} else {
						$tmp_sql = "SELECT u1.ID,u1.display_name,(SELECT count(*) as counts FROM {$wpdb->prefix}posts as k1 WHERE  k1.post_status = 'publish' and k1.post_author = u1.ID ) as 'countss' FROM {$wpdb->prefix}users as u1 INNER JOIN {$wpdb->prefix}usermeta as m ON m.user_id = u1.ID INNER JOIN {$wpdb->prefix}usermeta as mmm ON mmm.user_id = u1.ID  WHERE m.meta_key = 'wp_capabilities' AND m.meta_value REGEXP '".$settings['members_roles']."' and mmm.meta_key = 'editdate' AND mmm.meta_value > 0 order by countss DESC limit ".($numbers*($_REQUEST['paged']-1)).",".$numbers;
					}
				}

			}
			
			
			
			$sqldata = $wpdb->get_results($tmp_sql);


			if(!empty($sqldata)){
				foreach($sqldata as $user){
					$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94,$user->ID);
				
						$this->tmp_return_data .= '<div class="commentboxs" style="display:none;margin-top:100px;">';
						$this->tmp_return_data .= '<a href="'.$this->generate_link_to_id($user->ID).'">';
						$this->tmp_return_data .= '<img class="img_avatar_obj" width="75" height="75" class="avatar avatar-75 photo" src="'.$tmp.'" alt="'.$user->display_name.'">';
						$this->tmp_return_data .= '<div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$user->display_name.'</div></div>';
						$this->tmp_return_data .= '</a>';
						$this->tmp_return_data .= '</div>';
				}
			} else {
				if($data_list == 'list'){
					$this->tmp_return_data .= __('There is no members add at this moment','rhc');
				} 
			}

		return $this->tmp_return_data;
	}
	


	
	function extra_generate_list($data_list = 'show_friends',$list_type='list',$numbers = 10){
		global $post,$wpdb;
		
		
		if(empty($_REQUEST['paged'])){
			$_REQUEST['paged'] = 1;
		}
		
		$tmp_format_date = get_option('date_format');
		$tmp_format_time = get_option('time_format');
		
		if($data_list == 'show_friends'){
			$friends_lists = get_user_meta($this->check_up_user_id, 'friends_list', true);
			
			$tmp_pending = '';
			$tmp_requests = '';
			$tmp_ok = '';
		
			
			if(!empty($friends_lists)){
				foreach($friends_lists as $key => $friends_list){
					$tmpuser_info = get_userdata($key);
										
					if(!empty($tmpuser_info)){
						$tmpdisplay_name = __('No name','rhc');
						if(!empty($tmpuser_info) and !empty($tmpuser_info->data) and !empty($tmpuser_info->data->display_name)){
							$tmpdisplay_name = $tmpuser_info->data->display_name;
						}
					
						$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94,$key);
						
						if($friends_list == 'ok'){
							$tmp_ok .= '<div class="commentboxs avataitem" style="display:none;margin-top:100px;"><a href="'.$this->generate_link_to_id($key).'"><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name .'</div></div></a></div>';
						} else if($friends_list == 'pending') {
							$tmp_pending .= '<div class="commentboxs1 avataitem" style="display:none;margin-top:100px;"><a href="'.$this->generate_link_to_id($key).'"><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name .'</div></div></a></div>';
						} else if($friends_list == 'requests') {
							$tmp_requests .= '<div class="commentboxs2 avataitem" style="display:none;margin-top:100px;"><div class="avataritem_container" ><div class="show_link czpficon-link2" onclick="czpf_gotolink(\''.$this->generate_link_to_id($key).'\');"></div><div class="show_heart czpficon-uniE2A4" onclick="czpf_friend_check(this,'.$this->user_id.','.$key.',true)"></div><div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div><div class="czpf_tooltip"><div class="czpf_tooltip_sub">'.$tmpdisplay_name.'</div></div></div></div>';
						}	
					}
				}
				
				if((!empty($tmp_pending) or !empty($tmp_requests)) && !empty($this->user_id) && !empty($this->check_up_user_id) && $this->user_id == $this->check_up_user_id){
					
					if(!empty($tmp_ok)){
						$this->tmp_return_data .= '<div class="col-front-6">';
						$this->tmp_return_data .= '<h1>'.__('Friends','rhc').'</h1>';
						$this->tmp_return_data .= $tmp_ok;
						$this->tmp_return_data .= '</div><div class="col-front-1"></div>';
						$this->tmp_return_data .= '<div class="col-front-5">';
						
						if(!empty($tmp_requests)){
							$this->tmp_return_data .= '<h1>'.__('Friend requests','rhc').'</h1>';
							$this->tmp_return_data .= $tmp_requests;	
						}
						if(!empty($tmp_pending)){
							$this->tmp_return_data .= '<h1>'.__('Pending friends','rhc').'</h1>';
							$this->tmp_return_data .= $tmp_pending;
						}
						$this->tmp_return_data .= '</div>';
					} else {
						$this->tmp_return_data .= '<div class="col-front-6">';
						$this->tmp_return_data .= '<h1>'.__('Friend requests','rhc').'</h1>';
						$this->tmp_return_data .= $tmp_requests;
						$this->tmp_return_data .= '</div><div class="col-front-1"></div>';
						$this->tmp_return_data .= '<div class="col-front-5">';
						$this->tmp_return_data .= '<h1>'.__('Pending friends','rhc').'</h1>';
						$this->tmp_return_data .= $tmp_pending;
						$this->tmp_return_data .= '</div>';	
					}
				} else {
					if(!empty($tmp_ok)){
						$this->tmp_return_data .= $tmp_ok;
					} else {
						$this->tmp_return_data .= __('Sorry, but you have no friends or friend requests.','rhc');
					}
				}
				
			} else {
				$this->tmp_return_data .= '<h1>'.__('Friends','rhc').'</h1>';
				$this->tmp_return_data .= '<div class="nodata">'.__('Sorry, but you have no friends or friend requests.','rhc').'</div>'; 
			}
		} else if($data_list == 'show_postevents') {
		    $my_query = new WP_Query( array( 
		    'posts_per_page' => $numbers,
		    'author' => $this->check_up_user_id, 
		    'post_type' => 'post',
		    'paged' => ($_REQUEST['paged']) ? $_REQUEST['paged'] : 1
		    ) );

		    $curent_data_post = '';
			$curent_data_comment = '';
			
			
			if ( $my_query -> have_posts() ) :
				while ( $my_query -> have_posts()) : $my_query -> the_post();
					$get_data = date($tmp_format_date, strtotime($my_query->post->post_date)).' '. date($tmp_format_time, strtotime($my_query->post->post_date));
					$curent_data_post .= '<div class="profil_obj commentboxs" style="display:none;margin-top:100px;"><table><tr><td>';
					$tmp = '';
					if(has_post_thumbnail( $my_query->post->ID )){
					
						$tmp = wp_get_attachment_thumb_url( get_post_thumbnail_id( $my_query->post->ID ));
	
						if(empty($tmp)){
							$curent_data_post .= '<div class="img_thumbnail_obj noimageobject czpficon-uniE262"></div>';
						} else {
							$curent_data_post .= '<div class="img_thumbnail_obj" style="background-image:url(\''.$tmp.'\')"></div>';
						}	
	
					} else {
						$curent_data_post .= '<div class="img_thumbnail_obj noimageobject czpficon-uniE262"></div>';
					}
					
					
					
					
					$curent_data_post .= '</td><td>';
					$curent_data_post .= '<div class="col-front-12 czpf_rsvp_main"><div class="col-front-8 first czpf_rsvp_title"><a href="'.get_permalink( $my_query->post->ID ) .'">'.$my_query->post->post_title .'</a></div><div class="col-front-4 czpf_rsvp_date">'.$get_data.'</div></div><div class="clear"></div><div class="col-front-12">';
					if(!empty($my_query->post->post_excerpt)){
						$curent_data_post .= $my_query->post->post_excerpt;
					} else {
						$curent_data_post .= $this->desc_excerpt($my_query->post->post_content,200,'<a href="'.get_permalink( $my_query->post->ID ) .'"> ...</a>');
					}
					$curent_data_post .= '</div></td></tr></table></div>';
				endwhile;		
			endif;	
			
			$settings = get_option('czpf_advancede');
			
			$offset = ($_REQUEST['paged']) ? (($_REQUEST['paged']-1)*$numbers) : 0;
			
			
			$tmp_sql10 = "SELECT * FROM {$wpdb->comments} as k1, {$wpdb->posts} as k2 WHERE k1.user_id = ".$this->check_up_user_id." and k1.comment_approved = 1 and k1.comment_post_ID = k2.ID and k2.post_type in ('post','page') order by comment_date DESC limit ".$offset.",".$numbers;
				
			$comments = $wpdb->get_results($tmp_sql10);		
			
		
		    
			foreach($comments as $comment) :
			
					$get_data = date($tmp_format_date, strtotime($comment->comment_date)).' '. date($tmp_format_time, strtotime($comment->comment_date));
			
					$curent_data_comment .= '<div class="profil_obj commentboxs2" style="display:none;margin-top:100px;"><table><tr><td>';
					$tmp = '';
					$tmp = $this->get_avatar_url($this->location.'images/default_avatar.jpg');
					$curent_data_comment .= '<div class="img_avatar_obj" style="background-image:url(\''.$tmp.'\')"></div>';
					
					$curent_data_comment .= '</td><td>';
					$curent_data_comment .= '<div class="col-front-12 czpf_rsvp_main"><div class="col-front-8 first czpf_rsvp_title"><a href="'.get_permalink( $comment->comment_post_ID ) .'">'.$comment->post_title .'</a></div><div class="col-front-4 czpf_rsvp_date">'.$get_data.'</div></div><div class="clear"></div><div class="col-front-12">';
					$curent_data_comment .= $this->desc_excerpt($comment->comment_content,400,'<a href="'.get_permalink( $comment->comment_post_ID  ) .'"> ...</a>');
					$curent_data_comment .= '</div></td></tr></table></div>';
			endforeach;
			
			
			
			
			
			


			
			
			if($list_type != 'extend'){
				if(empty($curent_data_post)){
					$curent_data_post .= '<div class="nodata">'.__('You have no posts.','rhc').'</div>';	
				}
				if(empty($curent_data_comment)){
					$curent_data_comment .= '<div class="nodata">'.__('You have no comments.','rhc').'</div>';	
				}
				
				
				
				if(!empty($settings['show_post'])){
					$this->tmp_return_data .= 	'<div class="col-front-12 ex1">';
					$this->tmp_return_data .=		$curent_data_post;
					$this->tmp_return_data .= 	'</div>';
				}
				
				if(!empty($settings['show_comment'])){
					$this->tmp_return_data .= 	'<div class="col-front-12 ex2">';
					if(!empty($settings['show_post'])){
						$this->tmp_return_data .=		'<h1>'.__('Comments','rhc').'</h1>';
					}
					$this->tmp_return_data .=		$curent_data_comment;
					$this->tmp_return_data .= 	'</div>';
				}

				
			} else {
				return array($curent_data_post,$curent_data_comment);
			}
		} else if($data_list == 'show_upcoming' || $data_list == 'show_pastevents'){
			
			$user_info = get_userdata($this->check_up_user_id);
			$email_check = '';
			$tmp_facebook = get_user_meta($this->check_up_user_id, 'facebook_email_czpf', true);
			$tmp_googleplus = get_user_meta($this->check_up_user_id, 'googleplus_email_czpf', true);
			$tmp_linkedin = get_user_meta($this->check_up_user_id, 'linkedin_email_czpf', true);
			$tmp_twitter = get_user_meta($this->check_up_user_id, 'twitter_email_czpf', true);
			
			if(!empty($tmp_facebook)){
				$email_check .= "'".$tmp_facebook."',";
			}
			if(!empty($tmp_googleplus)){
				$email_check .= "'".$tmp_googleplus."',";
			}
			if(!empty($tmp_linkedin)){
				$email_check .= "'".$tmp_linkedin."',";
			}
			if(!empty($tmp_twitter)){
				$email_check .= "'".$tmp_twitter."',";
			}
			
			$email_check .= "'".$user_info->user_email ."'";
			
			
			
			if($data_list == 'show_pastevents'){
		   	 	$sql1 = "SELECT postID,event_date FROM {$wpdb->prefix}rhc_rsvp where email in (".$email_check.")  and event_date < '".date('YmdHms').",".date('Ymd')."000000' ORDER BY event_date DESC limit ".(($_REQUEST['paged']) ? (($_REQUEST['paged']-1)*$numbers) : 0).",10";
			} else {
				$sql1 = "SELECT postID,event_date FROM {$wpdb->prefix}rhc_rsvp where email in (".$email_check.")  and event_date >= '".date('YmdHms').",".date('Ymd')."000000' ORDER BY event_date ASC limit ".(($_REQUEST['paged']) ? (($_REQUEST['paged']-1)*$numbers) : 0).",10";
			}
			
			$sqldata1 = $wpdb->get_results($sql1);
			
			$curent_data_post = '';
		
			if(!empty($sqldata1)){
				foreach($sqldata1 as $sqldata){
					$post_tmp = get_post($sqldata->postID, ARRAY_A);


					$get_data = explode(',', $sqldata->event_date);
					$get_data = date($tmp_format_date, strtotime($get_data[0])).' '. date($tmp_format_time, strtotime($get_data[0]));
					
					if(!empty($post_tmp)){
						$curent_data_post .= '<div class="col-front-12 profil_obj commentboxs" style="display:none;margin-top:100px;"><table><tr><td>';
						$tmp = '';
						
						
							$attachment_id = get_post_meta( $sqldata->postID, 'rhc_tooltip_image', true);
							if(empty($attachment_id) && !is_numeric($attachment_id)){
								$tmp = wp_get_attachment_image_src(get_post_thumbnail_id($sqldata->postID));	
								if(!empty($tmp)){
									$tmp= $tmp[0];
								}	
							}else{
								$tmp=wp_get_attachment_image_src( $attachment_id, array(64,64));
								if(!empty($tmp)){
									$tmp= $tmp[0];
								}	
							}
							
						
						if(!empty($tmp)){
							$curent_data_post .= '<div class="img_thumbnail_obj" style="background-image:url(\''.$tmp.'\')"></div>';
						} else if(empty($tmp) && has_post_thumbnail( $sqldata->postID )){
						
							$tmp = wp_get_attachment_thumb_url( get_post_thumbnail_id( $sqldata->postID ));
							
							if(empty($tmp)){
								$curent_data_post .= '<div class="img_thumbnail_obj noimageobject czpficon-uniE262"></div>';
							} else {
								$curent_data_post .= '<div class="img_thumbnail_obj" style="background-image:url(\''.$tmp.'\')"></div>';
							}
	
						} else {
							$curent_data_post .= '<div class="img_thumbnail_obj noimageobject czpficon-uniE262"></div>';
						}
						$curent_data_post .= '</td><td>';
						$curent_data_post .= '<div class="col-front-12 czpf_rsvp_main"><div class="col-front-8 first czpf_rsvp_title"><a href="'.get_permalink( $sqldata->postID ) .'">'.$post_tmp['post_title'] .'</a></div><div class="col-front-4 czpf_rsvp_date">'.$get_data.'</div></div><div class="clear"></div><div class="col-front-12">';
						if(!empty($post_tmp['post_excerpt'])){
							$curent_data_post .= $post_tmp['post_excerpt'];
						} else {
							$curent_data_post .= $this->desc_excerpt($post_tmp['post_content'],400,'<a href="'.get_permalink( $sqldata->postID) .'"> ...</a>');
						}
						$curent_data_post .= '</div></td></tr></table></div>';

					} 	
				}
				
			}
		
			if($list_type != 'extend'){
				if(empty($curent_data_post) && $data_list == 'show_pastevents'){
					$curent_data_post .= '<div class="nodata">'.__('You have no past events.','rhc').'</div>';	
				} if(empty($curent_data_post)){
					$curent_data_post .= '<div class="nodata">'.__('You have no upcoming events.','rhc').'</div>';	
				}
				
				if($data_list == 'show_pastevents'){
					//$this->tmp_return_data .= '<h1>'.__('Past events','rhc').'</h1>';
				} else {
					//$this->tmp_return_data .= '<h1>'.__('Upcoming events','rhc').'</h1>';
				}
									
				$this->tmp_return_data .= '<div class="col-front-12 ex1">';
				$this->tmp_return_data .=		$curent_data_post;
				$this->tmp_return_data .= '</div>';
				
			} else {
				return array($curent_data_post);
			}
			
			
			
			
		} else if($data_list == 'show_rating'){
			global $rhc_rating_plugin,$post,$wpdb;
				$curent_data_post = '';
				if(defined('RHCRATING_URL')){
					$settings = get_option('rhc_rating_options');
	
					$icon_count = 5;
					$icon_type = 'star';
	
					if(!empty($settings['rating_icon_numbers'])){
						$icon_count = (int)$settings['rating_icon_numbers'];
					}
					if(!empty($settings['rating_icon_type'])){
						$icon_type = $settings['rating_icon_type'];
					}
					
					if($icon_type == 'faces'){
						$icon_count = 7;
					}
					
					if(empty($_REQUEST['paged'])){
						$_REQUEST['paged'] = 1;
					}
	
					$user_info = get_userdata($this->check_up_user_id);
					
					$email_check = '';
					$tmp_facebook = get_user_meta($this->check_up_user_id, 'facebook_email_czpf', true);
					$tmp_googleplus = get_user_meta($this->check_up_user_id, 'googleplus_email_czpf', true);
					$tmp_linkedin = get_user_meta($this->check_up_user_id, 'linkedin_email_czpf', true);
					$tmp_twitter = get_user_meta($this->check_up_user_id, 'twitter_email_czpf', true);
					
					if(!empty($tmp_facebook)){
						$email_check .= "'".$tmp_facebook."',";
					}
					if(!empty($tmp_googleplus)){
						$email_check .= "'".$tmp_googleplus."',";
					}
					if(!empty($tmp_linkedin)){
						$email_check .= "'".$tmp_linkedin."',";
					}
					if(!empty($tmp_twitter)){
						$email_check .= "'".$tmp_twitter."',";
					}
					
					$email_check .= "'".$user_info->user_email ."'";
							
					$tmp_avatar_url = $this->get_avatar_url($this->location.'images/default_avatar.jpg',94);
	
					$get_list_sql = "SELECT * FROM {$wpdb->prefix}rhc_rating WHERE ".($settings['rating_accept_inputs'] == true ? ' `show`=1 and' : '')." email in (".$email_check.") and rating <= ".$icon_count. " order by cDate DESC limit ".($numbers*($_REQUEST['paged']-1)).",".($numbers*$_REQUEST['paged']);
					
					$get_list_date = $wpdb->get_results($get_list_sql);
					
					
					if(!empty($get_list_date)){
						foreach($get_list_date as $tmp_key => $tmp_data){
						
						
							$attachment_id = get_post_meta( $tmp_data->postID, 'rhc_tooltip_image', true);
							if(empty($attachment_id) && !is_numeric($attachment_id)){
								$tmp_url = wp_get_attachment_image_src(get_post_thumbnail_id($tmp_data->postID));	
								if(!empty($tmp_url)){
									$tmp_url= $tmp_url[0];
								}	
							}else{
								$tmp_url=wp_get_attachment_image_src( $attachment_id, array(64,64));
								if(!empty($tmp_url)){
									$tmp_url= $tmp_url[0];
								}	
							}
							
							if(empty($tmp_url) && has_post_thumbnail( $tmp_data->postID )){
							
								$tmp_url = wp_get_attachment_thumb_url( get_post_thumbnail_id( $tmp_data->postID));
								
							} else if(empty($tmp_url)) {
								$tmp_url = $tmp_avatar_url;
							}
						
							$curent_data_post .= $this->rsvp_generate_avatar($tmp_data->email,get_the_title($tmp_data->postID),$tmp_url,get_permalink( $tmp_data->postID ),$tmp_data->rating,$tmp_data->cDate,$tmp_data->comment,$settings,false);
						}
					}	
					
					$return_showmore = 'more';
					
					if(count($get_list_date) < ($numbers+1)){
						$return_showmore = '';
					}
				}	
					
				if($list_type != 'extend'){
					if(empty($curent_data_post)){
						$curent_data_post .= '<div class="nodata">'.__('You have no ratings and reviews.','rhc').'</div>';	
					}
					
					$this->tmp_return_data .= '<div class="cit_rhc_rating_ rhc">';				
					$this->tmp_return_data .= '<div class="col-front-12 row-fluid ex1" id="rhc_rating_pos3">';
					$this->tmp_return_data .=		$curent_data_post;
					$this->tmp_return_data .= '</div></div>';
					
				} else {
					return array($curent_data_post);
				}
		}
		
		return '';
	}
	
	function rsvp_generate_avatar($email,$firstName,$externUrlPhoto,$externUrl,$rating,$cDate,$comment,$settings,$show = true){
		$return_data_content = '';
		$get_avatar = '';
		$faces_array = array('icon-angry','icon-sad','icon-wondering','icon-neutral','icon-cool','icon-smiley','icon-happy');	
						
		if(!empty($externUrlPhoto)){
			$get_avatar = '<img width="75" height="75" class="avatar avatar-75 photo" src="'.$externUrlPhoto.'">';
		}
		
		if(!empty($settings['rating_icon_numbers'])){
			$icon_count = (int)$settings['rating_icon_numbers'];
		}
		if(!empty($settings['rating_icon_type'])){
			$icon_type = $settings['rating_icon_type'];

			if($icon_type == 'faces'){
				$icon_count = 7;
			}
		}		
		
		$tmp_format_date = get_option('date_format');
		$tmp_format_time = get_option('time_format');
		
		if(!empty($comment)){
			$comment=preg_replace("/[\n\r]/","<br>",$comment);
		    $comment = preg_replace('/(<br( \/|)>)+(<br( \/|)>)+(<br( \/|)>)+/', '<br><br>', $comment); 
		}
		
		
		$return_data_content .= '<div class="rhc_rating_tooltip_start">';
		
		if(!empty($settings['rating_show_link']) && !empty($externUrl)){
			$return_data_content .= '<a target="_blank" href="'.$externUrl.'">';
		}
		$return_data_content .= $get_avatar;
		
		if(!empty($settings['rating_show_link']) && !empty($externUrl)){
			$return_data_content .= '</a>';
		}

		$return_data_content .= '</div>';
		
		
					$return_data_content2 = '<div class="commentboxs" style="display:'.($show == true?'block':'none;margin-top:100px').';"><table width="100%"><tr><td class="td_avatar">';		
						$return_data_content2 .= $return_data_content;
						$return_data_content2 .= '</td><td valign="top">';
							$return_data_content2 .= '<div class="span12 first">';
								$return_data_content2 .= '<div class="span7 first">';
									$return_data_content2 .= '<div class="commentheadtext"><a href="'.$externUrl.'">'. $firstName.'</a></div>';
									
									
								$return_data_content2 .= '</div>';	
								$return_data_content2 .= '<div class="span5 timeClock">';
									$return_data_content2 .= strtoupper(date($tmp_format_date.' '.$tmp_format_time,strtotime($cDate)));
									$return_data_content2 .= '<div style="font-size: 10px ! important; margin-right: -5px; margin-top: 5px;">';
									for($i=0;$i<$icon_count;$i++){
										if($icon_type == 'faces'){
											if($i == floor($rating-0.5)){
												$return_data_content2 .= '<div class="'.$faces_array[$i].' commentselect"></div>';
											} else {
												$return_data_content2 .= '<div class="'.$faces_array[$i].'-3 commentselect"></div>';
											}	
										} else {
											if(floatval($i - 0.25) <= floatval($rating-1)){
												$return_data_content2 .= '<div class="icon-'.$icon_type.' commentselect"></div>';
											} else if(($i - 0.75) <= floatval($rating-1)){
												$return_data_content2 .= '<div class="icon-'.$icon_type.'-2 commentselect"></div>';	
											} else {
												$return_data_content2 .= '<div class="icon-'.$icon_type.'-3 commentselect"></div>';	
											}	
										}
									}
									$return_data_content2 .= '</div>';
								$return_data_content2 .= '</div>';	
							$return_data_content2 .= '</div>';	
							$return_data_content2 .= '<div class="textcomment span12 first">';	
								$return_data_content2 .= $comment;
							$return_data_content2 .= '</div>';
							
					$return_data_content2 .= '</td></tr></table></div>';

		
					
		return $return_data_content2;
	}	
	
	
    // -----------------------------------
	// settings
	// -----------------------------------
	
	function all_icons(){
		$tmp = array('no-icon',
		
'czpficon-uni62',
'czpficon-uni65',
'czpficon-uni67',
'czpficon-uni68',
'czpficon-uni6A',
'czpficon-uni6C',
'czpficon-uni72',
'czpficon-uni76',
'czpficon-uni41',
'czpficon-uni4C',
'czpficon-uni52',
'czpficon-uni59',
'czpficon-uni27',
'czpficon-uni2F',
'czpficon-uni3D',
'czpficon-uni5E',
'czpficon-uni5F',
'czpficon-uni60',
'czpficon-uniE039',
'czpficon-uniE03A',
'czpficon-uniE005',
'czpficon-uniE022',
'czpficon-uniE024',
'czpficon-uniE025',
'czpficon-uniE026',
'czpficon-uniE030',
'czpficon-uniE035',
'czpficon-uniE037',
'czpficon-uniE038',
'czpficon-uniE03B',
'czpficon-uniE03C',
'czpficon-uniE042',
'czpficon-uniE046',
'czpficon-uniE047',
'czpficon-uniE063',
'czpficon-uniE065',
'czpficon-uniE066',
'czpficon-uniE082',
'czpficon-uniE08C',
'czpficon-uniE08E',
'czpficon-uniE099',
'czpficon-uniE0AB',
'czpficon-uniE0B1',
'czpficon-uniE0B2',
'czpficon-uniE0B4',
'czpficon-uniE0B5',
'czpficon-uniE0B6',
'czpficon-uniE0B7',
'czpficon-uniE0B8',
'czpficon-uniE0B9',
'czpficon-uniE0C6',
'czpficon-uniE0E7',
'czpficon-uniE0E8',
'czpficon-uniE0EE',
'czpficon-uniE0EF',
'czpficon-uniE0F0',
'czpficon-uniE0F1',
'czpficon-uniE0F9',
'czpficon-uniE12D',
'czpficon-uniE134',
'czpficon-uniE145',
'czpficon-uniE146',
'czpficon-uniE14A',
'czpficon-uniE164',
'czpficon-uniE184',
'czpficon-uniE18B',
'czpficon-uniE18F',
'czpficon-uniE190',
'czpficon-uniE1B5',
'czpficon-uniE1BF',
'czpficon-uniE1C9',
'czpficon-uniE1DE',
'czpficon-uniE1E8',
'czpficon-uniE1F4',
'czpficon-uniE204',
'czpficon-uniE216',
'czpficon-uniE263',
'czpficon-uniE267',
'czpficon-uniE278',
'czpficon-uniE293',
'czpficon-uniE294',
'czpficon-uniE297',
'czpficon-uniE2A4',
'czpficon-uniE2B0',
'czpficon-uniE2B4',
'czpficon-uniE2B6',
'czpficon-uniE2BE',
'czpficon-uniE2BF',
'czpficon-uniE2C0',
'czpficon-uniE2D5',
'czpficon-uniE2D7',
'czpficon-uniE2DA',
'czpficon-uniE2E2',
'czpficon-uniE2EC',
'czpficon-uniE2F6',
'czpficon-uniE2F9',
'czpficon-uniE2FC',
'czpficon-uniE2FD',
'czpficon-uniE2FE',
'czpficon-uniE2FF',
'czpficon-uniE300',
'czpficon-uniE301',
'czpficon-uniE302',
'czpficon-uniE303',
'czpficon-uniE304',
'czpficon-uniE305',
'czpficon-uniE316',
'czpficon-uniE317',
'czpficon-uniE318',
'czpficon-uniE319',
'czpficon-uniE31E',
'czpficon-uniE31F',
'czpficon-uniE322',
'czpficon-uniE323',
'czpficon-uniE324',
'czpficon-uniE325',
'czpficon-uniE334',
'czpficon-uniE337',
'czpficon-uniE33A',
'czpficon-uniE33F',
'czpficon-uniE346',
'czpficon-uniE349',
'czpficon-uniE35A',
'czpficon-uniE35B',
'czpficon-uniE35D',
'czpficon-uniE362',
'czpficon-uniE372',
'czpficon-uniE3B2',
'czpficon-uniE3B3',
'czpficon-uniE3BB',
'czpficon-uniE3BD',
'czpficon-uniE3C1',
'czpficon-uniE3C4',
'czpficon-uniE3C7',
'czpficon-uniE3C8',
'czpficon-uniE3D2',
'czpficon-uniE3D8',
'czpficon-uniE3E2',
'czpficon-uniE3E7',
'czpficon-uniE3EC',
'czpficon-uniE3F1',
'czpficon-uniE3F2',
'czpficon-uniE3F9',
'czpficon-uniE406',
'czpficon-uniE414',
'czpficon-uniE415',
'czpficon-uniE426',
'czpficon-uniE431',
'czpficon-uniE43F',
'czpficon-uniE443',
'czpficon-uniE44C',
'czpficon-uniE452',
'czpficon-uniE458',
'czpficon-uniE459',
'czpficon-uniE45B',
'czpficon-uniE462',
'czpficon-uniE463',
'czpficon-uniE46C',
'czpficon-uniE4B9',
'czpficon-uniE477',
'czpficon-uniE4CE',
'czpficon-uniE4D2',
'czpficon-uniE4D9',
'czpficon-uniE4DA',
'czpficon-uniE4DB',
'czpficon-uniE4E6',
'czpficon-uniE502',
'czpficon-uniE50C',
'czpficon-uniE520',
'czpficon-uniE524',
'czpficon-uniE52D',
'czpficon-uniE52E',
'czpficon-uniE52F',
'czpficon-uniE548',
'czpficon-uniE54C',
'czpficon-uniE553',
'czpficon-uniE554',
'czpficon-uniE558',
'czpficon-uniE559',
'czpficon-uniE55E',
'czpficon-uniE55F',
'czpficon-uniE560',
'czpficon-uniE561',
'czpficon-uniE5C7',
'czpficon-uniE097',
'czpficon-uniE098',
'czpficon-uniE000',
'czpficon-uniE001',
'czpficon-uniE002',
'czpficon-uniE004',
'czpficon-uniE007',
'czpficon-uniE009',
'czpficon-uniE00B',
'czpficon-uniE011',
'czpficon-uniE015',
'czpficon-uniE01A',
'czpficon-uniE027',
'czpficon-uniE02B',
'czpficon-uniE032',
'czpficon-uniE044',
'czpficon-uniE04C',
'czpficon-uniE050',
'czpficon-uniE056',
'czpficon-uniE057',
'czpficon-uniE058',
'czpficon-uniE064',
'czpficon-uniE080',
'czpficon-uniE083',
'czpficon-uniE084',
'czpficon-uniE085',
'czpficon-uniE08F',
'czpficon-uniE093',
'czpficon-uniE094',
'czpficon-uniE096',
'czpficon-uniE09A',
'czpficon-uniE09B',
'czpficon-uniE0A0',
'czpficon-uniE0A4',
'czpficon-uniE0A5',
'czpficon-uniE0C1',
'czpficon-uniE0C3',
'czpficon-uniE0C4',
'czpficon-uniE0E0',
'czpficon-uniE0EA',
'czpficon-uniE0EC',
'czpficon-uniE0F7',
'czpficon-uniE109',
'czpficon-uniE10F',
'czpficon-uniE110',
'czpficon-uniE112',
'czpficon-uniE113',
'czpficon-uniE114',
'czpficon-uniE115',
'czpficon-uniE116',
'czpficon-uniE117',
'czpficon-uniE147',
'czpficon-uniE148',
'czpficon-uniE14C',
'czpficon-uniE14D',
'czpficon-uniE14E',
'czpficon-uniE14F',
'czpficon-uniE157',
'czpficon-uniE18C',
'czpficon-uniE192',
'czpficon-uniE1A3',
'czpficon-uniE1A4',
'czpficon-uniE1A8',
'czpficon-uniE1C2',
'czpficon-uniE1E2',
'czpficon-uniE1E9',
'czpficon-uniE1ED',
'czpficon-uniE1EE',
'czpficon-uniE213',
'czpficon-uniE21D',
'czpficon-uniE227',
'czpficon-uniE23C',
'czpficon-uniE246',
'czpficon-uniE252',
'czpficon-uniE262',
'czpficon-uniE274',
'czpficon-uniE2C1',
'czpficon-uniE2C5',
'czpficon-uniE2D6',
'czpficon-uniE2F1',
'czpficon-uniE2F2',
'czpficon-uniE2F5',
'czpficon-uniE306',
'czpficon-uniE30E',
'czpficon-uniE312',
'czpficon-uniE314',
'czpficon-uniE31C',
'czpficon-uniE31D',
'czpficon-uniE320',
'czpficon-uniE333',
'czpficon-uniE335',
'czpficon-uniE338',
'czpficon-uniE340',
'czpficon-uniE34A',
'czpficon-uniE354',
'czpficon-uniE35C',
'czpficon-uniE35F',
'czpficon-uniE360',
'czpficon-uniE361',
'czpficon-uniE363',
'czpficon-uniE364',
'czpficon-uniE365',
'czpficon-uniE366',
'czpficon-uniE367',
'czpficon-uniE368',
'czpficon-uniE369',
'czpficon-uniE374',
'czpficon-uniE375',
'czpficon-uniE376',
'czpficon-uniE377',
'czpficon-uniE37C',
'czpficon-uniE37D',
'czpficon-uniE380',
'czpficon-uniE381',
'czpficon-uniE382',
'czpficon-uniE383',
'czpficon-uniE392',
'czpficon-uniE395',
'czpficon-uniE398',
'czpficon-uniE39D',
'czpficon-uniE39F',
'czpficon-uniE3A7',
'czpficon-uniE3B4',
'czpficon-uniE3B8',
'czpficon-uniE3BC',
'czpficon-uniE3BE',
'czpficon-uniE3D0',
'czpficon-uniE410',
'czpficon-uniE411',
'czpficon-uniE419',
'czpficon-uniE41B',
'czpficon-uniE41F',
'czpficon-uniE422',
'czpficon-uniE425',
'czpficon-uniE427',
'czpficon-uniE430',
'czpficon-uniE436',
'czpficon-uniE440',
'czpficon-uniE445',
'czpficon-uniE44A',
'czpficon-uniE44F',
'czpficon-uniE450',
'czpficon-uniE457',
'czpficon-uniE464',
'czpficon-uniE472',
'czpficon-uniE473',
'czpficon-uniE480',
'czpficon-uniE48F',
'czpficon-uniE49F',
'czpficon-uniE4A2',
'czpficon-uniE4AA',
'czpficon-uniE4C4',
'czpficon-uniE4CD',
'czpficon-uniE4D7',
'czpficon-uniE4D8',
'czpficon-uniE4DC',
'czpficon-uniE4DE',
'czpficon-uniE4E0',
'czpficon-uniE4E1',
'czpficon-uniE510',
'czpficon-uniE521',
'czpficon-uniE52C',
'czpficon-uniE537',
'czpficon-uniE538',
'czpficon-uniE539',
'czpficon-uniE544',
'czpficon-uniE562',
'czpficon-uniE56A',
'czpficon-uniE57E',
'czpficon-uniE582',
'czpficon-uniE58B',
'czpficon-uniE58C',
'czpficon-uniE58D',
'czpficon-uniE5A6',
'czpficon-uniE5AA',
'czpficon-uniE5AC',
'czpficon-uniE5B1',
'czpficon-uniE5B2',
'czpficon-uniE5B6',
'czpficon-uniE5B7',
'czpficon-uniE5BC',
'czpficon-uniE5BD',
'czpficon-uniE5BE',
'czpficon-uniE5BF',
'czpficon-uniE625',
'czpficon-link',
'czpficon-heart',
'czpficon-heart-brokenextra',
'czpficon-spinner',
'czpficon-camera',
'czpficon-camera2',
'czpficon-gamepad',
'czpficon-bubble-notification',
'czpficon-stack-plus',
'czpficon-stack-minus',
'czpficon-stack-star',
'czpficon-stack-picture',
'czpficon-stack-down',
'czpficon-warning',
'czpficon-warning2',
'czpficon-notification',
'czpficon-notification2',
'czpficon-question',
'czpficon-plus-circle',
'czpficon-arrow-down',
'czpficon-font-size',
'czpficon-bold',
'czpficon-italic',
'czpficon-superscript',
'czpficon-subscript',
'czpficon-insert-template',
'czpficon-google-drive',
'czpficon-feed',
'czpficon-feed2',
'czpficon-youtube',
'czpficon-youtube2',
'czpficon-vimeo',
'czpficon-vimeo2',
'czpficon-flickr',
'czpficon-flickr2',
'czpficon-picassa',
'czpficon-picassa2',
'czpficon-dribbble',
'czpficon-dribbble2',
'czpficon-dribbble3',
'czpficon-forrst',
'czpficon-forrst2',
'czpficon-deviantart',
'czpficon-deviantart2',
'czpficon-steam',
'czpficon-steam2',
'czpficon-github',
'czpficon-github2',
'czpficon-github3',
'czpficon-github4',
'czpficon-wordpress',
'czpficon-wordpress2',
'czpficon-blogger',
'czpficon-blogger2',
'czpficon-tux',
'czpficon-apple',
'czpficon-finder',
'czpficon-android',
'czpficon-windows',
'czpficon-windows8',
'czpficon-soundcloud',
'czpficon-soundcloud2',
'czpficon-lastfm',
'czpficon-lastfm2',
'czpficon-stumbleupon',
'czpficon-stumbleupon2',
'czpficon-stackoverflow',
'czpficon-pinterest',
'czpficon-paypal',
'czpficon-paypal2',
'czpficon-chrome',
'czpficon-firefox',
'czpficon-IE',
'czpficon-opera',
'czpficon-safari',
'fui-triangle-up',
'fui-triangle-up-small',
'fui-triangle-down-small',
'fui-triangle-right-large',
'fui-triangle-left-large',
'fui-triangle-down',
'fui-info',
'fui-alert',
'fui-question',
'fui-window',
'fui-windows',
'fui-arrow-right',
'fui-arrow-left',
'fui-loop',
'fui-cmd',
'fui-mic',
'fui-check-inverted',
'fui-heartextra',
'fui-location',
'fui-plus',
'fui-check',
'fui-cross',
'fui-list',
'fui-new',
'fui-video',
'fui-photo',
'fui-volume',
'fui-time',
'fui-eye',
'fui-chat',
'fui-home',
'fui-upload',
'fui-search',
'fui-user',
'fui-mail',
'fui-lock',
'fui-power',
'fui-star',
'fui-calendar',
'fui-gear',
'fui-book',
'fui-exit',
'fui-trash',
'fui-folder',
'fui-bubble',
'fui-cross-inverted',
'fui-plus-inverted',
'fui-export',
'fui-radio-unchecked',
'fui-radio-checked',
'fui-checkbox-unchecked',
'fui-checkbox-checked',
'fui-calendar-solid',
'fui-star-2',
'fui-credit-card',
'fui-clip',
'fui-link',
'fui-pause',
'fui-play',
'fui-tag',
'fui-document',
'fui-image',
'fui-youtube',
'fui-vimeo',
'fui-stumbleupon',
'fui-spotify',
'fui-skype',
'fui-pinterest',
'fui-path',
'fui-myspace',
'fui-dribbble',
'fui-blogger',
'fui-behance',
'fui-list-thumbnailed',
'fui-list-small-thumbnails',
'fui-list-numbered',
'fui-list-large-thumbnails',
'fui-list-columned',
'fui-list-bulleted',
'fui-facebook',
'fui-twitter',
'fui-googleplus',
'fui-linkedin',
'czpficon-facebook',
'czpficon-facebook2',
'czpficon-twitter',
'czpficon-twitter2',
'czpficon-googleplus',
'czpficon-googleplus2',
'czpficon-linkedin',
'czpficon-linkedin2',
'czpficon-tumblr',
'czpficon-tumblr2',
'czpficon-facebook1111',
'czpficon-twitter1111',
'czpficon-googleplus1111',
'czpficon-linkedin1111',
'czpficon-tumbler1111'
);
		return $tmp;

	}	
	
	function all_objects($tmp = ''){
		$tmp_array = array();
		
		$tmp_array['avatar']['id'] = 'avatar';
		$tmp_array['avatar']['name'] = 'Avatar';
		$tmp_array['avatar']['save'] = 'avatar_url';
		$tmp_array['avatar']['savepoint'] = 'usermeta';
		$tmp_array['avatar']['defaulticon'] ='czpficon-uniE157';
		$tmp_array['avatar']['default'] = $this->location.'images/default_avatar.jpg';
		$tmp_array['avatar']['controle_back'] = array('round_object','public','editable');
		$tmp_array['avatar']['form_objects'] = array('avatar');
		
		$tmp_array['label']['id'] = 'label';
		$tmp_array['label']['name'] = 'Label';
		$tmp_array['label']['save'] = '';
		$tmp_array['label']['savepoint'] = '';
		$tmp_array['label']['default'] = '';
		$tmp_array['label']['defaulticon'] ='czpficon-uniE04C';
		$tmp_array['label']['controle_back'] = array('value','object_icon','public');
		$tmp_array['label']['form_objects'] = array('text');	
				
				
		$tmp_array['full_name']['id'] = 'full_name';
		$tmp_array['full_name']['name'] = 'Full name';
		$tmp_array['full_name']['save'] = 'full_name';
		$tmp_array['full_name']['savepoint'] = 'usermeta';
		$tmp_array['full_name']['defaulticon'] ='czpficon-uniE157';
		$tmp_array['full_name']['default'] =  'Full name ';
		$tmp_array['full_name']['controle_back'] = array('object_icon','public','editable');
		$tmp_array['full_name']['form_objects'] = array('text');		
				
				
		$tmp_array['first_name']['id'] = 'first_name';
		$tmp_array['first_name']['name'] = 'First name';
		$tmp_array['first_name']['save'] = 'first_name';
		$tmp_array['first_name']['savepoint'] = 'usermeta';
		$tmp_array['first_name']['defaulticon'] ='czpficon-uniE157';
		$tmp_array['first_name']['default'] = 'First name ';
		$tmp_array['first_name']['controle_back'] = array('object_icon','public','editable');
		$tmp_array['first_name']['form_objects'] = array('text');
		
		$tmp_array['last_name']['id'] = 'last_name';
		$tmp_array['last_name']['name'] = 'Last name';
		$tmp_array['last_name']['save'] = 'last_name';
		$tmp_array['last_name']['savepoint'] = 'usermeta';
		$tmp_array['last_name']['defaulticon'] ='czpficon-uniE157';
		$tmp_array['last_name']['default'] = 'Last name ';
		$tmp_array['last_name']['controle_back'] = array('object_icon','public','editable');
		$tmp_array['last_name']['form_objects'] = array('text');
		
		$tmp_array['age']['id'] = 'age';
		$tmp_array['age']['name'] = 'Age';
		$tmp_array['age']['save'] = 'age';
		$tmp_array['age']['savepoint'] = 'usermeta';
		$tmp_array['age']['default'] = 'Age ';
		$tmp_array['age']['defaulticon'] ='czpficon-uniE320';
		$tmp_array['age']['controle_back'] = array('object_icon','public','editable');
		$tmp_array['age']['form_objects'] = array('text');			
		
		$tmp_array['nickname']['id'] = 'nickname';
		$tmp_array['nickname']['name'] = 'Nickname';
		$tmp_array['nickname']['save'] = 'nickname';
		$tmp_array['nickname']['savepoint'] = 'usermeta';
		$tmp_array['nickname']['default'] = 'Nickname ';
		$tmp_array['nickname']['defaulticon'] ='czpficon-uniE157';
		$tmp_array['nickname']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['nickname']['form_objects'] = array('text');		
		
		$tmp_array['address']['id'] = 'address';
		$tmp_array['address']['name'] = 'Address';
		$tmp_array['address']['save'] = 'address';
		$tmp_array['address']['savepoint'] = 'usermeta';
		$tmp_array['address']['default'] = 'Address ';
		$tmp_array['address']['defaulticon'] ='czpficon-uniE5B2';
		$tmp_array['address']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['address']['form_objects'] = array('text');		

		$tmp_array['state']['id'] = 'state';
		$tmp_array['state']['name'] = 'State';
		$tmp_array['state']['save'] = 'state';
		$tmp_array['state']['savepoint'] = 'usermeta';
		$tmp_array['state']['default'] = 'State ';
		$tmp_array['state']['defaulticon'] ='czpficon-uniE39D';
		$tmp_array['state']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['state']['form_objects'] = array('text');	
		
		$tmp_array['city']['id'] = 'city';
		$tmp_array['city']['name'] = 'City';
		$tmp_array['city']['save'] = 'city';
		$tmp_array['city']['savepoint'] = 'usermeta';
		$tmp_array['city']['default'] = 'City ';
		$tmp_array['city']['defaulticon'] ='czpficon-uniE3B4';
		$tmp_array['city']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['city']['form_objects'] = array('text');		
		
		$tmp_array['zip']['id'] = 'zip';
		$tmp_array['zip']['name'] = 'Zip Code';
		$tmp_array['zip']['save'] = 'zip';
		$tmp_array['zip']['savepoint'] = 'usermeta';
		$tmp_array['zip']['default'] = 'Zip Code ';
		$tmp_array['zip']['defaulticon'] ='czpficon-uniE398';
		$tmp_array['zip']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['zip']['form_objects'] = array('text');
		
		$tmp_array['sex']['id'] = 'sex';
		$tmp_array['sex']['name'] = 'Sex';
		$tmp_array['sex']['save'] = 'sex';
		$tmp_array['sex']['savepoint'] = 'usermeta';
		$tmp_array['sex']['default'] = 'Sex ';
		$tmp_array['sex']['defaulticon'] ='czpficon-uniE14C';
		$tmp_array['sex']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['sex']['form_objects'] = array('text');			
			
		$tmp_array['status_show']['id'] = 'status_show';
		$tmp_array['status_show']['name'] = 'Status';
		$tmp_array['status_show']['save'] = 'status_show';
		$tmp_array['status_show']['savepoint'] = 'usermeta';
		$tmp_array['status_show']['default'] = ' ';
		$tmp_array['status_show']['defaulticon'] ='czpficon-uniE02B';
		$tmp_array['status_show']['controle_back'] = array('object_icon');	
		$tmp_array['status_show']['form_objects'] = array('text');
		
		$tmp_array['groupsteams']['id'] = 'groupsteams';
		$tmp_array['groupsteams']['name'] = 'Groups & Teams';
		$tmp_array['groupsteams']['save'] = 'groupsteams';
		$tmp_array['groupsteams']['savepoint'] = '';
		$tmp_array['groupsteams']['default'] = ' ';
		$tmp_array['groupsteams']['defaulticon'] ='czpficon-uniE4E1';
		$tmp_array['groupsteams']['controle_back'] = array('object_icon','public');	
		$tmp_array['groupsteams']['form_objects'] = array('text');		
	
		$tmp_array['contry']['id'] = 'contry';
		$tmp_array['contry']['name'] = 'Country';
		$tmp_array['contry']['save'] = 'contry';
		$tmp_array['contry']['savepoint'] = 'usermeta';
		$tmp_array['contry']['default'] = 'Country ';
		$tmp_array['contry']['defaulticon'] ='czpficon-uniE3BC';
		$tmp_array['contry']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['contry']['form_objects'] = array('flag');
		
		$tmp_array['contrytext']['id'] = 'contrytext';
		$tmp_array['contrytext']['name'] = 'Country Text';
		$tmp_array['contrytext']['save'] = 'contry';
		$tmp_array['contrytext']['savepoint'] = 'usermeta';
		$tmp_array['contrytext']['default'] = 'Country ';
		$tmp_array['contrytext']['defaulticon'] ='czpficon-uniE3BC';
		$tmp_array['contrytext']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['contrytext']['form_objects'] = array('text');		
		
		$tmp_array['email']['id'] = 'email';
		$tmp_array['email']['name'] = 'Email';
		$tmp_array['email']['save'] = 'user_email';
		$tmp_array['email']['savepoint'] = 'users';
		$tmp_array['email']['default'] = 'Email ';
		$tmp_array['email']['defaulticon'] ='czpficon-uniE117';
		$tmp_array['email']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['email']['form_objects'] = array('text');	
		
		$tmp_array['title']['id'] = 'title';
		$tmp_array['title']['name'] = 'Title';
		$tmp_array['title']['save'] = 'title';
		$tmp_array['title']['savepoint'] = 'usermeta';
		$tmp_array['title']['default'] = 'Please write a title ';
		$tmp_array['title']['defaulticon'] ='czpficon-uniE625';
		$tmp_array['title']['controle_back'] = array('value','object_icon','public','editable');	
		$tmp_array['title']['form_objects'] = array('text');	
		
		$tmp_array['editdate']['id'] = 'editdate';
		$tmp_array['editdate']['name'] = 'Edit date';
		$tmp_array['editdate']['save'] = 'editdate';
		$tmp_array['editdate']['savepoint'] = 'usermeta';
		$tmp_array['editdate']['default'] = '';
		$tmp_array['editdate']['defaulticon'] ='czpficon-uniE320';
		$tmp_array['editdate']['controle_back'] = array('value','object_icon','public');	
		$tmp_array['editdate']['form_objects'] = array('text');	
		
		$tmp_array['description']['id'] = 'description';
		$tmp_array['description']['name'] = 'Description';
		$tmp_array['description']['save'] = 'description';
		$tmp_array['description']['savepoint'] = 'usermeta';
		$tmp_array['description']['default'] = 'Please write a description ';
		$tmp_array['description']['defaulticon'] ='czpficon-uniE0C1';
		$tmp_array['description']['controle_back'] = array('value','object_icon','public','editable');	
		$tmp_array['description']['form_objects'] = array('textarea');	
		
		$tmp_array['lang']['id'] = 'lang';
		$tmp_array['lang']['name'] = 'Languages';
		$tmp_array['lang']['save'] = 'lang';
		$tmp_array['lang']['savepoint'] = 'usermeta';
		$tmp_array['lang']['default'] = 'Language ';
		$tmp_array['lang']['defaulticon'] ='czpficon-uniE0E0';
		$tmp_array['lang']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['lang']['form_objects'] = array('flag');
		
		/*$tmp_array['langtext']['id'] = 'langtext';
		$tmp_array['langtext']['name'] = 'Languages Text';
		$tmp_array['langtext']['save'] = 'lang';
		$tmp_array['langtext']['savepoint'] = 'usermeta';
		$tmp_array['langtext']['default'] = 'Languages';
		$tmp_array['langtext']['defaulticon'] ='czpficon-flag';
		$tmp_array['langtext']['controle_back'] = array('object_icon','public','editable');	
		$tmp_array['langtext']['form_objects'] = array('text');*/
		
		$tmp_array['facebook']['id'] = 'facebook';
		$tmp_array['facebook']['name'] = 'Facebook';
		$tmp_array['facebook']['save'] = 'facebook_czpf';
		$tmp_array['facebook']['savepoint'] = 'usermeta';
		$tmp_array['facebook']['default'] = '';
		$tmp_array['facebook']['defaulticon'] ='czpficon-facebook1111';
		$tmp_array['facebook']['controle_back'] = array('public');	
		$tmp_array['facebook']['form_objects'] = array('box');	
		
		$tmp_array['twitter']['id'] = 'twitter';
		$tmp_array['twitter']['name'] = 'Twitter';
		$tmp_array['twitter']['save'] = 'twitter_czpf';
		$tmp_array['twitter']['savepoint'] = 'usermeta';
		$tmp_array['twitter']['default'] = '';
		$tmp_array['twitter']['defaulticon'] ='czpficon-twitter1111';
		$tmp_array['twitter']['controle_back'] = array('public');	
		$tmp_array['twitter']['form_objects'] = array('box');
		
		$tmp_array['googleplus']['id'] = 'googleplus';
		$tmp_array['googleplus']['name'] = 'Google+';
		$tmp_array['googleplus']['save'] = 'googleplus_czpf';
		$tmp_array['googleplus']['savepoint'] = 'usermeta';
		$tmp_array['googleplus']['default'] = '';
		$tmp_array['googleplus']['defaulticon'] ='czpficon-googleplus1111';
		$tmp_array['googleplus']['controle_back'] = array('public');	
		$tmp_array['googleplus']['form_objects'] = array('box');
		
		$tmp_array['linkedin']['id'] = 'linkedin';
		$tmp_array['linkedin']['name'] = 'LinkedIn';
		$tmp_array['linkedin']['save'] = 'linkedin_czpf';
		$tmp_array['linkedin']['savepoint'] = 'usermeta';
		$tmp_array['linkedin']['default'] = '';
		$tmp_array['linkedin']['defaulticon'] ='czpficon-linkedin1111';
		$tmp_array['linkedin']['controle_back'] = array('public');	
		$tmp_array['linkedin']['form_objects'] = array('box');
		
		$tmp_array['space']['id'] = 'space';
		$tmp_array['space']['name'] = 'Free Space';
		$tmp_array['space']['save'] = '';
		$tmp_array['space']['savepoint'] = '';
		$tmp_array['space']['default'] = '';
		$tmp_array['space']['defaulticon'] ='czpficon-uniE2D6';
		$tmp_array['space']['controle_back'] = array();	
		$tmp_array['space']['form_objects'] = array('text');		
		
		$tmp_array['custom']['id'] = 'custom';
		$tmp_array['custom']['name'] = 'Custom';
		$tmp_array['custom']['save'] = '';
		$tmp_array['custom']['savepoint'] = 'usermeta';
		$tmp_array['custom']['default'] = '';
		$tmp_array['custom']['defaulticon'] ='czpficon-uniE464';
		$tmp_array['custom']['controle_back'] = array('save','value','object_icon','public','editable');	
		$tmp_array['custom']['form_objects'] = array('text');

		if ( empty( $tmp ) ) {
			return $tmp_array;
		} elseif ( isset( $tmp_array[ $tmp ] ) ) {
			return $tmp_array[ $tmp ];
		}
	}

}
