<?php

/**
Plugin Name: Calendarize It! Map styles
Plugin URI: http://plugins.righthere.com/calendarize-it-map-styles/
Description: Provides additional map styles for Calendarize it!
Version: 1.0.0.64502
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/


if(defined('RHCMST_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if( !defined('PHP_VERSION_ID') || PHP_VERSION_ID < 50300 ) throw new Exception( sprintf( __('This addon/plugin requires PHP version 5.3 or greater.  PHP version %s detected','rhc'), phpversion() ) );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCMST_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCMST_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCMST_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCMST_URL", plugin_dir_url(__FILE__) );
} 

class plugin_rhc_map_styles {
	function __construct(){
		//frontend ( venues.php google map shortcode )
		add_filter( 'rhc_map_styles', array( &$this, 'rhc_map_styles' ), 10, 5 );
		//backend (options tab)
		add_filter( 'rhc_gmap3_style_options' , array( &$this, 'rhc_gmap3_style_options' ), 10, 1 );
	}
	
	function rhc_map_styles( $styles, $styleid, $atts, $template, $code ){
		//priorize styleid
		include 'map_styles.php';
		foreach($map_styles as $m){
			if( $styleid==$m->id ){
				return $m->style;
			}
		}
		//priorize the style defined in the shortcode.
		if( '[]' == $styles || empty($styles) ){
			//not defined, fallback to default
			global $rhc_plugin;
			$styleid = $rhc_plugin->get_option( 'gmap3_style', '', true);
			if( !empty( $styleid ) ){
				foreach($map_styles as $m){
					if( $styleid==$m->id ){
						return $m->style;
					}
				}
			}
		}
		return $styles;
	}
	
	function rhc_gmap3_style_options( $options ){
		include 'map_styles.php';
		foreach($map_styles as $m){
			$options[$m->id]=$m->label;
		}
		return $options;
	}
}

new plugin_rhc_map_styles();
?>