<?php
class RHCI_Styles_Scripts {
	public $is_admin = false;
	public $debugging_js_css = false;
	public $in_footer = false;

	public function __construct() {
		global $rhc_plugin;

		$this->is_admin = is_admin();

		if ( '1' == $rhc_plugin->get_option( 'debug_javascript', false, true ) ) {
			$this->debugging_js_css = true;
		}

		if ( '1' == $rhc_plugin->get_option( 'in_footer', false, true ) ) {
			$this->in_footer = true;
		}

		if ( $this->is_admin ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_and_frontend_scripts' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_only_scripts' ) );
		} else {
			add_action( 'wp_enqueue_scripts', array( $this, 'admin_and_frontend_scripts' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'frontend_only_scripts' ) );
		}
	}

	public function admin_and_frontend_scripts() {
	}

	public function admin_only_scripts() {
		wp_register_style( 'rhci-import', RHCI_URL . 'assets/css/import.min.css', array(), '1.0.0' );

		if ( $this->debugging_js_css ) {
			wp_register_script( 'rhci-import', RHCI_URL . 'assets/js/import.js', array( 'jquery' ), '1.0.0', $this->in_footer );
		} else {
			wp_register_script( 'rhci-import', RHCI_URL . 'assets/js/dist/import.min.js', array( 'jquery' ), '1.0.0', $this->in_footer );
		}
	}

	public function frontend_only_scripts() {
	}

}
