jQuery( document).ready( function( $ ) {
	'use strict';

	var $form = $( '#pop-options-form' );
	var $sysMsg = $( '#sys_msg' );
	var $updated = $( '.updated' );
	var $importContainer = $( '#rhci_container' );
	var $main = $( '#rhci_main' );
	var $colMap = $( '#rhci_col_map' );
	var frame;
	var $uploadButton = $form.find( '#rhci_upload_file' );
	var $importButton = $form.find( '#rhci_import' );
	var $fileName = $( '.rhci_file' );
	var $csvInterface = $( '#rhci_csv_interface' );
	var $events = $( '#rhci_events' );
	var $taxonomyTermsData = $( '#rhci_taxonomy_terms_data' );

	$csvInterface.on( 'change', function() {
		toggleInterface();
	});

	$uploadButton.on( 'click', function( event ) {
		var $el = $( this );
		event.preventDefault();

		if ( frame ) {
			frame.open();
			return;
		}

		frame = wp.media.frames.uploadCSV = wp.media({
			title: $el.data( 'title' ),
			library: {
				type: 'text/csv'
			}
		});

		frame.on( 'select', function() {
			var attachment = frame.state().get( 'selection' ).first();
			clearNotices();
			$uploadButton
				.next().remove().end()
				.data( 'file', attachment.id )
				.val( RHCI.upload_button.change )
				.after( getHtmlFile( attachment.attributes.filename ) )
			;
		});

		frame.open();
	});

	$importButton.on( 'click', function( event ) {
		var $this = $( this );
		event.preventDefault();

		if ( $this.data( 'requestRunning' ) ) {
			return false;
		}

		if ( ! $uploadButton.data( 'file' ) ) {
			clearNotices();
			$sysMsg.hide().append( getHtmlFileError( RHCI.no_file ) ).fadeIn();

			return false;
		}

		requestRunning( $this, true );
		$this.after( getHtmlSpinner() );

		if ( ! $this.data( 'ajax' ) ) {
			var args = getAjaxArgs( 'rhci_column_mapping' );
			$.post( ajaxurl, args, function( data ) {
				if ( 'OK' == data.MSG ) {
					requestRunning( $this, false );
					$this.data( 'ajax', 'rhci_import' )
					$main.hide();
					$colMap.append( data.html );
					$colMap.show();
				}

				$this.next().remove();
			}, 'json');
		} else {
			var args = getAjaxArgs( 'rhci_import' );
			$.post( ajaxurl, args, function( data ) {
				if ( 'OK' == data.MSG ) {
					requestRunning( $this, false );
					resetUploadButton();
					$this.removeData( 'ajax' );
					$colMap.hide().find( '.pt-option-select' ).remove();
					$main.show();
					clearNotices();
					$sysMsg.append( data.html );
				}

				$this.next().remove();
			}, 'json');
		}
	});

	function toggleInterface() {
		$taxonomyTermsData.fadeToggle();
		$events.fadeToggle();
	}

	function getHtmlFile( name ) {
		return '<div class="rhci_file">' + name + '</div>';
	}

	function getHtmlFileError( message ) {
		return '<div id="message" class="error"><p>' + message + '</p></div>';
	}

	function getHtmlSpinner() {
		return '<span class="spinner is-active"></span>';
	}

	function getAjaxArgs( ajaxName ) {
		return {
			action: ajaxName,
			_nonce: $form.find( '#_wpnonce' ).val(),
			file_id: $uploadButton.data( 'file' ),
			data: $form.serialize(),
		};
	}

	function requestRunning( $el, status ) {
		$el.data( 'requestRunning', status );
	}

	function resetUploadButton() {
		$uploadButton.val( RHCI.upload_button.upload ).removeData( 'file' ).next().remove();
	}

	function clearNotices() {
		$updated.remove();
		$sysMsg.empty();
	}
});