<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/
class rhc_gmap_options {
	function __construct($plugin_id='rhc',$capability='manage_options',$open=false){
		if(current_user_can($capability)){
			$this->id = $plugin_id;
			$this->open = $open;
			add_filter("pop-options_{$this->id}",array(&$this,'options'),9999,1);		
		}
		
	}
	
	function options($t){
		$i = count($t);
		//--  -----------------------		
		
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhc-gmap'; 
		$t[$i]->open 			= $this->open; 
		$t[$i]->label 		= __('Events map view','rhcgmap');
		$t[$i]->right_label	= __('Customize default events map view','rhcgmap');
		$t[$i]->page_title	= __('Events map view','rhcgmap');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array(

		
		);
			
//---------			
			
		$t[$i]->options[] =	(object)array(
				'id'		=> 'gmap_upcoming',
				'label'		=> __('Upcoming Only','rhcgmap'),
				'type'		=> 'select',
				'options'	=> array(
					'0'	=> __('disabled','rhcgmap'),
					'1' => __('Upcoming only, by start date', 'rhcgmap'),
					'2'	=> __('Upcoming only, by end date', 'rhcgmap')
				),
				'default'	=> '0',
				'description'=> __('Enable this option to only display upcoming events.  Choose by end date if you want to show events that have started.','rhcgmap'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);	

		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_button_label',
				'label'			=> __('Map button label','rhcgmap'),
				'description'	=> __('Set the label of the map button.  Shortcode argument: gmap_button_label','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);	
			
		$t[$i]->options[] =	(object)array(
				'id'		=> 'gmap_auto_button',
				'label'		=> __('Add map button','rhcgmap'),
				'type'		=> 'onoff',
				'default'	=> '1',
				'description'=> __('The map button is automatically appended to the right header control.  Choose no to remove the button.  You can then add it in the customize shortcode tab with the code "rhc_gmap"','rhcgmap'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);	
			
		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_zoom',
				'label'			=> __('Zoom','rhcgmap'),
				'description'	=> __('Initial default map zoom.  This value can be overwritten in the calendarizeit shortcode using the argument "gmap_zoom"','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);	
			
		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_months',
				'label'			=> __('Months','rhcgmap'),
				'description'	=> __('Number of months in the future to fetch.','rhcgmap'),
				'default'		=> 24,
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);	

		$t[$i]->options[] =	(object)array(
				'id'		=> 'gmap_only_latlng',
				'label'		=> __('Filter out venues without lat/lng details','rhcgmap'),
				'type'		=> 'onoff',
				'default'	=> '1',
				'description'=> __('Google geocode address service is slow.  Only choose no if you dont have many venues.  In general try always to set the latitude longitude for the venue.','rhcgmap'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);	

		$t[$i]->options[] =	(object)array(
				'id'		=> 'gmap_cluster',
				'label'		=> __('Enable clusters','rhcgmap'),
				'type'		=> 'onoff',
				'default'	=> '1',
				'description'=> __('Dynamically show venues grouped in clusters.','rhcgmap'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);	

		$t[$i]->options[] =	(object)array(
			'type'	=> 'subtitle',
			'label'	=> __('Fullscreen','rhcgmap')
		);	
			
		$t[$i]->options[] =	(object)array(
				'id'		=> 'gmap_fullscreen',
				'label'		=> __('Auto fullscreen','rhcgmap'),
				'type'		=> 'onoff',
				'default'	=> '0',
				'description'=> __('When loading a page where the map is the default view, automatically start in fullscreen mode.','rhcgmap'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);	
		
		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_fullscreen_label',
				'label'			=> __('Fullscreen label','rhcgmap'),
				'description'	=> __('Label shown on the fullscreen tab when fullscreen is inactive.','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);		
		
		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_exit_fullscreen_label',
				'label'			=> __('Exit fullscreen label','rhcgmap'),
				'description'	=> __('Label shown on the fullscreen tab when fullscreen is active.','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);		
			
		$t[$i]->options[] =	(object)array(
			'type'	=> 'subtitle',
			'label'	=> __('Sidelist','rhcgmap')
		);		
		
		$t[$i]->options[] =	(object)array(
				'id'		=> 'sidelist_link_target',
				'label'		=> __('Title link target','rhc'),
				'type'		=> 'select',
				'default'	=> '_BLANK',
				'options'	=> array(
					'_blank'	=> '_blank',
					'_self'		=> '_self'
				),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);
		
		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_sidelist_label',
				'label'			=> __('Side list tab label','rhcgmap'),
				'description'	=> __('Label shown on the side list tab.','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);			
		
		$t[$i]->options[] =	(object)array(
			'type'	=> 'subtitle',
			'label'	=> __('Map watermark','rhcgmap')
		);	
		
		$t[$i]->options[] =	(object)array(
				'id'	=> 'gmap_watermark_url',
				'type'	=>'fileuploader',
				//'dcurl'	=> $this->get_login_dc_url_path(),
				'label'=>__('Watermark URL','wlb'),
				'description'=> __('Upload an image to use as watermark in the calendar map.','rhcgmap'),
				'save_option'=>true,
				'load_option'=>true
			);
			
		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_watermark_link',
				'label'			=> __('Watermark link','rhcgmap'),
				'description'	=> __('Specify a url to link to when clicking on the watermark.','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);				
//---------			
	
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
			
		$t[$i]->options[]=(object)array(
			'type'=>'subtitle',
			'label'=> __('Taxonomy bar filter','rhc'),
			'description'=>__('Check no to remove the default taxonomies from the filtering bar.','rhc')
		);

		$default_taxonomies = array(
			RHC_CALENDAR 	=> __('Calendar','rhc'),
			RHC_ORGANIZER	=> __('Organizer','rhc'),
			RHC_VENUE		=> __('Venues','rhc')
		);		
		
		$tmp = $default_taxonomies;
		$tmp['core_year']=__('Year','rhc');
		$tmp['core_month']=__('Month','rhc');
		foreach($tmp as $taxonomy => $label){
			$t[$i]->options[] = (object)array(
				'id'		=> 'tax_filter_skip_'.$taxonomy,
				'label'		=> sprintf(__('Disable %s taxonomy','rhc'),$label),
				'type'		=> 'onoff',
				'default'	=> '0',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);	
		}	
		
		$t[$i]->options[]=	(object)array(
				'id'			=> 'tax_filter_skip',
				'type' 			=> 'textarea',
				'label'			=> __('Other taxonomy slugs','rhc'),
				'description'	=> sprintf('<p>%s</p>',
					__('Add comma separated taxonomy slugs to remove from the filter bar.','rhc')
				),
				'el_properties' => array('rows'=>'5','cols'=>'50'),
				'save_option'=>true,
				'load_option'=>true
			);
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
		
		$t[$i]->options[]=(object)array(
				'type'			=> 'subtitle',
				'label'			=> __('Business directory taxonomies','rhc'),
				'description'	=> __('When using the map view as a business directory, check the taxonomies that you would like to enable as taxonomies for the venue.  This will add an option on the venue edit page to choose taxonomies to filter the businesses displayed on the map.','rhc')
			);
		
		//if(!empty())
		
		$taxonomies = get_taxonomies( array('public'=>1), 'objects' );
		if(count($taxonomies)>0){
			foreach($taxonomies as $slug => $tax){
				if(in_array($slug,array('post_format',RHC_VENUE)))continue;
				$t[$i]->options[] = (object)array(
					'id'			=> 'venue_directory_'.$slug,
					'name'			=> 'venue_directory[]',
					'type'			=> 'checkbox',
					'option_value'	=> $slug,
					'label'			=> $tax->label,
					'el_properties' => array(),
					'save_option'	=> true,
					'load_option'	=> true
				);
			}
		}	
		
		$t[$i]->options[] =	(object)array(
				'id'			=> 'directory_label',
				'label'			=> __('Business Directory label','rhcgmap'),
				'description'	=> __('Label for the Business Directory','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);	
		
		$t[$i]->options[] =	(object)array(
				'id'			=> 'parent_venue_label',
				'label'			=> __('Category label','rhcgmap'),
				'description'	=> __('Label for the Category dropdown.  This is all parent venues.','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);	
			
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);		
			
		$t[$i]->options[] =	(object)array(
			'type'	=> 'subtitle',
			'label'	=> __('Geo Location','rhcgmap')
		);	

		$t[$i]->options[] =	(object)array(
				'id'		=> 'gmap_geolocated',
				'label'		=> __('Enable Geo Location','rhcgmap'),
				'type'		=> 'onoff',
				'default'	=> '1',
				'description'=> __('Enabled by default.  Choose no to disable geo location.  You will need to specify a default map center.','rhcgmap'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);				
			
		$t[$i]->options[] =	(object)array(
			'type'	=> 'subtitle',
			'label'	=> __('Default map center','rhcgmap')
		);	

		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_default_lat',
				'label'			=> __('Latitude','rhcgmap'),
				'description'	=> __('By default the map view attempts to use geolocation to center the map.  The latitude and longitude specified here are used if for some reason the location cannot be determined.','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);				

		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_default_lng',
				'label'			=> __('Longitude','rhcgmap'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);			

		$t[$i]->options[] =	(object)array(
				'id'			=> 'gmap_titleformat',
				'type' 			=> 'text',
				'label'			=> __('Title format','rhc'),
				'el_properties' => array(
					'class'=>'widefat rhc_dateformat',
					'rel'=> __('MMMM yyyy','rhc')
				),
				'save_option'=>true,
				'load_option'=>true
			);	
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
					
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcs'),
				'class' => 'button-primary'
			);
		//---------------
	
		return $t;	
	}
}

?>