<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class Integration {
	public function __construct() {
		add_filter( 'get_calendarize_args_options', array( $this, 'get_calendarize_args_options' ), 10, 2 );
		add_filter( 'rhc_postable_args_arr', array( $this, 'postable_args' ) );
		add_action( 'rhc_calendarizeit_shortcode', array( $this, 'enqueue_assets' ) );
		add_action( 'rhc_event_list_template', array( $this, 'enqueue_assets' ) );
	}

	public function get_calendarize_args_options( $options, $atts ) {
		global $rhc_plugin;

		$option_name = 'button_label';
		$button_label = isset( $atts[ $option_name ] ) && $atts[ $option_name ] ? $atts[ $option_name ] : $rhc_plugin->get_option( "eyv_{$option_name}", Defaults::$options[ $option_name ], true );
		
		$option_name = 'title_format';
		$title_format = isset( $atts[ $option_name ] ) && $atts[ $option_name ] ? $atts[ $option_name ] : $rhc_plugin->get_option( "eyv_{$option_name}", Defaults::$options[ $option_name ], true );

		$settings = $this->get_year_options( null, $atts );
	
		foreach ( $options->modes as $type => $mode ) {
			$options->modes[ $type ]['options']->rhc_year = $settings;
			$options->modes[ $type ]['options']->buttonText->rhc_year = $button_label;
			$options->modes[ $type ]['options']->titleFormat->rhc_year = $title_format;

			$option_name = 'add_button';

			if ( '1' === $rhc_plugin->get_option( "eyv_{$option_name}", Defaults::$options[ $option_name ], true ) ) {
				$options->modes[ $type ]['options']->header->right .= ',rhc_year';
			}

		}

		return $options;
	}

	public function postable_args( $args ) {
		$args[] = 'eventlistupcoming';

		return $args;
	}

	public function get_year_options( $type, $atts ) {
		global $rhc_plugin;

		$options = (object) array();
		$fields = array(
			'columns',
			'links_in_new_tab',
			'click_action',
			'overlay_animation',
			'overlay_background',
			'overlay_opacity',
			'overlay_date_format',
			'overlay_time_format',
			'overlay_allday_label',
			'disable_calendar',
			'disable_organizer',
			'disable_venue',
			'adm_lst_disabled_tax_state',
			'adm_lst_disabled_tax_country',
			'adm_lst_disabled_tax_city',
			'overlay_calendar_taxonomy',
			'overlay_organizer_taxonomy',
			'overlay_venue_taxonomy',
			'overlay_state_taxonomy',
			'overlay_country_taxonomy',
			'overlay_city_taxonomy',
			'overlay_taxonomy_icons',
			'overlay_event_link',
			'overlay_taxonomy_links',
		);

		foreach ( $fields as $field ) {
			$option_name = 'eyv_' . $field;
			$value = isset( $atts[ $option_name ] ) ? $atts[ $option_name ] : $rhc_plugin->get_option( $option_name, Defaults::$options[ $field ], true );
			
			$options->$field = $value;
		}

		return $options;
	}

	public function enqueue_assets() {
		global $rhc_plugin;

		wp_enqueue_style( 'rhc-year-view' );

		if ( 'overlay' === $rhc_plugin->get_option( 'eyv_click_action', Defaults::$options['click_action'], true ) ) {
			wp_enqueue_style( 'eyv-overlay' );
			wp_enqueue_style( 'eyv-overlay-animation' );
		}

		wp_enqueue_script( 'rhc-year-view' );
	}
}

return new Integration();