<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class Defaults {
	public static $options;

	public function __construct() {
		add_action( 'init', array( $this, 'options' ) );
	}

	public function options() {
		$options = array(
			'add_button'                   => '1',
			'button_label'                 => __( 'year', 'rhceyv' ),
			'title_format'                 => 'yyyy',
			'columns'                      => '3',
			'links_in_new_tab'             => '1',
			'click_action'                 => 'overlay',
			'overlay_animation'            => 'big-fade',
			'overlay_background'           => '#3498db',
			'overlay_opacity'              => '80',
			'overlay_date_format'          => 'dddd, MMMM d, yyyy',
			'overlay_time_format'          => 'HH:mm',
			'overlay_allday_label'         => __( 'All Day', 'rhceyv' ),
			'disable_calendar'             => '0',
			'disable_organizer'            => '0',
			'disable_venue'                => '0',
			'adm_lst_disabled_tax_state'   => '0',
			'adm_lst_disabled_tax_country' => '0',
			'adm_lst_disabled_tax_city'    => '0',
			'overlay_calendar_taxonomy'    => '1',
			'overlay_organizer_taxonomy'   => '1',
			'overlay_venue_taxonomy'       => '1',
			'overlay_state_taxonomy'       => '1',
			'overlay_country_taxonomy'     => '1',
			'overlay_city_taxonomy'        => '1',
			'overlay_taxonomy_icons'       => '1',
			'overlay_event_link'           => '1',
			'overlay_taxonomy_links'       => '1',
		);

		foreach ( $options as $key => $value ) {
			self::$options[ $key ] = $value;
		}
	}
}

return new Defaults();