<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class Assets {
	public $is_admin;
	public $is_debug;
	public $in_footer;

	public function __construct() {
		global $rhc_plugin;

		$this->is_admin = is_admin();

		if ( '1' == $rhc_plugin->get_option( 'debug_javascript', false, true ) ) {
			$this->is_debug = true;
		}

		if ( '1' == $rhc_plugin->get_option( 'in_footer', false, true ) ) {
			$this->in_footer = true;
		}

		if ( $this->is_admin ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'assets' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_assets' ) );
		} else {
			add_action( 'wp_enqueue_scripts', array( $this, 'assets' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'frontend_assets' ) );
		}
	}

	public function assets() {
		global $rhc_plugin;

		wp_register_style( 'rhc-year-view', RHCEYV_URL . 'assets/css/year-view.css', array( 'calendarizeit' ), RHCEYV_VERSION );
		wp_register_style( 'eyv-wp-admin', RHCEYV_URL . 'assets/css/wp-admin.css', array(), RHCEYV_VERSION );

		if ( 'overlay' === $rhc_plugin->get_option( 'eyv_click_action', Defaults::$options['click_action'], true ) ) {
			$animation_name = $rhc_plugin->get_option( 'eyv_overlay_animation', Defaults::$options['overlay_animation'], true );

			wp_register_style( 'eyv-overlay', RHCEYV_URL . 'assets/css/animations/overlay.css', array( 'rhc-year-view' ), RHCEYV_VERSION );
			wp_register_style( 'eyv-overlay-animation', RHCEYV_URL . 'assets/css/animations/' . $animation_name . '.css', array( 'eyv-overlay' ), RHCEYV_VERSION );

			wp_register_script( 'eyv-css-editor', RHCEYV_URL . 'assets/js/css-editor.js', array( 'rhc-year-view' ), RHCEYV_VERSION, $this->in_footer );
		}

		wp_register_script( 'rhc-year-view', RHCEYV_URL . 'assets/js/year-view.js', array( 'jquery' ), RHCEYV_VERSION, $this->in_footer );
	}

	public function admin_assets() {
	}

	public function frontend_assets() {
	}
}

return new Assets();