<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class Options {
	public $id;
	public $options;

	public function __construct() {
		$this->load_module();
		$this->init_hooks();
	}

	private function load_module() {
		global $rhc_plugin;

		$this->id = $rhc_plugin->id . '-events-year-view';

		$settings = array(
			'id'                 => $this->id,
			'menu_id'            => $this->id,
			'plugin_id'          => $rhc_plugin->id,
			'capability'         => $rhc_plugin->options_capability,
			'options_varname'    => $rhc_plugin->options_varname,
			'page_title'         => __( 'Year View', 'rhceyv' ),
			'menu_text'          => __( 'Year View', 'rhceyv' ),
			'option_menu_parent' => 'edit.php?post_type=' . RHC_EVENTS,
			'notification'       => (object) array(
				'plugin_version' => RHC_VERSION,
				'plugin_code'    => 'RHC',
				'message'        => __( 'Calendar plugin update %s is available! <a href="%s">Please update now</a>','rhc' )
			),
			'stylesheet'         => 'rhc-options',
			'path'               => RHC_PATH . 'options-panel/',
			'url'                => RHC_URL  . 'options-panel/',
			'pluginslug'         => RHC_SLUG,
		);

		$this->options = new \PluginOptionsPanelModule( $settings );
	}

	private function init_hooks() {
		add_filter( 'pop-options_' . $this->id, array( $this, 'options' ), 9999 );
	}

	public function options( $t ) {
		global $rhc_plugin;

		$i = count( $t );
		$t[ $i ]              = (object) array();
		$t[ $i ]->id          = 'rhceyv-general';
		$t[ $i ]->label       = __( 'General', 'rhceyv' );
		$t[ $i ]->right_label = __( 'General', 'rhceyv' );
		$t[ $i ]->page_title  = __( 'General', 'rhceyv' );
		$t[ $i ]->priority    = 9;
		$t[ $i ]->options     = array();

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'General', 'rhceyv' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_add_button',
			'type'        => 'onoff',
			'label'       => __( 'Add Button', 'rhceyv' ),
			'description' => __( 'The Year button is automatically added to the right header navigation. Choose OFF to remove the button, and you can manually add it by adding the attribute "rhc_year" to the shortcode.', 'rhceyv'),
			'default'     => Defaults::$options['add_button'],
			'save_option' => true,
			'load_option' => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_button_label',
			'type'        => 'text',
			'label'       => __( 'Button Label', 'rhceyv' ),
			'description' => __( 'Only use this options if you want to use different label from the localized one, or if the plugin is not providing localization at all.' ),
			'default'     => Defaults::$options['button_label'],
			'save_option' => true,
			'load_option' => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_title_format',
			'type'        => 'select',
			'label'       => __( 'Title Format', 'rhceyv' ),
			'default'     => Defaults::$options['title_format'],
			'options'     => array(
				'yyyy' => __( 'Year, 4 digits', 'rhceyv' ),
				'yy'   => __( 'Year, 2 digits', 'rhceyv' )
			),
			'save_option' => true,
			'load_option' => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_columns',
			'type'        => 'select',
			'label'       => __( 'Layout', 'rhceyv' ),
			'options'     => array(
				'1' => __( '1 x 12', 'rhceyv' ),
				'2' => __( '2 x 6', 'rhceyv' ),
				'3' => __( '3 x 4', 'rhceyv' ),
				'4' => __( '4 x 3', 'rhceyv' ),
				'6' => __( '6 x 2', 'rhceyv' )
			),
			'default'     => Defaults::$options['columns'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_links_in_new_tab',
			'type'        => 'onoff',
			'label'       => __( 'Open Links in a New Tab', 'rhceyv' ),
			'default'     => Defaults::$options['links_in_new_tab'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_click_action',
			'type'        => 'select',
			'label'       => __( 'Click Action', 'rhceyv' ),
			'description' => __( 'Choose a view' ),
			'default'     => Defaults::$options['click_action'],
			'options'	=> array(
				'overlay'    => __( 'Overlay', 'rhceyv' ),
				'month'      => __( 'Month', 'rhceyv' ),
				'basicWeek'  => __( 'Basic Week', 'rhceyv' ),
				'agendaWeek' => __( 'Agenda Week', 'rhceyv' ),
				'rhc_event'  => __( 'Event List', 'rhceyv' ),
				'rhc_gmap'   => __( 'Event Map', 'rhceyv' ),
				'rhc_grid'   => __( 'Event Grid', 'rhceyv' )
			),
			'hidegroup'   => '#eyv_click_action_group',
			'hidevalues'  => array( 'overlay' ),
			'save_option' => true,
			'load_option' => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'   => 'eyv_click_action_group',
			'type' => 'div_start'
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Overlay', 'rhceyv' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_animation',
			'type'        => 'select',
			'label'       => __( 'Animation', 'rhceyv' ),
			'options'     => array(
				'big-fade'        => __( 'Big Fade', 'rhceyv' ),
				'bottom-right'    => __( 'Bottom Right', 'rhceyv' ),
				'slide-in-top'    => __( 'Slide in Top', 'rhceyv' ),
				'grow'            => __( 'Grow', 'rhceyv' ),
				'cinema'          => __( 'Cinema', 'rhceyv' ),
				'slide-in-right'  => __( 'Push Right', 'rhceyv' ),
				'slide-in-bottom' => __( 'Slide in Bottom', 'rhceyv' )
			),
			'default'     => Defaults::$options['overlay_animation'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_background',
			'type'        => 'farbtastic',
			'label'       => __( 'Background', 'rhceyv' ),
			'default'     => Defaults::$options['overlay_background'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_opacity',
			'type'        => 'range',
			'min'         => '1',
			'max'         => '100',
			'step'        => '1',
			'label'       => __( 'Opacity', 'rhceyv' ),
			'default'     => Defaults::$options['overlay_opacity'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_allday_label',
			'type'        => 'text',
			'label'       => __( 'Overlay All Day Label', 'rhceyv' ),
			'default'     => Defaults::$options['overlay_allday_label'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Date & Time Settings', 'rhceyv' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'eyv_overlay_date_format',
			'type'          => 'text',
			'label'         => __( 'Default Date Format', 'rhceyv' ),
			'description'   => __( 'Information on how to format the date and time please refer to the Help tab.', 'rhceyv' ),
			'default'       => Defaults::$options['overlay_date_format'],
			'el_properties' => array(
				'class' => 'widefat',
			),
			'save_option'   => true,
			'load_option'   => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'eyv_overlay_time_format',
			'type'          => 'text',
			'label'         => __( 'Default Time Format', 'rhceyv' ),
			'default'       => Defaults::$options['overlay_time_format'],
			'el_properties' => array(
				'class' => 'widefat',
			),
			'save_option'   => true,
			'load_option'   => true
		);

		if ( $this->is_there_enabled_taxonomies() ) {
			$t[ $i ]->options[] = (object) array(
				'type'  => 'subtitle',
				'label' => __( 'Taxonomies', 'rhceyv' ),
			);
		}

		if ( '1' !== $rhc_plugin->get_option( 'disable_calendar', Defaults::$options['disable_calendar'], true ) ) {
			$t[ $i ]->options[] = (object) array(
				'id'          => 'eyv_overlay_calendar_taxonomy',
				'type'        => 'onoff',
				'label'       => __( 'Show Calendar Taxonomy', 'rhceyv' ),
				'default'     => Defaults::$options['overlay_calendar_taxonomy'],
				'save_option' => true,
				'load_option' => true
			);
		}

		if ( '1' !== $rhc_plugin->get_option( 'disable_organizer', Defaults::$options['disable_organizer'], true ) ) {
			$t[ $i ]->options[] = (object) array(
				'id'          => 'eyv_overlay_organizer_taxonomy',
				'type'        => 'onoff',
				'label'       => __( 'Show Organizer Taxonomy', 'rhceyv' ),
				'default'     => Defaults::$options['overlay_organizer_taxonomy'],
				'save_option' => true,
				'load_option' => true
			);
		}

		if ( '1' !== $rhc_plugin->get_option( 'disable_venue', Defaults::$options['disable_venue'], true ) ) {
			$t[ $i ]->options[] = (object) array(
				'id'          => 'eyv_overlay_venue_taxonomy',
				'type'        => 'onoff',
				'label'       => __( 'Show Venue Taxonomy', 'rhceyv' ),
				'default'     => Defaults::$options['overlay_venue_taxonomy'],
				'save_option' => true,
				'load_option' => true
			);
		}

		if ( '1' !== $rhc_plugin->get_option( 'adm_lst_disabled_tax_state', Defaults::$options['adm_lst_disabled_tax_state'], true ) ) {
			$t[ $i ]->options[] = (object) array(
				'id'          => 'eyv_overlay_state_taxonomy',
				'type'        => 'onoff',
				'label'       => __( 'Show State Taxonomy', 'rhceyv' ),
				'default'     => Defaults::$options['overlay_state_taxonomy'],
				'save_option' => true,
				'load_option' => true
			);
		}

		if ( '1' !== $rhc_plugin->get_option( 'adm_lst_disabled_tax_country', Defaults::$options['adm_lst_disabled_tax_country'], true ) ) {
			$t[ $i ]->options[] = (object) array(
				'id'          => 'eyv_overlay_country_taxonomy',
				'type'        => 'onoff',
				'label'       => __( 'Show Country Taxonomy', 'rhceyv' ),
				'default'     => Defaults::$options['overlay_country_taxonomy'],
				'save_option' => true,
				'load_option' => true
			);
		}

		if ( '1' !== $rhc_plugin->get_option( 'adm_lst_disabled_tax_city', Defaults::$options['adm_lst_disabled_tax_city'], true ) ) {
			$t[ $i ]->options[] = (object) array(
				'id'          => 'eyv_overlay_city_taxonomy',
				'type'        => 'onoff',
				'label'       => __( 'Show City Taxonomy', 'rhceyv' ),
				'default'     => Defaults::$options['overlay_city_taxonomy'],
				'save_option' => true,
				'load_option' => true
			);
		}

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_taxonomy_icons',
			'type'        => 'onoff',
			'label'       => __( 'Taxonomy Icons', 'rhceyv' ),
			'default'     => Defaults::$options['overlay_taxonomy_icons'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Links', 'rhcetc' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_event_link',
			'type'        => 'onoff',
			'label'       => __( 'Event Link', 'rhceyv' ),
			'default'     => Defaults::$options['overlay_event_link'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'          => 'eyv_overlay_taxonomy_links',
			'type'        => 'onoff',
			'label'       => __( 'Taxonomies are links', 'rhceyv' ),
			'default'     => Defaults::$options['overlay_taxonomy_links'],
			'save_option' => true,
			'load_option' => true
		);

		$t[ $i ]->options[] = (object) array(
			'type' => 'div_end',
		);	

		$t[ $i ]->options[] = (object) array(
			'type' => 'clear'
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'submit',
			'label' => __( 'Save', 'rhceyv' ),
			'class' => 'button-primary'
		);

		$i = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhceyv-help';
		$t[ $i ]->label         = __( 'Help', 'rhceyv' );
		$t[ $i ]->right_label   = __( 'Help', 'rhceyv' );
		$t[ $i ]->page_title    = __( 'Help', 'rhceyv' );
		$t[ $i ]->priority      = 99;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'     => 'callback',
			'callback' => array( $this, 'help_tab' )
		);

		wp_enqueue_style( 'eyv-wp-admin' );

		return $t;
	}

	public function help_tab() {
		return sprintf( '<p>%s</p>',
			sprintf( __( 'For detailed information on how to use the Events Year View for Calendarize it! add-on, please visit our knowledge base at the %s', 'rhceyv' ),
				sprintf( '<a href="https://righthere.zendesk.com/">%s</a>.', __( 'Help Center', 'rhceyv' )
				)
			)
		);
	}

	public function is_there_enabled_taxonomies() {
		global $rhc_plugin;

		$options = array(
			'disable_calendar',
			'disable_organizer',
			'disable_venue',
			'adm_lst_disabled_tax_state',
			'adm_lst_disabled_tax_country',
			'adm_lst_disabled_tax_city'
		);

		foreach ( $options as $option ) {
			if ( '1' !== $rhc_plugin->get_option( $option, Defaults::$options[ $option ], true ) ) {
				return true;
			}
		}

		return false;
	}
}

return new Options();