<?php
/**
 * Dashboard Widget
 * 
 * @package Event_Taxnonomy_Counter
 * @subpackage Event_Taxnonomy_Counter/includes
 * @since 1.0.3
 */
class rhc_etc_dashboard_widget {
	function rhc_etc_dashboard_widget() {
		add_action( 'wp_dashboard_setup', array( $this, 'dashboard_widgets' ) );
	}

	function dashboard_widgets() {
		global $rhc_plugin;

		wp_add_dashboard_widget(
			'etc-dashboard-widget',
			$rhc_plugin->get_option( 'rhcetc-dashboard-widget-title', 'Calendarize it! Taxonomy Counter', true ),
			array( $this, 'handle_main_d_widget' )
		);
	}

	function handle_main_d_widget() {
		global $rhc_plugin, $rhcetc_framework;

		$content = '';
		$icons_visible = (int) $rhc_plugin->get_option( 'rhcetc-d_widget-icons', '0', true );

		// Post Type
		// ------------------------------
		$post_type_visibility = (int) $rhc_plugin->get_option( 'rhcetc-dashboard-widget-' . RHC_EVENTS . '-onoff', '1', true );
		$posts_count = wp_count_posts( RHC_EVENTS );

		if ( $post_type_visibility && $posts_count->publish ) {
			$post_type_obj = get_post_type_object( RHC_EVENTS );
			$post_type_label = $rhcetc_framework->get_featured_content_label( $post_type_obj, $posts_count->publish );

			$featured_content = $rhcetc_framework->get_featured_content_html( $post_type_label, RHC_EVENTS, $icons_visible );

			$title_attr = sprintf( __( '%s', 'rhcetc' ) , $post_type_label );
			$content .= $rhcetc_framework->get_counter_container_html( $featured_content, $posts_count->publish, RHC_EVENTS, $title_attr );
		}

		// Taxonomies
		// ------------------------------
		$taxonomies_list = get_object_taxonomies( RHC_EVENTS );

		if ( is_array( $taxonomies_list ) && count( $taxonomies_list ) > 0 ) {
			foreach ( $taxonomies_list as $taxonomy_name ) {
				$taxonomy_visibility = (int) $rhc_plugin->get_option( 'rhcetc-dashboard-widget-' . $taxonomy_name . '-onoff', '1', true );
				$terms_count = (int) wp_count_terms( $taxonomy_name );

				if ( $taxonomy_visibility && $terms_count ) {
					$taxonomy_obj = get_taxonomy( $taxonomy_name );
					$taxonomy_label = $rhcetc_framework->get_featured_content_label( $taxonomy_obj, $terms_count );

					$featured_content = $rhcetc_framework->get_featured_content_html( $taxonomy_label, $taxonomy_name, $icons_visible );

					$title_attr = sprintf( __( '%s', 'rhcetc' ) , $taxonomy_label );
					$content .= $rhcetc_framework->get_counter_container_html( $featured_content, $terms_count, $taxonomy_name, $title_attr );
				}
			}
		}

		if ( ! did_action( 'event_taxonomy_styles' ) ) {	
			do_action( 'event_taxonomy_styles' );
		}

		$html = $rhcetc_framework->get_counter_box_html( $content, 'widget_event-taxonomy-counter', 'etc-counter' );

		wp_enqueue_style( 'tooltipster' );
		wp_enqueue_style( 'rhc-etc-style' );

		wp_enqueue_script( 'tooltipster' );
		wp_enqueue_script( 'rhc-etc-script' );

		echo $html;
	}
}


?>