<?php
/**
 * Event_Calendar_Term_Widget class, extended for creating widgets
 *
 * @package Event_Taxnonomy_Counter
 * @subpackage Event_Taxnonomy_Counter/includes
 * @since 1.0.0
 */
class Event_Calendar_Term_Widget extends WP_Widget {
	/**
	 * Sets up the widget name.
	 *
	 * @since 1.0.0
	 */
	public function __construct()
	{
		parent::__construct(
			'calendar-term-counter',
			__( 'Calendarize it! Calendar Terms', 'rhcetc' ),
			array( 'description' => __( 'Calendar Terms Counter', 'rhcetc' ) )
		);
	}

	/**
	 * Outputs the content of the widget.
	 *
	 * @since 1.0.0
	 * 
	 * @see WP_Widget::widget()
 	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance )
	{
		global $rhc_plugin;
		global $rhcetc_framework;
		$widget_html = '';
		$containers_html = '';

		$wrapper_class = 'widget_taxonomy-term-counter';
		$container_class = 'term-counter-container';
		$modifier = 'ttc-counter'; // ttc: Taxonomy Terms Counter
		//-------------
		$terms = get_terms( RHC_CALENDAR );

		$widget_html .= $args['before_widget'];
		$widget_html .= $args['before_title'] . $instance['title'] . $args['after_title'];

		foreach ( $terms as $term ) {
			$onoff = (int) $rhc_plugin->get_option( 'rhcctc-' . $term->slug . '-onoff', '1', true );

			if ( ! empty( $instance[ $term->slug ] ) || $onoff ) {
				$featured_content = $rhcetc_framework->get_featured_content_html( $term->name );
				$containers_html .= $rhcetc_framework->get_counter_container_html( $featured_content, $term->count, $term->slug, $container_class );
				
				$modifier .= ' ' . $rhcetc_framework->get_taxonomy_prefix( RHC_CALENDAR );
			}
		}

		$widget_html .= $rhcetc_framework->get_counter_box_html( $containers_html, $wrapper_class, "$modifier-counter" );
		$widget_html .= $args['after_widget'];

		if ( ! did_action( 'calendar_terms_styles' ) ) {
			do_action( 'calendar_terms_styles' );
		}
		
		wp_enqueue_style( 'rhc-etc-style' );
		
		echo $widget_html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @since 1.0.0
	 * 
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance )
	{
		$form_html = '';
		$terms = get_terms( RHC_CALENDAR );
		$title = ( isset( $instance['title'] ) ) ? strip_tags( $instance['title'] ) : '';

		$form_html .= '<p>';
		$form_html .= '<label for="' . $this->get_field_id( 'title' ) . '">' . __( 'Title:', 'rhc_etc' ) . '</label>';
		$form_html .= '<input class="widefat" id="' . $this->get_field_id( 'title' ) . '" name="' . $this->get_field_name( 'title' ) . '" type="text" value="' . esc_attr( $title ) . '">';
		$form_html .= '</p>';

		$form_html .= '<h4>Term Visibility</h4>';
		$form_html .= '<p>If you want to insert multiple instances of the Calendar Term Counter Widget you can overwrite the default visibility settings in the Options Panel by checking the individual terms below</p>';

		$form_html .= '<p>';

		foreach ( $terms as $term ) {
			$checked = ( ! empty( $instance[ $term->slug ] ) ) ? 'checked="checked"' : '';

			$form_html .= '<input class="checkbox" type="checkbox"' . $checked . ' id="' . $this->get_field_id( $term->slug ) . '" name="' . $this->get_field_name( $term->slug ) . '">';
			$form_html .= '<label for="' . $this->get_field_id( $term->slug ) . '">' . $term->name . '</label><br>';
		}

		$form_html .= '</p>';
		
		echo $form_html;
	}

	/**
	 * Sanitize widget form values as they are saved.
	 * 
	 * @since 1.0.0
	 * 
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance )
	{
		$instance = array();
		$terms = get_terms( RHC_CALENDAR );
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		foreach ( $terms as $term ) {
			$instance[ $term->slug ] = ( ! empty( $new_instance[ $term->slug ] ) ) ? 1 : 0;
		}

		return $instance;
	}
}

?>