/**
 * cbpGridGallery.js v1.0.0 merged with 
 * animOnScroll.js v1.0.0
 * http://www.codrops.com
 *
 * Licensed under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 * 
 * Copyright 2014, Codrops
 * http://www.codrops.com
 *
 * Modifications for RightHere by Alberto Lau.
 */
;( function( window ) {
	
	'use strict';

	var docElem = window.document.documentElement,
		transEndEventNames = {
			'WebkitTransition': 'webkitTransitionEnd',
			'MozTransition': 'transitionend',
			'OTransition': 'oTransitionEnd',
			'msTransition': 'MSTransitionEnd',
			'transition': 'transitionend'
		},
		transEndEventName = transEndEventNames[ Modernizr.prefixed( 'transition' ) ],
		support = {
			transitions : Modernizr.csstransitions,
			support3d : Modernizr.csstransforms3d
		};

	function setTransform( el, transformStr ) {
		el.style.WebkitTransform = transformStr;
		el.style.msTransform = transformStr;
		el.style.transform = transformStr;
	}

	// from http://responsejs.com/labs/dimensions/
	function getViewportW() {
		var client = docElem['clientWidth'],
			inner = window['innerWidth'];
		
		if( client < inner )
			return inner;
		else
			return client;
	}
	
	/* for animonscroll */
	function getViewportH() {
		var client = docElem['clientHeight'],
			inner = window['innerHeight'];
		
		if( client < inner )
			return inner;
		else
			return client;
	}	
	
	/* for animonscroll */
	function scrollY() {
		return window.pageYOffset || docElem.scrollTop;
	}

	/* for animonscroll */
	// http://stackoverflow.com/a/5598797/989439
	function getOffset( el ) {
		var offsetTop = 0, offsetLeft = 0;
		do {
			if ( !isNaN( el.offsetTop ) ) {
				offsetTop += el.offsetTop;
			}
			if ( !isNaN( el.offsetLeft ) ) {
				offsetLeft += el.offsetLeft;
			}
		} while( el = el.offsetParent )

		return {
			top : offsetTop,
			left : offsetLeft
		}
	}

	/* for animonscroll */
	function inViewport( el, h ) {
		var elH = el.offsetHeight,
			scrolled = scrollY(),
			viewed = scrolled + getViewportH(),
			elTop = getOffset(el).top,
			elBottom = elTop + elH,
			// if 0, the element is considered in the viewport as soon as it enters.
			// if 1, the element is considered in the viewport only when it's fully inside
			// value in percentage (1 >= h >= 0)
			h = h || 0;

		return (elTop + elH * h) <= viewed && (elBottom - elH * h) >= scrolled;
	}
		
	function extend( a, b ) {
		for( var key in b ) { 
			if( b.hasOwnProperty( key ) ) {
				a[key] = b[key];
			}
		}
		return a;
	}

	function CBPGridGallery( el, options ) {
		this.el = el;
		this.options = extend( {
			animonscroll: true,
			slideShowOffsetY: 0,
			enableslideshow: true
		}, this.options );
  		extend( this.options, options );
  		this._init();
	}

	CBPGridGallery.prototype.options = {
	};

	CBPGridGallery.prototype._init = function() {

		if(this.options.animonscroll){
			classie.addClass( this.el, 'animonscroll' );
		}	
		// main grid
		this.grid = this.el.querySelector( 'section.grid-wrap > ul.rhg_grid' );
		// main grid items
		this.gridItems = [].slice.call( this.grid.querySelectorAll( 'li:not(.grid-sizer)' ) );
		if( this.options.animonscroll ){
			this.items = this.gridItems;
			this.itemsRenderedCount = 0;
			this.didScroll = false;
			var self = this;		
		}
		// items total
		this.itemsCount = this.gridItems.length;
		//TODO: how do we do this without jQuery?		 
		this.slideshow_container = jQuery( this.el.querySelector( 'section.rhg_slideshow' ) )
			.addClass( jQuery(this.el).attr('class') )
			.appendTo('BODY')
			.wrap('<div class="rhg_slideshow_container rhg-default"></div>').parent()
			.get(0)
			;
		var _slideshow_id = this.el.id + '_sl';
		this.slideshow_container.id = _slideshow_id;
		this.el.setAttribute('data-slideshow_id', _slideshow_id);
		jQuery('<section class="slideshow slideshow-placeholder"><ul class="rhg_slideshow_items"></ul></section>').hide().appendTo(this.el);//placeholder for incoming sl elements.
		// slideshow grid
		this.slideshow = this.slideshow_container.querySelector( 'section.rhg_slideshow > ul' );
		// slideshow grid items
		this.slideshowItems = [].slice.call( this.slideshow.children );
		// index of current slideshow item
		this.current = -1;
		// slideshow control buttons		
		this.ctrlPrev = this.slideshow_container.querySelector( 'section.rhg_slideshow > nav > span.rhg-nav-prev' );
		this.ctrlNext = this.slideshow_container.querySelector( 'section.rhg_slideshow > nav > span.rhg-nav-next' );
		this.ctrlClose = this.slideshow_container.querySelector( 'section.rhg_slideshow > nav > span.rhg-nav-close' );
		// init masonry grid
		this._initMasonry();
		// init events
		this._initEvents();
	};

	CBPGridGallery.prototype._addItems = function() {

		var self = this;
		var slideshow_container = this.slideshow_container;	
		//rhg_slideshow_items
		jQuery(this.el).find('.rhg_slideshow_items').children().each(function(i,sl){	
			jQuery(sl).appendTo( jQuery(slideshow_container).find('.rhg_slideshow_items') );
		});
		
		// main grid items
		this.gridItems = [].slice.call( this.grid.querySelectorAll( 'li:not(.grid-sizer)' ) );
		if( this.options.animonscroll ){
			this.items = this.gridItems;
			this.itemsRenderedCount = 0;
			this.didScroll = false;
			var self = this;		
		}		
		// items total
		this.itemsCount = this.gridItems.length;
		// slideshow grid items
		this.slideshowItems = [].slice.call( this.slideshow.children );
		
		this._initMasonry();	
		// open the slideshow when clicking on the main grid items
		this.gridItems.forEach( function( item, idx ) {
			if( !classie.has(item, 'cbp-triggers-slide') ){
				classie.addClass( item, 'cbp-triggers-slide' );
				jQuery(item).bind('click',function(){
					self._openSlideshow( idx );
				});
				/* jQuery seems to react slightly faster
				item.addEventListener( 'click', function() {							
					self._openSlideshow( idx );
				} );
				*/			
			}
		} );	
	};

	CBPGridGallery.prototype._makeSameHeight = function() {	
		if( this.options.makeSameHeight ){
		
		}else{
			return false;
		}

		var self = this;		
		var heights = [];
		var container_width = 1;
		var element_width = 1;
		var items_per_row = 3;
		self.items.forEach( function( el, i ) {
			container_width = jQuery(el).closest('.rhg_grid_items').width();
			element_width = jQuery(el).width();
			heights.push( jQuery(el).height() );
			//--- clear prev values
			jQuery(el)
				.css('height','')		
				.find('.grid-item')
					.css('height','')
					.end()
				.find('.griditem')
					.css('height','')		
					.end()
				.find('figcaption')
					.css('height','')			
			;
			
		
				
		});
		items_per_row = Math.floor( container_width / element_width );

		var matrix = [];
		var row = 0;
		for( var a=0; a < self.items.length ; a++ ){
			
	
			matrix[ row ] = matrix[ row ] ? matrix[ row ] : [] ;
			matrix[ row ] .push( self.items[a] );
	
			if( matrix[ row ].length == items_per_row ){
				row++;
			}
		}

		if( matrix.length ){
			for( var a=0; a < matrix.length ; a++ ){
				if( matrix[a].length ){
					var row_height = 0;
					var heights = [];
					for( var b=0; b < matrix[a].length ; b++ ){
						heights.push( jQuery( matrix[a][b] ).height() );
					}

					row_height = Math.max.apply( null, heights );

					if( row_height > 100 ){
						for( var b=0; b < matrix[a].length ; b++ ){
							var el = jQuery( matrix[a][b] );
							el
								.addClass( 'rhg-forced-height' )
								.height( row_height )
								.find('.grid-item')
									.css('height','100%')
								.find('.griditem')
									.css('height','100%')
							;
							//-- expand the content to fill empty space
							var container_h = el.find('.griditem').height();
							var img_h = el.find('.griditem-img').outerHeight();
						
							var caption_height = container_h - img_h ;

							if( caption_height > 1 ){
								el.find('figure.griditem > figcaption').outerHeight( caption_height );
							}
						}	
					}
					
					//--
				}
			}
		}
	};
	
	CBPGridGallery.prototype._initMasonry = function() {

		var self = this;
		var grid = this.grid;	

		imagesLoaded( grid, function() {
		
			self._makeSameHeight();
		
			self.msnry = new Masonry( grid, {
				itemSelector: 'li',
				columnWidth: grid.querySelector( '.grid-sizer' )
			});
			
			if(self.options.animonscroll){
				if( Modernizr.cssanimations ) {
					// the items already shown...
					self.items.forEach( function( el, i ) {
						if( inViewport( el ) ) {
							self._checkTotalRendered();
		
							if( !self.options.starthidden ){
								classie.add( el, 'shown' );
							}
						}
					} );

					// animate on scroll the items inside the viewport
					if( !self.animonscroll_added_listeners ){
						self.animonscroll_added_listeners = true;

						window.addEventListener( 'scroll', function() {
							self._onScrollFn();
						}, false );
						
						window.addEventListener( 'resize', function() {
							self._resizeHandler();
						}, false );					
					}

				}else{
					console.log('Modernizr.cssanimations is not defined, check for duplicate Modernizr.');
				}		
			}
		});
	};

	CBPGridGallery.prototype._initEvents = function() {
		var self = this;

		// open the slideshow when clicking on the main grid items
		this.gridItems.forEach( function( item, idx ) {
			classie.addClass( item, 'cbp-triggers-slide' );
			item.addEventListener( 'click', function() {	
				var url = jQuery(item).attr('data-url') || false;
				url = ''==url?false:url;
				var trigger_size = jQuery(item).attr('data-trigger_size') || 0;			
				trigger_size = parseInt( trigger_size );

				var window_width = jQuery(window).width();
				if( false!==url && trigger_size > 0 && window_width > 0 ){
					if( window_width > trigger_size ){
						//window is big enough for slideshow.
						url = false;
					}
				}				
				if(false===url){
					self._openSlideshow( idx );
				}else{
					var target = jQuery(item).attr('data-target') || '_self';
					window.open(url, target);
				}
			} );
		} );
		
		// slideshow controls		
		/*
		this.ctrlPrev.addEventListener( 'click', function() { _console( '_navigate(prev) addEventListener' );	self._navigate( 'prev' ); } );		
		this.ctrlNext.addEventListener( 'click', function() { _console( '_navigate(next)' );	self._navigate( 'next' ); } );
		this.ctrlClose.addEventListener( 'click', function() { _console( 'close slideshow' );	self._closeSlideshow(); } );
		*/
		jQuery( this.ctrlPrev ).bind( 'click', function(){ self._navigate( 'prev' ); });		
		jQuery( this.ctrlNext ).bind( 'click', function(){ self._navigate( 'next' ); });		
		jQuery( this.ctrlClose ).bind( 'click', function(){ self._closeSlideshow(); });		
		
		// window resize
		window.addEventListener( 'resize', function() { self._resizeHandler(); } );

		// keyboard navigation events
		document.addEventListener( 'keydown', function( ev ) {
			if ( self.isSlideshowVisible ) {
				var keyCode = ev.keyCode || ev.which;

				switch (keyCode) {
					case 37:
						self._navigate( 'prev' );
						break;
					case 39:
						self._navigate( 'next' );
						break;
					case 27:
						self._closeSlideshow();
						break;
				}
			}
		} );

		// trick to prevent scrolling when slideshow is visible
		window.addEventListener( 'scroll', function() {
			if ( self.isSlideshowVisible ) {
				window.scrollTo( self.scrollPosition ? self.scrollPosition.x : 0, self.scrollPosition ? self.scrollPosition.y : 0 );
			}
			else {
				self.scrollPosition = { x : window.pageXOffset || docElem.scrollLeft, y : window.pageYOffset || docElem.scrollTop };
			}
		});
	};

	CBPGridGallery.prototype._openSlideshow = function( pos ) {
		if( !this.options.enableslideshow ) return;
		this.isSlideshowVisible = true;
		this.current = pos;

		classie.addClass( this.el, 'slideshow-open' );
		classie.addClass( this.slideshow_container, 'slideshow-open' );
		classie.addClass( document.getElementsByTagName("body")[0], 'rhg-slideshow-open' );
		
		/* bug fix, when the el is inside another fixed container slideshow breaks */
		var viewport_height = getViewportH() + 'px';
		var scrollTop = (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;	 
		this.slideshow_container.style.maxHeight = viewport_height;
		this.slideshow_container.style.top = scrollTop + 'px';
		/* position slideshow items */

		// set viewport items (current, next and previous)
		this._setViewportItems();
		
		// add class "current" and "show" to currentItem
		classie.addClass( this.currentItem, 'current' );
		classie.addClass( this.currentItem, 'show' );

		// add class show to next and previous items
		// position previous item on the left side and the next item on the right side
		if( this.prevItem ) {
			classie.addClass( this.prevItem, 'show' );
			var translateVal = Number( -1 * ( getViewportW() / 2 + this.prevItem.offsetWidth / 2 ) );
			setTransform( this.prevItem, support.support3d ? 'translate3d(' + translateVal + 'px, 0, -150px)' : 'translate(' + translateVal + 'px)' );
		}
		if( this.nextItem ) {
			classie.addClass( this.nextItem, 'show' );
			var translateVal = Number( getViewportW() / 2 + this.nextItem.offsetWidth / 2 );
			setTransform( this.nextItem, support.support3d ? 'translate3d(' + translateVal + 'px, 0, -150px)' : 'translate(' + translateVal + 'px)' );
		}

		if( this.options.openSlideshow ) this.options.openSlideshow( this, 0) ;			
	};

	CBPGridGallery.prototype._navigate = function( dir ) {
		if( this.isAnimating ) return;
		if( dir === 'next' && this.current === this.itemsCount - 1 ||  dir === 'prev' && this.current === 0  ) {
			this._closeSlideshow();
			return;
		}
		
		this.isAnimating = true;
		
		// reset viewport items
		this._setViewportItems();

		var self = this,
			itemWidth = this.currentItem.offsetWidth,
			// positions for the centered/current item, both the side items and the incoming ones
			transformLeftStr = support.support3d ? 'translate3d(-' + Number( getViewportW() / 2 + itemWidth / 2 ) + 'px, 0, -150px)' : 'translate(-' + Number( getViewportW() / 2 + itemWidth / 2 ) + 'px)',
			transformRightStr = support.support3d ? 'translate3d(' + Number( getViewportW() / 2 + itemWidth / 2 ) + 'px, 0, -150px)' : 'translate(' + Number( getViewportW() / 2 + itemWidth / 2 ) + 'px)',
			transformCenterStr = '', transformOutStr, transformIncomingStr,
			// incoming item
			incomingItem;

		if( dir === 'next' ) {
			transformOutStr = support.support3d ? 'translate3d( -' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px, 0, -150px )' : 'translate(-' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px)';
			transformIncomingStr = support.support3d ? 'translate3d( ' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px, 0, -150px )' : 'translate(' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px)';
		}
		else {
			transformOutStr = support.support3d ? 'translate3d( ' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px, 0, -150px )' : 'translate(' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px)';
			transformIncomingStr = support.support3d ? 'translate3d( -' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px, 0, -150px )' : 'translate(-' + Number( (getViewportW() * 2) / 2 + itemWidth / 2 ) + 'px)';
		}

		// remove class animatable from the slideshow grid (if it has already)
		classie.removeClass( self.slideshow, 'animatable' );
		if( dir === 'next' && this.current < this.itemsCount - 2 || dir === 'prev' && this.current > 1 ) {
			// we have an incoming item!
			incomingItem = this.slideshowItems[ dir === 'next' ? this.current + 2 : this.current - 2 ];
			setTransform( incomingItem, transformIncomingStr );
			classie.addClass( incomingItem, 'show' );
		}else{

		}

		var slide = function() {
			var jquery_transion_end = function(e){
				_onEndTransitionFn(e.originalEvent);
			}
			
			var _onEndTransitionFn = function( ev ) {
				if( support.transitions ) {
					if( ev.propertyName.indexOf( 'transform' ) === -1 ) return false;
					//note:jquery working better
					//this.removeEventListener( transEndEventName, _onEndTransitionFn );
					jQuery( self.currentItem ).unbind('transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd', jquery_transion_end );
				}

				if( self.prevItem && dir === 'next' ) {
					classie.removeClass( self.prevItem, 'show' );
				}
				else if( self.nextItem && dir === 'prev' ) {
					classie.removeClass( self.nextItem, 'show' );
				}

				if( dir === 'next' ) {
					self.prevItem = self.currentItem;
					self.currentItem = self.nextItem;
					if( incomingItem ) {
						self.nextItem = incomingItem;
					}
				}
				else {
					self.nextItem = self.currentItem;
					self.currentItem = self.prevItem;
					if( incomingItem ) {
						self.prevItem = incomingItem;
					}
				}

				self.current = dir === 'next' ? self.current + 1 : self.current - 1;
				self.isAnimating = false;
			};

			if( support.transitions ) {
				//note:jquery working better
				jQuery(self.currentItem).bind('transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd', jquery_transion_end );
				//self.currentItem.addEventListener( transEndEventName, _onEndTransitionFn );
			}
						
			// add class animatable to the slideshow grid
			classie.addClass( self.slideshow, 'animatable' );

			// overlays:
			classie.removeClass( self.currentItem, 'current' );
			var nextCurrent = dir === 'next' ? self.nextItem : self.prevItem;
			classie.addClass( nextCurrent, 'current' );

			setTransform( self.currentItem, dir === 'next' ? transformLeftStr : transformRightStr );
			if( self.nextItem ) {
				setTransform( self.nextItem, dir === 'next' ? transformCenterStr : transformOutStr );
			}

			if( self.prevItem ) {
				setTransform( self.prevItem, dir === 'next' ? transformOutStr : transformCenterStr );
			}

			if( incomingItem ) {
				setTransform( incomingItem, dir === 'next' ? transformRightStr : transformLeftStr );
			}

			if( support.transitions ) {
				//jQuery( self.currentItem ).on( transEndEventName, _onEndTransitionFn );
				//self.currentItem.addEventListener( transEndEventName, _onEndTransitionFn );
			}
			else {	
				_onEndTransitionFn();
			}
		};

		setTimeout( slide, 25 );
		
		if( this.options.navigate ) this.options.navigate( this, 1) ;
	}

	CBPGridGallery.prototype._closeSlideshow = function( pos ) {
		// remove class slideshow-open from the grid gallery elem
		classie.removeClass( this.slideshow_container, 'slideshow-open' );
		classie.removeClass( this.el, 'slideshow-open' );
		classie.removeClass( document.getElementsByTagName("body")[0], 'rhg-slideshow-open' );
		// remove class animatable from the slideshow grid
		classie.removeClass( this.slideshow, 'animatable' );

		var self = this,
			onEndTransitionFn = function( ev ) {
				if( support.transitions ) {
					if( ev.target.tagName.toLowerCase() !== 'ul' ) return;
					this.removeEventListener( transEndEventName, onEndTransitionFn );
				}
				// remove classes show and current from the slideshow items
				classie.removeClass( self.currentItem, 'current' );
				classie.removeClass( self.currentItem, 'show' );
				
				if( self.prevItem ) {
					classie.removeClass( self.prevItem, 'show' );
				}
				if( self.nextItem ) {
					classie.removeClass( self.nextItem, 'show' );
				}

				// also reset any transforms for all the items
				self.slideshowItems.forEach( function( item ) { setTransform( item, '' ); } );
				self.isSlideshowVisible = false;
			};

		if( support.transitions ) {
			this.slideshow_container.addEventListener( transEndEventName, onEndTransitionFn );
			this.el.addEventListener( transEndEventName, onEndTransitionFn );
		}
		else {
			onEndTransitionFn();
		}
	};

	CBPGridGallery.prototype._setViewportItems = function() {

		this.currentItem = null;
		this.prevItem = null;
		this.nextItem = null;

		if( this.current > 0 ) {
			this.prevItem = this.slideshowItems[ this.current - 1 ];
		}
		if( this.current < this.itemsCount - 1 ) {
			this.nextItem = this.slideshowItems[ this.current + 1 ];
		}
		this.currentItem = this.slideshowItems[ this.current ];
	}

	// taken from https://github.com/desandro/vanilla-masonry/blob/master/masonry.js by David DeSandro
	// original debounce by John Hann
	// http://unscriptable.com/index.php/2009/03/20/debouncing-javascript-methods/
	CBPGridGallery.prototype._resizeHandler = function() {
		var self = this;
		function delayed() {
			self._resize();
			self._resizeTimeout = null;		
			//------------------	
			if(self.isSlideshowVisible){
				var viewport_height = getViewportH() + 'px';
				var scrollTop = (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;	 
				self.slideshow_container.style.maxHeight = viewport_height;
				self.slideshow_container.style.top = scrollTop + 'px';	
			}
			//------------------
		}
		if ( this._resizeTimeout ) {
			clearTimeout( this._resizeTimeout );
		}
		this._resizeTimeout = setTimeout( delayed, 50 );
	}

	CBPGridGallery.prototype._resize = function() {
		if ( this.isSlideshowVisible ) {
			// update width value
			if( this.prevItem ) {
				var translateVal = Number( -1 * ( getViewportW() / 2 + this.prevItem.offsetWidth / 2 ) );
				setTransform( this.prevItem, support.support3d ? 'translate3d(' + translateVal + 'px, 0, -150px)' : 'translate(' + translateVal + 'px)' );
			}
			if( this.nextItem ) {
				var translateVal = Number( getViewportW() / 2 + this.nextItem.offsetWidth / 2 );
				setTransform( this.nextItem, support.support3d ? 'translate3d(' + translateVal + 'px, 0, -150px)' : 'translate(' + translateVal + 'px)' );
			}		
		}
	}

	/* start methods for animonscroll */
	CBPGridGallery.prototype.defaults = {
			minDuration : 0,
			maxDuration : 0,
			viewportFactor : 0
	}
	
	CBPGridGallery.prototype._onScrollFn = function() {
		var self = this;
		if( !this.didScroll ) {
			this.didScroll = true;
			setTimeout( function() { self._scrollPage(); }, 60 );
		}
	}

	CBPGridGallery.prototype._scrollPage = function() {
		var self = this;
		this.items.forEach( function( el, i ) {
			if( !classie.has( el, 'shown' ) && !classie.has( el, 'animate' ) && inViewport( el, self.options.viewportFactor ) ) {
				setTimeout( function() {
					var perspY = scrollY() + getViewportH() / 2;
					self.el.style.WebkitPerspectiveOrigin = '50% ' + perspY + 'px';
					self.el.style.MozPerspectiveOrigin = '50% ' + perspY + 'px';
					self.el.style.perspectiveOrigin = '50% ' + perspY + 'px';

					self._checkTotalRendered();

					if( self.options.minDuration && self.options.maxDuration ) {
						var randDuration = ( Math.random() * ( self.options.maxDuration - self.options.minDuration ) + self.options.minDuration ) + 's';
						el.style.WebkitAnimationDuration = randDuration;
						el.style.MozAnimationDuration = randDuration;
						el.style.animationDuration = randDuration;
					}
					
					classie.add( el, 'animate' );
				}, 25 );
			}
		});
		this.didScroll = false;
	}
	
	CBPGridGallery.prototype._checkTotalRendered = function() {
		++this.itemsRenderedCount;
		if( this.itemsRenderedCount === this.itemsCount ) {
			window.removeEventListener( 'scroll', this._onScrollFn );
		}
	}	
	/* end methods for animonscroll */
	
	// add to global namespace
	window.CBPGridGallery = CBPGridGallery;

})( window );