<?php

/**
 * 
 * Alberto Lau
 * @version $Id$
 * @copyright 2003 
 **/

class rh_feeds {
	var $id='rh-feed';
	var $version='1.0.0';
	var $template=false;
	var $items_per_page=50;
	function __construct( $args=array() ){
		//------------
		$defaults = array(
			'id'				=> 'rh-feed',
			'template'			=> false,
			'items_per_page'	=> 2
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------	
		add_action('init', array(&$this,'init'), 10);
		add_filter('pre_get_posts', array(&$this,'number_of_posts_on_rh_feed'), 999999 );	
		
		add_filter('template_include', array(&$this,'template_include'), 10, 1);
	}
	
	function template_include($template){
		global $wp_query;
		if ( $this->is_rh_feed($wp_query) ) {
			return $this->template;
		}
		return $template;
	}
	
	function init(){
		//note: this require a one time flush_rules, like saving permalinks once.
		add_rewrite_endpoint( $this->id, EP_ALL );
		//add_feed( $this->id, array(&$this,'cb_gridfeed') );
	}
	
	function is_rh_feed($query){
		return isset($query->query[$this->id])? true : false ;
	}
	/*
	function cb_gridfeed(){	
		while ( have_posts() ) : the_post();
		if($this->template){
			include $this->template;
		} else {
			echo get_the_title()."<br>";
		}
		endwhile;
	}
	*/
	function number_of_posts_on_rh_feed($query){
		if ( $this->is_rh_feed($query) ) {
			$query->set('posts_per_page', intval($this->items_per_page) );
		}
	    return $query;
	}
 
		
}

?>