<?php

 
class plugin_rhg {
	var $in_footer=false;
	function __construct($args=array()){
		//------------
		$defaults = array(
			'id'				=> 'rhg',
			'tdom'				=> 'rhg',
			'plugin_code'		=> 'RHG',
			'options_varname'	=> 'rhg_options',
			'options_parameters'=> array(),
			'options_capability'=> 'manage_options',
			'license_capability'=> 'manage_options',
			'resources_path'	=> 'grid-gallery',
			'options_panel_version'	=> '2.6.4',
			'post_info_shortcode'=> 'rhc_post_info',
			'debug_menu'		=> false,
			'autoupdate'		=> true,
			'debugging_js_css'	=> false,
			'feedname'			=> 'grid-feed',
			'path'				=> '',
			'url'				=> '',
			'pop_path'			=> '',
			'pop_url'			=> '',
			'theme'				=> false,
			'menu_parent'		=> 'rhg',
			'option_title'		=> __('Options','rhg'),
			'downloadables'		=> true,
			'grid_menu'			=> true
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------
		$this->options = get_option($this->options_varname);
		$this->options = is_array($this->options)?$this->options:array();
		//-----------		
		if( $this->grid_menu ){
			add_action( 'admin_menu', array(&$this,'admin_menu') );
		}
		add_action('plugins_loaded',array(&$this,'handle_addons_load'),5);
		add_action('plugins_loaded',array(&$this,'plugins_loaded'),9);
		add_action('wp_enqueue_scripts',array(&$this,'wp_enqueue_scripts'),99);
		add_action('admin_enqueue_scripts',array(&$this,'admin_enqueue_scripts'),10);
		add_action( 'wp_enqueue_media', array( &$this, 'wp_enqueue_media' ) );
		
		require_once $this->pop_path . 'load.pop.php';
		rh_register_php('options-panel', 	$this->pop_path . 'class.PluginOptionsPanelModule.php', $this->options_panel_version);
		rh_register_php('rh-functions', 	$this->pop_path . 'rh-functions.php', $this->options_panel_version);	

		//--
		if('1'==$this->get_option('enable_debug',false,true)){
			$this->debug_menu = true;
		}
		
		if(defined('RHC_VERSION')){
			global $rhc_plugin;
			if('1'==$rhc_plugin->get_option('in_footer',false,true)){
				$this->in_footer = true;
			}		
		}
		//---
		if(defined('RHC_VERSION')){
			add_filter('rhc_views', array(&$this,'grid_rhc_views'));	
		}
		
		add_action('enqueue_frontend_only', array( &$this, 'enqueue_frontend_only') );
	}
	
	function enqueue_frontend_only(){
		wp_enqueue_script( 'rhc-grid-view' );
	}
	
	function grid_rhc_views($views){
		$views['rhc_grid']=__('Event Grid View','rhg');
		return $views;
	}
	
	function wp_enqueue_scripts() {
		global $rhc_plugin;

		//TODO: merge into a minified file when stable.
		wp_register_style( 'google-grid-gallery', $this->url.'css/component.css', array(),'1.0.0.2');	
		wp_register_style( 'animonscroll', $this->url.'css/animonscroll.css', array(),'1.0.0.2');	
		wp_register_style( 'debug', $this->url.'css/debug.css', array(),'1.0.0.1');	
		
		wp_enqueue_style( 'google-grid-gallery' );
		wp_enqueue_style( 'animonscroll' );
		wp_enqueue_style( 'debug' );
	
		$theme = wp_get_theme();

		if ( 'Samui' === $theme->get( 'Name' ) ) {
			wp_register_script( 'rhg-modernizr', $this->url.'js/modernizr.custom.alt.js', array(), '3.5.0', $this->in_footer );
		} else {
			wp_register_script( 'rhg-modernizr', $this->url.'js/modernizr.custom.full.js', array(), '2.8.2', $this->in_footer );
		}

		$grid_gallery_deps = array();

		if ( '1' !== $rhc_plugin->get_option( 'grid_disable_modernizr', '0', true ) ) {
			$grid_gallery_deps[] = 'rhg-modernizr';
		}

		wp_register_script( 'imagesloaded', $this->url . 'js/imagesloaded.pkgd.min.js', array(), '3.1.4', $this->in_footer );
		wp_register_script( 'masonry', $this->url . 'js/masonry.pkgd.min.js', array(), '3.1.4', $this->in_footer );
		wp_register_script( 'classie', $this->url . 'js/classie.js', array(), '1.0.0', $this->in_footer );
		wp_register_script( 'cbpGridGallery', $this->url . 'js/cbpGridGallery.js', $grid_gallery_deps, '1.0.1.0', $this->in_footer );
		
		$dependency = array(
			'jquery',
			'imagesloaded',
			'masonry',
			'classie',
			'cbpGridGallery'
		);

		wp_enqueue_script( 'rhg', $this->url.'js/rhg_frontend.js', $dependency, '1.0.1.3',$this->in_footer);
		wp_enqueue_script( 'jquery-touchswipe', $this->url.'js/jquery.TouchSwipe.js', array('rhg'), '1.6.6',$this->in_footer);
		
		$this->rhc_view_scripts();		
		
		if( '0' == $this->get_option('scripts_on_demand','0',true)){
			do_action('enqueue_frontend_only');		
		}		
	}

	function admin_enqueue_scripts(){
		$this->rhc_view_scripts();			
	}

	function rhc_view_scripts(){
		if(!defined('RHC_VERSION'))return;		
		wp_register_script( 'rhc-grid-view', $this->url.'js/rhc_google_grid_view.js', array('calendarize'),'1.1.2.6',$this->in_footer);			
	}
	
	function wp_enqueue_media(){
		wp_enqueue_script( 'rhg-media-editor', $this->url.'js/media-editor.js', array('media-views'),'1.0.0',$this->in_footer);
	}
	
	function plugins_loaded(){
		load_plugin_textdomain('rhg', null, RHG_LANGUAGES );
		
		require_once $this->path.'class.rhg_ajax.php';
		new rhg_ajax(array(
			'template_archive'	=> $this->path.'templates/content-archive.php',
			'items_per_page'	=> 3
		));
		
		require_once $this->path.'class.rhg_shortcodes.php';
		new rhg_shortcodes();
		
		require_once $this->path.'class.rhg_custom_media_settings.php';
		new rhg_custom_media_settings();
		
		require_once $this->path.'class.rhg_media_gallery_shortcode.php';
		new rhg_media_gallery_shortcode();
		
		if(defined('RHC_VERSION')){
			require_once $this->path.'class.rhc_grid_integration.php';
			new rhc_grid_integration( $this->path );
		}
		
		if( is_admin() ){
			
		
			require_once $this->path.'class.rhg_options.php';
			new rhg_options($this->id);		
			
			$license_keys = $this->get_option('license_keys',array());
			$license_keys = is_array($license_keys)?$license_keys:array();
							
			$api_url = 'secondary'==$this->get_option('righthere_api_url','',true) ? 'http://plugins.albertolau.com/' : 'http://plugins.righthere.com/';
			
			$dc_options = array(
				'id'			=> $this->id.'-dc',
				'plugin_id'		=> $this->id,
				'capability'	=> $this->options_capability,
				'resources_path'=> $this->resources_path,
				'parent_id'		=> $this->menu_parent,
				'menu_text'		=> __('Downloads','rhg'),
				'page_title'	=> __('Downloadable content - Google Grid Gallery for WordPress','rhg'),
				'license_keys'	=> $license_keys,
				'plugin_code'	=> $this->plugin_code,
				'api_url'		=> $api_url,
				'product_name'	=> __('Google Grid Gallery','rhg'),
				'options_varname' => $this->options_varname,
				'tdom'			=> 'rhg',
				'module_url'	=> $this->pop_url
			);
			
			$ad_options = array(
				'id'			=> $this->id.'-addons',
				'plugin_id'		=> $this->id,
				'capability'	=> $this->options_capability,
				'resources_path'=> $this->resources_path,
				'parent_id'		=> $this->menu_parent,
				'menu_text'		=> __('Add-ons','rhg'),
				'page_title'	=> __('Google Grid Gallery add-ons','rhg'),
				'options_varname' => $this->options_varname,
				'module_url'	=> $this->pop_url
			);
			
			$settings = array(				
				'id'					=> $this->id,
				'plugin_id'				=> $this->id,
				'capability'			=> $this->options_capability,
				'capability_license'	=> $this->license_capability,
				'options_varname'		=> $this->options_varname,
				'menu_id'				=> $this->id,
				'page_title'			=> $this->option_title,
				'menu_text'				=> $this->option_title,
				'option_menu_parent'	=> $this->menu_parent,
				'notification'			=> (object)array(
					'plugin_version'=> RHG_VERSION,
					'plugin_code' 	=> 'RHG',
					'message'		=> __('Google Grid Gallery plugin update %s is available! <a href="%s">Please update now</a>','rhg')
				),
				'ad_options'			=> $ad_options,
				//'addons'				=> is_array($license_keys)&&count($license_keys)>0?true:false,
				'addons'				=> $this->debug_menu,
				'dc_options'			=> $dc_options,
				'fileuploader'			=> true,
				'theme'					=> $this->theme,
				'stylesheet'			=> 'rhg-options',
				'option_show_in_metabox'=> true,
				'path'			=> $this->pop_path,
				'url'			=> $this->pop_url,
				'pluginslug'	=> RHG_SLUG,
				'api_url' 		=> $api_url,//affects registration api
				'import_export'	=> false,
				'import_export_options' => false,
				'registration'	=> (!$this->theme),
				'downloadables'	=> $this->downloadables,
				'parentchilddropdown' => true,
				'layout'		=> 'horizontal'
			);
			
			do_action('rh-php-commons');	
			
			if(class_exists('PluginOptionsPanelModule'))new PluginOptionsPanelModule($settings);			
		}
	}
	
	function get_grid_feed_template(){
		return apply_filters('rh_grid_feed_template', $this->path.'templates/content-grid-feed.php' );
	}
	
	function admin_menu( ){
		add_menu_page( __('Grid Gallery','rhg'), __('Grid Gallery','rhg'), $this->options_capability, $this->id, create_function('','return "";'), '', 53.971 );
	}

	function handle_addons_load(){
		//-- nexgt gen gallery compat fix.

		if( defined('NGG_PLUGIN') ){
			rh_register_php('options-panel', $this->pop_path.'class.PluginOptionsPanelModule.php', $this->options_panel_version);
		}
		//---
		$upload_dir = wp_upload_dir();
		$addons_path = $upload_dir['basedir'].'/'.$this->resources_path.'/';	
		$addons_url = $upload_dir['baseurl'].'/'.$this->resources_path.'/';	
		$addons = $this->get_option('addons',array(),true);
		if(is_array($addons)&&!empty($addons)){
			define('RHG_ADDON_PATH',$addons_path);
			define('RHG_ADDON_URL',$addons_url);
			foreach($addons as $addon){
				try {
					@include_once $addons_path.$addon;
				}catch(Exception $e){
					$current = get_option( $this->options_varname, array() );
					$current = is_array($current) ? $current : array();
					$current['addons'] = is_array($current['addons']) ? $current['addons'] : array() ;
					//----
					$current['addons'] = array_diff($current['addons'], array($addon))  ;
					update_option($this->options_varname, $current);					
				}
			}
		}
	}
	
	function get_option($name,$default='',$default_if_empty=false){
		$value = isset($this->options[$name])?$this->options[$name]:$default;
		if($default_if_empty){
			$value = ''==$value?$default:$value;
		}
		return $value;
	}	
	
	function update_option($name,$value){
		$options = get_option($this->options_varname);
		$options[$name]=$value;
		update_option($this->options_varname, $options);
		//--update plugin object options
		$this->options = get_option($this->options_varname);
		$this->options = is_array($this->options)?$this->options:array();	
	}	
}

?>