<?php
/**
 * rhcss_term_counter_widget class, extended for module_righthere_css
 * 
 * @package Calendarize_It_Editor
 * @subpackage Calendarize_It_Editor/includes
 * @since 1.6.0
 */

class rhcss_term_counter_widget extends module_righthere_css {
	function __construct( $args = array() ) {
		$args['cb_init'] = array( $this, 'cb_init' );
		return parent::__construct($args);
	}
	
	function cb_init() {
		//called on the head when editor is active.
	}

	function options( $t = array() ) {

		// Width Settings
		// ------------------------------
		$i = count( $t );
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhcttc_width_settings'; 
		$t[ $i ]->label   = __( 'Width Settings', 'rhcetc' );
		$t[ $i ]->options = array();

		$t[ $i ]->options[] = (object) array( 'input_type' => 'grid_start' );
		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcttc_left_column_width',
			'type'          => 'css',
			'label'         => __( 'Left Column', 'rhcetc' ),
			'input_type'    => 'number',
			'class'         => 'input-mini',
			'unit'          => '%',
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'holder_class'  => 'span6',
			'selector'      => "body .term-counter-container .featured",
			'property'      => 'width',
			'other_options' => array(
				'transparent'    => 'transparent'
			),				
			'real_time'     => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcttc_right_column_width',
			'type'          => 'css',
			'label'         => __( 'Right Column', 'rhcetc' ),
			'input_type'    => 'number',
			'class'         => 'input-mini',
			'unit'          => '%',
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'holder_class'  => 'span6',
			'selector'      => "body .term-counter-container .number",
			'property'      => 'width',
			'other_options' => array(
				'transparent'    => 'transparent'
			),				
			'real_time'     => true
		);
		$t[ $i ]->options[] = (object) array( 'input_type' => 'grid_end' );

		// Labels
		// ------------------------------
		$i = count( $t );
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhcttc_labels_font'; 
		$t[ $i ]->label   = __( 'Font (Labels)', 'rhcetc' );
		$t[ $i ]->options = array();

		$t[$i]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcttc_label_default_font',
			'selector' => 'body .widget_taxonomy-term-counter .term-counter-container .featured .label',
			'labels'   => (object) array(
				'family'    => __( 'Default font', 'rhc' ),
				'size'      => __( 'Size', 'rhc' ),
				'color'     => __( 'Color', 'rhc' )				
			)
		));

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhcttc_label_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => 'body .widget_taxonomy-term-counter .term-counter-container .featured .label',
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		// Numbers
		// ------------------------------
		$i++;
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhcttc_numbers_font'; 
		$t[ $i ]->label   = __( 'Font (Numbers)', 'rhcetc' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcttc_number_default_font',
			'selector' => 'body .widget_taxonomy-term-counter .term-counter-container .number',
			'labels'   => (object) array(
				'family'    => __( 'Default font', 'rhc' ),
				'size'      => __( 'Size', 'rhc' ),
				'color'     => __( 'Color', 'rhc' )				
			)
		));

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhcttc_number_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => 'body .widget_taxonomy-term-counter .term-counter-container .number',
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		// Back Container
		// ------------------------------
		$i++;
		$box_prefix = 'rhcttc_counter';
		$box_selector = '.ttc-counter';
		$with_image = true;

		$label = ( isset( $label ) ) ? $label : array(); // Background bar

		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = $box_prefix . '-outer'; 
		$t[ $i ]->label   = ( isset( $label['outer'] ) ) ? $label['outer'] : __( 'Back Container', 'rhc' );
		$t[ $i ]->options = array();

		$t[ $i ]->options[] = (object) array(
			'id'            => $box_prefix . '_back_width',
			'type'          => 'css',
			'label'         => ( isset( $label['image_width'] ) ) ? $label['image_width'] : __( 'Width', 'rhc' ),
			'input_type'    => 'number',
			'class'         => 'input-mini',
			'unit'          => '%',
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'holder_class'  => '',
			'selector'      => ".fe-extrainfo-container$box_selector",
			'property'      => 'width',
			'other_options' => array(
				'transparent'    => 'transparent'
			),				
			'real_time'     => true
		);	

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => $box_prefix . '_outer_pad',
			'selector' => ".fe-extrainfo-container$box_selector"
		));

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => $box_prefix . '_outer_border',
			'selector' => "body .fe-extrainfo-container$box_selector, $box_selector .rhcetc-counter-container+.rhcetc-counter-container .column"
		));

		$t[$i]->options = $this->add_border_radius_options( $t[ $i ]->options, array(
			'prefix'   => $box_prefix . '_outer_radius',
			'selector' => ".fe-extrainfo-container$box_selector"
		));

		//-- Saved and DC  -----------------------		
		$i                = count( $t );
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rh-saved-list'; 
		$t[ $i ]->label   = __( 'Templates', 'rhc' );
		$t[ $i ]->options = array(
			(object) array(
				'id'         => 'rh_saved_settings',
				'input_type' => 'backup_list'
			)			
		);

		return $t;
	}
}


?>