<?php

class rhc_cb_visual_composer {
	function __construct(){
		add_action( 'vc_before_init', array( &$this, 'vc_before_init' ) );
		
		add_filter( 'rhc_vc_shortcode_subcategories', array( &$this, 'rhc_vc_shortcode_subcategories' ) , 10, 1 );
	}
	
	function rhc_vc_shortcode_subcategories( $arr ){
		$arr['rhc_button']=array('rhc-venue','rhc-event');
		return $arr;
	}
	
	function vc_before_init(){
		$meta_fields = $this->get_meta_fields();
		vc_map( array(
			"name" 				=> __( "Custom button", "rhccb" ),
			"base" 				=> "rhc_button",
			"category" 			=> "Calendarize It!", //this have to match with the main plugin class.rhc_visual_composer.php 
			"description"		=> __("Add custom button","rhccb"),
			"params" 			=> array(
				array(
				  "type" 		=> "textfield",
				  "holder" 		=> "div",
				  "class" 		=> "",
				  "heading" 	=> __('Button label','rhccb'),
				  "param_name" 	=> "label",
				  "value" 		=> __('Button label','rhccb'),
				  "description" => __( "A label for this button.", "rhccb" ),
				  'group'		=> __('Basic','rhccb')
				),	
				array(
				  "type" 		=> "textfield",
				  "holder" 		=> "div",
				  "class" 		=> "",
				  "heading" 	=> __('Custom class','rhccb'),
				  "param_name" 	=> "class",
				  "value" 		=> __('Custom class','rhccb'),
				  "description" => __( "A custom class for the container of this button.", "rhccb" ),
				  'group'		=> __('Basic','rhccb')
				),	
				array(
				  "type" 		=> "textfield",
				  "holder" 		=> "div",
				  "class" 		=> "",
				  "heading" 	=> __('Link url','rhccb'),
				  "param_name" 	=> "href",
				  "value" 		=> __('Button href','rhccb'),
				  "description" => __( "The url that this button links to.", "rhccb" ),
				  'group'		=> __('Basic','rhccb')
				),	
				array(
				  "type" 		=> "dropdown",
				  "holder" 		=> "div",
				  "class" 		=> "",
				  "heading" 	=> __('Link target','rhccb'),
				  "param_name" 	=> "target",
				  "value" 		=> array(
				  	__('Same tab (_self)','rhccb') => '_self',
				  	__('New tab (_blank)','rhccb') => '_blank'
				  ),
				  "description" => __( "Where should the url open.", "rhccb" ),
				  'group'		=> __('Basic','rhccb')
				),	
				array(
				  "type" 		=> "dropdown",
				  "holder" 		=> "div",
				  "class" 		=> "",
				  "heading" 	=> __('Label from postmeta field','rhccb'),
				  "param_name" 	=> "postmeta_label",
				  "value" 		=> $meta_fields,
				  "description" => __( "Overwrites the label with the value from the specified post meta field.", "rhccb" ),
				  'group'		=> __('Advanced','rhccb')
				),	
				array(
				  "type" 		=> "dropdown",
				  "holder" 		=> "div",
				  "class" 		=> "",
				  "heading" 	=> __('Link url from postmeta field','rhccb'),
				  "param_name" 	=> "postmeta_href",
				  "value" 		=> $meta_fields,
				  "description" => __( "Overwrites the url with the value from the specified post meta field.", "rhccb" ),
				  'group'		=> __('Advanced','rhccb')
				)		
			)
		)); // calendarizeit
		

	}
	
	function get_ce_custom_meta_fields(){
		global $rhc_plugin;
		$meta_fields = array();
		$max_custom_fields = intval( $rhc_plugin->get_option('max_custom_fields',3,true) );
		$max_custom_fields = $max_custom_fields<=0?3:$max_custom_fields;
		for($a=0;$a<$max_custom_fields;$a++){
			$option_meta_key = 'custom_field_'.$a;
			$tmp = (object)array(
				'label'		=> '',
				'meta_key'	=> $rhc_plugin->get_option($option_meta_key,'',true)
			);
			
			if(!empty($tmp->meta_key)){
				$this->metabox_meta_fields[] = $tmp->meta_key;
				
				$option_label = 'custom_label_'.$a;
				$tmp->label = $rhc_plugin->get_option($option_label,'',true);
				/*
				$option = 'custom_placeholder_'.$a;
				$tmp->placeholder = $rhc_plugin->get_option($option,'',true);
				*/
				$meta_fields[]=$tmp;
			}
		}
		return $meta_fields;
	}
		
	function get_meta_fields( ){
		//based on code from class.rhc_info_metabox.php from main plugin.
		global $wpdb;
		$options = array();
		include RHC_PATH.'includes/meta_fields_default_labels.php';
		
		$always_keys = array_keys($default_meta_field_labels);

		if( false === ( $meta_keys = get_transient( 'rhc_cb_meta_keys' ) ) ){
			$meta_keys = $wpdb->get_col("SELECT DISTINCT(meta_key) FROM `{$wpdb->postmeta}` WHERE meta_key NOT LIKE '\_%'",0);
			$meta_keys = is_array( $meta_keys ) ? $meta_keys : array() ;
		
			set_transient( 'rhc_cb_meta_keys', $meta_keys, 12 * HOUR_IN_SECONDS );
		}		
		
		$meta_keys = is_array( $meta_keys ) ? $meta_keys : array() ;
		
		$b = array_merge( $always_keys, $meta_keys );
		$b = array_unique( $b );

		$meta_keys = $b;

		if(is_array($meta_keys) && count($meta_keys)>0){
			$meta_keys[]='rhc_excerpt';
			$meta_keys[]='rhc_post_title';
			
			foreach($meta_keys as $field){
				if(in_array($field, apply_filters('postinfo_postmeta_exclude',array('extra_info_columns','extra_info_separators','extra_info_data'))))continue;
				
				$label = isset($default_meta_field_labels[$field])?$default_meta_field_labels[$field]:$field;
	
				if(in_array($field,$default_skip_meta_fields))continue;
				$options[$field]=$label;

			}
		}
		
		if(count($options) <= 1){// it always has at least 1 since we added rhc_excerpt.
			require_once RHC_PATH.'includes/meta_fields_default_labels.php';
			foreach(array('fc_start','fc_start_time','fc_end','fc_end_time','fc_start_datetime','fc_end_datetime','rhc_excerpt','rhc_post_title') as $field){
				$label = isset($default_meta_field_labels[$field])?$default_meta_field_labels[$field]:$field;
				$options[$field]=$label;
			}
		}
		
		if( defined('RHCCE_PATH') ){
			//apply CE custom labels
			$ce_custom_meta_fields = $this->get_ce_custom_meta_fields();
			foreach( $options as $value => $label ){
				foreach( $ce_custom_meta_fields as $ce ){
					if( $value == $ce->meta_key ){
						$options[$value] = $ce->label;
					}
				}
			}
		}
		
		
		$options = apply_filters('postinfo_postmeta_include', $options);
		
		//-- invert for vc
		$vc_options = array();
		if( is_array( $options ) && count( $options ) > 0 ){
			foreach( $options as $value => $label ){
				$vc_options[$label]=$value;
			}
		}
		
		return $vc_options;
	}	
}