<?php

/**
Plugin Name: Custom Buttons for Calendarize it!
Plugin URI: http://calendarize.it
Description: Provides custom buttons for the post info boxes of Calendarize it!
Version: 1.0.8.81105
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/

if(defined('RHCCB_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCCB_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCCB_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCCB_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCCB_URL", plugin_dir_url(__FILE__) );
} 
 
class plugin_rhc_custom_buttons {
	function __construct(){		
		add_filter('rhc_post_info_quick_icons',array(&$this,'rhc_post_info_quick_icons'),10,1);
		add_filter('rhc_post_info_field_render',array(&$this,'rhc_post_info_field_render'),10,3);
		
		add_filter('rhc_post_info_value', array(&$this,'rhc_post_info_value'), 10, 3);
		
		add_shortcode('rhc_button',			array(&$this,'rhc_button'));	
		
		global $rhc_plugin;
		$plugins_loaded_hook = '1'==$rhc_plugin->get_option('ignore_wordpress_standard',false,true)?'plugins_loaded':'after_setup_theme';		
		add_action($plugins_loaded_hook,array(&$this,'plugins_loaded'));
	}	
	
	function plugins_loaded(){
		global $rhc_plugin;
		if( defined('WPB_VC_VERSION') && '1'==$rhc_plugin->get_option('enable_rhc_vc','1',true) ){
			require_once RHCCB_PATH.'class.rhc_cb_visual_composer.php';
			new rhc_cb_visual_composer( array( 'url' => RHCCB_URL ) );		
		}
	}
	
	function rhc_button( $atts, $content=null, $code="" ){
		extract(shortcode_atts(array(
			'label' 				=> __('Button label','rhccb'),
			'href'			 		=> '',
			'postmeta_href'			=> '', //--overwrites href with the value of postmeta field defined here. only valid isnide a loop where $post is defined.
			'postmeta_label'		=> '',
			'class'					=> '',
			'target'				=> '',
			'nofollow'				=> '',
			'anchorclass'			=> '',
			'is_author'				=> ''
		), $atts));
		
		$out = $this->get_template('', (object)array(
			'frontend' => true,
			'nofollow'	=> $nofollow
		),$target);
		
		global $post;
		
		if( '1' == $is_author ){
			if( property_exists( $post, 'ID' ) && is_user_logged_in() ){
				global $userdata;
				if( $userdata->ID == $post->post_author ){
				
				}else{
					return '';
				}
			}else{
				return '';
			}
		}
		
		if( !empty( $postmeta_href ) ){

			if( property_exists( $post, 'ID' ) ){
				$href = get_post_meta( $post->ID, $postmeta_href, true );
				if( empty( $href ) ){
					//if the postmeta is not defined do not render button.
					return '';
				}
			}
		}		
		
		if( !empty( $postmeta_label ) ){

			if( property_exists( $post, 'ID' ) ){
				$tmp = get_post_meta( $post->ID, $postmeta_label, true );
				if( !empty( $tmp ) ){
					$label = $tmp;
				}
			}
		}
		
		if( empty( $href ) ){
			$anchorclass = empty( $anchorclass ) ? 'rhc-event-link' : ' rhc-event-link' ;
			$href = get_permalink();
			if( is_singular() && isset($_REQUEST['event_rdate']) ){
				$arr = explode(',', $_REQUEST['event_rdate'] );
				if( count($arr)==2 && is_numeric($arr[0]) && is_numeric($arr[1]) ){
					$href = shortcode_calendarize::addURLParameter($href, 'event_rdate', $_REQUEST['event_rdate']);
				}
			}
		}
		
		$out = str_replace( '{label}', $label, $out);
		$out = str_replace( '{value}', $href, $out);
		$out = str_replace( '{class}', $class, $out);
		$out = str_replace( '{emptylabel}', ( empty($label) ? '1' : '0' ), $out);
		$out = str_replace( '{emptyvalue}', ( empty($href) ? '1' : '0' ), $out);
		$out = str_replace( 'rhc-anchorclass', $anchorclass, $out);
		//--
		if( property_exists( $post, 'ID' ) ){
			$out = str_replace( '{eventid}', $post->ID, $out);
		}		
		return $out;
	}
	
	function rhc_post_info_value($value, $o, $for_filter){
		if(strtolower($value)=='[permalink]'){
			$value = get_permalink( $o->post_ID );	
			
			if( isset($_REQUEST['event_rdate']) ){
				if( isset($_REQUEST['rhc_action']) && 'rhc_tooltip_detail' == $_REQUEST['rhc_action'] ){
					$arr = explode(',', $_REQUEST['event_rdate'] );
					if( count($arr)==2 && is_numeric($arr[0]) && is_numeric($arr[1]) ){
						$value = shortcode_calendarize::addURLParameter($value, 'event_rdate', $_REQUEST['event_rdate']);
					}				
				}

			}
							
			$o->value = $value;
		}
		return $value;
	}
	
	function rhc_post_info_quick_icons($arr){
		foreach($arr as $o){
			if($o->id=='label_icons'){
				$o->items[]=new quick_icon_item(array(
					'label'							=> __('Button','rhp'),
					'post_extrainfo_type'			=> 'custom',
					'post_extrainfo_custom'			=> 'button',
					'post_extrainfo_label'			=> __('Add your label','rhccb'),
					'post_extrainfo_value'			=> __('Add your link','rhccb')			
				));
				$o->items[]=new quick_icon_item(array(
					'label'							=> __('Button(_blank)','rhp'),
					'post_extrainfo_type'			=> 'custom',
					'post_extrainfo_custom'			=> 'button_blank',
					'post_extrainfo_label'			=> __('Add your label','rhccb'),
					'post_extrainfo_value'			=> __('Add your link','rhccb')			
				));
				$o->items[]=new quick_icon_item(array(
					'label'							=> __('More info','rhp'),
					'post_extrainfo_type'			=> 'custom',
					'post_extrainfo_custom'			=> 'button',
					'post_extrainfo_label'			=> __('More info','rhccb'),
					'post_extrainfo_value'			=> __('[permalink]','rhccb')			
				));				
			}else if($o->id=='event_info_icons'){
				/*
				$o->items[]=new quick_icon_item(array(
					'label'							=> __('Button','rhp'),
					'post_extrainfo_type'			=> 'postmeta',
					'post_extrainfo_custom'			=> 'button',
					'post_extrainfo_label'			=> __('Add your label','rhccb'),
					'post_extrainfo_postmeta'		=> 'url'//if this is empty it doesnt shows in teh admin.			
				));
				$o->items[]=new quick_icon_item(array(
					'label'							=> __('Button(_blank)','rhp'),
					'post_extrainfo_type'			=> 'postmeta',
					'post_extrainfo_custom'			=> 'button_blank',
					'post_extrainfo_label'			=> __('Add your label','rhccb'),
					'post_extrainfo_postmeta'		=> 'url'//if this is empty it doesnt shows in teh admin.			
				));
				*/
			}
		}
		return $arr;
	}
	
	function my_class( $str, $cf ){
		if( property_exists( $cf, 'class' ) ){
			$str = $cf->class . ' ' . $str ;
		}
		return $str;
	}
	
	function rhc_post_info_field_render($output,$cf,$template){		
		if($cf->custom=='button'){
			//$output.='xxx';
			$template = $this->get_template($template,$cf);
			
			$output = $cf->inject_values_to_template( array(
				'label'	=> $cf->label,
				'class'	=> $this->my_class( 'fe-cell-custom', $cf ),
				'value'	=> $cf->value
			), $template );
			
		}else if($cf->custom=='button_blank'){
			//$output.='xxx';
			$template = $this->get_template($template,$cf,'_blank');
			
			$output = $cf->inject_values_to_template( array(
				'label'	=> $cf->label,
				'class'	=> $this->my_class( 'fe-cell-custom', $cf ),
				'value'	=> $cf->value
			), $template );
			
		}
		
		return $output;
	}
	
	function get_template($template,$cf,$target='_self'){
		if($cf->frontend){
			if( property_exists($cf,'nofollow') && '1'==$cf->nofollow){
				$nofollow='rel="nofollow"';
			}else{
				$nofollow='';
			}
			$class = property_exists( $cf, 'class' ) ? $cf->class : '';
			ob_start();
?>
<div class="<?php echo $class?> rhc-info-cell {class} fe-is-empty-{emptyvalue} fe-is-empty-label-{emptylabel}">
	<div class="rhcalendar">
		<a <?php echo $nofollow?> target="<?php echo $target?>" href="{value}" class="fc-button fc-button-custom fc-state-default  fc-corner-left fc-corner-right rhc-anchorclass">
			<span class="fc-button-inner">
				<span class="fc-button-content">{label}</span>
				<span class="fc-button-effect"><span></span></span>
			</span>
		</a>
	</div>
</div>
<?php	
			$content = ob_get_contents();
			ob_end_clean();
			return $content;
		}
		
		ob_start();
?>
<div class="widget rhc-extra-info-cell rhcalendar {class}" rel="{index}">	
	<div class="widget-top">
		<div class="widget-title-action">
			<a href="javascript:void(0);" class="ui-icon extra-info-toggle ui-icon-triangle-1-s"></a>
			<a href="javascript:void(0);" class="ui-icon ui-icon-closethick"></a>
		</div>
		
		<div class="widget-title ">
			
			<div class="rhcalendar">
				<a href="javascript:void(0);" class="fc-button fc-button-custom fc-state-default  fc-corner-left fc-corner-right">
					<span class="fc-button-inner">
						<span class="fc-button-content">{label}</span>
						<span class="fc-button-effect"><span></span></span>
					</span>
				</a>
			</div>			
			
		</div>
	</div>
	<div class="widget-inside">
		<div class="widget-content"></div>
		<div class="widget-control-actions">
			<input type="button" class="pinfo-save button-primary" value="<?php _e('Save','rhc')?>" />
		</div>
	</div>
</div>
<?php	
		$out = ob_get_contents();
		ob_end_clean();
		
		if($cf->id!=''){
			$out = str_replace("{id}",sprintf('id="%s"',$cf->id),$out);
		}		
		return $out;
	}
}

new plugin_rhc_custom_buttons();
?>