<?php

class rhc_countdown_shortcode extends rh_conditional_shortcode {
	function __construct( $args=array() ){		
		/* the base class calls add_shortcode */
		parent::__construct( array(
			'rhc_countdown',
			'rh_countdown'
		) );
		
		add_shortcode( 'rhc_countdown_template', array( &$this, 'rhc_countdown_template' ) );
		
		add_action('wp_enqueue_scripts', array(&$this,'enqueue_scripts'));	
		add_action('wp_enqueue_scripts', array(&$this,'enqueue_styles'));		
	}
	
	function enqueue_styles(){
		wp_enqueue_style( 'rhc-countdown', RHCCD_URL.'css/countdown.css', array(),'1.0.0.9');
	}
	
	function enqueue_scripts(){	
		wp_enqueue_script( 'rhc-countdown', RHCCD_URL.'js/countdown.js', array('jquery'),'1.0.0.9');
	}
		
	function rhc_countdown_template( $atts, $template='', $code="" ){
		$atts['class'] = 'rhc-countdown';
		$atts['meta_key'] = 'enable_rhc_countdown';
		$atts['meta_value'] = '1';
		$atts['default'] = '0';

		extract(shortcode_atts(array(
			'class'				=> 'rhc-countdown',
			'conditional_tag' 	=> 'is_singular',
			'capability'	 			=> '',
			'meta_key'					=> 'enable_rhc_countdown',
			'meta_value'				=> '1',
			'default'					=> '0',//value to give meta_value if it is empty.
			'operator'					=> '=',//TODO: allow other operators.
			'filter' 					=> ''//TODO: allow applying a filter to the value
		), $atts));
		
		$atts['meta_value_default'] = $default; //bug fix, boxes dissappearing on ce submitted events.
	
		if( !$this->sc_output_conditions_met ( $atts, $template, $code) ){
			return '';
		}
		
		return $this->handle_rhc_countdown( $atts, $template, $code );
	}	
		
	function handle_rhc_countdown( $atts, $template='', $code="" ){
		extract(shortcode_atts(array(
			'date'			=> '',
			'upcoming'		=> '0'
		), $atts));


		if( empty($date) ){

			global $rhc_plugin, $post;
			if( property_exists( $post, 'ID' ) ){
				if( $rhc_plugin->template_frontend->is_event || $post->post_type != RHC_EVENTS ){ //second test is to allow properly loading counter on post types other than events.
				
					$date_start = fc_get_repeat_start_date($post->ID,'yyyy-MM-dd HH:mm:00');
					if( !empty( $date_start ) ){
						$date_end = fc_get_repeat_end_date($post->ID,'yyyy-MM-dd HH:mm:00');
						if( !empty( $date_end ) ){
							$timeFirst  = strtotime( $date_start );
							$timeSecond = strtotime( $date_end );
							$atts['message_end_delay'] = intval( $timeSecond - $timeFirst );											
						}
					}
				
					$count_to = get_post_meta( $post->ID, 'rhc_countdown_to', true );
					
					if( 'end' == $count_to ){
						$date = fc_get_repeat_end_date($post->ID,'yyyy-MM-dd HH:mm');
						$atts['message_end_delay']=0;//inmediately show the end message.
						if( isset( $atts['message_end'] ) && !empty( $atts['message_end'] ) ){
					//		$atts['message'] = $atts['message_end'];
						}
						
						$atts['count_to'] = 'end';
					}else{
						$date = fc_get_repeat_start_date($post->ID,'yyyy-MM-dd HH:mm');
						$atts['count_to'] = 'start';
					}
				
					if( isset( $_REQUEST['rhc_debug'] ) && current_user_can('manage_options') ){
						return "COUNTDOWN: post->ID:".$post->ID."Date:".$date."<br>";	
					}else{
						$atts['date'] = $date;
					}
				}			
			}else{
				global $post;
				if( property_exists( $post, 'ID' ) ){
				
				}
			}
		}

			
		return $this->handle_rh_countdown( $atts, $template, $code );
	}
		
	function handle_rh_countdown($atts,$template='',$code=""){
		extract(shortcode_atts(array(
			'href'			=> '',
			'width'			=> '98',
			'height'		=> '',
			'bgcolor'		=> '#cecece',
			'fgcolor'		=> '#66CC66',
			'date'			=> '',
			'thickness'		=> '.3',
			'adjust_w'		=> '3',
			'adjust_h'		=> '3',
			'css_edit'		=> '1',
			'show_labels'	=> apply_filters('rhc_countdown_label_show', '1' ),
			'label_day'		=> apply_filters('rhc_countdown_label', __('Days','rhc-cd'), 'day' ),
			'label_hour'	=> apply_filters('rhc_countdown_label', __('Hours','rhc-cd'), 'hour' ),
			'label_minute'	=> apply_filters('rhc_countdown_label', __('Minutes','rhc-cd'), 'minute' ),
			'label_second'	=> apply_filters('rhc_countdown_label', __('Seconds','rhc-cd'), 'second' ),
			'max_days'		=> '1099',
			'title'			=> '',
			'title_end'		=> '',
			'message'		=> '',
			'message_end'		=> '',
			'message_end_delay' => '',
			'count_to'		=> 'start'
		), $atts));

		$width = $width > 0 ? ( $width .= '%' ) : '' ;
		$height = $height > 0 ? ( $height .= '%' ) : '' ;
		
		
		$time = strtotime( $date );		
		
		//TODO: bug with template version B, prevents enqueing here.
		//wp_enqueue_script( 'rhc-countdown' );
		
		$output = sprintf('<div class="rhc-countdown-holder rhc-css-edit-%s %s %s">',
			intval($css_edit),
			( empty( $message ) ? 'no-end-message' : 'has-end-message' ),
			( empty( $count_to ) ? '' : sprintf('rhc-count-to-%s',$count_to) )
		);
		
		$output .= '<div class="rhc-countdown-cont">';

		if( !empty( $title ) ){
			$output .= sprintf('<div class="rhc-countdown-title">%s</div>',$title);
		}

		if( !empty( $title_end ) ){
			$output .= sprintf('<div class="rhc-countdown-title-end">%s</div>',$title_end);
		}

		if( !empty( $message ) ){
			$output .= sprintf('<div class="rhccd-end-message">%s</div>', $message );
		}
		
		if( !empty( $message_end ) ){
			$output .= sprintf('<div class="rhccd-end-message-end">%s</div>', $message_end );
		}

		$dial_year 	= date('Y', $time);
		$dial_month = date('m', $time);
		$dial_d 	= date('d', $time);
		$dial_H_i 	= date('H:i', $time);
		//$output .= '<div style="display:none;" class="rhc-countdown-fgcolor"></div>';
				
		$width_str = empty($width) ? '' : sprintf('data-width="%s"', $width);
		$height_str = empty($height) ? '' : sprintf('data-height="%s"', $height);
		$thickness_str = empty($thickness) ? '' : sprintf('data-thickness="%s"', $thickness);
		
		$days_to_event = floor(abs($time - time())/3600/24) ;

		foreach( array( 
			'rhc-days'	=> abs(intval($max_days)), 
			'rhc-hour' 	=> '24',
			'rhc-minute'=> '60',
			'rhc-second'=> '60'
		) as $item_class => $value ){
			if( 'rhc-days'==$item_class ){
				$label = $label_day;
			}else if( 'rhc-hour'==$item_class ){
				$label = $label_hour;
			}else if( 'rhc-minute'==$item_class ){
				$label = $label_minute;
			}else {
				$label = $label_second;
			}
			
			$output .= sprintf('<div class="rhc-countdown" data-message_end_delay="%s" data-year="%s" data-month="%s" data-day="%s" data-time="%s" data-adjust_w="%s" data-adjust_h="%s" data-css_edit="%s">',
				intval( $message_end_delay ),
				$dial_year,
				$dial_month,
				$dial_d,
				$dial_H_i,
				$adjust_w,
				$adjust_h,
				('1'==$css_edit?1:0)
			);
			
			if( 'rhc-days'==$item_class ){
				//$value = $days_to_event;  // this makes the day circle always complete.
				//$value = '99';//just force it to be all same size.//doesnt work as expected. maxes the day number to 99.
			}
			
			$output.=sprintf('<input class="rhc-countdown-item %s" %s %s %s data-min="0" data-max="%s" data-displayPrevious=true data-bgColor="%s" data-fgColor="%s" data-readOnly="true" value="1">',
				$item_class,
				$width_str,
				$height_str,
				$thickness_str,
				$value,
				$bgcolor,
				$fgcolor
			);
			
			if('1'==$show_labels){
				$output.="<div class=\"rhc-countdown-item-label\">".$label."</div>";
			}
			
			$output.="</div>";		
		}
		$output .= '</div>';
		//--- this are to provide a way for the css editor to read and write styles
		$output .= '<div style="display:none;" class="for-css-editor rhc-countdown-tpl"></div>';
		$output .= '</div>';
		return $output;
	}
		
}