<?php

class plugin_rhc_countdown {
	var $id = 'rhc';
	function __construct(){
		add_action( 'plugins_loaded', array(&$this,'plugins_loaded'), 9 );

		//add option to Layout Options to automatically add the shortcode to events
		add_filter( 'rhc_calendar_metabox_save_fields', array( &$this, 'rhc_calendar_metabox_save_fields' ), 10, 1 );
		add_filter( 'rhc_calendar_metabox_options', array( &$this, 'rhc_calendar_metabox_options' ), 99, 1 );
		
		
		global $rhc_plugin;
		if( '1' == $rhc_plugin->get_option('rhccd_auto_template', RHCCD_AUTO_TEMPLATE_DEFAULT, true ) ){
			add_filter( 'rhc_single_template_content_before', array( &$this, 'rhc_single_template_content_before' ), 10, 1 );
		}
	}

	function plugins_loaded(){
		if( !class_exists('rh_conditional_shortcode') ){
			/* this will be included with rhc */
			require RHCCD_PATH.'includes/class.rh_conditional_shortcode.php';
		}
		
		require RHCCD_PATH.'includes/class.rhc_countdown_shortcode.php';
		new rhc_countdown_shortcode();	
	
		if( is_admin() ){
			add_filter("pop-options_{$this->id}",array(&$this,'options'),9999,1);				
		}
			
	}
	
	function rhc_calendar_metabox_save_fields( $arr ){
		if( is_array( $arr ) && count( $arr ) > 0 ){
			$arr[] = 'enable_rhc_countdown';
			$arr[] = 'rhc_countdown_to';
		}
		return $arr;
	}
	
	function rhc_calendar_metabox_options( $metaboxes ){
		if( is_array( $metaboxes ) && count( $metaboxes ) > 0 ){
			global $rhc_plugin;
			
			foreach( $metaboxes as $metabox ){
				if( 'rhc-layout-options' == $metabox->id ){
					$metabox->options[] = (object)array(
						'type'			=> 'clear'
					);	
					/*
					$metabox->options[] = (object)array(
						'id'			=> 'rhccd_title',
						'type'			=> 'subtitle',
						'label'			=>  __('Event countdown','rhc-cd')
					);	
					*/				
					$metabox->options[] = (object)array(
						'id'			=> 'enable_rhc_countdown',
						'type'			=> 'onoff',
						'default'		=> $rhc_plugin->get_option('enable_rhc_countdown', $rhc_plugin->get_option( 'bop_enable_rhc_countdown', '0', true ) ,true),
						'label'			=>  __('Event Countdown Box','rhc-cd'),
						'save_option'	=> true,
						'load_option'	=> true
					);
					
					$metabox->options[] = (object)array(
						'id'			=> 'rhc_countdown_to',
						'type'			=> 'select',
						'default'		=> 'start',
						'options'		=> array(
							'start'	=> __('Start of event', 'rhc-cd'),
							'end'	=> __('End of event', 'rhc-cd')
						),
						'label'			=>  __('Count to','rhc-cd'),
						'save_option'	=> true,
						'load_option'	=> true
					);	
					
					$metabox->options[] = (object)array(
						'type'			=> 'clear'
					);										
				}
			}
		
		}
		return $metaboxes;
	}
		
	function options( $t ){	
		$prefix = 'rhccd_';
		$main_option = true;
		include RHCCD_PATH.'includes/options.php';
		return $t;
	}	
	
	function rhc_single_template_content_before( $content ){
		$content.= $this->generate_rhc_countdown_shortcode_from_options();
		return $content;
	}
	
	function generate_rhc_countdown_shortcode_from_options(){
		global $rhc_plugin;
		
		$fields = array(
			'title',
			'title_end',
			'message',
			'message_end',
			'css_edit',
			'max_days',
			'width',
			'height',
			'bgcolor',
			'fgcolor',
			'thickness',
			'adjust_w',
			'adjust_h'
		);
		
		$arr = array();
		foreach( $fields as $field ){
			$option_name = 'rhccd_'.$field;
			$value = $rhc_plugin->get_option( $option_name, '', true );
			if( !empty( $value ) ){
				$arr[] = sprintf("%s='%s'", $field, $value );
			}
		}
		$out = sprintf("[rhc_countdown %s meta_key='enable_rhc_countdown' meta_value='1' default='0' class='rhc-countdown']",
			implode(' ', $arr )
		);
	
		return $out;
	}
}