<?php

/**
Plugin Name: Calendarize It! Backend Options
Plugin URI: http://plugins.righthere.com/calendarize-it/
Description: Provides options to configure the backend calendar so that it resembles the frontend settings.  Requires at least Calendarize It! Version 2.9.2 rev50779
Version: 1.0.6.75448
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/

if(defined('RHCBOP_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCBOP_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCBOP_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCBOP_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCBOP_URL", plugin_dir_url(__FILE__) );
} 
 
class rhc_addon_backend_options {
	var $id = 'rhc';
	var $open = false;
	function __construct(){
		add_action('plugins_loaded', array(&$this,'plugins_loaded'));
		add_filter('rhc_bop_options', array(&$this,'rhc_bop_options'),10,1);
		
		add_filter( 'bop_meta_field', array( &$this, 'bop_meta_field' ), 10, 2);
	}

	function bop_meta_field( $value, $meta_field ){
		global $rhc_plugin;
		if( ''==trim($value) && in_array($meta_field, array('fc_color','fc_text_color','fc_click_link','fc_click_target') ) ){
			$option = 'bop_'.$meta_field;
			return $rhc_plugin->get_option( $option, $value, true );
		}
		return $value;
	}
	
	function plugins_loaded(){
		if( is_admin() ){
			add_filter("pop-options_{$this->id}",array(&$this,'options'),9999,1);				
		}
	}
	
	function rhc_bop_options( $options ){
		global $rhc_plugin;
		$options->defaultView 		= $rhc_plugin->get_option('bop_defaultview','month',true);
		$options->header->left 		= $rhc_plugin->get_option('bop_header_left','prevYear,prev,next,nextYear today ',true);
		$options->header->center 	= $rhc_plugin->get_option('bop_header_center','title',true);
		$options->header->right 	= $rhc_plugin->get_option('bop_header_right','month,agendaWeek,agendaDay',true);
		$options->header->right 	= $rhc_plugin->get_option('bop_header_right','month,agendaWeek,agendaDay',true);
		
		$hiddendays = $rhc_plugin->get_option('bop_hiddendays',array(),true);
		$hiddendays = is_array($hiddendays)?$hiddendays:array();
		$options->hiddenDays = $hiddendays;
		if($options->hiddenDays){
			foreach($options->hiddenDays as $i => $d){
				$options->hiddenDays[$i]=intval($d);
			}
		}
		
		$skipmonths = $rhc_plugin->get_option('bop_skipmonths',array(),true);
		if( is_array($skipmonths) && count( $skipmonths) > 0 ){
			$options->skipMonths = array();
			foreach( $skipmonths as $m ){
				$options->skipMonths[] = intval($m);
			}
		}
		//--
		$options->weekends = $rhc_plugin->get_option('bop_weekends','',true) ? true : false;
		$options->firstDay = intval($rhc_plugin->get_option('bop_firstday',0,true));
		$options->weekNumbers = ( $rhc_plugin->get_option('bop_week_numbers',false,true) ? true : false );
		$options->weekNumberTitle = $rhc_plugin->get_option('bop_week_numbers_title','',true);
		
		$options->monthNames = explode(',', $rhc_plugin->get_option('bop_monthnames', __('January,February,March,April,May,June,July,August,September,October,November,December','rhc'),true));
		$options->monthNamesShort = explode(',',$rhc_plugin->get_option('bop_monthnamesshort', __('Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec','rhc'),true));
		$options->dayNames = explode(',',$rhc_plugin->get_option('bop_daynames', __('Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday','rhc'),true));
		$options->dayNamesShort = explode(',',$rhc_plugin->get_option('bop_daynamesshort', __('Sun,Mon,Tue,Wed,Thu,Fri,Sat','rhc'), true));
		
		$options->weekMode = $rhc_plugin->get_option('bop_week_mode','fixed',true);

		return $options;
	}
		
	function options( $t ){
		include RHCBOP_PATH.'options.php';
		return $t;
	}
}

new rhc_addon_backend_options();
?>