<?php

/**
Plugin Name: Author Filtering for Calendarize it!
Plugin URI: https://calendarize.it/add-ons/author-filtering/
Description: Add Author Filtering to Calendar when using personal calendars for your users.
Version: 1.0.4.83897
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/

if(defined('RHCADD_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCADD_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCADD_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCADD_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCADD_URL", plugin_dir_url(__FILE__) );
} 

class plugin_rhc_author_filter {
	var $in_footer = false;	
	function __construct(){
		add_action('plugins_loaded', array( &$this, 'plugins_loaded' ), 99 );
	}
	
	function plugins_loaded(){
		global $rhc_plugin;
		if('1'==$rhc_plugin->get_option('in_footer',false,true)){
			$this->in_footer = true;
		}	
			
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'),10,2);
		add_filter('get_calendarize_args_output', array(&$this,'get_calendarize_args_output'), 10, 1);
	
		add_action('rhc_scripts_frontend',array(&$this,'wp_enqueue_scripts'));
		add_action('rhc_scripts_admin',array(&$this,'wp_enqueue_scripts'));			

		add_filter('rhc_feature_access_capabilities', array( &$this, 'rhc_feature_access_capabilities' ), 10, 1 );
	}
	
	function rhc_feature_access_capabilities( $capabilities ){
		
		$capabilities['rhc_author_filter'] = __('View Author Filtering (addon)', 'rhcadd' );
		
		return $capabilities;
	}
	
	function get_calendarize_args_options( $options, $atts ){

		if( ! $this->is_author_filtered( $options ) ){

			return $options;
		}
		
		//if( current_user_can('rhc_author_filter' ) || current_user_can('manage_options' ) ){
		if( current_user_can('rhc_author_filter' ) ){
			$settings = $this->get_options(null,$atts);
			$this->set_authors( $settings );
			
			foreach($options->modes as $type => $mode){
				$options->modes[$type]['options']->rhcadd = $settings;
				//--
				$options->modes[$type]['options']->btn_author_filter = 'btn_author_filter';
				$options->modes[$type]['options']->buttonText->btn_author_filter = $settings->label;
			}
	
			wp_enqueue_script('rhcadd');
			wp_enqueue_style('rhcadd');

		}else{
			foreach($options->modes as $type => $mode){
				//avoid a js error, if user is not authorized to see author dropdown.
				$options->modes[$type]['options']->header->right = str_replace( 'btn_author_filter', '', $options->modes[$type]['options']->header->right );
				$options->modes[$type]['options']->header->left = str_replace( 'btn_author_filter', '', $options->modes[$type]['options']->header->left );
				$options->modes[$type]['options']->header->center = str_replace( 'btn_author_filter', '', $options->modes[$type]['options']->header->center );			
			}		
		}

		return $options;
	}
	
	function set_authors( &$settings ){
		$args = array(
			'number' => 1000, // hard limit of 1000
			'orderby' => 'display_name'
		);
		if( !empty( $settings->author_role ) ){
			$args['role__in'] = explode(',', str_replace(' ','', $settings->author_role ) );
		}
		$users = get_users( $args );
		
		$settings->authors = array();
		foreach( $users as $u ){
			$settings->authors[] = (object)array(
				//'value' 		=> md5( wp_salt() . $u->ID . $u->user_login ),
				'value' 		=> $u->ID,
				'label'			=> $u->display_name
			);
		}
		
		return true;
	}
	
	function is_author_filtered( $options ){
		$is_author_filtered=false;
		foreach($options->modes as $type => $mode){
			if( false !== strpos( $options->modes[$type]['options']->header->right, 'btn_author_filter'  ) ){		
				$is_author_filtered = true;
			}
			if( false !== strpos( $options->modes[$type]['options']->header->center, 'btn_author_filter'  ) ){		
				$is_author_filtered = true;
			}

			if( false !== strpos( $options->modes[$type]['options']->header->left, 'btn_author_filter'  ) ){		
				$is_author_filtered = true;
			}
		
		}	
		
		return $is_author_filtered;
	}
	
	function get_options($type,$atts){
		global $rhc_plugin;
		$r = (object)array();
		foreach(array(
			'label'					=> __('Author','rhcadd'),
			'umeta_key'				=> '',
			'umeta_value'			=> '',
			'author_role'			=> ''
		) as $field => $default){
			$option_name = "rhcadd_".$field;
			$value = isset($atts[$option_name]) ? $atts[$option_name] : $rhc_plugin->get_option($option_name,$default,true) ;
			$r->$field = $value;
		}

		return $r;
	}
	
		
	function get_calendarize_args_output($out){
		return str_replace('"btn_author_filter"','btn_author_filter',$out);
	}
	

	
	function wp_enqueue_scripts(){
		wp_register_style( 'rhcadd', RHCADD_URL.'css/rhcadd.css', array(),'1.0.1');
		wp_register_script( 'rhcadd', RHCADD_URL.'js/rhcadd.js', array('calendarize'),'1.0.1',$this->in_footer);

		global $rhc_plugin;
		if( is_admin() || '0' == $rhc_plugin->get_option('scripts_on_demand','0',true)){
			do_action('enqueue_frontend_only');		
		}			
	}	
}

new plugin_rhc_author_filter();