<?php

/**
Plugin Name: Calendarize It! Remove Vertical Scrollbar
Plugin URI: http://plugins.righthere.com/calendarize-it/
Description: Removes the vertical scroll bar in the agenda view
Version: 1.0.0 
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/

if(defined('RHCNVB_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCNVB_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCNVB_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCNVB_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCNVB_URL", plugin_dir_url(__FILE__) );
} 
 
class plugin_rhc_no_vscroll {
	function plugin_rhc_no_vscroll(){		
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'),10,1);
		add_filter('get_calendarize_args_output',array(&$this,'get_calendarize_args_output'),10,1);
		if(is_admin()){
			add_action('admin_head',array(&$this,'head'));
		}else{
			add_action('wp_head',array(&$this,'head'));
		}	
	}	
	
	function get_calendarize_args_options($options){
		foreach($options->modes as $i => $m){
			$options->modes[$i]['options']->viewDisplay = 'fc_no_vertical_scroll_bar';
		}

		return $options;
	}
	function get_calendarize_args_output($out){
		$method_name='fc_no_vertical_scroll_bar';
		$out = str_replace('"'.$method_name.'"',$method_name,$out);
		return $out;
	}
	function head(){
?>
<style>
.rhcalendar.not-widget.rhc_holder div.fc-view.fc-agenda > div > div:last-child {
height:auto !important;
}
</style>
<script type="text/javascript">
function fc_no_vertical_scroll_bar(view){
	var h;
	if (view.name == "month") {
	    h = NaN;
	}
	else {
	    h = 99999;
	}
	jQuery(this).fullCalendar('option', 'contentHeight', h);
}
</script>
<?php	
	}
}

new plugin_rhc_no_vscroll();
?>