<?php

class rhc_post_type_advent {
	function __construct( $args=array() ){
		$defaults = array(
			'options_capability'				=> 'manage_options',
			'advent_capability'					=> 'manage_options',
			'show_in_menu'						=> null,
			'menu_position'						=> null,
			'post_type'							=> 'advent',
			'slug'								=> 'advent',
			'taxonomies'						=> array(),
			'debug'								=> true
		);
		
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------		
		global $rhc_plugin;
		$init_hook = '1'==$rhc_plugin->get_option('ignore_wordpress_standard',false,true)?'setup_theme':'init';
		$this->add_action_init_hook( $init_hook, array(&$this,'init') );	
		
		add_filter( 'map_meta_cap', array( &$this, 'map_meta_cap' ), 10, 4 );	
		
		if( 'manage_advent' == $this->advent_capability ){
			add_filter('rhc_feature_access_capabilities', array( &$this, 'rhc_feature_access_capabilities' ) );		
		}
	}
	
	function rhc_feature_access_capabilities( $caps ){
		$caps['manage_advent'] = __('Manage Advent Items','rhcadvent');
		return $caps;
	}

	function map_meta_cap( $caps, $cap, $user_id, $args ) {
		if ( 'edit_'.$this->post_type == $cap || 'delete_'.$this->post_type == $cap || 'read_'.$this->post_type == $cap ) {
			$post = get_post( $args[0] );
			$post_type = get_post_type_object( $post->post_type );

			$caps = array();
		}

		/* If editing a movie, assign the required capability. */
		if ( 'edit_'.$this->post_type == $cap ) {
			if ( $user_id == $post->post_author )
				$caps[] = $post_type->cap->edit_posts;
			else
				$caps[] = $post_type->cap->edit_others_posts;
		}

		/* If deleting a movie, assign the required capability. */
		elseif ( 'delete_'.$this->post_type == $cap ) {
			if ( $user_id == $post->post_author )
				$caps[] = $post_type->cap->delete_posts;
			else
				$caps[] = $post_type->cap->delete_others_posts;
		}

		/* If reading a private movie, assign the required capability. */
		elseif ( 'read_'.$this->post_type == $cap ) {

			if ( 'private' != $post->post_status )
				$caps[] = 'read';
			elseif ( $user_id == $post->post_author )
				$caps[] = 'read';
			else
				$caps[] = $post_type->cap->read_private_posts;
		}

		/* Return the capabilities required by the user. */
		return $caps;
	}
	
	function add_action_init_hook( $init_hook, $cb, $priority=10 ){
		//vc loads on init priority 9 and thus when form fields data is obtained our taxonomies are not registered yet.
		if( defined('DOING_AJAX') && DOING_AJAX && isset( $_REQUEST['action'] ) && $_REQUEST['action']=='vc_edit_form' ){
			$priority = 8;
		}
		add_action($init_hook, $cb, $priority);
	}
	
	function init(){
		$slug = $this->slug;
		$taxonomies = $this->taxonomies;
		//NEW POST TYPE	
		register_post_type( $this->post_type, array(
			'label' => __('Advent Items','rhcadvent'),
			'labels' => array(
				'menu_name'			=> __('Advent Items','rhcadvent'),
				'all_items'			=> __('Advent Items','rhcadvent'),
				'name' 				=> __('Advent Item','rhcadvent'),
				'singular_name' 	=> __('Advent Item','rhcadvent'),
				'add_new' 			=> __('Add new advent item','rhcadvent'),
				'edit_item' 		=> __('Edit advent item','rhcadvent'),
				'new_item' 			=> __('New advent item','rhcadvent'),
				'view_item'			=> __('View advent item','rhcadvent'),
				'search_items'		=> __('Search advent items','rhcadvent'),
				'not_found'			=> __('No advent items found','rhcadvent'),
				'not_found_in_trash'=> __('No advent items found in trash','rhcadvent'),
				'add_new_item'		=> __('Add new advent item','rhcadvent')
			),
			'public' => true,
			'show_ui' => true,
			
			'map_meta_cap'	=> false,

			'capabilities'	=> array(
            	'edit_post' 			=> $this->advent_capability,
				'read_post'				=> $this->advent_capability,
            	'delete_post'			=> $this->advent_capability,
            	'edit_posts'			=> $this->advent_capability,
            	'edit_others_posts'		=> $this->advent_capability,
            	'publish_posts'			=> $this->advent_capability,
            	'read_private_posts'	=> $this->advent_capability,
            	'read'					=> $this->advent_capability,
            	'delete_posts'			=> $this->advent_capability,
            	'delete_private_posts'	=> $this->advent_capability,
            	'delete_published_posts'=> $this->advent_capability,
            	'delete_others_posts'	=> $this->advent_capability,
            	'edit_private_posts'	=> $this->advent_capability,
            	'edit_published_posts'	=> $this->advent_capability	
			),
			'rewrite' => array(
				'slug'			=> $slug,
				'with_front'	=> false
			),
			'hierarchical' 		=> false,
			'has_archive'		=> false,
			'query_var' 		=> false,
			'supports' => array('title','editor','excerpt','revisions','page-attributes','comments','author','thumbnail'/*,'custom-fields'*/),
			'exclude_from_search' => true,
			'menu_position' => $this->menu_position,
			'show_in_menu' => (null==$this->show_in_menu ? 'edit.php?post_type='.RHC_EVENTS : $this->show_in_menu),
			'show_in_nav_menus' => true,
			'taxonomies' => $taxonomies
		));
	}
}

?>