<?php

class rhc_auw_call_to_action_metabox {
	var $uid=0;
	var $post_type;
	var $debug=false;
	function __construct( $post_type=RHC_EVENTS,$debug=false ){
		$this->debug = $debug;
		if(!class_exists('post_meta_boxes'))
			require_once( RHC_PATH.'includes/class.post_meta_boxes.php');		
		$this->post_type = $post_type;

		$this->post_meta_boxes = new post_meta_boxes(array(
			'post_type'=>$post_type,
			'options'=>$this->metaboxes(),
			'styles'=>array('rhc-admin'),
			'scripts'=>array('rhc-admin'),
			'metabox_meta_fields' =>  'auw_meta_fields',
			'pluginpath'=>RHC_PATH
		));
		//auw: Accordion Upcoming Widget
		//cta: Call to action
		$this->post_meta_boxes->save_fields = apply_filters( 'auw_fields', array('rhc_auw_cta_label','rhc_auw_cta_url','rhc_auw_cta_target') );	
	}
	
	function metaboxes($t=array()){
		global $rhc_plugin;
		$i = count($t);
		//------------------------------		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhc_auw_cta'; 
		$t[$i]->label 		= __('Accordion Upcoming Events Widget','rhcauw');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->context = 'normal';
		$t[$i]->priority = 'low';
		$t[$i]->options = array();	
		
		$t[$i]->options[] = (object)array(
			'type'			=> 'subtitle',
			'label'			=> __('Call to action','rhcauw'),
			'description'	=> __('Optional. Type a label and url to link to, and the Accordion Widget templates will display a Call to action button.','rhcauw'),
		);	
		
		$t[$i]->options[] = (object)array(
			'id'	=> 'rhc_auw_cta_label',
			'label'	=> __('Label','rhcauw'),
			'type'	=> 'text',
			'el_properties' => array('class'=>'widefat'),
			'save_option' => true,
			'load_option' => true
		);	
		
		$t[$i]->options[] = (object)array(
			'id'	=> 'rhc_auw_cta_url',
			'label'	=> __('URL','rhcauw'),
			'type'	=> 'text',
			'el_properties' => array('class'=>'widefat'),
			'save_option' => true,
			'load_option' => true
		);	
		
		$t[$i]->options[] = (object)array(
			'id'	=> 'rhc_auw_cta_target',
			'label'	=> __('Target','rhcauw'),
			'type'	=> 'select',
			'options' => array(
				'_self' => __('Same tab','rhcauw'),
				'_blank'=> __('New tab', 'rhcauw')
			),
			'default'	=> '_self',
			'el_properties' => array('class'=>'widefat'),
			'save_option' => true,
			'load_option' => true
		);	
		
		$t = apply_filters('rhc_auw_metaboxes', $t);	
		//----- 
		return $t;
	}		
}