<?php
/*
Plugin Name: Accordion Upcoming Events for Calendarize it!
Plugin URI: http://calendarize.it/add-ons/accordion-upcoming-events/
Description: Adds an upcoming events accordion widget to Calendarize It!
Version: 1.2.9.82524
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
*/

// namespace RHC\Accordion

if(defined('RHCAEW_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhcauw') );
 
if( !defined('PHP_VERSION_ID') || PHP_VERSION_ID < 50300 ) throw new Exception( sprintf( __('This addon/plugin requires PHP version 5.3 or greater.  PHP version %s detected','rhcauw'), phpversion() ) );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCAEW_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCAEW_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );

	$language_path = plugin_righthere_calendar::get_relative_path( WP_PLUGIN_DIR, RHCAEW_PATH ) . 'languages/';
	define('RHCAEW_LANGUAGE', $language_path);	
}else{
	define('RHCAEW_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCAEW_URL", plugin_dir_url(__FILE__) );
	define('RHCAEW_LANGUAGE', RHCAEW_PATH.'languages/');
} 

//rhc_uew_templates

class rhc_addon_widget {
	var $id='';
	var $file='';
	var $name='';
	var $class='';
	var $parse_taxonomy='1';
	var $loading_overlay='1';
	var $parse_postmeta='fc_color,fc_text_color,rhc_auw_cta_label,rhc_auw_cta_url,rhc_auw_cta_target';
	var $enqueue_scripts=array();
	var $enqueue_styles=array();
	var $vc_js_init_script='';
	var $in_sidebar=true;
	function __construct( $args ){
		foreach( $args as $field => $value ){
			$this->$field = $value;
		}
	}
	function get_id(){
		return $this->id;
	}
}

class plugin_rhc_widgets {
	var $widgets=array();
	function __construct($args=array()){
		$defaults = array(
			'path'				=> ''
		);
		
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-- show template in widget admin Upcoming Event Widget settings:
		add_filter( 'rhc_uew_templates', array( &$this, 'rhc_uew_templates' ) );
		//-- point to the addon template
		add_filter( 'rhc_template_path', array( &$this, 'rhc_template_path' ), 10, 2 );
		//-- filter ran at the beginning of widget instance
		add_filter( 'uew_args', array( &$this, 'uew_args' ), 10, 2 );
		add_filter( 'uew_instance', array( &$this, 'uew_instance' ), 10, 2 );
		add_filter( 'supe_atts', array( &$this, 'supe_atts'), 10, 2 );	

		add_action( 'wp_enqueue_scripts', array( &$this, 'wp_enqueue_scripts') ); 
		//-- add an option to disable the title
		add_action( 'rhc_widget_upcoming_events_form', array( &$this,'rhc_widget_upcoming_events_form'), 10, 2);
		add_filter( 'rhc_widget_upcoming_events_update', array( &$this, 'rhc_widget_upcoming_events_update' ), 10, 3 );
		
		add_action( 'init', array(&$this,'init_rhc_metaboxes'), 999 );
		
		add_action('plugins_loaded',array(&$this,'plugins_loaded'),9);
		//add media settings
		add_filter( 'rhc_media_size_options', array( &$this, 'rhc_media_size_options' ), 10, 1 );
		//handle media settings
		add_filter( 'supe_handle_get_images', array( &$this, 'supe_handle_get_images' ), 10, 3 );
	}

	function plugins_loaded(){
		load_plugin_textdomain('rhcauw', null, RHCAEW_LANGUAGE );
	}	
	
	function init_rhc_metaboxes(){
		if( is_admin() ){
			global $rhc_plugin;
			//---options
			require_once RHCAEW_PATH.'includes/class.rhc_auw_options.php';
			new rhc_auw_options( $rhc_plugin->id );
			//---
			require_once RHCAEW_PATH.'includes/class.rhc_auw_call_to_action_metabox.php';
			new rhc_auw_call_to_action_metabox();
			//--- enable post info for other post types.
			$post_types = $rhc_plugin->get_option('auw_post_types',array());
			$post_types = is_array($post_types)?$post_types:array();
			$post_types = apply_filters('rhc_auw_metabox_post_types',$post_types);					
			if(is_array($post_types)&&count($post_types)>0){
				foreach($post_types as $post_type){
					$pt = get_post_type_object( $post_type );
					if(is_object($pt)){
						new rhc_auw_call_to_action_metabox( $post_type );
					}				
				}
			}			
		}
	}
	
	function rhc_widget_upcoming_events_update( $instance, $new_instance, $old_instance ){
		$instance['auw_title_type'] = $new_instance['auw_title_type'];
		return $instance;
	}
	
	function rhc_widget_upcoming_events_form( $o, $instance ){
		$auw_title_type = isset( $instance['auw_title_type'] ) ? $instance['auw_title_type'] : '' ;	
		?>
			<div class="" style="margin-top:10px;">
				<?php _e('*Title type','rhcauw'); ?>
				<select id="<?php echo $o->get_field_id('auw_title_type')?>" name="<?php echo $o->get_field_name('auw_title_type'); ?>" class="widefat">
					<option value="" <?php echo $auw_title_type==''?'selected="selected"':''?> ><?php _e('Title is a link','rhcauw')?></option>
					<option value="1" <?php echo $auw_title_type=='1'?'selected="selected"':''?> ><?php _e('Title without link','rhcauw')?></option>
				</select>	
			</div>	
			<p style="margin-top:3px;"><?php _e('*Only applies to the templates provided by the Accordion Upcoming Widgets add-on.','rhcauw');?></p>
		<?php
	}
	
	function get_addon_widgets(){
		if(!empty($this->widgets)){
			return $this->widgets;	
		}
		
		$widgets =& $this->widgets;
		
		$widgets[] = new rhc_addon_widget(array(
			'id'				=> 'widget_custom_accordion.php',
			'file' 				=> 'widget_custom_accordion.php',
			'name' 				=> __('Accordion','rhcauw'),
			'enqueue_scripts' 	=> array('rhc-widgets-ac'),
			'enqueue_styles'	=> array('rhc-widgets'),
			'class'				=> 'rhc-supe rhc-upcoming-events6 rhc-supe-loading supe-simple-nav',
			'vc_js_init_script' => 'jQuery(document).ready(function($){init_uew_widgets();});'
		));
		
		$widgets[] = new rhc_addon_widget(array(
			'id'				=> 'widget_custom_image_expands.php',
			'file' 				=> 'widget_custom_image_expands.php',
			'name' 				=> __('Image expands','rhcauw'),
			'enqueue_scripts' 	=> array('rhc-widgets-ac'),
			'enqueue_styles'	=> array('rhc-widgets'),
			'class'				=> 'rhc-supe rhc-upcoming-events7 rhc-supe-loading supe-simple-nav',
			'vc_js_init_script' => 'jQuery(document).ready(function($){init_uew_widgets();});',
			'in_sidebar'		=> false
		));
		
		$widgets[] = new rhc_addon_widget(array(
			'id'				=> 'widget_custom_date_tilts.php',
			'file' 				=> 'widget_custom_date_tilts.php',
			'name' 				=> __('Date tilts','rhcauw'),
			'enqueue_scripts' 	=> array('rhc-widgets-ac'),
			'enqueue_styles'	=> array('rhc-widgets'),
			'class'				=> 'rhc-supe rhc-upcoming-events8 rhc-supe-loading supe-simple-nav',
			'vc_js_init_script' => 'jQuery(document).ready(function($){init_uew_widgets();});',
			'in_sidebar'		=> false
		));
		
		$widgets[] = new rhc_addon_widget(array(
			'id'				=> 'widget_custom_date_tilts_b.php',
			'file' 				=> 'widget_custom_date_tilts_b.php',
			'name' 				=> __('Date tilts B','rhcauw'),
			'enqueue_scripts' 	=> array('rhc-widgets-ac'),
			'enqueue_styles'	=> array('rhc-widgets'),
			'class'				=> 'rhc-supe rhc-upcoming-events8 rhc-supe-loading supe-simple-nav date-tilts-b',
			'vc_js_init_script' => 'jQuery(document).ready(function($){init_uew_widgets();});',
			'in_sidebar'		=> false
		));

		return $widgets;
	}
	
	function wp_enqueue_scripts(){	
//TODO: decide how are we loading css		
		//wp_register_style(  'rhc-widgets-ac', RHCAEW_URL.'css/rhc_accordion_widget.css', array('calendarize','rhc-last-minue'),'1.0.0');
		//wp_register_script( 'rhc-widgets-ac', RHCAEW_URL.'js/rhc_accordion_widget.js', array('calendarize'),'1.0.0');
		//wp_enqueue_style(  'rhc-widgets-ac', RHCAEW_URL.'css/rhc_accordion_widget.css', array('calendarize','rhc-last-minue'),'1.0.0');
		wp_enqueue_style(  'rhc-widgets', RHCAEW_URL.'rhc_widgets.css', array('calendarizeit','rhc-last-minue'),'1.0.1.3');
		wp_enqueue_script( 'rhc-widgets-ac', RHCAEW_URL.'js/rhc_accordion_widget.js', array('calendarize','google-api3'),'1.2.5.1');
		
	}
	
	function uew_args( $args, $instance ){
		$args['before_widget'] = isset( $args['before_widget'] ) ? $args['before_widget'] : '';
		$args['after_widget'] = isset( $args['after_widget'] ) ? $args['after_widget'] : '';

		foreach( $this->get_addon_widgets() as $w ){
			if( !empty( $w->enqueue_styles ) ){
				foreach( $w->enqueue_styles as $wp_registered_style ){
					wp_enqueue_style( $wp_registered_style );
				}
			}
		}
		
		foreach( $this->get_addon_widgets() as $w ){
			if( !empty( $w->enqueue_styles ) ){
				foreach( $w->enqueue_styles as $wp_registered_style ){
					wp_enqueue_style( $wp_registered_style );
				}
			}
		}

		return $args;
	}
	
	function uew_instance( $instance, $args ){
		if( isset( $instance['auw_title_type'] ) && '1' == $instance['auw_title_type'] ){			
			$instance['class'] = isset( $instance['class'] ) ? $instance['class'] . ' rhc-title-is-not-link' : 'rhc-title-is-not-link';
		}else{
			$instance['class'] = isset( $instance['class'] ) ? $instance['class'] . ' rhc-title-is-link' : 'rhc-title-is-link';		
		}
		$instance['loading_method'] = 'server'; //ajax rendering is incomplete for taxonomies and end datetimes.	
		return $instance;
	}
	
	function supe_atts( $atts, $uid ){	
		if( !isset( $atts['for_sidebar'] ) || $atts['for_sidebar']!='1' ){
			if( isset( $atts['auw_title_type'] ) && '1' == $atts['auw_title_type'] ){			
				$atts['class'] = isset( $atts['class'] ) ? $atts['class'] . ' rhc-title-is-not-link' : 'rhc-title-is-not-link';
			}else{
				$atts['class'] = isset( $atts['class'] ) ? $atts['class'] . ' rhc-title-is-link' : 'rhc-title-is-link';		
			}	
		}

		if( isset($atts['template']) ) {
			foreach( $this->get_addon_widgets() as $w ){
				if( $w->id == $atts['template'] ){
					$atts['class'] = isset($atts['class']) ? $atts['class'] . ' ' . $w->class : $w->class;
					$atts['parse_taxonomy'] = $w->parse_taxonomy;
					$atts['loading_overlay'] = $w->loading_overlay;
					$atts['vc_js_init_script'] = $w->vc_js_init_script;
					if( !empty( $w->parse_postmeta ) ){
						if( isset($atts['parse_postmeta']) && !empty($atts['parse_postmeta']) ){
							$atts['parse_postmeta'] .= ',' . $w->parse_postmeta ;
						}else{
							$atts['parse_postmeta'] = $w->parse_postmeta;
						}
					}
				}
			}	
		}
		return $atts;
	}
	
	function rhc_template_path( $path, $file ){
		foreach( $this->get_addon_widgets() as $w ){
			if( $w->id == $file ){
				return $this->path.'templates/'.$w->file;
			}
		}
		return $path;
	}
	
	function rhc_uew_templates( $templates ){
		foreach( $this->get_addon_widgets() as $w ){
			if( $w->in_sidebar ){
				$templates[$w->file] = $w->name;			
			}

		}
		//$templates = array(''=> __('--choose--','rhcauw') ) + $templates;
		return $templates;
	}
	
	function rhc_media_size_options( $options ){
		$options[] = (object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Accordion Upcoming Events (Addon)','rhc')
			);
	
		$options[] = (object)array(
				'id'		=> 'rhc_aew_date_tilt',
				'label'		=> __('Date tilt template','rhc'),
				'type'		=> 'select',
				'default'	=> 'thumbnail',
				'options'	=> array(
					'thumbnail'	=> __('Thumbnail','rhc'),
					'medium'	=> __('Medium','rhc'),
					'large'		=> __('Large','rhc'),
					'full'		=> __('Full','rhc')
				),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			)
		;
		return $options;
	}
	
	function supe_handle_get_images( $size, $atts, $meta_key ){
		if( isset( $atts['template'] ) ){
			if( $meta_key == 'rhc_tooltip_image' ){
				switch ( $atts['template'] ) {
					case 'widget_custom_date_tilts.php':
					case 'widget_custom_date_tilts_b.php':
						global $rhc_plugin;
						$size = $rhc_plugin->get_option( 'rhc_aew_date_tilt', $size, true );
						break;
				}			
			}

		}
		return $size;
	}
}

new plugin_rhc_widgets(array(
	'path' => RHCAEW_PATH
));



?>