<?php
/**
 * Button X
 *
 * This file is used for dual buttons functionality.
 *
 * @package Buttons X
 * @since 1.7
 */
// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'BtnsxDual' ) ) {
	
	class BtnsxDual {

		private static $instance;

		/**
		 * Initiator
		 * @since 1.7
		 */
		public static function init(){
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 1.7
		 */
		public function __construct() {
			global $wp_version, $btnsx_settings;
			// execute code if minimum wp version is 4 n above else throw notice
			if ( $wp_version >= BTNSX__MIN_WP_VERSION ) {
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.design.php' );
				require_once( BTNSX__PLUGIN_DIR . 'includes/class.btnsx.form.php' );
				// admin functionality
					add_action( 'init', array( $this, 'register_cpt' ) );
					add_action( 'init', array( $this, 'register_taxonomies' ) );
					add_action( 'add_meta_boxes', array( $this, 'register_meta_boxes' ) );
	            	add_action( 'do_meta_boxes', array( $this, 'remove_extra_meta_boxes' ) );
	            	add_filter( 'post_updated_messages', array( $this, 'updated_messages' ) );
	            	add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) , 50 );
	    			// add_action( 'admin_head', array( $this, 'admin_head' ) );
	            	add_action( 'manage_buttons-x-dual_posts_custom_column', array( $this, 'column_preview' ), 10, 2);
	   				add_action( 'save_post_buttons-x-dual', array( $this, 'save_data' ) );
	            	
					add_filter( 'post_row_actions', array( $this, 'row_actions' ), 10, 2 );
					add_filter( 'manage_buttons-x-dual_posts_columns', array( $this, 'columns' ) );
	   				add_shortcode( 'btnsx_dual' , array( $this, 'shortcode' ) );
	   				if( isset( $btnsx_settings[ 'css' ] ) && $btnsx_settings[ 'css' ] === 'external' ){
						add_action( 'save_post_buttons-x-dual', array( $this, 'print_css' ) );
						add_action( 'delete_post', array( $this, 'remove_css') );
					}
					add_action( 'post_submitbox_misc_actions', array( $this, 'publishing_actions' ) );
					add_filter( 'views_edit-buttons-x-dual', array( $this, 'screen_meta_view' ) );
			} else {
				add_action( 'admin_notices', array( $this, 'dependency_notice' ) );
			}
		}

		/**
		 * Add packs and tags links on dual buttons list page
		 * @since  1.7.3
		 * @param  array    $views
		 * @return array
		 */
		function screen_meta_view($views){
		    $packs = count(get_terms('btnsx_dual_pack'));
		    $tags = count(get_terms('btnsx_dual_tag'));
		    $views['packs'] = "<a href='edit-tags.php?taxonomy=btnsx_dual_pack&post_type=buttons-x-dual'>".__('Packs','btnsx')." <span class='count'>(".$packs.")</span></a>";
		    $views['tags'] = "<a href='edit-tags.php?taxonomy=btnsx_dual_tag&post_type=buttons-x-dual'>".__('Tags','btnsx')." <span class='count'>(".$tags.")</span></a>";
		    return $views;
		}

		/**
		 * Adds a box to the side column on Buttons edit screens.
		 * @since  1.7
		 * @return string
		 */
		public function preview_settings_callback( $post ) {
			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'btnsx_preview_settings_meta', 'btnsx_preview_settings_meta_nonce' );

			$meta_values = array();
	        $meta_values = get_post_meta( $post->ID, 'btnsx', true );

			$btnsx_form = new BtnsxFormElements();
			echo '<div style="min-height:200px;"><div class="btnsx btnsx-side">';
			echo $btnsx_form->input( array(
	        		'type'			=>	'color',
					'id'			=>	'btnsx_opt_dual_preview_background',
					'name'			=>	'btnsx_opt_dual_preview_background',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Background Color', 'btnsx' ),
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background' ) ),
					'tooltip'		=>	__( 'Changing the color will change the preview background. If you intend to use this button on a coloured background then changing the preview background will give you exact look of the button over a color.', 'btnsx' )
				)
        	);
        	// echo '<hr>';
        	echo $btnsx_form->input( array(
        			'type'			=>	'background-image',
					'id'			=>	'btnsx_opt_dual_preview_background_image',
					'name'			=>	'btnsx_opt_dual_preview_background_image',
					'label'			=>	__( 'Background Image', 'btnsx' ),
					'tooltip'		=>	array(
						'image'			=>	__( 'Select or upload button preview background image.', 'btnsx' ),
						// 'repeat'		=>	__( 'Set preview background image repeat.', 'btnsx' ),
						'position'		=>	__( 'Set preview background image position.', 'btnsx' ),
					),
					'value'			=>	array(
						'image'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_image', 'field2' => 'image' ) ),
						// 'repeat'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_image', 'field2' => 'repeat' ) ),
						'position'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_image', 'field2' => 'position' ) ),
					)
				)
        	);
        	// echo '<hr>';
        	echo $btnsx_form->input( array(
					'type'			=>	'range',
					'id'			=>	'btnsx_opt_dual_preview_background_overlay',
					'name'			=>	'btnsx_opt_dual_preview_background_overlay',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Overlay', 'btnsx' ),
					'tooltip'		=>	__( 'Adjust background overlay opacity. You can change overlay colour by changing the background colour option above.', 'btnsx' ),
					'min'			=>	0,
					'max'			=>	1,
					'step'			=>	0.1,
					'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_preview_background_overlay', 'value' => '0' ) )
				)
        	);
        	echo '</div></div>';
		}

		/**
		 * Function to rest button options
		 * @since  1.7
		 * @return string
		 */
		public function publishing_actions() {
		    global $post;
		    if ( $post->post_type === 'buttons-x-dual' ) {
		        echo '<div class="misc-pub-section misc-pub-btnsx-options-reset"><i id="btnsx_options_reset_icon" class="fa fa-refresh" style="font-size:16px;color:#82878c;margin-right:10px;"></i><a id="btnsx_options_reset" href="javascript:void(0)">' . __( 'Reset Options', 'btnsx' ) . '</a></div>';
		        echo '<div class="misc-pub-section misc-pub-btnsx-options-reset"><i id="btnsx_options_clone_icon" class="fa fa-clone" style="font-size:16px;color:#82878c;margin-right:10px;"></i><a id="btnsx_options_clone" href="edit.php?post_type=buttons-x-dual&btnsx-clone=' . $post->ID . '">' . __( 'Clone Button', 'btnsx' ) . '</a></div>';
		    }
		}

		/**
		 * Function to display error in case 
		 * @since  1.7
		 * @return string
		 */
		public function error_notice_remove_css() {
		    ?>
		    <div class="error"> 
		        <p><b><?php _e( 'Buttons X CSS Remove Error : ', 'btnsx' ); ?></b><?php _e( 'Seems like you do not have file write access. Please contact your host to get write access to "/wp-content/uploads/btnsx" directory and files inside it OR "/wp-content/uploads/sites/{site_id}/btnsx".', 'btnsx' ); ?></p>
		    </div>
		    <?php
		}

		/**
		 * Function to remove css when button is deleted
		 * @since  1.7
		 * @param  int   $post_id
		 * @return string
		 */
		public function remove_css( $post_id ) {
			// var_dump('works');
			$access_type = '';
			if( function_exists('get_filesystem_method') ){
		    	$access_type = get_filesystem_method();
			}
		    if( $access_type === 'direct' )
		    {
		        $slug = 'buttons-x-dual';

		        // If this isn't a 'buttons-x' post, don't update it.
		        if ( $slug != get_post_type( $post_id ) ) {
		            return;
		        }

		        $creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, false, array() );

		        if ( !WP_Filesystem( $creds ) ) {
		            return false;
		        }

		        global $wp_filesystem;
		        $file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/btnsx/dynamic.css';
		        $file_content = $wp_filesystem->get_contents( $file, FS_CHMOD_FILE );

		        $button_id = $post_id;
		        if ( strpos( $file_content, (string) $button_id ) === FALSE) {
		        	// var_dump( false );
		            // do nothing
		        } else {
		            // var_dump( true );
		            $start = "/*" . $button_id . "-start*/";
		            $end = "/*" . $button_id . "-end*/";
		            $css = preg_replace( '#(' . preg_quote( $start ) . ')(.*)(' . preg_quote( $end ) . ')#si', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
		            $wp_filesystem->put_contents( $file, $css, FS_CHMOD_FILE ) ;
		            $empty_lines = preg_replace( '/^[\r\n]+|[\r\n]+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
		            $wp_filesystem->put_contents( $file, $empty_lines, FS_CHMOD_FILE );
		        }
		    }
		    else{
		        add_action( 'admin_notice', array( $this, 'error_notice_remove_css' ) ); 
		    }
		}

		/**
		 * Notice when unable to save css
		 * @since  0.1
		 * @return string
		 */
		public function error_notice_css() {
		    ?>
		    <div class="error"> 
		        <p><?php _e( 'Buttons X needs permission to write custom styles in css file. Please change directory permission at ( wp-content/uploads/btnsx OR wp-content/uploads/sites/{site_id}/btnsx  ) to 644 or higher.', 'btnsx' ); ?></p>
		    </div>
		    <?php
		}

		/**
		 * generate CSS when saving or updating an extreme button
		 * @since  1.7
		 * @param  number    $post_id   current post ID
		 * @return string
		 */
		public function print_css( $post_id ) {
			// if function exists get_filesystem_method define access type
		    if( function_exists( 'get_filesystem_method' ) ) {
		        $access_type = get_filesystem_method();
		    } else {
		        $access_type = '';
		    }
		    // if access type is direct then only proceed else generate notice
		    if( $access_type === 'direct' ) {

		    	// custom post type slug
		        $slug = 'buttons-x-dual';

		        // If this isn't a 'buttons-x' post, don't update it.
		        if ( $slug != get_post_type( $post_id ) ) {
		            return;
		        }

		        // check for filesystem credentials, if false return
		        $creds = request_filesystem_credentials( site_url() . '/wp-admin/', '', false, false, array() );
		        if ( !WP_Filesystem( $creds ) ) {
		            return false;
		        }

		        // if ( get_metadata('post', $post_id ) == false) {
		        //     return;
		        // }
		        global $wp_filesystem;

		        // dynamic file
		        if( is_multisite() ) {
		        	if( is_main_site() ) {
		        		$file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/btnsx/dynamic.css';
		        	} else {
		        		$blog_id = get_current_blog_id();
		        		$file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/sites/' . $blog_id . '/btnsx/dynamic.css';
		        	}
		        } else {
		        	$file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'uploads/btnsx/dynamic.css';
		        }
		        // store current file content
		        $file_content = $wp_filesystem->get_contents( $file );

		        $start = "/*" . $post_id . "-start*/";
            	$end   = "/*" . $post_id . "-end*/";
            	// remove existing css for the button
	    		$existing_css   = preg_replace( '#(' . preg_quote( $start ) . ')(.*)(' . preg_quote( $end ) . ')#si', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
	    		$wp_filesystem->put_contents( $file, $existing_css, FS_CHMOD_FILE );
	    		// remove unwanted new lines
            	$empty_lines = preg_replace( '/^[\r\n]+|[\r\n]+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
            	$wp_filesystem->put_contents( $file, $empty_lines, FS_CHMOD_FILE );
		        // fetch data and store css
		        $button_first = $this->meta_values( $post_id, array( 'field' => 'btnsx_button_first' ) );
		        $button_second = $this->meta_values( $post_id, array( 'field' => 'btnsx_button_second' ) );
		        $generated_css = $this->generate_css( $post_id, $button_first, $button_second );
		        // combine css
	            $css = $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) . $generated_css;
	            // write combined css to file
	            $wp_filesystem->put_contents( $file, $css, FS_CHMOD_FILE );
	            // remove empty declarations
	            $empty_declarations = preg_replace( '/^.*{}.*+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
	            $wp_filesystem->put_contents( $file, $empty_declarations, FS_CHMOD_FILE );
	            // remove unwanted new lines
	            $empty_lines = preg_replace( '/^[\r\n]+|[\r\n]+$/m', '', $wp_filesystem->get_contents( $file, FS_CHMOD_FILE ) );
	            $wp_filesystem->put_contents( $file, $empty_lines, FS_CHMOD_FILE );

	            // Flush WP cache
	            if ( function_exists( 'wp_cache_flush' ) ) {
	            	wp_cache_flush();
	            }

	            // Flush W3TC cache
	            if ( function_exists( 'w3tc_pgcache_flush' ) ) {
					w3tc_pgcache_flush();
				}

				// Flush WPSC cache
	            if ( function_exists( 'wp_cache_clear_cache' ) ) {
					wp_cache_clear_cache();
				}

		    } else {
		    	// if file not accessible generate a notice
		        add_action( 'admin_notice', array( $this, 'error_notice_css' ) ); 
		    }
		}


		/**
	     * Function to generate css
	     * @since  1.7
	     * @param  int    	$id
	     * @param  boolean  $override
	     * @return string
	     */
	    public function generate_css( $id, $pid, $sid ) {
	    	// Start
	    		$css = '/*' . $id . '-start*/' . PHP_EOL;

			// Divider
				$css .= '#btnsx-dual-' . $id . ' .btnsx-dual-divider{';
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_text_size' ), array( 'css' => true, 'css_prefix' => 'font-size', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_width' ), array( 'css' => true, 'css_prefix' => 'width', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_height' ), array( 'css' => true, 'css_prefix' => 'height', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_position_left' ), array( 'css' => true, 'css_prefix' => 'margin-left', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_position_top' ), array( 'css' => true, 'css_prefix' => 'top', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_text_position' ), array( 'css' => true, 'css_prefix' => 'line-height' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border', 'field2' => 'size' ), array( 'css' => true, 'css_prefix' => 'border-width', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border', 'field2' => 'style' ), array( 'css' => true, 'css_prefix' => 'border-style' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border', 'field2' => 'color' ), array( 'css' => true, 'css_prefix' => 'border-color' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'top_left' ), array( 'css' => true, 'css_prefix' => 'border-top-left-radius', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'top_right' ), array( 'css' => true, 'css_prefix' => 'border-top-right-radius', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'bottom_left' ), array( 'css' => true, 'css_prefix' => 'border-bottom-left-radius', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'bottom_right' ), array( 'css' => true, 'css_prefix' => 'border-bottom-right-radius', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_background_color' ), array( 'css' => true, 'css_prefix' => 'background-color' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_divider_text_color' ), array( 'css' => true, 'css_prefix' => 'color' ) );
				$css .= '}' . PHP_EOL;

			// Button First
				$css .= '#btnsx-dual-' . $id . ' .btnsx-dual-first{';
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' ) );
				$css .= '}' . PHP_EOL;

			// Button Second
				$css .= '#btnsx-dual-' . $id . ' .btnsx-dual-second{';
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'top' ), array( 'css' => true, 'css_prefix' => 'padding-top', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'bottom' ), array( 'css' => true, 'css_prefix' => 'padding-bottom', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'left' ), array( 'css' => true, 'css_prefix' => 'padding-left', 'css_suffix' => 'px' ) );
				$css .= $this->empty_check_definition( '', $id, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'right' ), array( 'css' => true, 'css_prefix' => 'padding-right', 'css_suffix' => 'px' ) );
				$css .= '}' . PHP_EOL;

		    // Filter - CSS
				$btn_css_filter = apply_filters( 'btnsx_dual_css_filter', array(), $id );
				$btn_css_filter_as_string = '';
				foreach ( $btn_css_filter as $key => $value ) {
					$btn_css_filter_as_string .= implode( ' ', $value );
				}
				$css .= $btn_css_filter_as_string;

	    	// End
	    		$css .= '/*' . $id . '-end*/' . PHP_EOL;

	    	return $css;
	    }

	    /**
	     * Function to check whether the given value is serializable/unserializable without throwing error
	     * @since  1.7
	     * @param  mixed    $str
	     * @return boolean
	     */
	    public function is_serialized( $str ) {
	    	if( $str != '' )
		    	return ( $str == serialize( false ) || @unserialize( $str ) !== false );
		    else
		    	return false;
		}

	    /**
	     * Function to check short code paramter values, if empty fetch values from meta data
	     * @since  1.7
	     * @param  string    $variable passed parameter value in short code
	     * @param  string    $id post ID
	     * @param  array     $field meta values function parameters
	     * @param  array     $type parameter use type. Used as css, class or attribute.
	     * @return string
	     */
	    public function empty_check_definition( $variable = '', $id = '', $field = array(), $type = array() ) {

	    	$defaults = array(
	    		'css' => false,
	    		'css_prefix' => '',
	    		'css_suffix' => '',
	    		'class' => false,
	    		'class_name' => '',
	    		'attribute' => false,
	    		'attribute_name' => ''
	    	);

	    	$type = array_merge( $defaults, $type );

	    	if( is_array( $field ) && $field != null ){
	    		// check if value is serialized
	    		$serializable = $this->is_serialized( $this->meta_values( $id, $field ) ); // @TODO - FIX - removed (string) before $this->meta..
	    		// if serialized, unserialize value
	    		$meta_value = $serializable != false ? unserialize( $this->meta_values( $id, $field ) ) : $this->meta_values( $id, $field );
	    		// store value
		    	$variable = $variable != '' ? $variable : $meta_value;
				
				if( $type['css'] === true && $type['class'] === false && $type['attribute'] === false ) {
					if( $variable != '' ){
						$variable = sanitize_text_field( $type['css_prefix'] ) . ':' . sanitize_text_field( $variable ) . sanitize_text_field( $type['css_suffix'] ) . ';';
					}
				}

				if( $type['css'] === false && $type['class'] === true && $type['attribute'] === false ) {
					if( $variable == '1' ){
						$variable = ' ' . esc_attr( $type['class_name'] );
					}
				}

				if( $type['css'] === false && $type['class'] === false && $type['attribute'] === true ) {
					if( $variable != '' ){
						$variable = ' ' . sanitize_text_field( $type['attribute_name'] ) . '="' . esc_attr( $variable ) . '"';
					}
				}

				return $variable;

			}
	    }

		/**
		 * Function to remove view link to row actions on buttons X post type
		 * @since  1.7
		 * @param  string    $actions default actions
		 * @param  WP_Post   $post post object
		 * @return string
		 */
		public function row_actions( $actions, WP_Post $post ) {
	        if ( $post->post_type != 'buttons-x-dual' ) {
	            return $actions;
	        }
	        unset( $actions['view'] );
	        return $actions;
	    }

	    /**
	     * [columns description]
	     * @since  1.7
	     * @param  [type]    $defaults
	     * @return [type]
	     */
	    public function columns( $defaults ) {
			$defaults['btnsx_dual_shortcode'] 	= __( 'Shortcode', 'btnsx' );
		    $defaults['btnsx_dual_preview'] 	= __( 'Preview', 'btnsx' );
		    unset( $defaults['date'] );
		    return $defaults;
		}

		/**
		 * [column_preview description]
		 * @since  1.7
		 * @param  [type]    $column_name
		 * @param  [type]    $id
		 * @return [type]
		 */
		public function column_preview( $column_name, $id ) {
		    if ( $column_name == 'btnsx_dual_preview' ) {
		        $meta = get_post_meta( $id, 'btnsx-dual', true);
		        $background = ( isset( $meta['btnsx_preview_background'] ) && $meta['btnsx_preview_background'] != '' ? $meta['btnsx_preview_background'] : '#fff' );
		        $background_image = ( isset( $meta['btnsx_preview_background_image']['image'] ) && $meta['btnsx_preview_background_image']['image'] != '' ? 'background-image:url(' . $meta['btnsx_preview_background_image']['image'] . ');' : '' );
		       	$background_image_position = ( isset( $meta['btnsx_preview_background_image']['position'] ) && $meta['btnsx_preview_background_image']['position'] != '' ? 'background-position:' . $meta['btnsx_preview_background_image']['position'] . ';' : '' );
		       	$background_overlay = ( isset( $meta['btnsx_preview_background_overlay'] ) && $meta['btnsx_preview_background_overlay'] != '' ? 'opacity:' . $meta['btnsx_preview_background_overlay'] . ';' : 'opacity:0;' );
		        ?>
		        <div class="btnsx">
			        <!-- Modal Trigger -->
					<a class="waves-effect waves-light btn modal-trigger" href="#modal<?php echo sanitize_text_field( $id ); ?>"><?php _e( 'Preview', 'btnsx' ); ?></a>
					<!-- Modal Structure -->
					<style type="text/css">
						#modal<?php echo sanitize_text_field( $id ); ?> .modal-content, #modal<?php echo sanitize_text_field( $id ); ?> .modal-footer {
						  	background-color: <?php echo sanitize_text_field( $background ); ?>;
						  	<?php echo $background_image;echo $background_image_position; ?>
						  	background-repeat: repeat;
						}
					</style>
					<div id="modal<?php echo $id; ?>" class="modal preview-modal">
						<div class="btnsx-preview-overlay" style="<?php echo sanitize_text_field( $background_overlay ); echo 'background-color:'.sanitize_text_field( $background ).';'; ?>"></div>
					    <div class="modal-content">
					    	<?php 
					    		echo $this->shortcode( array ( 'id' => $id, 'css_inline' => '1' ) ); 
					    	?>
					    	<a href="javascript:void(0)" class="modal-action modal-close" style="position:absolute;bottom:10px;right:10px;"><i class="fa fa-close"></i></a>
					    </div>
					    <div class="modal-footer" style="display:none;">
					      	<a href="javascript:void(0)" class="modal-action modal-close"><i class="fa fa-close"></i></a>
					    </div>
					</div>
				</div>
				<?php
		        // echo $this->shortcode( array ( 'id' => $id, 'css_inline' => '1' ) );
		    }
		    if ( $column_name == 'btnsx_dual_shortcode' ) {
		        echo '[btnsx_dual id="' . sanitize_text_field( $id ) . '" css_inline="1"]';
		    }
		}

		/**
		 * [columns_order description]
		 * @since  1.7
		 * @param  [type]    $columns
		 * @return [type]
		 */
		public function columns_order( $columns ) {
		    return array(
		        'cb' 							=> '<input type="checkbox" />',
		        'title' 						=> __( 'Title', 'btnsx' ),
		        'taxonomy-btnsx_dual_pack' 		=> __( 'Packs', 'btnsx' ),
		        'taxonomy-btnsx_dual_tag' 		=> __( 'Tags', 'btnsx' ),
		        'btnsx_dual_shortcode' 			=> __( 'Shortcode', 'btnsx' ),
		        'btnsx_dual_preview' 			=> __( 'Preview', 'btnsx' ),
		    );
		}

	    /**
	     * Button short code
	     * @param $atts 
	     * @since 1.7
	     */
	    public function shortcode( $atts, $content = '' ) {

	    	extract( shortcode_atts( array(
			
			// General
				'id'									=> '',
				'button_first' 							=> '',
	        	'button_second' 						=> '',
	        	'button_full_width' 					=> '',
	        	'button_wrap_center' 					=> '',
	        // Divider
	        	'divider_enable' 						=> '',
	        	'divider_type' 							=> '',
	        	'divider_text' 							=> '',
	        	'divider_icon' 							=> '',
	        	'divider_text_size' 					=> '',
	        	'divider_width' 						=> '',
	        	'divider_height' 						=> '',
	        	'divider_position_left' 				=> '',
	        	'divider_position_top' 					=> '',
	        	'divider_text_position' 				=> '',
	        	'divider_type' 							=> '',
	        	'divider_border_size' 					=> '',
	        	'divider_border_style' 					=> '',
	        	'divider_border_color' 					=> '',
            	'divider_border_radius_top_left' 		=> '',
            	'divider_border_radius_top_right' 		=> '',
            	'divider_border_radius_bottom_left' 	=> '',
            	'divider_border_radius_bottom_right' 	=> '',
            	'divider_background_color' 				=> '',
            	'divider_text_color' 					=> '',
        	// link
				'button_first_link_type'				=>	'',
				'button_first_link_target'				=>	'',
				'button_first_link_relationship'		=>	'',
				'button_first_link_post'				=>	'',
				'button_first_link_menu'				=>	'',
				'button_first_link_menu_display'		=>	'',
				'button_first_link'						=>	'',
				'button_first_link_edd_id'				=>	'',
				'button_first_link_woocommerce_id'		=>	'',
				'button_first_link_redirect_url'		=>	'',
			// link
				'button_second_link_type'				=>	'',
				'button_second_link_target'				=>	'',
				'button_second_link_relationship'		=>	'',
				'button_second_link_post'				=>	'',
				'button_second_link_menu'				=>	'',
				'button_second_link_menu_display'		=>	'',
				'button_second_link'					=>	'',
				'button_second_link_edd_id'				=>	'',
				'button_second_link_woocommerce_id'		=>	'',
				'button_second_link_redirect_url'		=>	'',

            // Admin
            	'css_inline'							=> ''

			
			), $atts ) );
				$btnsx = new Btnsx();

				$button_full_width					= $button_full_width != '' ? $button_full_width : $this->meta_values( $id, array( 'field' => 'btnsx_button_full_width' ) );
				if( $button_full_width == '1' ){
					$button_full_width = ' btnsx-dual-full-width';
				}

				$button_wrap_center					= $button_wrap_center != '' ? $button_wrap_center : $this->meta_values( $id, array( 'field' => 'btnsx_button_wrap_center' ) );
				$button_wrap_center_class = '';
				if( $button_wrap_center == '1' ){
					$button_wrap_center = ' align="center"';
					$button_wrap_center_class = ' btnsx-wrap-center';
				}

			// Button First Link
				$button_first_link_type				= $button_first_link_type != '' ? $button_first_link_type : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_type' ) );
				if( $button_first_link_type != '' ){
					$button_first_link_type = ' link_type="'.$button_first_link_type.'"';
				}
				$button_first_link_target			= $button_first_link_target != '' ? $button_first_link_target : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_target' ) );
				if( $button_first_link_target != '' ){
					$button_first_link_target = ' link_target="'.$button_first_link_target.'"';
				}
				$button_first_link_relationship			= $button_first_link_relationship != '' ? $button_first_link_relationship : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_relationship' ) );
				if( $button_first_link_relationship != '' ){
					$button_first_link_relationship = ' link_relationship="'.$button_first_link_relationship.'"';
				}
				$button_first_link_post				= $button_first_link_post != '' ? $button_first_link_post : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_post' ) );
				if( $button_first_link_post != '' ){
					$button_first_link_post = ' link_post="'.$button_first_link_post.'"';
				}
				$button_first_link_menu				= $button_first_link_menu != '' ? $button_first_link_menu : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_menu' ) );
				if( $button_first_link_menu != '' ){
					$button_first_link_menu = ' link_menu="'.$button_first_link_menu.'"';
				}
				$button_first_link_menu_display		= $button_first_link_menu_display != '' ? $button_first_link_menu_display : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_menu_display' ) );
				if( $button_first_link_menu_display != '' ){
					$button_first_link_menu_display = ' link_menu_display="'.$button_first_link_menu_display.'"';
				}
				$button_first_link				= $button_first_link != '' ? $button_first_link : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link' ) );
				if( $button_first_link != '' ){
					$button_first_link = ' link="'.$button_first_link.'"';
				}
				$button_first_link_edd_id				= $button_first_link_edd_id != '' ? $button_first_link_edd_id : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_edd_id' ) );
				if( $button_first_link_edd_id != '' ){
					$button_first_link_edd_id = ' link_edd_id="'.$button_first_link_edd_id.'"';
				}
				$button_first_link_woocommerce_id		= $button_first_link_woocommerce_id != '' ? $button_first_link_woocommerce_id : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_woocommerce_id' ) );
				if( $button_first_link_woocommerce_id != '' ){
					$button_first_link_woocommerce_id = ' link_woocommerce_id="'.$button_first_link_woocommerce_id.'"';
				}
				$button_first_link_redirect_url			= $button_first_link_redirect_url != '' ? $button_first_link_redirect_url : $this->meta_values( $id, array( 'field' => 'btnsx_button_first_link_redirect_url' ) );
				if( $button_first_link_redirect_url != '' ){
					$button_first_link_redirect_url = ' link_redirect_url="'.$button_first_link_redirect_url.'"';
				}

			// Button Second Link
				$button_second_link_type				= $button_second_link_type != '' ? $button_second_link_type : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_type' ) );
				if( $button_second_link_type != '' ){
					$button_second_link_type = ' link_type="'.$button_second_link_type.'"';
				}
				$button_second_link_target			= $button_second_link_target != '' ? $button_second_link_target : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_target' ) );
				if( $button_second_link_target != '' ){
					$button_second_link_target = ' link_target="'.$button_second_link_target.'"';
				}
				$button_second_link_relationship			= $button_second_link_relationship != '' ? $button_second_link_relationship : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_relationship' ) );
				if( $button_second_link_relationship != '' ){
					$button_second_link_relationship = ' link_relationship="'.$button_second_link_relationship.'"';
				}
				$button_second_link_post				= $button_second_link_post != '' ? $button_second_link_post : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_post' ) );
				if( $button_second_link_post != '' ){
					$button_second_link_post = ' link_post="'.$button_second_link_post.'"';
				}
				$button_second_link_menu				= $button_second_link_menu != '' ? $button_second_link_menu : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_menu' ) );
				if( $button_second_link_menu != '' ){
					$button_second_link_menu = ' link_menu="'.$button_second_link_menu.'"';
				}
				$button_second_link_menu_display		= $button_second_link_menu_display != '' ? $button_second_link_menu_display : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_menu_display' ) );
				if( $button_second_link_menu_display != '' ){
					$button_second_link_menu_display = ' link_menu_display="'.$button_second_link_menu_display.'"';
				}
				$button_second_link				= $button_second_link != '' ? $button_second_link : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link' ) );
				if( $button_second_link != '' ){
					$button_second_link = ' link="'.$button_second_link.'"';
				}
				$button_second_link_edd_id				= $button_second_link_edd_id != '' ? $button_second_link_edd_id : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_edd_id' ) );
				if( $button_second_link_edd_id != '' ){
					$button_second_link_edd_id = ' link_edd_id="'.$button_second_link_edd_id.'"';
				}
				$button_second_link_woocommerce_id		= $button_second_link_woocommerce_id != '' ? $button_second_link_woocommerce_id : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_woocommerce_id' ) );
				if( $button_second_link_woocommerce_id != '' ){
					$button_second_link_woocommerce_id = ' link_woocommerce_id="'.$button_second_link_woocommerce_id.'"';
				}
				$button_second_link_redirect_url			= $button_second_link_redirect_url != '' ? $button_second_link_redirect_url : $this->meta_values( $id, array( 'field' => 'btnsx_button_second_link_redirect_url' ) );
				if( $button_second_link_redirect_url != '' ){
					$button_second_link_redirect_url = ' link_redirect_url="'.$button_second_link_redirect_url.'"';
				}

			// CSS Inline
				if( $css_inline == '1' ){
					$style_inline = ' css_inline="1"';
				}else{
					$style_inline = '';
				}

			// Buttons
				$button_first						= $button_first != '' ? $button_first : $this->meta_values( $id, array( 'field' => 'btnsx_button_first' ) );
				if( $button_first != '' ){
					$button_first_object = get_page_by_title( $button_first, 'OBJECT', 'buttons-x' );
					$button_first_id = $button_first_object->ID;

					$button_first = '[btnsx id="'. $button_first_id .'" class="btnsx-dual-first" full_width=" "'. $button_first_link_type . $button_first_link_target . $button_first_link_relationship . $button_first_link_post . $button_first_link_menu . $button_first_link_menu_display . $button_first_link . $button_first_link_edd_id . $button_first_link_woocommerce_id . $button_first_link_redirect_url . $style_inline . ']';
				}
				$button_second						= $button_second != '' ? $button_second : $this->meta_values( $id, array( 'field' => 'btnsx_button_second' ) );
				if( $button_second != '' ){
					$button_second_object = get_page_by_title( $button_second, 'OBJECT', 'buttons-x' );
					$button_second_id = $button_second_object->ID;
					$button_second = '[btnsx id="'. $button_second_id .'" class="btnsx-dual-second" full_width=" "'. $button_second_link_type . $button_second_link_target . $button_second_link_relationship . $button_second_link_post . $button_second_link_menu . $button_second_link_menu_display . $button_second_link . $button_second_link_edd_id . $button_second_link_woocommerce_id . $button_second_link_redirect_url . $style_inline . ']';
				}

			// Divider
				$divider_text						= $divider_text != '' ? $divider_text : $this->meta_values( $id, array( 'field' => 'btnsx_divider_text' ) );
				$divider_icon						= $divider_icon != '' ? ' ' . $divider_icon : ' ' . $this->meta_values( $id, array( 'field' => 'btnsx_divider_icon' ) );

				$divider_type						= $divider_type != '' ? $divider_type : $this->meta_values( $id, array( 'field' => 'btnsx_divider_type' ) );
				if( $divider_type == 'text' ){
					$divider_icon = '';
				}else{
					$divider_text = '';
				}

				$divider_enable						= $divider_enable != '' ? $divider_enable : $this->meta_values( $id, array( 'field' => 'btnsx_divider_enable' ) );
				if( $divider_enable == '1' ){
					$divider = '<span id="btnsx-dual-'. $id .'-divider" class="btnsx-dual-divider'. $divider_icon .'">'. $divider_text .'</span>';
				}else{
					$divider = '';
				}

			// Inline CSS
				global $btnsx_settings;
				if( isset( $btnsx_settings['css'] ) && $btnsx_settings['css'] === 'inline' ){
					$css = '<style type="text/css" scoped>' . $this->generate_css( $id, $button_first, $button_second ) . '</style>';
				} else {
					$css = '';
				}

			// override css option
				if( $css_inline === '1' ) {
					$css = '<style type="text/css" scoped>' . $this->generate_css( $id, $button_first, $button_second ) . '</style>';
				}

			return 
			'
			<!-- Buttons X Dual - Start -->
			'. $css .'
			<div id="btnsx-dual-'. $id .'" class="btnsx btnsx-dual-btn'.$button_full_width.$button_wrap_center_class.'"'. $button_wrap_center .'>' . do_shortcode( $button_first ) . $divider . do_shortcode( $button_second ) . '</div>
			<!-- Buttons X Dual - End -->
			';
	    }

	    /**
	     * When the post is saved, saves our custom data.
	     * @param int $post->ID_id The ID of the post being saved.
	     * @since 1.7
	     */
	    public function save_data( $post_id ) {

	    	// wp_die('working');

	        /*
	         * We need to verify this came from our screen and with proper authorization,
	         * because the save_post action can be triggered at other times.
	         */

	        // Check if our nonce is set.
	        if ( !isset( $_POST[ 'btnsx_options_nonce' ] ) ) {
	            return;
	        }

	        // Verify that the nonce is valid.
	        if ( !wp_verify_nonce( $_POST[ 'btnsx_options_nonce' ], 'btnsx-dual' ) ) {
	            return;
	        }

	        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
	        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
	            return;
	        }

	        // Check the user's permissions.
	        if ( isset( $_POST[ 'post_type' ] ) && 'page' == $_POST[ 'post_type' ] ) {
	            if ( !current_user_can( 'edit_page', $post_id ) ) {
	                return;
	            }
	        } else {
	            if ( !current_user_can( 'edit_post', $post_id ) ) {
	                return;
	            }
	        }

	        /* OK, its safe for us to save the data now. */

	        $btnsx_data = array();

	        // Sanitize user input.
	        $btnsx_data = array(
	        	// Tab 
	        		'btnsx_tab' 						=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_tab'] ) ? $_POST['btnsx_opt_dual_tab'] : '' ),
	        	// General
		        	'btnsx_id' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_id'] ) ? $_POST['btnsx_opt_dual_id'] : '' ),
		        	'btnsx_button_first' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first'] ) ? $_POST['btnsx_opt_dual_button_first'] : '' ),
		        	'btnsx_button_second' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second'] ) ? $_POST['btnsx_opt_dual_button_second'] : '' ),
		        	'btnsx_button_full_width' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_full_width'] ) ? $_POST['btnsx_opt_dual_button_full_width'] : '' ),
		        	'btnsx_button_wrap_center' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_wrap_center'] ) ? $_POST['btnsx_opt_dual_button_wrap_center'] : '' ),
		        // Divider
		        	'btnsx_divider_enable' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_enable'] ) ? $_POST['btnsx_opt_dual_divider_enable'] : '' ),
		        	'btnsx_divider_type' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_type'] ) ? $_POST['btnsx_opt_dual_divider_type'] : '' ),
		        	'btnsx_divider_text' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_text'] ) ? $_POST['btnsx_opt_dual_divider_text'] : '' ),
		        	'btnsx_divider_icon' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_icon'] ) ? $_POST['btnsx_opt_dual_divider_icon'] : '' ),
		        	// 'btnsx_divider_style' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_style'] ) ? $_POST['btnsx_opt_dual_divider_style'] : '' ),
		        	'btnsx_divider_text_size' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_text_size'] ) ? $_POST['btnsx_opt_dual_divider_text_size'] : '' ),
		        	'btnsx_divider_width' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_width'] ) ? $_POST['btnsx_opt_dual_divider_width'] : '' ),
		        	'btnsx_divider_height' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_height'] ) ? $_POST['btnsx_opt_dual_divider_height'] : '' ),
		        	'btnsx_divider_position_left' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_position_left'] ) ? $_POST['btnsx_opt_dual_divider_position_left'] : '' ),
		        	'btnsx_divider_position_top' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_position_top'] ) ? $_POST['btnsx_opt_dual_divider_position_top'] : '' ),
		        	'btnsx_divider_text_position' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_text_position'] ) ? $_POST['btnsx_opt_dual_divider_text_position'] : '' ),
		        	'btnsx_divider_type' 				=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_type'] ) ? $_POST['btnsx_opt_dual_divider_type'] : '' ),
		        	'btnsx_divider_border' 				=> array(
		        		'size'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_size'] ) ? $_POST['btnsx_opt_dual_divider_border_size'] : '' ),
		        		'style'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_style'] ) ? $_POST['btnsx_opt_dual_divider_border_style'] : '' ),
		        		'color'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_color'] ) ? $_POST['btnsx_opt_dual_divider_border_color'] : '' ),
	            	),
	            	'btnsx_divider_border_radius' 		=> array(
		        		'top_left'		=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_radius_top_left'] ) ? $_POST['btnsx_opt_dual_divider_border_radius_top_left'] : '' ),
		        		'top_right'		=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_radius_top_right'] ) ? $_POST['btnsx_opt_dual_divider_border_radius_top_right'] : '' ),
		        		'bottom_left'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_radius_bottom_left'] ) ? $_POST['btnsx_opt_dual_divider_border_radius_bottom_left'] : '' ),
		        		'bottom_right'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_border_radius_bottom_right'] ) ? $_POST['btnsx_opt_dual_divider_border_radius_bottom_right'] : '' ),
	            	),
	            	'btnsx_divider_background_color' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_background_color'] ) ? $_POST['btnsx_opt_dual_divider_background_color'] : '' ),
	            	'btnsx_divider_text_color' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_divider_text_color'] ) ? $_POST['btnsx_opt_dual_divider_text_color'] : '' ),
	            // First Button
	            	'btnsx_button_first_link_type' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_type'] ) ? $_POST['btnsx_opt_dual_button_first_link_type'] : '' ),
	            	'btnsx_button_first_link_target' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_target'] ) ? $_POST['btnsx_opt_dual_button_first_link_target'] : '' ),
	            	'btnsx_button_first_link_relationship' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_relationship'] ) ? $_POST['btnsx_opt_dual_button_first_link_relationship'] : '' ),
	            	'btnsx_button_first_link_post' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_post'] ) ? $_POST['btnsx_opt_dual_button_first_link_post'] : '' ),
	            	'btnsx_button_first_link_menu' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_menu'] ) ? $_POST['btnsx_opt_dual_button_first_link_menu'] : '' ),
	            	'btnsx_button_first_link_menu_display' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_menu_display'] ) ? $_POST['btnsx_opt_dual_button_first_link_menu_display'] : '' ),
	            	'btnsx_button_first_link' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link'] ) ? $_POST['btnsx_opt_dual_button_first_link'] : '' ),
	            	'btnsx_button_first_link_edd_id' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_edd_id'] ) ? $_POST['btnsx_opt_dual_button_first_link_edd_id'] : '' ),
	            	'btnsx_button_first_link_redirect_url' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_redirect_url'] ) ? $_POST['btnsx_opt_dual_button_first_link_redirect_url'] : '' ),
	            	'btnsx_button_first_link_woocommerce_id' => sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_link_woocommerce_id'] ) ? $_POST['btnsx_opt_dual_button_first_link_woocommerce_id'] : '' ),
	            	'btnsx_button_first_padding' => array(
	            		'top'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_padding_top'] ) ? $_POST['btnsx_opt_dual_button_first_padding_top'] : '' ),
	            		'bottom'=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_padding_bottom'] ) ? $_POST['btnsx_opt_dual_button_first_padding_bottom'] : '' ),
	            		'left'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_padding_left'] ) ? $_POST['btnsx_opt_dual_button_first_padding_left'] : '' ),
	            		'right'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_first_padding_right'] ) ? $_POST['btnsx_opt_dual_button_first_padding_right'] : '' ),
	            	),
	            // Second Button
	            	'btnsx_button_second_link_type' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_type'] ) ? $_POST['btnsx_opt_dual_button_second_link_type'] : '' ),
	            	'btnsx_button_second_link_target' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_target'] ) ? $_POST['btnsx_opt_dual_button_second_link_target'] : '' ),
	            	'btnsx_button_second_link_relationship' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_relationship'] ) ? $_POST['btnsx_opt_dual_button_second_link_relationship'] : '' ),
	            	'btnsx_button_second_link_post' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_post'] ) ? $_POST['btnsx_opt_dual_button_second_link_post'] : '' ),
	            	'btnsx_button_second_link_menu' 		=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_menu'] ) ? $_POST['btnsx_opt_dual_button_second_link_menu'] : '' ),
	            	'btnsx_button_second_link_menu_display' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_menu_display'] ) ? $_POST['btnsx_opt_dual_button_second_link_menu_display'] : '' ),
	            	'btnsx_button_second_link' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link'] ) ? $_POST['btnsx_opt_dual_button_second_link'] : '' ),
	            	'btnsx_button_second_link_edd_id' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_edd_id'] ) ? $_POST['btnsx_opt_dual_button_second_link_edd_id'] : '' ),
	            	'btnsx_button_second_link_redirect_url' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_redirect_url'] ) ? $_POST['btnsx_opt_dual_button_second_link_redirect_url'] : '' ),
	            	'btnsx_button_second_link_woocommerce_id' => sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_link_woocommerce_id'] ) ? $_POST['btnsx_opt_dual_button_second_link_woocommerce_id'] : '' ),
	            	'btnsx_button_second_padding' => array(
	            		'top'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_padding_top'] ) ? $_POST['btnsx_opt_dual_button_second_padding_top'] : '' ),
	            		'bottom'=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_padding_bottom'] ) ? $_POST['btnsx_opt_dual_button_second_padding_bottom'] : '' ),
	            		'left'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_padding_left'] ) ? $_POST['btnsx_opt_dual_button_second_padding_left'] : '' ),
	            		'right'	=>	sanitize_text_field( isset( $_POST['btnsx_opt_dual_button_second_padding_right'] ) ? $_POST['btnsx_opt_dual_button_second_padding_right'] : '' ),
	            	),
	            // Preview
	            	'btnsx_preview_background' 			=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_preview_background'] ) ? $_POST['btnsx_opt_dual_preview_background'] : '' ),
	            	'btnsx_preview_background_image' 	=> array(
		            	'image' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_preview_background_image_image'] ) ? $_POST['btnsx_opt_dual_preview_background_image_image'] : '' ),
		            	'position' 							=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_preview_background_image_position'] ) ? $_POST['btnsx_opt_dual_preview_background_image_position'] : '' )
		            ),
		            'btnsx_preview_background_overlay' 	=> sanitize_text_field( isset( $_POST['btnsx_opt_dual_preview_background_overlay'] ) ? $_POST['btnsx_opt_dual_preview_background_overlay'] : '' ),
	        );

	        // Update the meta field in the database.
	        update_post_meta( $post_id, 'btnsx-dual', $btnsx_data );
	    }

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 1.7
	     */
	    public function options_callback( $post ) {

	        // Add an nonce field so we can check for it later.
	        	wp_nonce_field( 'btnsx-dual', 'btnsx_options_nonce' );

	        // Loader
	        	echo '<div class="btnsx"><div id="btnsx-options-loader" class="loader-inner ball-pulse"><div></div><div></div><div></div></div></div>';

	        // fetch buttons
		        global $wpdb;
			   	$btnsx_post = 'buttons-x';
				$btnsx_post_status = 'publish';
		        $btnsx = $wpdb->get_results( $wpdb->prepare(
		            "SELECT ID, post_title
		                FROM $wpdb->posts 
		                WHERE $wpdb->posts.post_type = %s
		                AND $wpdb->posts.post_status = %s
		                ORDER BY ID DESC",
		            $btnsx_post,
		            $btnsx_post_status
		        ) );
		        $btns = array();
		        foreach ( $btnsx as $btn ) {
					$btn_id = $btn->ID;
					$btn_name = $btn->post_title;
					$btns[$btn_name] = $btn_name;
				}
			// fetch woo products
				$woo = 'product';
				$woo_status = 'publish';
		        $woo_links = $wpdb->get_results( $wpdb->prepare(
		            "SELECT ID, post_title
		                FROM $wpdb->posts 
		                WHERE $wpdb->posts.post_type = %s
		                AND $wpdb->posts.post_status = %s
		                ORDER BY ID DESC",
		            $woo,
		            $woo_status
		        ) );
		        $woo_products = array();
		        if( class_exists('WooCommerce') ){
			        foreach ( $woo_links as $product ) {
						$product_id = $product->ID;
						$product_name = $product->post_title;
						$woo_products[$product_id] = $product_name;
					}
				}

	        /*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        // $meta_values = array();
	        // $meta_values = get_post_meta( $post->ID, 'btnsx-dual', false );

	        // tab
				echo '<input type="hidden" id="btnsx_opt_dual_tab" name="btnsx_opt_dual_tab" value="' . $this->meta_values( $post->ID, array( 'field' => 'btnsx_tab', 'value' => '0' ) ) . '">';

        	$btnsx_form_design = new BtnsxFormDesign();
        	$btnsx_default_options = array(
        		array(
					'icon_class'	=>	'fa fa-object-ungroup',
					'text'			=>	__( 'Buttons', 'btnsx' ),
					'elements'	=>	array(
						array(
							'type'			=>	'hidden',
							'id'			=>	'btnsx_opt_dual_id',
							'name'			=>	'btnsx_opt_dual_id',
							'label'			=>	__( 'ID', 'btnsx' ),
							'value'			=>	$post->ID
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_dual_button_first',
							'name'			=>	'btnsx_opt_dual_button_first',
							'placeholder'	=>	__( 'Choose first button', 'btnsx' ),
							'label'			=>	__( 'First Button', 'btnsx' ),
							'tooltip'		=>	__( 'Select the button that would appear first.', 'btnsx' ),
							'options'		=>	$btns,
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first' ) )
						),
						array(
							'type'			=>	'select',
							'id'			=>	'btnsx_opt_dual_button_second',
							'name'			=>	'btnsx_opt_dual_button_second',
							'placeholder'	=>	__( 'Choose second button', 'btnsx' ),
							'label'			=>	__( 'Second Button', 'btnsx' ),
							'tooltip'		=>	__( 'Select the button that would appear second.', 'btnsx' ),
							'options'		=>	$btns,
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_dual_button_full_width',
							'name'			=>	'btnsx_opt_dual_button_full_width',
							'label'			=>	__( 'Force Full Width', 'btnsx' ),
							'tooltip'		=>	__( 'Make the dual button cover full container width.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_full_width', 'value' => '0' ) )
						),
						array(
							'type'			=>	'checkbox',
							'id'			=>	'btnsx_opt_dual_button_wrap_center',
							'name'			=>	'btnsx_opt_dual_button_wrap_center',
							'label'			=>	__( 'Wrap Center', 'btnsx' ),
							'tooltip'		=>	__( 'Makes the button centered. Very helpful when you want the button to be centered inside a big container.', 'btnsx' ),
							'class'			=>	'btnsx-checkbox',
							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_wrap_center', 'value' => '0' ) )
						)
					)
				),
        		array(
					'icon_class'	=>	'fa fa-smile-o',
					'text'			=>	__( 'Divider', 'btnsx' ),
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Main', 'btnsx' ),
							'id'			=>	'btnsx_dual_main_collapsible',
							'elements'		=>	array(
								array(
									'type'			=>	'checkbox',
									'id'			=>	'btnsx_opt_dual_divider_enable',
									'name'			=>	'btnsx_opt_dual_divider_enable',
									'label'			=>	__( 'Enable', 'btnsx' ),
									'tooltip'		=>	__( 'Enable buttons divider.', 'btnsx' ),
									'class'			=>	'btnsx-checkbox',
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_enable', 'value' => '1' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_divider_type',
									'name'			=>	'btnsx_opt_dual_divider_type',
									'placeholder'	=>	__( 'Choose divider type', 'btnsx' ),
									'label'			=>	__( 'Divider Type', 'btnsx' ),
									'tooltip'		=>	__( 'Select the type of divider for dual button.', 'btnsx' ),
									'options'		=>	array(
										'text'			=> __( 'Text', 'btnsx' ),
										'icon'			=> __( 'Icon', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_type', 'value' => 'text' ) )
								),
								array(
									'type'			=>	'text',
									'id'			=>	'btnsx_opt_dual_divider_text',
									'name'			=>	'btnsx_opt_dual_divider_text',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Divider Text', 'btnsx' ),
									'tooltip'		=>	__( 'Select the desired text.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_text', 'value' => __('OR','btnsx') ) )
								),
								array(
									'type'			=>	'icon',
									'id'			=>	'btnsx_opt_dual_divider_icon',
									'name'			=>	'btnsx_opt_dual_divider_icon',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Divider Icon', 'btnsx' ),
									'tooltip'		=>	__( 'Select the desired icon.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_icon', 'value' => 'fa fa-adjust' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_divider_style',
									'name'			=>	'btnsx_opt_dual_divider_style',
									'placeholder'	=>	__( 'Choose divider style', 'btnsx' ),
									'label'			=>	__( 'Divider Style', 'btnsx' ),
									'tooltip'		=>	__( 'Select the style of divider for dual button.', 'btnsx' ),
									'options'		=>	array(
										'custom'		=> __( 'Custom', 'btnsx' ),
										'style_1'		=> __( 'Style 1', 'btnsx' ),
										'style_2'		=> __( 'Style 2', 'btnsx' ),
										'style_3'		=> __( 'Style 3', 'btnsx' ),
										'style_4'		=> __( 'Style 4', 'btnsx' ),
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_style', 'value' => 'style_1' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_dual_divider_text_size',
									'name'			=>	'btnsx_opt_dual_divider_text_size',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Text/Icon Size', 'btnsx' ),
									'tooltip'		=>	__( 'Add text/icon size in pixels.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_text_size', 'value' => '10' ) )
								),
							)
						),
						array(
							'text'			=>	__( 'Layout', 'btnsx' ),
							'id'			=>	'btnsx_dual_layout_collapsible',
							'elements'		=>	array(
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_dual_divider_width',
									'name'			=>	'btnsx_opt_dual_divider_width',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Divider Width', 'btnsx' ),
									'tooltip'		=>	__( 'Add width in pixels.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_width', 'value' => '34' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_dual_divider_height',
									'name'			=>	'btnsx_opt_dual_divider_height',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Divider Height', 'btnsx' ),
									'tooltip'		=>	__( 'Add height in pixels.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_height', 'value' => '34' ) )
								),
							)
						),
						array(
							'text'			=>	__( 'Positioning', 'btnsx' ),
							'id'			=>	'btnsx_dual_positioning_collapsible',
							'elements'		=>	array(
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_dual_divider_position_left',
									'name'			=>	'btnsx_opt_dual_divider_position_left',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Horizontal Position', 'btnsx' ),
									'tooltip'		=>	__( 'Position the divider from left in pixels. Negative values are allowed.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_position_left', 'value' => '-18' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_dual_divider_position_top',
									'name'			=>	'btnsx_opt_dual_divider_position_top',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Vertical Position', 'btnsx' ),
									'tooltip'		=>	__( 'Position the divider from top in pixels. Negative values are allowed.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_position_top', 'value' => '9' ) )
								),
								array(
									'type'			=>	'range',
									'id'			=>	'btnsx_opt_dual_divider_text_position',
									'name'			=>	'btnsx_opt_dual_divider_text_position',
									'placeholder'	=>	' ',
									'label'			=>	__( 'Divider Text Position', 'btnsx' ),
									'min'			=>	'0',
									'max'			=>	'10',
									'step'			=>	'0.1',
									'tooltip'		=>	__( 'Position the text vertically.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_text_position', 'value' => '3.3' ) )
								),
							)
						),
						array(
							'text'			=>	__( 'Border', 'btnsx' ),
							'id'			=>	'btnsx_dual_border_collapsible',
							'elements'		=>	array(
								array(
								    'type'			=>	'border',
								    'id'			=>	'btnsx_opt_dual_divider_border',
								    'name'			=>	'btnsx_opt_dual_divider_border',
								    'placeholder'	=>	' ',
								    'tooltip'		=>	array(
										'size'			=>	__( 'Set border size in pixels.', 'btnsx' ),
										'style'			=>	__( 'Set border style.', 'btnsx' ),
										'color'			=>	__( 'Set border color.', 'btnsx' )
									),
								    'value' 		=> array(
								    	'size' 			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border', 'field2' => 'size', 'value' => '0' ) ),
								    	'style' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border', 'field2' => 'style', 'value' => 'none' ) ),
								    	'color' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border', 'field2' => 'color' ) )
								    )
							    )
							)
						),
						array(
							'text'			=>	__( 'Border Radius', 'btnsx' ),
							'id'			=>	'btnsx_dual_border_radius_collapsible',
							'elements'		=>	array(
							    array(
								    'type'		=>	'radius',
								    'id'		=>	'btnsx_opt_dual_divider_border_radius',
								    'name'		=>	'btnsx_opt_dual_divider_border_radius',
								    'tooltip'		=>	array(
								    	'all'				=>	__( 'Set radius for all corners at once.', 'btnsx' ),
										'top_left'			=>	__( 'Set top left border radius in pixels.', 'btnsx' ),
										'top_right'			=>	__( 'Set top right border radius in pixels.', 'btnsx' ),
										'bottom_left'		=>	__( 'Set bottom left border radius in pixels.', 'btnsx' ),
										'bottom_right'		=>	__( 'Set bottom right border radius in pixels.', 'btnsx' )
									),
								    'value' 	=> array(
								    	'top_left' 		=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'top_left', 'value' => '50' ) ),
								    	'top_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'top_right', 'value' => '50' ) ),
								    	'bottom_left' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'bottom_left', 'value' => '50' ) ),
								    	'bottom_right' 	=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_border_radius', 'field2' => 'bottom_right', 'value' => '50' ) )
								    )
							    ),
							)
						),
						array(
							'text'			=>	__( 'Color', 'btnsx' ),
							'id'			=>	'btnsx_dual_color_collapsible',
							'elements'		=>	array(
							    array(
	    							'type'			=>	'color',
	    							'id'			=>	'btnsx_opt_dual_divider_background_color',
	    							'name'			=>	'btnsx_opt_dual_divider_background_color',
	    							'placeholder'	=>	' ',
	    							'label'			=>	__( 'Background Color.', 'btnsx' ),
	    							'tooltip'		=>	__( 'Set divider background colour.', 'btnsx' ),
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_background_color', 'value' => '#fff' ) ),
	    						),
	    						array(
	    							'type'			=>	'color',
	    							'id'			=>	'btnsx_opt_dual_divider_text_color',
	    							'name'			=>	'btnsx_opt_dual_divider_text_color',
	    							'placeholder'	=>	' ',
	    							'label'			=>	__( 'Text/Icon Color.', 'btnsx' ),
	    							'tooltip'		=>	__( 'Set divider text/icon colour.', 'btnsx' ),
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_divider_text_color', 'value' => '#444' ) ),
	    						)
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fa fa-check-square-o',
					'text'			=>	__( 'First Button', 'btnsx' ),
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Link', 'btnsx' ),
							'id'			=>	'btnsx_dual_button_first_link_collapsible',
							'elements'		=>	array(
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_first_link_type',
									'name'			=>	'btnsx_opt_dual_button_first_link_type',
									'placeholder'	=>	__( 'Choose type', 'btnsx' ),
									'label'			=>	__( 'Type', 'btnsx' ),
									'tooltip'		=>	__( 'Choose the type of link required for the button.', 'btnsx' ),
									'options'		=>	array(
										'none'									=> __( 'None', 'btnsx' ),
										'admin_page'							=> __( 'Admin Page', 'btnsx' ),
										'back_to_top'							=> __( 'Back To Top', 'btnsx' ),
										'edd_checkout'							=> __( 'EDD - Checkout', 'btnsx' ),
										'edd_straight_to_gateway'				=> __( 'EDD - Straight to Gateway', 'btnsx' ),
										'home_page'								=> __( 'Home Page', 'btnsx' ),
										'login'									=> __( 'Login Page', 'btnsx' ),
										'login_redirect_current_page'			=> __( 'Login - Redirect to Current Page', 'btnsx' ),
										'login_redirect_home_page'				=> __( 'Login - Redirect to Home Page', 'btnsx' ),
										'login_redirect_custom_page'			=> __( 'Login - Redirect to Custom Page', 'btnsx' ),
										'logout'								=> __( 'Logout Page', 'btnsx' ),
										'logout_redirect_current_page'			=> __( 'Logout - Redirect to Current Page', 'btnsx' ),
										'logout_redirect_home_page'				=> __( 'Logout - Redirect to Home Page', 'btnsx' ),
										'logout_redirect_custom_page'			=> __( 'Logout - Redirect to Custom Page', 'btnsx' ),
										'lost_password'							=> __( 'Lost Password Page', 'btnsx' ),
										'lost_password_redirect_current_page'	=> __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
										'lost_password_redirect_home_page'		=> __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
										'lost_password_redirect_custom_page'	=> __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
										'menu'									=> __( 'Menu', 'btnsx' ),
										'post'									=> __( 'Post/Page/CPT', 'btnsx' ),
										'previous_page'							=> __( 'Previous Page', 'btnsx' ),
										'register'								=> __( 'Registration Page', 'btnsx' ),
										'url'									=> __( 'URL', 'btnsx' ),
										'woocommerce_add_to_cart'				=> __( 'Woocommerce -  Add to Cart', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_type' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_first_link_target',
									'name'			=>	'btnsx_opt_dual_button_first_link_target',
									'placeholder'	=>	__( 'Choose target', 'btnsx' ),
									'label'			=>	__( 'Target', 'btnsx' ),
									'tooltip'		=>	__( 'Where would you like to open the new link? New window or Same Window?', 'btnsx' ),
									'options'		=>	array(
										'new_window'	=> __( 'New Window', 'btnsx' ),
										'same_window'	=> __( 'Same Window', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_target' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_first_link_relationship',
									'name'			=>	'btnsx_opt_dual_button_first_link_relationship',
									'placeholder'	=>	__( 'Choose relationship', 'btnsx' ),
									'label'			=>	__( 'Relationship', 'btnsx' ),
									'tooltip'		=>	__( 'It species the relationship between the current document and linked document/resource. Alternate - Links to an alternate version of the document. Author - Links to author of the document. Bookmark - Permanent URL used for bookmarking. Help - Links to a help doument. License - Links to copyright information for the document. Next - The next document in a selection. Nofollow - Links to an unendorsed document, like a paid link. No Referrer - Specifies that the browser should not send a HTTP referer header if the user follows the hyperlink. Prefetch - Specifies that the target document should be cached. Previous - The previous document in a selection. Search - Links to a search tool for the document. Tag - A tag (keyword) for the current document.', 'btnsx' ),
									'options'		=>	array(
										''				=> __( 'None', 'btnsx' ),
										'alternate'		=> __( 'Alternate', 'btnsx' ),
										'author'		=> __( 'Author', 'btnsx' ),
										'bookmark'		=> __( 'Bookmark', 'btnsx' ),
										'help'			=> __( 'Help', 'btnsx' ),
										'license'		=> __( 'License', 'btnsx' ),
										'next'			=> __( 'Next', 'btnsx' ),
										'nofollow'		=> __( 'Nofollow', 'btnsx' ),
										'noreferrer'	=> __( 'No Referrer', 'btnsx' ),
										'prefetch'		=> __( 'Prefetch', 'btnsx' ),
										'prev'			=> __( 'Previous', 'btnsx' ),
										'search'		=> __( 'Search', 'btnsx' ),
										'tag'			=> __( 'Tag', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_relationship' ) )
								),
								array(
									'type'			=>	'postlinks',
									'id'			=>	'btnsx_opt_dual_button_first_link_post',
									'name'			=>	'btnsx_opt_dual_button_first_link_post',
									'placeholder'	=>	__( 'Choose post', 'btnsx' ),
									'label'			=>	__( 'Post/Page/CPT', 'btnsx' ),
									'tooltip'		=>	__( 'Select a post, page or custom post type.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_post' ) )
								),
								array(
									'type'			=>	'menu',
									'id'			=>	'btnsx_opt_dual_button_first_link_menu',
									'name'			=>	'btnsx_opt_dual_button_first_link_menu',
									'placeholder'	=>	__( 'Choose menu', 'btnsx' ),
									'label'			=>	__( 'Menu as Dropdown', 'btnsx' ),
									'tooltip'		=>	__( 'Select a menu. These are the menus created under Appearance -> Menu.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_menu' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_first_link_menu_display',
									'name'			=>	'btnsx_opt_dual_button_first_link_menu_display',
									'placeholder'	=>	__( 'Choose When To Display', 'btnsx' ),
									'label'			=>	__( 'Menu Display', 'btnsx' ),
									'tooltip'		=>	__( 'Select whether to display menu <strong>on button click</strong> or <strong>on button hover</strong>.', 'btnsx' ),
									'options'		=>	array(
										'on_click'	=> __( 'On Click', 'btnsx' ),
										'on_hover'  => __( 'On Hover', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_menu_display' ) )
								),
								array(
									'type'			=>	'text',
									'id'			=>	'btnsx_opt_dual_button_first_link',
									'name'			=>	'btnsx_opt_dual_button_first_link',
									'placeholder'	=>	' ',
									'label'			=>	__( 'URL', 'btnsx' ),
									'tooltip'		=>	__( 'Add a custom URL.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link' ) )
								),
							    array(
								    'type'			=>	'edd',
								    'id'			=>	'btnsx_opt_dual_button_first_link_edd_id',
								    'name'			=>	'btnsx_opt_dual_button_first_link_edd_id',
								    'placeholder'	=>	__( 'Choose download id', 'btnsx' ),
								    'label'			=>	__( 'EDD Download ID', 'btnsx' ),
								    'tooltip'		=>	__( 'Select Easy Digital Downloads download ID.', 'btnsx' ),
								    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_edd_id' ) )
							    ),
							    array(
								    'type'			=>	'text',
								    'id'			=>	'btnsx_opt_dual_button_first_link_redirect_url',
								    'name'			=>	'btnsx_opt_dual_button_first_link_redirect_url',
								    'placeholder'	=>	__( '/my-page', 'btnsx' ),
								    'label'			=>	__( 'Redirect URL', 'btnsx' ),
								    'tooltip'		=>	__( 'Only add the last part of the url where you would like to redirect user. If the full URL is http://wwww.example.com/my-page/ then only add /my-page/ in this field. The other part of the URL is computed automatically.', 'btnsx' ),
								    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_redirect_url' ) )
							    ),
							    array(
								    'type'			=>	'select',
								    'id'			=>	'btnsx_opt_dual_button_first_link_woocommerce_id',
								    'name'			=>	'btnsx_opt_dual_button_first_link_woocommerce_id',
								    'placeholder'	=>	__( 'Choose product id', 'btnsx' ),
								    'label'			=>	__( 'WooCommerce Product ID', 'btnsx' ),
								    'tooltip'		=>	__( 'Select a Woocommerce product ID.', 'btnsx' ),
								    'options'		=>	$woo_products,
								    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_link_woocommerce_id' ) )
							    )
							)
						),
						array(
							'text'			=>	__( 'Padding', 'btnsx' ),
							'elements'		=> array(
								array(
        							'type'			=>	'trbl',
        							'id'			=>	'btnsx_opt_dual_button_first_padding',
        							'name'			=>	'btnsx_opt_dual_button_first_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for first button.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for first button.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for first button.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for first button.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'top' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'bottom' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'left' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_first_padding', 'field2' => 'right' ) )
	    							)
        						)
							)
						)
					)
				),
				array(
					'icon_class'	=>	'fa fa-check-square-o',
					'text'			=>	__( 'Second Button', 'btnsx' ),
					'inner_group'	=>	array(
						array(
							'text'			=>	__( 'Link', 'btnsx' ),
							'id'			=>	'btnsx_dual_button_second_link_collapsible',
							'elements'		=>	array(
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_second_link_type',
									'name'			=>	'btnsx_opt_dual_button_second_link_type',
									'placeholder'	=>	__( 'Choose type', 'btnsx' ),
									'label'			=>	__( 'Type', 'btnsx' ),
									'tooltip'		=>	__( 'Choose the type of link required for the button.', 'btnsx' ),
									'options'		=>	array(
										'none'									=> __( 'None', 'btnsx' ),
										'admin_page'							=> __( 'Admin Page', 'btnsx' ),
										'back_to_top'							=> __( 'Back To Top', 'btnsx' ),
										'edd_checkout'							=> __( 'EDD - Checkout', 'btnsx' ),
										'edd_straight_to_gateway'				=> __( 'EDD - Straight to Gateway', 'btnsx' ),
										'home_page'								=> __( 'Home Page', 'btnsx' ),
										'login'									=> __( 'Login Page', 'btnsx' ),
										'login_redirect_current_page'			=> __( 'Login - Redirect to Current Page', 'btnsx' ),
										'login_redirect_home_page'				=> __( 'Login - Redirect to Home Page', 'btnsx' ),
										'login_redirect_custom_page'			=> __( 'Login - Redirect to Custom Page', 'btnsx' ),
										'logout'								=> __( 'Logout Page', 'btnsx' ),
										'logout_redirect_current_page'			=> __( 'Logout - Redirect to Current Page', 'btnsx' ),
										'logout_redirect_home_page'				=> __( 'Logout - Redirect to Home Page', 'btnsx' ),
										'logout_redirect_custom_page'			=> __( 'Logout - Redirect to Custom Page', 'btnsx' ),
										'lost_password'							=> __( 'Lost Password Page', 'btnsx' ),
										'lost_password_redirect_current_page'	=> __( 'Lost Password - Redirect to Current Page', 'btnsx' ),
										'lost_password_redirect_home_page'		=> __( 'Lost Password - Redirect to Home Page', 'btnsx' ),
										'lost_password_redirect_custom_page'	=> __( 'Lost Password - Redirect to Custom Page', 'btnsx' ),
										'menu'									=> __( 'Menu', 'btnsx' ),
										'post'									=> __( 'Post/Page/CPT', 'btnsx' ),
										'previous_page'							=> __( 'Previous Page', 'btnsx' ),
										'register'								=> __( 'Registration Page', 'btnsx' ),
										'url'									=> __( 'URL', 'btnsx' ),
										'woocommerce_add_to_cart'				=> __( 'Woocommerce -  Add to Cart', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_type' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_second_link_target',
									'name'			=>	'btnsx_opt_dual_button_second_link_target',
									'placeholder'	=>	__( 'Choose target', 'btnsx' ),
									'label'			=>	__( 'Target', 'btnsx' ),
									'tooltip'		=>	__( 'Where would you like to open the new link? New window or Same Window?', 'btnsx' ),
									'options'		=>	array(
										'new_window'	=> __( 'New Window', 'btnsx' ),
										'same_window'	=> __( 'Same Window', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_target' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_second_link_relationship',
									'name'			=>	'btnsx_opt_dual_button_second_link_relationship',
									'placeholder'	=>	__( 'Choose relationship', 'btnsx' ),
									'label'			=>	__( 'Relationship', 'btnsx' ),
									'tooltip'		=>	__( 'It species the relationship between the current document and linked document/resource. Alternate - Links to an alternate version of the document. Author - Links to author of the document. Bookmark - Permanent URL used for bookmarking. Help - Links to a help doument. License - Links to copyright information for the document. Next - The next document in a selection. Nofollow - Links to an unendorsed document, like a paid link. No Referrer - Specifies that the browser should not send a HTTP referer header if the user follows the hyperlink. Prefetch - Specifies that the target document should be cached. Previous - The previous document in a selection. Search - Links to a search tool for the document. Tag - A tag (keyword) for the current document.', 'btnsx' ),
									'options'		=>	array(
										''				=> __( 'None', 'btnsx' ),
										'alternate'		=> __( 'Alternate', 'btnsx' ),
										'author'		=> __( 'Author', 'btnsx' ),
										'bookmark'		=> __( 'Bookmark', 'btnsx' ),
										'help'			=> __( 'Help', 'btnsx' ),
										'license'		=> __( 'License', 'btnsx' ),
										'next'			=> __( 'Next', 'btnsx' ),
										'nofollow'		=> __( 'Nofollow', 'btnsx' ),
										'noreferrer'	=> __( 'No Referrer', 'btnsx' ),
										'prefetch'		=> __( 'Prefetch', 'btnsx' ),
										'prev'			=> __( 'Previous', 'btnsx' ),
										'search'		=> __( 'Search', 'btnsx' ),
										'tag'			=> __( 'Tag', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_relationship' ) )
								),
								array(
									'type'			=>	'postlinks',
									'id'			=>	'btnsx_opt_dual_button_second_link_post',
									'name'			=>	'btnsx_opt_dual_button_second_link_post',
									'placeholder'	=>	__( 'Choose post', 'btnsx' ),
									'label'			=>	__( 'Post/Page/CPT', 'btnsx' ),
									'tooltip'		=>	__( 'Select a post, page or custom post type.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_post' ) )
								),
								array(
									'type'			=>	'menu',
									'id'			=>	'btnsx_opt_dual_button_second_link_menu',
									'name'			=>	'btnsx_opt_dual_button_second_link_menu',
									'placeholder'	=>	__( 'Choose menu', 'btnsx' ),
									'label'			=>	__( 'Menu as Dropdown', 'btnsx' ),
									'tooltip'		=>	__( 'Select a menu. These are the menus created under Appearance -> Menu.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_menu' ) )
								),
								array(
									'type'			=>	'select',
									'id'			=>	'btnsx_opt_dual_button_second_link_menu_display',
									'name'			=>	'btnsx_opt_dual_button_second_link_menu_display',
									'placeholder'	=>	__( 'Choose When To Display', 'btnsx' ),
									'label'			=>	__( 'Menu Display', 'btnsx' ),
									'tooltip'		=>	__( 'Select whether to display menu <strong>on button click</strong> or <strong>on button hover</strong>.', 'btnsx' ),
									'options'		=>	array(
										'on_click'	=> __( 'On Click', 'btnsx' ),
										'on_hover'  => __( 'On Hover', 'btnsx' )
									),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_menu_display' ) )
								),
								array(
									'type'			=>	'text',
									'id'			=>	'btnsx_opt_dual_button_second_link',
									'name'			=>	'btnsx_opt_dual_button_second_link',
									'placeholder'	=>	' ',
									'label'			=>	__( 'URL', 'btnsx' ),
									'tooltip'		=>	__( 'Add a custom URL.', 'btnsx' ),
									'value'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link' ) )
								),
							    array(
								    'type'			=>	'edd',
								    'id'			=>	'btnsx_opt_dual_button_second_link_edd_id',
								    'name'			=>	'btnsx_opt_dual_button_second_link_edd_id',
								    'placeholder'	=>	__( 'Choose download id', 'btnsx' ),
								    'label'			=>	__( 'EDD Download ID', 'btnsx' ),
								    'tooltip'		=>	__( 'Select Easy Digital Downloads download ID.', 'btnsx' ),
								    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_edd_id' ) )
							    ),
							    array(
								    'type'			=>	'text',
								    'id'			=>	'btnsx_opt_dual_button_second_link_redirect_url',
								    'name'			=>	'btnsx_opt_dual_button_second_link_redirect_url',
								    'placeholder'	=>	__( '/my-page', 'btnsx' ),
								    'label'			=>	__( 'Redirect URL', 'btnsx' ),
								    'tooltip'		=>	__( 'Only add the last part of the url where you would like to redirect user. If the full URL is http://wwww.example.com/my-page/ then only add /my-page/ in this field. The other part of the URL is computed automatically.', 'btnsx' ),
								    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_redirect_url' ) )
							    ),
							    array(
								    'type'			=>	'select',
								    'id'			=>	'btnsx_opt_dual_button_second_link_woocommerce_id',
								    'name'			=>	'btnsx_opt_dual_button_second_link_woocommerce_id',
								    'placeholder'	=>	__( 'Choose product id', 'btnsx' ),
								    'label'			=>	__( 'WooCommerce Product ID', 'btnsx' ),
								    'tooltip'		=>	__( 'Select a Woocommerce product ID.', 'btnsx' ),
								    'options'		=>	$woo_products,
								    'value'			=> $this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_link_woocommerce_id' ) )
							    )
							)
						),
						array(
							'text'			=>	__( 'Padding', 'btnsx' ),
							'elements'		=> array(
								array(
        							'type'			=>	'trbl',
        							'id'			=>	'btnsx_opt_dual_button_second_padding',
        							'name'			=>	'btnsx_opt_dual_button_second_padding',
        							'placeholder'	=>	'',
        							'tooltip'		=>	array(
        								'all'			=>	__( 'Set padding for all sides. This field is not saved. It should be used to apply same padding value to all sides.', 'btnsx' ),
        								'top'			=>	__( 'Set top padding for first button.', 'btnsx' ),
        								'bottom'		=>	__( 'Set bottom padding for first button.', 'btnsx' ),
        								'left'			=>	__( 'Set left padding for first button.', 'btnsx' ),
        								'right'			=>	__( 'Set right padding for first button.', 'btnsx' ),
        							),
        							'value'			=>	array(
	    								'top'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'top' ) ),
	    								'bottom'		=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'bottom' ) ),
	    								'left'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'left' ) ),
	    								'right'			=>	$this->meta_values( $post->ID, array( 'field' => 'btnsx_button_second_padding', 'field2' => 'right' ) )
	    							)
        						)
							)
						)
					)
				),
	        );

			// filter to add custom options
        	$btnsx_filtered_options = apply_filters( 'btnsx_dual_options_filter', array(), $btnsx_default_options );
        	$btnsx_options = wp_parse_args( $btnsx_filtered_options, $btnsx_default_options );
        	$btnsx_form_design->tabs(
        		array(
        			'id'			=>	'btnsx-tabs',
        			'outer_group'	=>	$btnsx_options
        		)
        	);
	    }

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 1.7
	     */
	    public function preview_callback( $post ) {
	    	$btnsx_settings = array(
	    		'material_admin_theme' => false,
	    		'wp_admin_theme' => true,
	    	);
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	    	if( $btnsx_settings['material_admin_theme'] == true ) :
	        ?>
	        <!-- Material Style For Admin Page -->
	        <style>
	        	/*#poststuff h3 {
				  background-color: #ee6e73;
				  color: #fff;
				}*/
				.accordion-section-title:after, .handlediv, .item-edit, .sidebar-name-arrow, .widget-action {
				  color: #fff;
				}
				.wp-core-ui .button-primary {
				  background: #26a69a;
				  border-color: #26a69a;
				  -webkit-box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
				  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.16), 0 2px 10px 0 rgba(0, 0, 0, 0.12);
				  color: #fff;
				  text-decoration: none;
				}
				.wp-core-ui .button-primary.focus, .wp-core-ui .button-primary.hover, .wp-core-ui .button-primary:focus, .wp-core-ui .button-primary:hover {
				  background: #2bbbad;
				  border-color: #2bbbad;
				  -webkit-box-shadow: 0 5px 11px 0 rgba(0, 0, 0, 0.18), 0 4px 15px 0 rgba(0, 0, 0, 0.15);
				  box-shadow: 0 5px 11px 0 rgba(0, 0, 0, 0.18), 0 4px 15px 0 rgba(0, 0, 0, 0.15);
				  color: #fff;
				}
				.btnsx-tabs nav li.tab-current a {
				  color: #ee6e73;
				}
				#all-plugins-table .plugins a.delete, #media-items a.delete, #media-items a.delete-permanently, #nav-menu-footer .menu-delete, #search-plugins-table .plugins a.delete, .plugins a.delete, .row-actions span.delete a, .row-actions span.spam a, .row-actions span.trash a, .submitbox .submitdelete {
				  color: #ee6e73;
				}
	        </style>
	        <?php
	        endif;
	        if( $btnsx_settings['wp_admin_theme'] == true ) :
	        ?>
	        <style>
	        	#poststuff .inside {
					min-height: 42px;
				}
				.btnsx-tabs nav li.tab-current a {
				  color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
				.ball-pulse>div {
				  background-color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
				.btnsx .collapsible-header.active i {
					color: <?php echo $_wp_admin_css_colors[$current_color]->colors[3]; ?>;
				}
	        </style>
	        <?php 
	        endif;
	        ?>
	        <!-- Overlay -->
	        <div id="btnsx-preview-overlay"></div>
	        <!-- Loader -->
	        <div id="btnsx-preview-loader" class="loader-inner ball-pulse">
        		<div></div>
        		<div></div>
        		<div></div>
        	</div>
        	<!-- Dual Button -->
        	<style type="text/css" id="btnsx-preview-dual-css" scoped></style>
	        <div id="btnsx-dual-preview-container" class="btnsx btnsx-dual-btn" style="font-size:0;display:none;position:relative;">
	        	<a class="btnsx-btn btnsx-dual-first btnsx-dual-placeholder-first" href="" style=""><?php _e('Placeholder','btnsx'); ?></a>
	        	<span id="btnsx-dual-divider" class="btnsx-dual-divider" style=""><?php _e('OR','btnsx'); ?></span>
	        	<a class="btnsx-btn btnsx-dual-second btnsx-dual-placeholder-second" href="" style=""><?php _e('Placeholder','btnsx'); ?></a>
	        </div>
	       	
	    	<?php
	    }

	    /**
		 * Fetch meta values
		 * @since  0.1
		 * @param  int   	$post_id ID for the current post/page.
		 * @param  array    $params 
		 * @return string
		 */
		public function meta_values( $post_id, $params = array( 'field' => '', 'field2' => '', 'value' => '' ) ) {
			/*
	         * Use get_post_meta() to retrieve an existing value
	         * from the database and use the value for the form.
	         */
	        $meta_values = array();
	        $meta_values = get_post_meta( $post_id, 'btnsx-dual', true );

	        // meta key value
	        $field = isset( $params['field'] ) ? $params['field'] : '';
	        // meta key value in case stored as an array
	        $field2 = isset( $params['field2'] ) ? $params['field2'] : '';
	        // value in case meta value is not defined
	        $value = isset( $params['value'] ) ? $params['value'] : '';

	        // Based on defined parameters set value
	        if ( $field != '' && $field2 == '' ){
	        	$meta_value = isset( $meta_values[$field] ) ? $meta_values[$field] : $value;
	        } elseif ( $field != '' && $field2 != '' ) {
	        	$meta_value = isset( $meta_values[$field][$field2] ) ? $meta_values[$field][$field2] : $value;
	        } else {
	        	$meta_value = '';
	        }

	        return $meta_value;
		}

		/**
		 * Enqueue Admin Scripts
		 * @since 1.7
		 */
		public function admin_enqueue_scripts() {
			$screen = get_current_screen();
			// Admin Scripts
			if ( in_array( $screen->id, array( 'buttons-x-dual' ) ) ) {
				wp_register_script(
					'btnsx' . '-view-dual-js',
					BTNSX__PLUGIN_URL . 'assets/js/admin/view-dual.js',
					array('jquery'),
					BTNSX__VERSION,
					false
				);
				// wp_enqueue_script( 'btnsx' . '-view-dual-js' );
				wp_register_script(
					'btnsx' . '-public-admin',
					BTNSX__PLUGIN_URL . 'assets/js/public/btnsx.js',
					array('jquery'),
					BTNSX__VERSION,
					false
				);
				// wp_enqueue_script( 'btnsx' . '-public-admin' );
			}
			if ( in_array( $screen->id, array( 'buttons-x-dual','edit-buttons-x-dual' ) ) ) {
				// $upload_dir = wp_upload_dir();
				// if( is_ssl() ){
			 //  		$upload_dir = str_ireplace('http', 'https', $upload_dir);
			 //  	}
				// global $btnsx_settings; global $wp_filesystem;
				// if( isset( $btnsx_settings['css'] ) && $btnsx_settings['css'] === 'external' ){
				// 	wp_enqueue_style(
				// 		'btnsx' . '-dynamic',
				// 		trailingslashit( $upload_dir['baseurl'] ) . 'btnsx/dynamic.css',
				// 		array(),
				// 		BTNSX__VERSION
				// 	);
				// }
			}
		}

	    /**
         * Button update messages.
         * @since  0.1
         * @param  array    $messages
         * @return array
         */
		public function updated_messages( $messages ) {
			$post             = get_post();
			$post_type        = get_post_type( $post );
			$post_type_object = get_post_type_object( $post_type );
			$messages['buttons-x-dual'] = array(
				0  => '', // Unused. Messages start at index 1.
				1  => __( 'Dual button updated.', 'btnsx' ),
				2  => __( 'Custom field updated.', 'btnsx' ),
				3  => __( 'Custom field deleted.', 'btnsx' ),
				4  => __( 'Dual button updated.', 'btnsx' ),
				/* translators: %s: date and time of the revision */
				5  => isset( $_GET['revision'] ) ? sprintf( __( 'Dual button restored to revision from %s', 'btnsx' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
				6  => __( 'Dual button published.', 'btnsx' ),
				7  => __( 'Dual button saved.', 'btnsx' ),
				8  => __( 'Dual button submitted.', 'btnsx' ),
				9  => sprintf(
					__( 'Dual button scheduled for: <strong>%1$s</strong>.', 'btnsx' ),
					// translators: Publish box date format, see http://php.net/date
					date_i18n( __( 'M j, Y @ G:i', 'btnsx' ), strtotime( $post->post_date ) )
				),
				10 => __( 'Dual button draft updated.', 'btnsx' )
			);

			// if ( $post_type_object->publicly_queryable ) {
			// 	$permalink = get_permalink( $post->ID );

			// 	$view_link = sprintf( ' <a href="%s">%s</a>', esc_url( $permalink ), __( 'View button', 'btnsx' ) );
			// 	$messages[ $post_type ][1] .= $view_link;
			// 	$messages[ $post_type ][6] .= $view_link;
			// 	$messages[ $post_type ][9] .= $view_link;

			// 	$preview_permalink = add_query_arg( 'preview', 'true', $permalink );
			// 	$preview_link = sprintf( ' <a target="_blank" href="%s">%s</a>', esc_url( $preview_permalink ), __( 'Preview Button', 'btnsx' ) );
			// 	$messages[ $post_type ][8]  .= $preview_link;
			// 	$messages[ $post_type ][10] .= $preview_link;
			// }
			return $messages;
		}

		/**
		 * remove extra meta boxes on custom post page
		 * @since 1.7
		 */
		public function remove_extra_meta_boxes() {
		    if( get_post_type() == 'buttons-x-dual' ){
		        $meta_boxes_advanced = $this->get_meta_boxes( 'buttons-x-dual', 'advanced' );
		        $meta_boxes_normal = $this->get_meta_boxes( 'buttons-x-dual', 'normal' );
		        $meta_boxes_side = $this->get_meta_boxes( 'buttons-x-dual', 'side' );
		        $meta_advanced = array( '' );
		        $meta_normal = array( 'btnsx-preview', 'btnsx-options' );
		        $meta_side = array( 'submitdiv', 'btnsx_dual_packdiv', 'tagsdiv-btnsx_dual_tag', 'btnsx-preview-settings', 'btnsx-shortcode' );
		        foreach ( $meta_boxes_advanced as $key => $value ) {
		            foreach ( $value as $k => $v ) {
		                if( !in_array( $v['id'], $meta_advanced )  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-dual' , 'advanced' );
		                }
		            }
		        }
		        foreach ($meta_boxes_normal as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_normal)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-dual' , 'normal' );
		                }
		            }
		        }
		        foreach ($meta_boxes_side as $key => $value) {
		            foreach ($value as $k => $v) {
		                if( !in_array($v['id'], $meta_side)  ){
		                    remove_meta_box( $v['id'] , 'buttons-x-dual' , 'side' );
		                }
		            }
		        }
		    }
		}

		/**
		 * Extract meta boxes information
		 * @param  string $screen  target page
		 * @param  string $context part of page where meta box is shown
		 * @return array          list of meta boxes on the target page
		 * @since 1.7
		 */
		public function get_meta_boxes( $screen = null, $context = 'advanced' ) {
		    global $wp_meta_boxes;
		    if ( empty( $screen ) ) {
		        $screen = get_current_screen();
		    } elseif ( is_string( $screen ) ) {
		        $screen = convert_to_screen( $screen );
		    }
		    $page = $screen->id;
		    if( isset( $wp_meta_boxes[ $page ][ $context ] ) ) {
		    	return $wp_meta_boxes[ $page ][ $context ];
		    } else {
		    	return array();
		    }
		}

	    /**
		* Adds the meta box container.
		* @since 1.7
		*/
		public function register_meta_boxes() {
			$screens = array( 'buttons-x-dual' );
			foreach ( $screens as $screen ) {
			    add_meta_box(
			        'btnsx-preview',
			        __( 'Live Preview', 'btnsx' ),
			        array( $this, 'preview_callback' ),
			        $screen,
			        'normal',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-options',
			        __( 'Buttons X - Options Panel', 'btnsx' ),
			        array( $this, 'options_callback' ),
			        $screen,
			        'normal',
			        'core'
			    );
			    add_meta_box(
			        'btnsx-preview-settings',
			        __( 'Buttons X - Preview Settings', 'btnsx' ),
			        array( $this, 'preview_settings_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			    add_meta_box(
			        'btnsx-shortcode',
			        __( 'Buttons X - Short Code', 'btnsx' ),
			        array( $this, 'shortcode_callback' ),
			        $screen,
			        'side',
			        'high'
			    );
			}
			// global $btnsx_settings;
			// $posts = isset( $btnsx_settings['social'] ) ? $btnsx_settings['social'] : '';
			// if( isset( $btnsx_settings['social'] ) ) {
			// 	foreach ( $posts as $post ) {
			// 	    add_meta_box(
			// 	        'btnsx-social',
			// 	        __( 'Buttons X - Social Buttons', 'btnsx' ),
			// 	        array( $this, 'post_metabox_callback' ),
			// 	        $post,
			// 	        'side',
			// 	        'low'
			// 	    );
			// 	}
			// }
		}

		/**
	     * Prints the box content.
	     * @param WP_Post $post The object for the current post/page.
	     * @since 0.1
	     */
	    public function shortcode_callback( $post ) {
	    	$current_color = get_user_option( 'admin_color' );
	    	global $_wp_admin_css_colors;
	        echo '<p style="font-weight:bold;color:'.$_wp_admin_css_colors[$current_color]->colors[2].';">[btnsx_dual id="'.$post->ID.'"]</p>';
	    }

	    /**
         * Register custom taxonomies for button post type
         * @since  0.1
         * @return 
         */
        public function register_taxonomies() {
		    // Add new taxonomy, make it hierarchical (like categories)
		    $labels = array(
		        'name' 				=> _x( 'Packs', 'btnsx' ),
		        'singular_name' 	=> _x( 'Pack', 'btnsx' ),
		        'search_items' 		=> __( 'Search Pack', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Pack', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Pack:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Pack', 'btnsx' ),
		        'update_item' 		=> __( 'Update Pack', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Pack', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Pack Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Packs', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> true,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'show_in_nav_menus' => false,
		        'rewrite' 			=> array( 'slug' => 'btnsx_dual_pack' ),
		    );
		    register_taxonomy( 'btnsx_dual_pack', array( 'buttons-x-dual' ), $args );
		    // Add new taxonomy, not hierarchical (like tags)
		    $labels = array(
		        'name' 				=> _x( 'Tags', 'btnsx' ),
		        'singular_name' 	=> _x( 'Tag', 'btnsx' ),
		        'search_items' 		=> __( 'Search Tag', 'btnsx' ),
		        'all_items' 		=> __( 'All', 'btnsx' ),
		        'parent_item' 		=> __( 'Parent Tag', 'btnsx' ),
		        'parent_item_colon' => __( 'Parent Tag:', 'btnsx' ),
		        'edit_item' 		=> __( 'Edit Tag', 'btnsx' ),
		        'update_item' 		=> __( 'Update Tag', 'btnsx' ),
		        'add_new_item' 		=> __( 'Add New Tag', 'btnsx' ),
		        'new_item_name' 	=> __( 'New Tag Name', 'btnsx' ),
		        'menu_name' 		=> __( 'Tags', 'btnsx' )
		    );
		    $args = array(
		    	'public' 			=> false,
		        'hierarchical' 		=> false,
		        'labels' 			=> $labels,
		        'show_ui' 			=> true,
		        'show_admin_column' => true,
		        'query_var' 		=> true,
		        'show_in_nav_menus' => false,
		        'rewrite' 			=> array( 'slug' => 'btnsx_dual_tag' ),
		    );
		    register_taxonomy( 'btnsx_dual_tag', array( 'buttons-x-dual' ), $args );
		}

	    /**
        * Register the menu for the Dashboard.
        * @since 1.7
        */
        public function register_cpt() {
    		//	global $btnsx_settings;

            if( isset( $btnsx_settings['social_menu_name'] ) ){
                $button_menu_name = $btnsx_settings['social_menu_name'];
            } else {
                $button_menu_name = __('Dual Buttons', 'admin menu', 'btnsx');
            }

            if( isset( $btnsx_settings['social_name_singular'] ) ){
                $button_name_singular = $btnsx_settings['social_name_singular'];
            } else {
                $button_name_singular = __('Dual Button', 'post type singular name', 'btnsx');
            }

            if( isset( $btnsx_settings['social_name_plural'] ) ){
                $button_name_plural = $btnsx_settings['social_name_plural'];
            } else {
                $button_name_plural = __('Dual Buttons', 'post type general name', 'btnsx');
            }

            if( isset( $btnsx_settings['social_admin_bar_name'] ) ){
                $button_admin_bar_name = $btnsx_settings['social_admin_bar_name'];
            } else {
                $button_admin_bar_name = __('Dual Button', 'add new on admin bar', 'btnsx');
            }

            // Register buttons post
            register_post_type( 'buttons-x-dual',
                array(
                    'labels' => array(
                        'name' => $button_name_plural,
                        'singular_name' => $button_name_singular,
                        'menu_name' => $button_menu_name,
                        'name_admin_bar' => $button_admin_bar_name,
                        'add_new' => _x('Add New', $button_name_singular, 'btnsx'),
                        'add_new_item' => __('Add New ', 'btnsx') . $button_name_singular,
                        'new_item' => __('New ', 'btnsx') . $button_name_singular,
                        'edit_item' => __('Edit ', 'btnsx') . $button_name_singular,
                        'view_item' => __('View ', 'btnsx') . $button_name_singular,
                        'all_items' => $button_name_plural,
                        'search_items' => __('Search ', 'btnsx') . $button_name_plural,
                        'parent_item_colon' => __('Parent ', 'btnsx') . $button_name_plural . ':',
                        'not_found' => __('No ', 'btnsx') . $button_name_plural . __(' found.', 'btnsx'),
                        'not_found_in_trash' => __('No ', 'btnsx') . $button_name_plural . __(' found in Trash.', 'btnsx'),
                    ),
                    'public'                => false,
                    'show_ui'				=> true,
                    'exclude_from_search'   => true,
                    'publicly_queryable'    => false,
                    'has_archive'           => false,
                    'show_in_admin_bar'     => true,
                    'show_in_nav_menus'		=> true,
                    'show_in_menu'			=> 'btnsx',
                    'supports'              => array( 'title', 'btnsx_dual_pack', 'btnsx_dual_tag' ),
                    'menu_icon'				=> 'dashicons-btnsx-logo'
                )
            );
        }

	} // Main Class

}

/**
 *  Kicking this off
 */

$btn = new BtnsxDual();
$btn->init();