<?php
namespace BricksUltimate\Trait;

if ( ! defined( 'ABSPATH' ) ) exit;

trait WooQuickAddFormControls {

	public function bu_quick_add_controls( $controls, $return = true ) {
		$controls['quickAddInfo'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'info',
			'content' 	=> esc_html__( 'Make sure that you activate the Swatches feature at the Bricks-> BricksUltimate -> MISC tab.', 'bricksultimate' ),
		];

		$controls['enableQuickAdd'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Enable quick add action', 'bricksultimate' ),
		];

		$controls['qaQty'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'checkbox',
			'label' 	=> esc_html__( 'Disable quantity field', 'bricksultimate' ),
			'css' 		=> [
				[
					'selector' 	=> '.quick-add-wrapper div.quantity',
					'property' 	=> 'display',
					'value' 	=> 'none',
					'important' => true
				]
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['excludeQuickAdd'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Exclude products', 'bricksultimate' ),
			'description' => esc_html__( 'enter product IDs with comma', 'bricksultimate' ),
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['quickAddBtnText'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Button text', 'bricksultimate' ),
			'description' => esc_html__( 'It is for Swatches for Loop element', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Add To Cart', 'bricksultimate' ),
			'inline' 	=> true,
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnSep'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Close button', 'bricksultimate' ),
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnText'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Close', 'bricksultimate' ),
			'inline' 	=> true,
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnIcon'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'icon',
			'label' 	=> esc_html__( 'Icon', 'bricksultimate' ),
			'default' 	=> [
				'library' => 'themify',
				'icon'    => 'ti-close',
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnIconColor'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Icon color', 'bricksultimate' ),
			'type'     => 'color',
			'required' => [ [ 'qaCloseBtnIcon.icon', '!=', '' ], ['enableQuickAdd', '=', true] ],
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.bu-qa-close-icon'
				],
				[
					'property' => 'fill',
					'selector' => '.bu-qa-close-icon'
				],
			],
		];

		$controls['qaCloseBtnIconSize'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Icon size', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'required' => [ [ 'qaCloseBtnIcon.icon', '!=', '' ], ['enableQuickAdd', '=', true] ],
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.bu-qa-close-icon'
				],
			],
		];

		$controls['qaCloseBtnIconGap'] = [
			'group'  	=> 'quickadd',
			'label'    => esc_html__( 'Gap', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'required' => [ [ 'qaCloseBtnIcon.icon', '!=', '' ], ['enableQuickAdd', '=', true] ],
			'css'      => [
				[
					'property' => 'gap',
					'selector' => '.bu-qa-close-icon a'
				],
			],
		];

		$controls['qaCloseBtnPT'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Position: Top', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'top',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnPR'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Position: Right', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnPL'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Position: Left', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnW'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Width', 'bricksultimate' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'width',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnPad'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Padding', 'bricksultimate' ),
			'type'     => 'dimensions',
			'css'      => [
				[
					'property' => 'padding',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnTg'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Typography', 'bricksultimate' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnBg'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Background color', 'bricksultimate' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaCloseBtnBrd'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Border', 'bricksultimate' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.quick-add-wrapper .qa-close-btn'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaContainer'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Container', 'bricksultimate' ),
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$selector = '.quick-add-wrapper';

		$controls['qaWrapperPad'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Padding', 'bricksultimate' ),
			'type'     => 'dimensions',
			'css'      => [
				[
					'property' => 'padding',
					'selector' => $selector
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaWrapperBg'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Background color', 'bricksultimate' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => $selector
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaWrapperSW'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Scrollbar width', 'bricksultimate' ),
			'type' 	=> 'number',
			'units' => true,
			'css' 	=> [
				[
					'property' => 'width',
					'selector' => '.qa-cart-form::-webkit-scrollbar'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaWrapperSTH'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Scrollbar thumb color', 'bricksultimate' ),
			'type' 	=> 'color',
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => '.qa-cart-form::-webkit-scrollbar-thumb'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaWrapperST'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Scrollbar track color', 'bricksultimate' ),
			'type' 	=> 'color',
			'css' 	=> [
				[
					'property' => 'background-color',
					'selector' => '.qa-cart-form::-webkit-scrollbar-track'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtn'] = [
			'group' 	=> 'quickadd',
			'type' 		=> 'separator',
			'label' 	=> esc_html__( 'Add To Cart Button', 'bricksultimate' ),
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$selector = '.qa-cart-form .button';

		$controls['qaATCBtnText'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Text', 'bricks' ),
			'type'  => 'text',
			'placeholder' => esc_html__('Add to cart', 'woocommerce'),
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnW'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector,
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnH'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Height', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'height',
					'selector' => $selector,
				],
			],
			'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnPad'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Padding', 'bricks' ),
			'type'  => 'dimensions',
			'css'   => [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnBG'] = [
			'group' => 'quickadd',
			'type'  => 'color',
			'label' => esc_html__('Background', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'background-color'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnTg'] = [
			'group' => 'quickadd',
			'type'  => 'typography',
			'label' => esc_html__('Typography', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'font'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnBorder'] = [
			'group' => 'quickadd',
			'type'  => 'border',
			'label' => esc_html__('Border', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'border'
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaATCBtnBoxshadow'] = [
			'group' => 'quickadd',
			'type'  => 'box-shadow',
			'label' => esc_html__('Box shadow', 'bricks'),
			'css' 	=> [
				[
					'selector' => $selector,
					'property' => 'box-shadow',
				],
			],
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaicon'] = [
			'group' => 'quickadd',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
			'required' 	=> ['enableQuickAdd', '=', true]
		];

		$controls['qaIconTypography'] = [
			'group' 	=> 'quickadd',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.qa-cart-form .button i',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [['enableQuickAdd', '=', true], [ 'qaicon.icon', '!=', '' ]],
		];

		$controls['qaIconHColor'] = [
			'group' 	=> 'quickadd',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '.qa-cart-form .button:hover i, .qa-cart-form .button:hover svg',
				],
				[
					'property' => 'fill',
					'selector' => '.qa-cart-form .button:hover i, .qa-cart-form .button:hover svg',
				],
			],
			'required' => [['enableQuickAdd', '=', true], [ 'qaicon.icon', '!=', '' ]],
		];

		$controls['qaHideBtnText'] = [
			'group' 	=> 'quickadd',
			'label'    	=> esc_html__( 'Show only icon', 'bricks' ),
			'type' 		=> 'checkbox',
			'required' 	=> [['enableQuickAdd', '=', true], [ 'qaicon.icon', '!=', '' ]],
		];

		$controls['qaIconPosition'] = [
			'group' 	  => 'quickadd',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '.button',
					'property' => 'flex-direction'
				]
			],
			'required'    	=> [ ['enableQuickAdd', '=', true], [ 'qaicon.icon', '!=', '' ], ['qaHideBtnText', '!=', true] ]
		];

		$controls['qaIconMrg'] = [
			'group' 	=> 'quickadd',
			'label'    	=> esc_html__( 'Gap between icon & text', 'bricks' ),
			'type'     	=> 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => '.qa-cart-form .button i',
				],
			],
			'required' => [ ['enableQuickAdd', '=', true], [ 'qaicon.icon', '!=', '' ], ['qaHideBtnText', '!=', true] ]
		];

		if( $return )
			return $controls;
	}

}