<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed Woocommerce_directly

class WSFormsStyles {
	public function __construct() {
		add_filter( 'bricks/theme_styles/control_groups', [ $this, 'set_groups' ] );
		add_filter( 'bricks/theme_styles/controls', [ $this, 'set_controls' ] );
	}

	/**
	 * Add BricksUltimate elements style control groups
	 */
	public function set_groups( $control_groups ) {
		$control_groups['buwsf'] = [
			'title' => 'Ultimate - ' . esc_html__( 'WSForms Styler', 'bricksultimate' ),
		];

		return $control_groups;
	}

	/**
	 * Add BricksUltimate elements style controls
	 */
	public function set_controls( $controls ) {
		$wsfControls = [];

		$elSelector = ".brxe-bu-wsf-styler";
		$selector = "{$elSelector} input[type=radio].wsf-field + label.wsf-label";
		$pseudoBefore = "{$elSelector} input[type=radio].wsf-field + label.wsf-label:before";
		$pseudoAfter = "{$elSelector} input[type=radio].wsf-field + label.wsf-label:after";
		$button = "{$elSelector} button.wsf-button";

		$wsfControls['buwsf'] = [
			'labels' => [
				'group' 	=> 'buwsf',
				'type'      => 'typography',
				'label'     => esc_html__('Labels', 'bricks'),
				'css' 		=> [
					[
						'property' => 'font',
						'selector' => $elSelector . ' .wsf-field-wrapper > .wsf-label'
					]
				]
			],
			'ast' => [
				'group' 	=> 'buwsf',
				'type'      => 'typography',
				'label'     => esc_html__('Asterisk', 'bricks'),
				'css' 		=> [
					[
						'property' => 'font',
						'selector' => $elSelector . ' .wsf-required-wrapper .wsf-text-danger'
					]
				],
				'exclude' => [
					'text-transform',
					'text-align',
					'text-decoration',
					'letter-spacing',
					'text-shadow'
				]
			],
			'helptxt' => [
				'group' 	=> 'buwsf',
				'type'      => 'typography',
				'label'     => esc_html__('Help text', 'bricks'),
				'css' 		=> [
					[
						'property' => 'font',
						'selector' => $elSelector . ' .wsf-help'
					]
				]
			],
			'reqtxt' => [
				'group' 	=> 'buwsf',
				'type'      => 'typography',
				'label'     => esc_html__('Required text', 'bricks'),
				'css' 		=> [
					[
						'property' => 'font',
						'selector' => $elSelector . ' .wsf-invalid-feedback'
					]
				]
			],
			'spacer' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				"units" => true,
				'label' => esc_html__( 'Spacer', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'height',
						'selector' =>  "{$elSelector} .wsf-tile[data-type=\"spacer\"] div"
					]
				]
			],
			'dcolor' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Divider color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$elSelector} hr.wsf-field"
					],
	  				[
						'property' => 'background-color',
						'selector' => "{$elSelector} hr.wsf-field",
						'value' 	=> 'transparent'
					],
					[
						'property' => 'border-style',
						'selector' => "{$elSelector} hr.wsf-field",
						'value' 	=> 'solid'
					],
				]
			],
			'dwidth' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'units' => true,
				'label' => esc_html__( 'Divider width', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-top-width',
						'selector' => "{$elSelector} hr.wsf-field"
					]
				]
			],
			'inp_sep' => [
				'group' 	=> 'buwsf',
				'type'      => 'separator',
				'label'     => esc_html__('Input Fields', 'bricks'),
			],
			'inpPad' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'dimensions',
				'label' 	=> esc_html__( 'Padding', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'padding',
						'selector' => "{$elSelector} input[type=email].wsf-field, 
									{$elSelector} input[type=number].wsf-field, 
									{$elSelector} input[type=tel].wsf-field, 
									{$elSelector} input[type=text].wsf-field, 
									{$elSelector} input[type=url].wsf-field, 
									{$elSelector} select.wsf-field, 
									{$elSelector} textarea.wsf-field"
					]
				],
			],
			'inpH' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'number',
				"units" 	=> true,
				'label' 	=> esc_html__( 'Height', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'height',
						'selector' => "{$elSelector} input[type=email].wsf-field, 
									{$elSelector} input[type=number].wsf-field, 
									{$elSelector} input[type=tel].wsf-field, 
									{$elSelector} input[type=text].wsf-field, 
									{$elSelector} input[type=url].wsf-field, 
									{$elSelector} select.wsf-field:not([multiple]):not([size])"
					]
				],
			],
			'inpGap' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'number',
				'units' 	=> true,
				'label' 	=> esc_html__( 'Row gap', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'margin-bottom',
						'selector' => "{$elSelector} .wsf-field-wrapper"
					]
				],
			],
			'inpPlaceholder' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'color',
				'label' 	=> esc_html__( 'Placeholder', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'color',
						'selector' => "{$elSelector} input[type=email].wsf-field::placeholder, 
									{$elSelector} input[type=number].wsf-field::placeholder, 
									{$elSelector} input[type=tel].wsf-field::placeholder, 
									{$elSelector} input[type=text].wsf-field::placeholder, 
									{$elSelector} input[type=url].wsf-field::placeholder, 
									{$elSelector} select.wsf-field::placeholder, 
									{$elSelector} textarea.wsf-field::placeholder"
					]
				],
			],
			'inpBg' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'color',
				'label' 	=> esc_html__( 'Background', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'background-color',
						'selector' => "{$elSelector} input[type=email].wsf-field, 
									{$elSelector} input[type=number].wsf-field, 
									{$elSelector} input[type=tel].wsf-field, 
									{$elSelector} input[type=text].wsf-field, 
									{$elSelector} input[type=url].wsf-field, 
									{$elSelector} select.wsf-field, 
									{$elSelector} textarea.wsf-field"
					]
				],
			],
			'inpBrd' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'border',
				'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'border',
						'selector' => "{$elSelector} input[type=email].wsf-field, 
									{$elSelector} input[type=number].wsf-field, 
									{$elSelector} input[type=tel].wsf-field, 
									{$elSelector} input[type=text].wsf-field, 
									{$elSelector} input[type=url].wsf-field, 
									{$elSelector} select.wsf-field, 
									{$elSelector} textarea.wsf-field"
					]
				],
			],
			'inpTa' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'separator',
				'label' 	=> esc_html__( 'Textarea', 'bricksultimate' ),
			],
			'inpTaWidth' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'number',
				'units' 	=> true,
				'label' 	=> esc_html__( 'Width', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'width',
						'selector' => $elSelector . ' textarea.wsf-field'
					]
				],
			],
			'inpTaHeight' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'number',
				'units' 	=> true,
				'label' 	=> esc_html__( 'Height', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'height',
						'selector' => $elSelector . ' textarea.wsf-field'
					]
				],
			],
			'focus_sep' => [
				'group' 	=> 'buwsf',
				'type'      => 'separator',
				'label'     => esc_html__('Focus: Input Fields', 'bricks'),
			],
			'inpFocusBG' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'color',
				'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'background-color',
						'selector' => "{$elSelector} input[type=email].wsf-field:focus, 
									{$elSelector} input[type=number].wsf-field:focus, 
									{$elSelector} input[type=tel].wsf-field:focus, 
									{$elSelector} input[type=text].wsf-field:focus, 
									{$elSelector} input[type=url].wsf-field:focus, 
									{$elSelector} select.wsf-field:focus, textarea.wsf-field:focus"
					]
				]
			],
			'inpFocusColor' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'color',
				'label' 	=> esc_html__( 'Text color', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'color',
						'selector' => "{$elSelector} input[type=email].wsf-field:focus, 
									{$elSelector} input[type=number].wsf-field:focus, 
									{$elSelector} input[type=tel].wsf-field:focus, 
									{$elSelector} input[type=text].wsf-field:focus, 
									{$elSelector} input[type=url].wsf-field:focus, 
									{$elSelector} select.wsf-field:focus, textarea.wsf-field:focus"
					]
				],
			],
			'inpFocusBorder' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'border',
				'label' 	=> esc_html__( 'Borders', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'border',
						'selector' => "{$elSelector} input[type=email].wsf-field:focus, 
									{$elSelector} input[type=number].wsf-field:focus, 
									{$elSelector} input[type=tel].wsf-field:focus, 
									{$elSelector} input[type=text].wsf-field:focus, 
									{$elSelector} input[type=url].wsf-field:focus, 
									{$elSelector} select.wsf-field:focus, textarea.wsf-field:focus"
					]
				],
			],
			'inpFocusBs' => [
				'group' 	=> 'buwsf',
				'type' 		=> 'box-shadow',
				'label' 	=> esc_html__( 'Box shadow', 'bricksultimate' ),
				'css'		=> [
					[
						'property' => 'box-shadow',
						'selector' => "{$elSelector} input[type=email].wsf-field:focus, 
									{$elSelector} input[type=number].wsf-field:focus, 
									{$elSelector} input[type=tel].wsf-field:focus, 
									{$elSelector} input[type=text].wsf-field:focus, 
									{$elSelector} input[type=url].wsf-field:focus, 
									{$elSelector} select.wsf-field:focus, textarea.wsf-field:focus"
					]
				],
			],
			'btn_sep' => [
				'group' 	=> 'buwsf',
				'type'      => 'separator',
				'label'     => esc_html__('Button', 'bricks'),
			],
			'buttonPad' => [
				'group' => 'buwsf',
				'type' 	=> 'dimensions',
				'label' => esc_html__( 'Padding', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'padding',
						'selector' => $button
					]
				]
			],
			'buttonW' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				"units" => true,
				'label' => esc_html__( 'Width', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'width',
						'selector' => $button
					]
				]
			],
			'buttonH' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				"units" => true,
				'label' => esc_html__( 'Height', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'height',
						'selector' => $button
					]
				]
			],
			'buttonTg' => [
				'group' => 'buwsf',
				'type' 	=> 'typography',
				'label' => esc_html__( 'Typography', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'font',
						'selector' => $button
					]
				]
			],
			'buttonBrd' => [
				'group' => 'buwsf',
				'type' 	=> 'border',
				'label' => esc_html__( 'Border', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border',
						'selector' => $button
					]
				]
			],
			'buttonBS' => [
				'group' => 'buwsf',
				'type' 	=> 'box-shadow',
				'label' => esc_html__( 'Box shadow', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'box-shadow',
						'selector' => $button
					]
				]
			],
			'buttonPrimary' => [
				'group' => 'buwsf',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Default/Primary Button', 'bricksultimate' ),
			],
			'buttonBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}, {$button}.wsf-button-primary"
					]
				]
			],
			'buttonTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}, {$button}.wsf-button-primary"
					]
				]
			],
			'buttonBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}, {$button}.wsf-button-primary"
					]
				]
			],
			'buttonHBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}:hover, {$button}.wsf-button-primary:hover"
					]
				]
			],
			'buttonHTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}:hover, {$button}.wsf-button-primary:hover"
					]
				]
			],
			'buttonHBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}:hover, {$button}.wsf-button-primary:hover"
					]
				]
			],
			'buttonSecond' => [
				'group' => 'buwsf',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Secondary Button', 'bricksultimate' ),
			],
			'buttonSBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-secondary"
					]
				]
			],
			'buttonSTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-secondary"
					]
				]
			],
			'buttonSBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-secondary"
					]
				]
			],
			'buttonSHBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-secondary:hover"
					]
				]
			],
			'buttonSHTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-secondary:hover"
					]
				]
			],
			'buttonSHBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-secondary:hover"
					]
				]
			],
			'buttonSuc' => [
				'group' => 'buwsf',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Success Button', 'bricksultimate' ),
			],
			'buttonSucBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-success"
					]
				]
			],
			'buttonSucTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-success"
					]
				]
			],
			'buttonSucBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-success"
					]
				]
			],
			'buttonSucHBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-success:hover"
					]
				]
			],
			'buttonSucHTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-success:hover"
					]
				]
			],
			'buttonSucHBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-success:hover"
					]
				]
			],
			'buttonInfo' => [
				'group' => 'buwsf',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Information Button', 'bricksultimate' ),
			],
			'buttonInfoBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-information"
					]
				]
			],
			'buttonInfoTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-information"
					]
				]
			],
			'buttonInfoBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-information"
					]
				]
			],
			'buttonInfoHBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-information:hover"
					]
				]
			],
			'buttonInfoHTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-information:hover"
					]
				]
			],
			'buttonInfoHBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-information:hover"
					]
				]
			],
			'buttonWrn' => [
				'group' => 'buwsf',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Warning Button', 'bricksultimate' ),
			],
			'buttonWBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-warning"
					]
				]
			],
			'buttonWTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-warning"
					]
				]
			],
			'buttonWBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-warning"
					]
				]
			],
			'buttonWHBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-warning:hover"
					]
				]
			],
			'buttonWHTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-warning:hover"
					]
				]
			],
			'buttonWHBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-warning:hover"
					]
				]
			],
			'buttonD' => [
				'group' => 'buwsf',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Danger Button', 'bricksultimate' ),
			],
			'buttonDBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-danger"
					]
				]
			],
			'buttonDTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-danger"
					]
				]
			],
			'buttonDBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-danger"
					]
				]
			],
			'buttonDHBG' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => "{$button}.wsf-button-danger:hover"
					]
				]
			],
			'buttonDHTxt' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover text color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => "{$button}.wsf-button-danger:hover"
					]
				]
			],
			'buttonDHBrdC' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Hover border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$button}.wsf-button-danger:hover"
					]
				]
			],
			'cb_sep' => [
				'group' 	=> 'buwsf',
				'type'      => 'separator',
				'label'     => esc_html__('Checkboxes', 'bricks'),
			],
			'cbLabels' => [
				'group' => 'buwsf',
				'type' 	=> 'typography',
				'label' => esc_html__( 'Label', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'font',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label",
					]
				]
			],
			'cbGap' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'units' => true,
				'label' => esc_html__( 'Gap', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => '-webkit-padding-start',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label",
					],
					[
						'property' => 'padding-inline-start',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label",
					]
				]
			],
			'cbSize' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'units' => true,
				'label' => esc_html__( 'Size', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'line-height',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label",
					],
					[
						'property' => 'width',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field, {$elSelector} input[type=checkbox].wsf-field + label.wsf-label:before, {$elSelector} input[type=checkbox].wsf-field + label.wsf-label:after",
					],
					[
						'property' => 'height',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field, {$elSelector} input[type=checkbox].wsf-field + label.wsf-label:before, {$elSelector} input[type=checkbox].wsf-field + label.wsf-label:after",
					]
				]
			],
			'cbColor' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label:before"
					]
				]
			],
			'cbCheckColor' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Checked color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field:checked + label.wsf-label:before"
					],
					[
						'property' => 'background-color',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field:checked + label.wsf-label:before"
					]
				]
			],
			'cbBW' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'unit' 	=> 'px',
				'label' => esc_html__( 'Border width', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-width',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label:before"
					]
				]
			],
			'cbBRD' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'unit' 	=> 'px',
				'label' => esc_html__( 'Border radius', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-radius',
						'selector' => "{$elSelector} input[type=checkbox].wsf-field + label.wsf-label:before"
					]
				]
			],
			'rb_sep' => [
				'group' 	=> 'buwsf',
				'type'      => 'separator',
				'label'     => esc_html__('Radio Buttons', 'bricks'),
			],
			'radioLabels' => [
				'group' => 'buwsf',
				'type' 	=> 'typography',
				'label' => esc_html__( 'Label', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'font',
						'selector' => $selector,
					]
				]
			],
			'radioGap' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'units' => true,
				'label' => esc_html__( 'Gap', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => '-webkit-padding-start',
						'selector' => $selector,
					],
					[
						'property' => 'padding-inline-start',
						'selector' => $selector,
					]
				]
			],
			'radioSize' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'units' => true,
				'label' => esc_html__( 'Size', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'line-height',
						'selector' => $selector,
					],
					[
						'property' => 'width',
						'selector' => "{$elSelector} input[type=radio].wsf-field, {$pseudoBefore}, {$pseudoAfter}",
					],
					[
						'property' => 'height',
						'selector' => "{$elSelector} input[type=radio].wsf-field, {$pseudoBefore}, {$pseudoAfter}",
					]
				]
			],
			'radioBW' => [
				'group' => 'buwsf',
				'type' 	=> 'number',
				'unit' 	=> 'px',
				'label' => esc_html__( 'Border width', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-width',
						'selector' => $pseudoBefore
					]
				]
			],
			'radioColor' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Border color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => $pseudoBefore
					]
				]
			],
			'radioCheckColor' => [
				'group' => 'buwsf',
				'type' 	=> 'color',
				'label' => esc_html__( 'Checked color', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border-color',
						'selector' => "{$elSelector} input[type=radio].wsf-field:checked + label.wsf-label:before"
					],
					[
						'property' => 'background-color',
						'selector' => "{$elSelector} input[type=radio].wsf-field:checked + label.wsf-label:before"
					]
				]
			],
			'sec_sep' => [
				'group' 	=> 'buwsf',
				'type'      => 'separator',
				'label'     => esc_html__('Section', 'bricks'),
			],
			'sec_pad' => [
				'group' 	=> 'buwsf',
				'type'      => 'dimensions',
				'label'     => esc_html__('Padding', 'bricks'),
				'css' 		=> [
					[
						'property' => 'padding',
						'selector' => $elSelector . ' .wsf-section'
					]
				]
			],
			'sec_bg' => [
				'group' 	=> 'buwsf',
				'type'      => 'color',
				'label'     => esc_html__('Background', 'bricks'),
				'css' 		=> [
					[
						'property' => 'background-color',
						'selector' => $elSelector . ' .wsf-section'
					]
				]
			],
			'sec_altbg' => [
				'group' 	=> 'buwsf',
				'type'      => 'color',
				'label'     => esc_html__('Alt background', 'bricks'),
				'css' 		=> [
					[
						'property' => 'background-color',
						'selector' => $elSelector . ' .wsf-section:nth-child(2n+2)'
					]
				]
			],
			'secBorder' => [
				'group' 	=> 'buwsf',
				'type'      => 'border',
				'label'     => esc_html__('Borders', 'bricks'),
				'css' 		=> [
					[
						'property' => 'border',
						'selector' => $elSelector . ' .wsf-section'
					]
				]
			],
			'seclblTg' => [
				'group' 	=> 'buwsf',
				'type'      => 'typography',
				'label'     => esc_html__('Labels', 'bricks'),
				'css' 		=> [
					[
						'property' => 'font',
						'selector' => $elSelector . ' .wsf-section > legend'
					],
					[
						'property' => 'font',
						'selector' => $elSelector . ' .wsf-fieldset > legend'
					]
				]
			]
		];

		return array_merge( $controls, $wsfControls );
	}
}