<?php
namespace BricksUltimate;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed Woocommerce_directly

class GravityFormsStyles {
	public function __construct() {
		add_filter( 'bricks/theme_styles/control_groups', [ $this, 'set_groups' ] );
		add_filter( 'bricks/theme_styles/controls', [ $this, 'set_controls' ] );
	}

	/**
	 * Add BricksUltimate elements style control groups
	 */
	public function set_groups( $control_groups ) {
		$control_groups['bugfs'] = [
			'title' => 'Ultimate - ' . esc_html__( 'Gravity Forms Styler', 'bricksultimate' ),
		];

		return $control_groups;
	}

	/**
	 * Add BricksUltimate elements style controls
	 */
	public function set_controls( $controls ) {
		$gfs_controls = [];

		$inp_selector = '.brxe-bu-gf-styler .gform_wrapper .gfield input:not([type=radio]):not([type=checkbox]):not([type=submit]):not([type=button]):not([type=image]):not([type=file])';
		$select_inp = '.brxe-bu-gf-styler .gform_wrapper .gfield select';
		$selector_ta = '.brxe-bu-gf-styler .gform_wrapper .gfield textarea';

		$selector = '.brxe-bu-gf-styler .gform_wrapper input[type="submit"]';

		$gfs_controls['bugfs'] = [
			'labels' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Labels', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' => ".brxe-bu-gf-styler .gform_wrapper.gravity-theme .gfield_label",
						'property' => 'font',
					],
				],
			],

			'labelSub' => [
				'group' 	=> 'bugfs',
				'type'      => 'typography',
				'label'     => esc_html__('Sub Labels', 'bricksultimate'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> '.brxe-bu-gf-styler .gform_wrapper.gravity-theme .ginput_container span label',
						'property'  => 'font',
					],
					[
						'selector' 	=> '.brxe-bu-gf-styler .gform_wrapper.gravity-theme .gfield_time_hour label',
						'property'  => 'font',
					],
					[
						'selector' 	=> '.brxe-bu-gf-styler .gform_wrapper.gravity-theme .gfield_time_minute label',
						'property'  => 'font',
					]
				]
			],

			'hGap' => [
				'group'  => 'bugfs',
				'type'      => 'number',
				'label'     => esc_html__('Horizontal Gap', 'bricksultimate'),
				'description' => __('Gap between columns', 'bricksultimate'),
				'units' 	=> true,
				'min'		=> 0,
				'max'  		=> 10000,
				'step' 		=> 1,
				'default' 	=> '2%',
				'inline' 	=> true,
				'css' 	=> [
					[
						'selector' => '.brxe-bu-gf-styler .gform_wrapper.gravity-theme .gform_fields',
						'property' => 'grid-column-gap',
					],
					[
						'selector' 	=> '.brxe-bu-gf-styler .gform_wrapper.gravity-theme',
						'property' 	=> '--inp-col-gap'
					]
				],
			],

			'vGap' => [
				'group'  	=> 'bugfs',
				'type'      => 'number',
				'label'     => esc_html__('Vertical Gap', 'bricksultimate'),
				'description' => __('Gap between rows', 'bricksultimate'),
				'units' 	=> true,
				'min'		=> 0,
				'max'  		=> 10000,
				'step' 		=> 1,
				'default' 	=> '16px',
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' => '.brxe-bu-gf-styler .gform_wrapper.gravity-theme .gform_fields',
						'property' => 'grid-row-gap',
						'value'    => '%s',
					]
				],
			],

			'inpSep' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Input Fields', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'inpWidth' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Width', 'bricks' ),
				'type'   => 'number',
				'units'  => true,
				'min' 	 => 0,
				'step' 	 => 1,
				'inline' => true,
				'medium' => true,
				'css'    => [
					[
						'selector' => $inp_selector,
						'property' => 'width',
					],
					[
						'selector' 	=> $select_inp,
						'property' 	=> 'width',
					],
				],
			],

			'inpHeight' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Height', 'bricks' ),
				'type'   => 'number',
				'units'  => true,
				'min' 	 => 0,
				'step' 	 => 1,
				'placeholder' => '40px',
				'default' => 'auto',
				'inline' => true,
				'medium' => true,
				'css'    => [
					[
						'selector' => $inp_selector,
						'property' => 'height',
					],
					[
						'selector' 	=> $select_inp,
						'property' 	=> 'height',
					],
				],
			],

			'inpPadding' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Padding', 'bricks' ),
				'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'padding',
					],
					[
						'selector' => $select_inp,
						'property' => 'padding',
					],
				],
			],

			'inpBackground' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'background-color',
					],
					[
						'selector' => $select_inp,
						'property' => 'background-color',
					],
					[
						'selector' => $selector_ta,
						'property' => 'background-color',
					],
				],
			],

			'inpTypography' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Typography', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' => $inp_selector,
						'property' => 'font',
					],
					[
						'selector' => $select_inp,
						'property' => 'font',
					],
					[
						'selector' => $selector_ta,
						'property' => 'font',
					],
				],
			],

			'phTypography' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Placeholder', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' 	=> "::-webkit-input-placeholder",
						'property' 	=> 'font'
					],
					[
						'selector' 	=> "::-ms-input-placeholder",
						'property' 	=> 'font'
					],
					[
						'selector' 	=> "::-moz-input-placeholder",
						'property' 	=> 'font'
					],
					[
						'selector' 	=> "::-moz-placeholder",
						'property' 	=> 'font'
					]
				],
			],

			'inpBorder' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $inp_selector,
						'property' => 'border',
					],
					[
						'selector' => $select_inp,
						'property' => 'border',
					],
					[
						'selector' => $selector_ta,
						'property' => 'border',
					],
				],
			],

			'inpFocusSep' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Focus', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'inpFBackground' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' 	=> $inp_selector . ":focus",
						'property'  => 'background-color',
					],
					[
						'selector' 	=> $select_inp . ":focus",
						'property'  => 'background-color',
					],
					[
						'selector' 	=> $selector_ta . ":focus",
						'property'  => 'background-color',
					]
				],
			],

			'inpFColor' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Text Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' 	=> $inp_selector . ":focus",
						'property'  => 'color',
					],
					[
						'selector' 	=> $select_inp . ":focus",
						'property'  => 'color',
					],
					[
						'selector' 	=> $selector_ta . ":focus",
						'property'  => 'color',
					]
				],
			],

			'inpFBorder' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' 	=> $inp_selector . ":focus",
						'property'  => 'border-color',
					],
					[
						'selector' 	=> $select_inp . ":focus",
						'property'  => 'border-color',
					],
					[
						'selector' 	=> $selector_ta . ":focus",
						'property'  => 'border-color',
					]
				],
			],

			'buttonSep' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Submit Button', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'width' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Width', 'bricks' ),
				'type'   => 'number',
				'units'  => true,
				'min' 	 => 0,
				'step' 	 => 1,
				'inline' => true,
				'medium' => true,
				'css'    => [
					[
						'selector' => $selector,
						'property' => 'width',
					],
				],
			],

			'padding' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Padding', 'bricks' ),
				'type'  => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'padding',
					],
				],
			],

			'background' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'background-color',
					],
				],
			],

			'typography' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Typography', 'bricks' ),
				'type'   => 'typography',
				'inline' => true,
				'small' => true,
				'css'    => [
					[
						'selector' => $selector,
						'property' => 'font',
					],
				],
			],

			'border' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'border',
					],
				],
			],

			'boxshadow' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Box shadow', 'bricks' ),
				'type'  => 'box-shadow',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => $selector,
						'property' => 'box-shadow',
					],
				],
			],

			'hBtnSep' => [
				'group'  => 'bugfs',
				'label'  => esc_html__( 'Hover', 'bricksultimate' ),
				'type'   => 'separator',
			],

			'transition' => [
				'group' 	=> 'bugfs',
				'label' 	=> esc_html__( 'Transition', 'bricks' ),
				'css' 		=> [
					[
						'property' => 'transition',
						'selector' => $selector,
					],
				],
				'type'        => 'text',
				'placeholder' => 'all 0.2s ease-in',
				'description' => sprintf( '<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Transitions/Using_CSS_transitions" target="_blank">%s</a>', esc_html__( 'Learn more about CSS transitions', 'bricks' ) ),
			],

			'hbackground' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Background Color', 'bricks' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'background-color',
					],
				],
			],

			'hcolor' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Text Color', 'bricksultimate' ),
				'type'  => 'color',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'color',
					],
				],
			],

			'hborder' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Border', 'bricks' ),
				'type'  => 'border',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'border',
					],
				],
			],

			'hboxshadow' => [
				'group' => 'bugfs',
				'label' => esc_html__( 'Box shadow', 'bricks' ),
				'type'  => 'box-shadow',
				'inline' => true,
				'small' => true,
				'css'   => [
					[
						'selector' => "{$selector}:hover",
						'property' => 'box-shadow',
					],
				],
			],

			'inpDesctg' => [
				'group' => 'bugfs',
				'type'      => 'typography',
				'label'     => esc_html__('Fields Description', 'bricks'),
				'small' 	=> true,
				'inline' 	=> true,
				'css' 		=> [
					[
						'selector' 	=> '.brxe-bu-gf-styler .gfield_description:not(.validation_message)',
						'property'  => 'font',
					],
					[
						'selector' 	=> '.brxe-bu-gf-styler .gform_fileupload_rules',
						'property'  => 'font',
					]
				]
			],
		];

		return array_merge( $controls, $gfs_controls );
	}
}