<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooSoldOutBadge extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-sold-out-badge';
	public $icon 			= 'ti-tag';
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Sold Out Badge', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['info'] = [
			'tab'       => 'content',
			'content'    => esc_html__( 'Builder editor will show the demo value for editing. You will get correct data at frontend.', 'bricks' ),
			'type'      => 'info'
		];

		$this->controls['builder_mode'] = [
			'tab' 	=> 'content',
			'type' 	=> 'checkbox',
			'label' => __('Hide In-Builder Editor?', 'bricksultimate'),
			'inline' => true,
		];

		$this->controls['tag'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Tag', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'div' 		=> 'div',
				'span' 		=> 'span',
				'p' 		=> 'p',
				'section' 	=> 'section'
			],
			'inline'    => true,
			'clearable' => false,
			'default'   => 'div',
		];

		$this->controls['product_id'] = [
			'tab' 	=> 'content',
			'type' 	=> 'text',
			'label' => esc_html__( 'Product ID', 'bricksultimate' ),
			'info' 	=> esc_html__('Leave it blank if you are using on single product page or repeater.', 'bricksultimate'),
		];

		$this->controls['badge'] = [
			'tab'       	=> 'content',
			'type'      	=> 'text',
			'label'     	=> esc_html__( 'Badge', 'bricksultimate' ),
			'default' 		=> esc_html__( 'Sold Out', 'woocommerce' ),
			'placeholder' 	=> esc_html__( 'Sold Out', 'woocommerce' ),
			'hasDynamicData' => false
		];

		$this->controls['sep'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Size & Spacing', 'bricksultimate' ),
		];

		$this->controls['width'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'property'  => 'width',
				]
			]
		];

		$this->controls['height'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'property'  => 'height',
				]
			]
		];

		$this->controls['margin'] = [
			'tab' 		=> 'content',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'property'  => 'margin',
				]
			]
		];

		$this->controls['padding'] = [
			'tab' 		=> 'content',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'property'  => 'padding',
				]
			]
		];

		$this->controls['backgroundColor'] = [
			'tab' 			=> 'content',
			'label' 		=> esc_html__( 'Background Color', 'bricks' ),
			'type' 			=> 'color',
			'inline' 		=> true,
			'small' 		=> true,
			'css' 			=> [
				[
					'property' => 'background-color',
				],
			]
		];

		$this->controls['typography'] = [
			'tab' 			=> 'content',
			'label' 		=> esc_html__( 'Typography', 'bricks' ),
			'type' 			=> 'typography',
			'inline' 		=> true,
			'small' 		=> true,
			'css' 			=> [
				[
					'property' => 'font',
				],
			]
		];

		$this->controls['sepFlex'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Layout', 'bricks' ),
		];

		// Display
		$this->controls['display'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => '',
				],
			],
			'default' 		=> 'flex',
			'placeholder' 	=> 'flex',
		];

		$this->controls['flexWrap'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		unset( $this->controls['_spacingSeparator'] );
		unset( $this->controls['_margin'] );
		unset( $this->controls['_padding'] );

		unset( $this->controls['_width'] );
		unset( $this->controls['_height'] );
	}

	// Render element HTML
	public function render() {
		global $product;

		$settings = $this->settings;

		$product_id = Helpers::get_value($settings, 'product_id', false);

		if( empty( $product_id ) || $product_id === false )
			$product_id = $this->post_id;

		if( ! is_object( $product ) ) {
			$product = WC()->product_factory->get_product( $product_id );
		}

		if( $product === false )
			return;

		if( $product->is_in_stock() )
			return;

		$badge = Helpers::get_value($settings, 'badge', __('Sold Out', 'woocommerce'));

		echo "<{$this->tag} {$this->render_attributes('_root')}>{$badge}</{$this->tag}>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-sold-out-badge">
			<component
				:is="tag" 
				v-if="settings.badge&&!settings.builder_mode"
			>
				{{settings.badge}}
			</component>
		</script>
		<?php
	}
}