<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooShipTo extends \Bricks\Element {
	public $category = 'checkout';
	public $name 	= 'bu-shipping-to';
	public $icon 	= 'ti-truck';
	public $nestable = true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Shipping Address Selector', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['radio'] = [
			'title' 	=> esc_html__( 'Radio Buttons', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->control_groups['innerwrap'] = [
			'title' 	=> esc_html__( 'Shipping Fields Container', 'bricksultimate' ),
			'tab' 		=> 'content',
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->control_groups['inlineMsg'] = [
			'title' 	=> esc_html__( 'Inline error message', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['saInfo'] = [
			'type' 		=> 'info',
			'content' 	=> esc_html__( 'Refresh the builder editor for the preview.', 'bricksultimate' ),
		];

		$this->controls['radioButtons'] = [
			'type'  	=> 'checkbox',
			'label' 	=> esc_html__( 'Disable radio buttons', 'bricksultimate' ),
			'description' => esc_html__('If you enable it, this element will work as a form fields container.', 'bricksultimate')
		];

		$this->controls['label1'] = [
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Label of 1st radio button', 'bricksultimate' ),
			'placeholder' => esc_html__('Same as billing address', 'bricksultimate'),
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['label2'] = [
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Label of 2nd radio button', 'bricksultimate' ),
			'placeholder' => esc_html__('Use a different shipping address', 'bricksultimate'),
			'required' 	=> ['radioButtons', '!=', true]
		];

		$selector = '.bu-shipping-option';

		$this->controls['btnwpbg'] = [
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['btnsBorderW'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'border-width',
					'selector' => $selector
				],
				[
					'property' => 'border-bottom-width',
					'selector' => $selector . ' li'
				]
			],
			'default' => '1px',
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['btnsBorderColor'] = [
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => '--bricks-border-color'
				]
			],
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['btnsBorderStyle'] = [
			'type' 	=> 'select',
			'label' => esc_html__( 'Border style', 'bricksultimate' ),
			'options' => [ 'none' => 'none', 'solid' => 'Solid', 'dashed' => 'Dashed', 'dotted' => 'Dotted'],
			'css'	=> [
				[
					'property' => 'border-style',
					'selector' => '.bu-shipping-option, .bu-shipping-option li'
				]
			],
			'default' => 'solid',
			'inline' => true,
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['btnsBorderRadius'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => '--bricks-border-radius'
				]
			],
			'default' => '4px',
			'required' 	=> ['radioButtons', '!=', true]
		];

		$this->controls['btnSpacing'] = [
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Spacing', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector . ' li .bu-shipping-option-wrapper',
				]
			],
			'required' 	=> ['radioButtons', '!=', true]
		];

		/**
		 * Radio
		 * ----------------------------------------*/
		$this->controls['radioLabel'] = [
			'group' => 'radio',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.bu-shipping-option-wrapper label'
				]
			],
		];

		/*$this->controls['radioW'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'label' => esc_html__( 'Label width', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'width',
					'selector' => '.bu-billing-option-wrapper label'
				]
			],
		];*/

		$this->controls['radioGap'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'label' => esc_html__( 'Gap between Label & button', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'gap',
					'selector' => '.bu-shipping-option-wrapper'
				]
			],
		];

		$this->controls['radioSep'] = [
			'group' => 'radio',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Radio button', 'bricksultimate' ),
		];

		$rd_selector = '.bu-shipping-option-wrapper input[type=radio]';

		$this->controls['rdsize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['rdbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['rdbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rd_selector,
				]
			]
		];

		$rdc_checked = '.bu-shipping-option-wrapper input[type=radio]:checked';
		$this->controls['rdcbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rdc_checked,
				]
			],
		];

		$this->controls['rdcbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rdc_checked,
				]
			]
		];

		$bullet = '.bu-shipping-option-wrapper input[type=radio]:checked:after';
		$this->controls['rdBulletSize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Mini bullet size', 'bricksultimate' ),
			'placeholder' 	=> '6px',
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $bullet
				],
				[
					'property' => 'height',
					'selector' => $bullet
				]
			],
		];

		$this->controls['rdBulletolor'] = [
			'group' 	=> 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Mini bullet color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $bullet
				]
			],
		];

		$this->controls['rdBulletPos'] = [
			'group' 	=> 'radio',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Bullet position(Translate)', 'bricksultimate' ),
			'placeholder' => '-50%,-50%',
			'css'   	=> [
				[
					'property' => '--bullet-position',
				]
			],
		];

		/**
		 * Inner wrapper
		 * ----------------------------------------*/
		$selector = '.bu-shipping-form-fields';
		$this->controls['innerBg'] = [
			'group' => 'innerwrap',
			'type' 	=> 'color',
			'label' => esc_html__( 'Background', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['innerBrdClr'] = [
			'group' => 'innerwrap',
			'type' 	=> 'color',
			'label' => esc_html__( 'Border top color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'border-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['innerSpacing'] = [
			'group' => 'innerwrap',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		$this->controls['hideErrorMsg'] = [
			'group' => 'inlineMsg',
			'type' 	=> 'checkbox',
			'label' => esc_html__( 'Hide inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' 	=> 'display',
					'selector' 	=> '.checkout-inline-error-message',
					'value' 	=> 'none'
				]
			]
		];

		$this->controls['errorMsg'] = [
			'group' => 'inlineMsg',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Inline error message', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.checkout-inline-error-message'
				]
			],
			'required' => ['hideErrorMsg', '!=', true]
		];

		$this->controls['errorMsgSp'] = [
			'group' => 'inlineMsg',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Spacing', 'bricksultimate' ),
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => '.checkout-inline-error-message'
				]
			]
		];
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$label_1 = Helpers::get_value($settings, 'label1', esc_html__( 'Same as billing address', 'bricksultimate' ));
		$label_2 = Helpers::get_value($settings, 'label2', esc_html__( 'Use a different shipping address', 'bricksultimate' ));

		$isChecked = apply_filters( 'woocommerce_ship_to_different_address_checked', 'shipping' === get_option( 'woocommerce_ship_to_destination' ) ? 1 : 0 );
		$checked_1 	= (!$isChecked) ? 'checked="checked"' : '';
		$checked_2 	= $isChecked ? 'checked="checked"' : '';
		$class 		= (!$isChecked) ? 'screen-reader-text' : '';
		
		if( function_exists('run_paynow_shipping') ) 
			$class .= ' wc-block-components-address-address-wrapper is-editing';// ' woocommerce-shipping-fields__field-wrapper';

		$this->set_attribute( '_root', 'class', ['woocommerce-shipping-fields'] );

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		
		$children = \Bricks\Frontend::render_children( $this );

		if( empty( $settings['radioButtons'] ) ):
		?>
		<h3 id="ship-to-different-address">
			<input id="ship-to-different-address-checkbox" class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox hidden" <?php checked( $isChecked, 1 ); ?> type="checkbox" name="ship_to_different_address" value="1" />
		</h3>
		<ul id="bu-shipping-option" class="bu-shipping-option bu-radio-buttons">
			<li>
				<div class="bu-shipping-option-wrapper">
					<input type="radio" name="ship_to_address" data-index="0" id="ship_to_address" value="same_as_billing" class="shipping_option" <?php echo $checked_1; ?>><label for="shipping_same_as_billing_radio"><?php echo $label_1; ?></label>
				</div>
			</li>
			<li>
				<div class="bu-shipping-option-wrapper">
					<input type="radio" name="ship_to_address" data-index="1" id="ship_to_diff_address" value="diff_from_billing" class="shipping_option" <?php echo $checked_2; ?>><label for="shipping_diff_from_billing_radio"><?php echo $label_2; ?></label>
				</div>
				<div class="bu-shipping-form-fields <?php echo $class; ?>"><?php echo $children; ?></div>
			</li>
		</ul>
		<?php
		else:
			echo '<div class="wc-block-components-address-address-wrapper is-editing">' . $children . '</div>';
		endif;

		echo "</{$this->tag}>";
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-shipping-to">
			<component :is="tag">
				<ul v-if="!settings.radioButtons" id="bu-shipping-option" class="bu-shipping-option bu-radio-buttons">
					<li>
						<div class="bu-shipping-option-wrapper">
							<input type="radio" name="ship_to_different_address" data-index="0" id="shipping_same_as_billing_radio" value="same_as_shipping" class="shipping_option" checked="checked"><label for="shipping_same_as_billing_radio">{{ settings.label1 ? settings.label1 : 'Same as billing address' }}</label>
						</div>
					</li>
					<li>
						<div class="bu-shipping-option-wrapper">
							<input type="radio" name="ship_to_different_address" data-index="1" id="shipping_diff_from_billing_radio" value="diff_from_shipping" class="shipping_option"><label for="shipping_diff_from_billing_radio">{{ settings.label2 ? settings.label2 : 'Use a different shipping address' }}</label>
						</div>
						<div class="bu-shipping-form-fields wc-block-components-address-address-wrapper is-editing">
							<bricks-element-children :element="element" />
						</div>
					</li>
				</ul>
				<div v-if="settings.radioButtons" class="wc-block-components-address-address-wrapper is-editing">
					<bricks-element-children :element="element" />
				</div>
			</component>
		</script>
	<?php
	}
}