<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooSalesBadge extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-sales-badge';
	public $icon 			= 'ti-tag';
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Sales Badge', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['info'] = [
			'tab'       => 'content',
			'content'    => esc_html__( 'Builder editor will show the demo value for editing. You will get correct data at frontend.', 'bricks' ),
			'type'      => 'info'
		];

		$this->controls['tag'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Tag', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'div' 		=> 'div',
				'span' 		=> 'span',
				'p' 		=> 'p',
				'section' 	=> 'section'
			],
			'inline'    => true,
			'clearable' => false,
			'default'   => 'div',
		];

		$this->controls['product_id'] = [
			'tab' 	=> 'content',
			'type' 	=> 'text',
			'label' => esc_html__( 'Product ID', 'bricksultimate' ),
			'info' 	=> esc_html__('Leave it blank if you are using on single product page or repeater.', 'bricksultimate'),
		];

		$this->controls['type'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Type', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'percentage' 	=> esc_html__( 'Percentage', 'bricksultimate' ),
				'fixed' 		=> esc_html__( 'Fixed Rate', 'bricksultimate' ),
			],
			'inline'    => true,
			'medium' 	=> true,
			'default'   => 'percentage',
		];

		$this->controls['math'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Math logic', 'bricksultimate' ),
			'type'      => 'select',
			'options'   => [
				'ceil' 		=> esc_html__( 'Ceil', 'bricksultimate' ),
				'floor' 	=> esc_html__( 'Floor', 'bricksultimate' ),
				'round' 	=> esc_html__( 'Round', 'bricksultimate' ),
			],
			'inline'    => true,
			'medium' 	=> true,
			'default'   => 'round',
			'required' 	=> [ 'type', '=', 'percentage' ]
		];

		$this->controls['before'] = [
			'tab'       	=> 'content',
			'type'      	=> 'text',
			'label'     	=> esc_html__( 'Before Text', 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter before text', 'bricksultimate'),
		];

		$this->controls['after'] = [
			'tab'       	=> 'content',
			'type'      	=> 'text',
			'label'     	=> esc_html__( 'After Text', 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter after text', 'bricksultimate'),
		];

		$this->controls['sepFlex'] = [
			'tab'       	=> 'content',
			'type'      	=> 'separator'
		];

		// Display
		$this->controls['display'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline',
				'none'         => 'none',
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => '',
				],
			],
			'default' 		=> 'flex',
			'placeholder' 	=> 'flex',
		];

		$this->controls['flexWrap'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'tab'      => 'content',
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' => [ 'display', '=', [ '', 'flex' ] ],
		];

		$this->controls['sep'] = [
			'tab'       => 'content',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Size & Spacing', 'bricksultimate' ),
		];

		$this->controls['width'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'width',
				]
			]
		];

		$this->controls['height'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'height',
				]
			]
		];

		$this->controls['margin'] = [
			'tab' 		=> 'content',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'margin',
				]
			]
		];

		$this->controls['padding'] = [
			'tab' 		=> 'content',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'padding',
				]
			]
		];

		$this->controls['backgroundColor'] = [
			'tab' 			=> 'content',
			'label' 		=> esc_html__( 'Background Color', 'bricks' ),
			'type' 			=> 'color',
			'inline' 		=> true,
			'small' 		=> true,
			'css' 			=> [
				[
					'property' => 'background-color',
					'selector' => '',
				],
			]
		];

		$this->controls['typography'] = [
			'tab' 			=> 'content',
			'label' 		=> esc_html__( 'Typography', 'bricks' ),
			'type' 			=> 'typography',
			'inline' 		=> true,
			'small' 		=> true,
			'css' 			=> [
				[
					'property' => 'font',
					'selector' => '',
				],
			]
		];

		unset( $this->controls['_spacingSeparator'] );
		unset( $this->controls['_margin'] );
		unset( $this->controls['_padding'] );

		unset( $this->controls['_width'] );
		unset( $this->controls['_height'] );
	}

	// Render element HTML
	public function render() {
		global $product;

		$settings = $this->settings;

		$calculate = Helpers::get_value( $settings, 'type', 'percentage');
		$product_id = Helpers::get_value($settings, 'product_id', false);

		if( empty( $product_id ) || $product_id === false )
			$product_id = $this->post_id;

		if( ! is_object( $product ) ) {
			$product = WC()->product_factory->get_product( $product_id );
		}

		if( $product == false && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   => 1,
					'orderby' => 'date',
					'order'   => 'DESC',
				]
			)[0];
		}

		if( $product === false )
			return;

		if( $product->is_type('simple') || $product->is_type('external') || $product->is_type('variation') ) {
			$regular_price = (float) $product->get_regular_price();
			$sale_price = (float) $product->get_sale_price();
		}

		if( $product->is_type('variable') ) {
			$regular_price = (float) $product->get_variation_regular_price( 'min', true );
			$sale_price = (float) $product->get_variation_sale_price( 'min', true );
		}

		$before = Helpers::get_value( $settings, 'before', false);
		$after = Helpers::get_value( $settings, 'after', false);

		if( empty( $sale_price ) || absint( $sale_price ) < 1 ) {
			if( Helpers::isBricksBuilderActive() ) {
				if( $calculate == 'fixed' ) {
					$sales_off_price = wc_price( 10 );
				} else {
					$sales_off_price = '10%';
				}

				echo "<{$this->tag} {$this->render_attributes('_root')}>";
				echo ( $before ? wp_kses_post( $before ) . ' ' : '' ) . $sales_off_price . ( $after ? ' ' . wp_kses_post( $after ) : '' );
				echo "</{$this->tag}>";

				return;
			} else {
				return;
			}
		}

		if( $regular_price < 1 )
			return;

		if( $calculate == 'fixed' ) {
			$sales_off_price = ( $regular_price - $sale_price );
		} else {
			$math_fn = Helpers::get_value( $settings, 'math', 'ceil' );
			if( $math_fn == 'ceil' )
				$sales_off_price = ceil( 100 - ( $sale_price / $regular_price * 100 ) );
			elseif( $math_fn == 'round' )
				$sales_off_price = round( 100 - ( $sale_price / $regular_price  * 100 ) );
			else
				$sales_off_price = floor( 100 - ( $sale_price / $regular_price * 100 ) );
		}

		if( $sales_off_price < 1 )
			return;

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		echo ( $before ? wp_kses_post( $before ) . ' ' : '' ) . 
			( ( $calculate == 'fixed' ) ? wc_price( $sales_off_price ) : $sales_off_price . '%' ) . 
			( $after ? ' ' . wp_kses_post( $after ) : '' );
		echo "</{$this->tag}>";
	}
}