<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooQuantity extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-qty';
	public $icon 			= 'ti-plus';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Quantity', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['triggerSelector'] = [
			'tab' 		=> 'content',
			'type'      => 'text',
			'label'     => esc_html__( 'Add to cart button selector', 'bricks' ),
			'placeholder' => '.brxe-product-add-to-cart a',
			'description' => esc_html__('Bridge with the Add To Cart button.', 'bricksultimate')
		];

		//* Quantity
		$selector = '.quantity';

		$this->controls['qtyWidth'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '75px',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$this->controls['qtyHeight'] = [
			'tab' 		=> 'content',
			'type'      => 'number',
			'label'     => esc_html__( 'Wrapper Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$this->controls['wraprBg'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Wrapper Background', 'bricksultimate' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			]
		];

		$this->controls['wrapBorder'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Wrapper Border', 'bricksultimate' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$this->controls['pmBtnSep'] = [
			'tab'   => 'content',
			'label' => esc_html__( '+/- Buttons', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['pmBtnDisable'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Disable it', 'bricksultimate' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'property' => 'display',
					'selector' => $selector . ' .action',
					'value' 	=> 'none'
				]
			],
		];

		$this->controls['pmBtnWidth'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .action',
				]
			],
			'placeholder' => '40px'
		];

		$this->controls['pmBtnBG'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnSize'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Size', 'bricksultimate' ),
			'type'  => 'number',
			'unit' 	=> 'px',
			'placeholder' => '13px', 
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'width',
				],
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'height',
				]
			]
		];

		$this->controls['pmBtnColor'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['pmBtnBrd'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$this->controls['pmBtnHBG'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Hover Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['pmBtnHColor'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Hover Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover svg',
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['pmBtnHBrd'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Hover Border', 'bricks' ),
			'type'  => 'border',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .action:hover',
					'property' 	=> 'border',
					'important' => true
				]
			]
		];

		$this->controls['inpSep'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Quantity field', 'bricksultimate' ),
			'type'  => 'separator',
		];

		$this->controls['inpWidth'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Width', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'width',
					'selector' => $selector . ' .qty',
				],
			],
			'placeholder' => '25px'
		];

		$this->controls['inpBG'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['qtySize'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Font Size', 'bricks' ),
			'type'  => 'number',
			'units' => true,
			'css'   => [
				[
					'property' => 'font-size',
					'selector' => $selector . ' .qty',
				],
			],
			'placeholder' => '10px'
		];

		$this->controls['inpColor'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty',
					'property' 	=> 'color',
				]
			]
		];

		$this->controls['inpFocusBG'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Focus Background', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'background-color',
				]
			]
		];

		$this->controls['inpFocusColor'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Focus Color', 'bricksultimate' ),
			'type'  => 'color',
			'css' 	=> [
				[
					'selector' 	=> $selector . ' .qty:focus',
					'property' 	=> 'color',
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-item-qty', Helpers::get_asset_url('css') . 'buitemqty.min.css', [], filemtime(Helpers::get_asset_path('css') . 'buitemqty.min.css'), 'all' );
		} else {*/
			wp_enqueue_script( 'bu-atci', Helpers::get_asset_url('js') . 'buatci.min.js', ['jquery','wc-add-to-cart'], filemtime(Helpers::get_asset_path('js') . 'buatci.min.js'), true );
		//}
	}

	// Render element HTML
	public function render() {
		global $product;

		$product = wc_get_product( $this->post_id );

		if( $product == false && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   => 1,
					'orderby' => 'date',
					'order'   => 'DESC',
				]
			)[0];
		}

		if ( empty( $product ) ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'For better preview select content to show.', 'bricks' ),
					'description' => esc_html__( 'Go to: Settings > Template Settings > Populate Content', 'bricks' ),
				]
			);
		}

		if( $product->is_in_stock() && in_array($product->get_type(), [ 'simple', 'variation' ]) && $product->is_purchasable()) {
			$this->set_attribute('_root', 'class', [ 'woocommerce' ]);

			$this->set_attribute('_root', 'data-trigger-class', Helpers::get_value( $this->settings, 'triggerSelector', '.brxe-product-add-to-cart a') );

			echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
			echo $this->getQtyForm( $product );
			echo "</{$this->tag}>";
		}
	}

	public function getQtyForm( $product ) {
		$quantity = 1;
		$args = array(
			//'input_id'     => uniqid( 'quantity_' ),
			'input_name'   => 'quantity',
			'input_value'  => $quantity,
			'classes'      => apply_filters( 'woocommerce_quantity_input_classes', array( 'input-text', 'qty', 'text' ), $product ),
			'max_value'    => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
			'min_value'    => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
			'step'         => apply_filters( 'woocommerce_quantity_input_step', 1, $product ),
			'pattern'      => apply_filters( 'woocommerce_quantity_input_pattern', has_filter( 'woocommerce_stock_amount', 'intval' ) ? '[0-9]*' : '' ),
			'inputmode'    => apply_filters( 'woocommerce_quantity_input_inputmode', has_filter( 'woocommerce_stock_amount', 'intval' ) ? 'numeric' : '' ),
			'product_name' => $product ? $product->get_title() : '',
			'placeholder'  => apply_filters( 'woocommerce_quantity_input_placeholder', '', $product ),
			'autocomplete' => apply_filters( 'woocommerce_quantity_input_autocomplete', 'off', $product ),
		);

		$args = apply_filters( 'woocommerce_quantity_input_args', $args, $product );

		// Apply sanity to min/max args - min cannot be lower than 0.
		$args['min_value'] = max( $args['min_value'], 0 );
		$args['max_value'] = 0 < $args['max_value'] ? $args['max_value'] : '';

		// Max cannot be lower than min if defined.
		if ( '' !== $args['max_value'] && $args['max_value'] < $args['min_value'] ) {
			$args['max_value'] = $args['min_value'];
		}
		
		if( class_exists( 'Morningtrain\WooAdvancedQTY\Plugin\Controllers\InputArgsController' ) ) {
			$advnargs = Morningtrain\WooAdvancedQTY\Plugin\Controllers\InputArgsController::applyArgs(array(), $cart_item['product_id'], true);
			if( isset( $advnargs['min_value'] ) && $advnargs['min_value'] > $args['min_value'] )
				$args['min_value'] = $advnargs['min_value'];
			
			if( isset( $advnargs['max_value'] ) && $advnargs['max_value'] > $args['max_value'] )
				$args['max_value'] = $advnargs['max_value'];
		}

		/* translators: %s: Quantity. */
		$label = ! empty( $args['product_name'] ) ? sprintf( esc_html__( '%s quantity', 'woocommerce' ), wp_strip_all_tags( $args['product_name'] ) ) : esc_html__( 'Quantity', 'woocommerce' );

		ob_start();
		?>
		<div class="quantity">
			<?php do_action( 'woocommerce_before_quantity_input_field' ); ?>
			<label class="screen-reader-text"><?php echo esc_attr( $label ); ?></label>
			<input
				type="number"
				class="<?php echo esc_attr( join( ' ', (array) $args['classes'] ) ); ?>"
				step="<?php echo esc_attr( $args['step'] ); ?>"
				min="<?php echo esc_attr( $args['min_value'] ); ?>"
				max="<?php echo esc_attr( 0 < $args['max_value'] ? $args['max_value'] : '' ); ?>"
				name="<?php echo esc_attr( $args['input_name'] ); ?>"
				value="<?php echo esc_attr( $args['input_value'] ); ?>"
				title="<?php echo esc_attr_x( 'Qty', 'Product quantity input tooltip', 'woocommerce' ); ?>"
				size="4"
				placeholder="<?php echo esc_attr( $args['placeholder'] ); ?>"
				inputmode="<?php echo esc_attr( $args['inputmode'] ); ?>"
				autocomplete="<?php echo esc_attr( isset( $args['autocomplete'] ) ? $args['autocomplete'] : 'on' ); ?>"
			/>
			<?php do_action( 'woocommerce_after_quantity_input_field' ); ?>
		</div>
		<?php

		return ob_get_clean();
	}
}