<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooProductImage extends \Bricks\Element {
	public $category 	= 'ultimate';
	public $name 		= 'bu-product-image';
	public $icon 		= 'ti-image';
	public $scripts  	= [ 'bricksSplide' ];
	public $tag 		= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Product Image', 'bricksultimate' );
	}

	public function set_control_groups() {

		$this->control_groups['options'] = [
			'title' => esc_html__( 'Slider Options', 'bricks' ),
			'required' 	=> ['effect', '=', 'splide'],
		];

		$this->control_groups['arrows'] = [
			'title' => esc_html__( 'Arrows', 'bricks' ),
			'required' 	=> ['effect', '=', 'splide'],
		];

		$this->control_groups['pagination'] = [
			'title' => esc_html__( 'Pagination', 'bricks' ),
			'required' 	=> ['effect', '=', 'splide'],
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['image_size'] = [
			'tab' 		=> 'content',
			'type'      => 'select',
			'label'     => esc_html__('Thumbnail resolution', 'bricksultimate'),
			'options'   => $this->control_options['imageSizes'],
			'default'   => 'woocommerce_thumbnail'
		];

		$this->controls['objectFit'] = [
			'label'   => esc_html__( 'Object fit', 'bricks' ),
			'type'    => 'select',
			'inline'  => true,
			'options' => $this->control_options['objectFit'],
			'css'     => [
				[
					'selector' => 'img',
					'property' => 'object-fit',
				],
			],
		];

		$this->controls['objectPosition'] = [
			'label'  => esc_html__( 'Object position', 'bricks' ),
			'type'   => 'text',
			'inline' => true,
			'dd'     => false,
			'css'    => [
				[
					'selector' => 'img',
					'property' => 'object-position',
				],
			],
		];

		$this->controls['linkToPost'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Link to post', 'bricks' ),
			'type'  => 'checkbox',
		];

		$this->controls['hoverImg'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Show gallery images', 'bricksultimate' ),
			'type'  => 'checkbox',
		];

		$this->controls['effect'] = [
			'tab'   => 'content',
			'label' => esc_html__( 'Effect', 'bricksultimate' ),
			'type'  => 'select',
			'options'   => [
				'fade' 		=> 'Image on hover',
				'flip' 		=> 'Flip',
				'splide' 	=> 'Slider'
			],
			'required' => ['hoverImg', '=', true],
			'placeholder' => esc_html__( 'Image on hover', 'bricksultimate' ),
			'inline' => true
		];

		$this->controls['outerSelector'] = [
			'label' => esc_html__( 'Container selector', 'bricksultimate' ),
			'type'  => 'text',
			'hasDynamicData' => false,
			'required' => [ ['hoverImg', '=', true], ['effect', '=', 'fade'] ],
			'placeholder' => '.brxe-loop-builder-on',
			'description' => esc_html__('The image will change when a user enters the mouse in this container.', 'bricksultimate')
		];

		$this->controls['hoverTransition'] = [
			'label' => esc_html__( 'Transition', 'bricksultimate' ),
			'type'  => 'text',
			'placeholder' => 'opacity 0.5s ease,transform 2s cubic-bezier(0,0,.44,1.18)',
			'required' => [ ['hoverImg', '=', true], ['effect', '=', 'fade'] ],
			'css' => [
				[
					'property' => 'transition',
					'selector' => '.hover-img'
				]
			]
		];

		$this->controls['initScale'] = [
			'label' => esc_html__( 'Initial scale', 'bricksultimate' ),
			'type'  => 'number',
			'unitless' => true,
			'required' => [ ['hoverImg', '=', true], ['effect', '=', 'fade'] ],
			'css' => [
				[
					'property' => 'transform',
					'selector' => '.hover-img',
					'value' 	=> 'scale(%s)'
				]
			]
		];

		$this->controls['hoverScale'] = [
			'label' => esc_html__( 'Hover scale', 'bricksultimate' ),
			'type'  => 'number',
			'unitless' => true,
			'required' => [ ['hoverImg', '=', true], ['effect', '=', 'fade'] ],
			'css' => [
				[
					'property' => 'transform',
					'selector' => '&.fade:hover .hover-img, &.fade .bu-mouse-enter.hover-img',
					'value' 	=> 'scale(%s)'
				]
			]
		];

		/**
		 * Slider section
		 */

		$this->controls['slideType'] = [
			'tab' 		  => 'content',
			'group'       => 'options',
			'label'       => esc_html__( 'Type', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'loop'  => esc_html__( 'Loop', 'bricks' ),
				'slide' => esc_html__( 'Slide', 'bricks' ),
				'fade'  => esc_html__( 'Fade', 'bricks' ),
			],
			'inline'      => true,
			'fullAccess'  => true,
			'default' 	=> 'slide',
			'placeholder' => esc_html__( 'Slide', 'bricks' ),
		];

		$this->controls['direction'] = [
			'tab' 		=> 'content',
			'group'       => 'options',
			'label'       => esc_html__( 'Direction', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'ltr' => esc_html__( 'Left to right', 'bricks' ),
				'rtl' => esc_html__( 'Right to left', 'bricks' ),
			],
			'inline'      => true,
			'placeholder' => esc_html__( 'Left to right', 'bricks' ),
			'breakpoints' => true,
			'fullAccess'  => true,
		];

		$this->controls['keyboard'] = [
			'tab' 		=> 'content',
			'group'       => 'options',
			'label'       => esc_html__( 'Keyboard', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'false'   => esc_html__( 'Off', 'bricks' ),
				'focused' => esc_html__( 'Focused', 'bricks' ),
				'global'  => esc_html__( 'Global', 'bricks' ),
			],
			'inline'      => true,
			'placeholder' => esc_html__( 'Global', 'bricks' ),
			'breakpoints' => true,
			'fullAccess'  => true,
		];

		$this->controls['autoplay'] = [
			'tab' 		=> 'content',
			'group'       => 'options',
			'label'      => esc_html__( 'Autoplay', 'bricks' ),
			'type'       => 'checkbox',
			'required'   => ['slideType', '=', 'loop' ],
			'fullAccess' => true,
		];

		$this->controls['speed'] = [
			'tab' 		=> 'content',
			'group'       => 'options',
			'label'       => esc_html__( 'Speed in ms', 'bricks' ),
			'type'        => 'number',
			'placeholder' => 400,
			'breakpoints' => true,
			'fullAccess'  => true,
		];

		$this->controls['interval'] = [
			'tab' 		=> 'content',
			'group'       => 'options',
			'label'       => esc_html__( 'Interval in ms', 'bricks' ),
			'type'        => 'number',
			'required'    => [ 'autoplay', '!=', true ],
			'placeholder' => 3000,
			'fullAccess'  => true,
		];

		$this->controls['slidesLimit'] = [
			'tab'   => 'content',
			'group' => 'options',
			'label' => esc_html__( 'Slides limit', 'bricksultimate' ),
			'info' 	=> esc_html__( 'Leave empty or enter 0 to show all slides', 'bricksultimate' ),
			'placeholder' => 0,
			'type'  => 'number',
			'min' 	=> 0,
			'max' 	=> 100,
			'step' 	=> 1,
			'inline' => true,
			'unitless' => true
		];

		// Arrows

		$this->controls['arrows'] = [
			'group'      => 'arrows',
			'label'      => esc_html__( 'Show', 'bricks' ),
			'type'       => 'checkbox',
			'inline'     => true,
			'rerender'   => true,
			'fullAccess' => true,
		];

		$this->controls['arrowsOnHover'] = [
			'group'      => 'arrows',
			'label'      => esc_html__( 'Show on hover', 'bricks' ),
			'type'       => 'checkbox',
			'inline'     => true,
			'rerender'   => true,
			'fullAccess' => true,
			'required'   => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowHeight'] = [
			'group'       => 'arrows',
			'label'       => esc_html__( 'Height', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'height',
					'selector' => '.splide__arrow',
				],
			],
			'placeholder' => 50,
			'required'    => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowWidth'] = [
			'group'       => 'arrows',
			'label'       => esc_html__( 'Width', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'width',
					'selector' => '.splide__arrow',
				],
			],
			'placeholder' => 50,
			'required'    => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowBackground'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Background', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.splide__arrow',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowBorder'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.splide__arrow',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowColor'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.splide__arrow',
				],
				[
					'property' => 'fill',
					'selector' => '.splide__arrow svg',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowSize'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Size', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'font-size',
					'selector' => '.splide__arrow',
				],
				[
					'property' => 'height',
					'selector' => '.splide__arrow svg',
				],
				[
					'property' => 'width',
					'selector' => '.splide__arrow svg',
				],
				[
					'property' => 'min-height',
					'selector' => '.splide__arrow',
				],
				[
					'property' => 'min-width',
					'selector' => '.splide__arrow',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		// text-shadow (@since 1.8.5)
		$this->controls['arrowTextShadow'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Text shadow', 'bricks' ),
			'type'     => 'text-shadow',
			'css'      => [
				[
					'property' => 'text-shadow',
					'selector' => '.splide__arrow',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		// Custom arrows typography
		$this->controls['arrowTypography'] = [
			'deprecated' => true, // @since 1.8.5 (use 'arrowTextShadow' setting above)
			'group'      => 'arrows',
			'label'      => esc_html__( 'Typography', 'bricks' ),
			'type'       => 'typography',
			'css'        => [
				[
					'property' => 'font',
					'selector' => '.splide__arrow',
				],
			],
			'exclude'    => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'letter-spacing',
				'line-height',
				'text-decoration',
				'text-transform',
			],
			'required'   => [
				[ 'arrows', '!=', '' ],
				[ 'prevArrow.icon', '!=', '' ],
				[ 'nextArrow.icon', '!=', '' ],
			],
		];

		/**
		 * DISABELED ARROW
		 *
		 * First/last arrow when not using 'loop' option.
		 *
		 * @since 1.8.5
		 */

		$this->controls['disabledArrowSeparator'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Disabled', 'bricks' ),
			'type'     => 'separator',
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowDisabledBackground'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Background', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'background-color',
					'selector' => '.splide__arrow:disabled',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowDisabledBorder'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.splide__arrow:disabled',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowDisabledColor'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.splide__arrow:disabled',
				],
				[
					'property' => 'fill',
					'selector' => '.splide__arrow:disabled svg',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['arrowDisabledOpacity'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Opacity', 'bricks' ),
			'type'     => 'number',
			'inline'   => true,
			'min'      => 0,
			'max'      => 1,
			'step'     => 0.1,
			'css'      => [
				[
					'property' => 'opacity',
					'selector' => '.splide__arrow:disabled',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		// PREV ARROW

		$this->controls['prevArrowSeparator'] = [
			'group'      => 'arrows',
			'label'      => esc_html__( 'Prev arrow', 'bricks' ),
			'type'       => 'separator',
			'required'   => [ 'arrows', '!=', '' ],
			'fullAccess' => true,
		];

		$this->controls['prevArrow'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Prev arrow', 'bricks' ),
			'type'     => 'icon',
			'rerender' => true,
			'css'      => [
				[
					'selector' => '.splide__arrow--prev > *',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['prevArrowTop'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Top', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'top',
					'selector' => '.splide__arrow--prev',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['prevArrowRight'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Right', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => '.splide__arrow--prev',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['prevArrowBottom'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Bottom', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'bottom',
					'selector' => '.splide__arrow--prev',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['prevArrowLeft'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Left', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => '.splide__arrow--prev',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		// NEXT ARROW

		$this->controls['nextArrowSeparator'] = [
			'group'      => 'arrows',
			'label'      => esc_html__( 'Next arrow', 'bricks' ),
			'type'       => 'separator',
			'required'   => [ 'arrows', '!=', '' ],
			'fullAccess' => true,
		];

		$this->controls['nextArrow'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Next arrow', 'bricks' ),
			'type'     => 'icon',
			'rerender' => true,
			'css'      => [
				[
					'selector' => '.splide__arrow--next > *',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['nextArrowTop'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Top', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'top',
					'selector' => '.splide__arrow--next',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['nextArrowRight'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Right', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => '.splide__arrow--next',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['nextArrowBottom'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Bottom', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'bottom',
					'selector' => '.splide__arrow--next',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];

		$this->controls['nextArrowLeft'] = [
			'group'    => 'arrows',
			'label'    => esc_html__( 'Left', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => '.splide__arrow--next',
				],
			],
			'required' => [ 'arrows', '!=', '' ],
		];


		// Pagination (dots)
		$this->controls['pagination'] = [
			'group'      => 'pagination',
			'label'      => esc_html__( 'Show', 'bricks' ),
			'type'       => 'checkbox',
			'inline'     => true,
			'rerender'   => true,
			'default'    => true,
			'fullAccess' => true,
		];

		$this->controls['paginationSpacing'] = [
			'group'       => 'pagination',
			'label'       => esc_html__( 'Margin', 'bricks' ),
			'type'        => 'spacing',
			'css'         => [
				[
					'property' => 'margin',
					'selector' => '.splide__pagination .splide__pagination__page',
				],
			],
			'placeholder' => [
				'top'    => '5px',
				'right'  => '5px',
				'bottom' => '5px',
				'left'   => '5px',
			],
			'required'    => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationHeight'] = [
			'group'       => 'pagination',
			'label'       => esc_html__( 'Height', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'units'       => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'css'         => [
				[
					'property' => 'height',
					'selector' => '.splide__pagination .splide__pagination__page',
				],
			],
			'placeholder' => '10px',
			'required'    => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationWidth'] = [
			'group'       => 'pagination',
			'label'       => esc_html__( 'Width', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'units'       => [
				'px' => [
					'min' => 1,
					'max' => 100,
				],
			],
			'css'         => [
				[
					'property' => 'width',
					'selector' => '.splide__pagination .splide__pagination__page',
				],
			],
			'placeholder' => '10px',
			'required'    => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationColor'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.splide__pagination .splide__pagination__page',
				],
				[
					'property' => 'background-color',
					'selector' => '.splide__pagination .splide__pagination__page',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationBorder'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.splide__pagination .splide__pagination__page',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		// ACTIVE

		$this->controls['paginationActiveSeparator'] = [
			'group'      => 'pagination',
			'label'      => esc_html__( 'Active', 'bricks' ),
			'type'       => 'separator',
			'required'   => [ 'pagination', '!=', '' ],
			'fullAccess' => true,
		];

		$this->controls['paginationHeightActive'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Height', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'height',
					'selector' => '.splide__pagination .splide__pagination__page.is-active',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationWidthActive'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Width', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'width',
					'selector' => '.splide__pagination .splide__pagination__page.is-active',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationColorActive'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'property' => 'color',
					'selector' => '.splide__pagination .splide__pagination__page.is-active',
				],
				[
					'property' => 'background-color',
					'selector' => '.splide__pagination .splide__pagination__page.is-active',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationBorderActive'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'property' => 'border',
					'selector' => '.splide__pagination .splide__pagination__page.is-active',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		// POSITION

		$this->controls['paginationPositionSeparator'] = [
			'group'      => 'pagination',
			'label'      => esc_html__( 'Position', 'bricks' ),
			'type'       => 'separator',
			'required'   => [ 'pagination', '!=', '' ],
			'fullAccess' => true,
		];

		$this->controls['paginationTop'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Top', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'top',
					'selector' => '.splide__pagination',
				],
				[
					'property' => 'bottom',
					'value'    => 'auto',
					'selector' => '.splide__pagination',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationRight'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Right', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'right',
					'selector' => '.splide__pagination',
				],
				[
					'property' => 'left',
					'value'    => 'auto',
					'selector' => '.splide__pagination',
				],
				[
					'property' => 'transform',
					'selector' => '.splide__pagination',
					'value'    => 'translateX(0)',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationBottom'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Bottom', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'bottom',
					'selector' => '.splide__pagination',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];

		$this->controls['paginationLeft'] = [
			'group'    => 'pagination',
			'label'    => esc_html__( 'Left', 'bricks' ),
			'type'     => 'number',
			'units'    => true,
			'css'      => [
				[
					'property' => 'left',
					'selector' => '.splide__pagination',
				],
				[
					'property' => 'right',
					'value'    => 'auto',
					'selector' => '.splide__pagination',
				],
				[
					'property' => 'transform',
					'selector' => '.splide__pagination',
					'value'    => 'translateX(0)',
				],
			],
			'required' => [ 'pagination', '!=', '' ],
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		$effect = Helpers::get_value( $this->settings, 'effect', 'fade' );
		if( $effect == 'splide' ) {
			wp_enqueue_script( 'bricks-splide' );
			wp_enqueue_style( 'bricks-splide' );
		}
		
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-prd-image', Helpers::get_asset_url('css') . 'prdimg.min.css', [], filemtime(Helpers::get_asset_path('css') . 'prdimg.min.css') );
		}*/
	}

	/**
	 * Render arrows (use custom HTML solution as splideJS only accepts SVG path via 'arrowPath')
	 */
	public function render_arrows() {
		$prev_arrow = ! empty( $this->settings['prevArrow'] ) ? self::render_icon( $this->settings['prevArrow'] ) : false;
		$next_arrow = ! empty( $this->settings['nextArrow'] ) ? self::render_icon( $this->settings['nextArrow'] ) : false;

		if ( ! $prev_arrow && ! $next_arrow ) {
			return;
		}

		$output = '<div class="splide__arrows custom">';

		if ( $prev_arrow ) {
			$output .= '<button class="splide__arrow splide__arrow--prev" type="button">' . $prev_arrow . '</button>';
		}

		if ( $next_arrow ) {
			$output .= '<button class="splide__arrow splide__arrow--next" type="button">' . $next_arrow . '</button>';
		}

		$output .= '</div>';

		return $output;
	}

	// Render element HTML
	public function render() {
		global $product;

		$product = wc_get_product( $this->post_id );

		if( $product == false && $item = \BricksUltimate\DynamicData\ProviderUltimate::getOrderItem() ) {
			$product = $item->get_product();
		} elseif( $product == false && ( bricks_is_builder() || bricks_is_builder_iframe() || Helpers::isBricksBuilderActive() ) ) {
			$product = wc_get_products(
				[
					'limit'   => 1,
					'orderby' => 'date',
					'order'   => 'DESC',
				]
			)[0];
		}

		if( $product === false ) return;

		if( ! method_exists( $product, 'get_image_id' ) ) return;

		$product_image = $product->get_image_id();

		if( empty( $product_image ) ) {
			$product_image = get_option( 'woocommerce_placeholder_image', 0 );
		}
		
		if( empty( $product_image ) ) {
			return;
		}

		$settings 		= $this->settings;
		$image_size 	= Helpers::get_value( $settings, 'image_size', 'woocommerce_thumbnail' );
		$effect 		= Helpers::get_value( $settings, 'effect', 'fade' );
		$link_to_post 	= isset( $settings['linkToPost'] );
		$attachment_ids = $product->get_gallery_image_ids();
		$flipTag 		= ( $link_to_post ) ? 'a' : 'span';
		$output = '';

		// Arrows
		$arrows = isset( $settings['arrows'] );

		if ( $arrows ) {
			// Custom arrows set OR use default splide SVG arrows if no custom arrows set
			$arrows = ( ! empty( $settings['prevArrow'] ) && ! empty( $settings['nextArrow'] ) ) || ( empty( $settings['prevArrow'] ) && empty( $settings['nextArrow'] ) );
		}

		if ( $link_to_post ) {
			$this->set_attribute( 'flip-image', 'href', get_the_permalink( $this->post_id ) );
		}

		if ( $effect == 'flip' && $attachment_ids ) {
			$this->set_attribute( 'flip-image', 'class', 'flip-container' );
		}

		if ( $effect == 'fade' && Helpers::get_value( $settings, 'outerSelector', false ) ) {
			$this->set_attribute( '_root', 'data-selector', Helpers::get_value( $settings, 'outerSelector', false ) );
		}
		
		if( ! empty( $settings['hoverImg'] ) ) {
			if( $effect == 'splide' ) {
				if ( $attachment_ids ) {
					if( isset( $settings['arrowsOnHover'] ) && $this->is_frontend ) {
						$effect .= ' arrows-on-hover';
					}

					$this->set_attribute( '_root', 'class', [ $effect, 'brxe-slider-nested'] );
					$splide_options = [
						'type'         => ! empty( $settings['slideType'] ) ? $settings['slideType'] : 'slide',
						'direction'    => ! empty( $settings['direction'] ) ? $settings['direction'] : ( is_rtl() ? 'rtl' : 'ltr' ),
						'gap' 		   => '0px',
						'keyboard'     => ! empty( $settings['keyboard'] ) ? $settings['keyboard'] : 'global',
						'start'        => 0,
						'perPage'      => 1,
						'perMove'      => 1,
						'speed'        => ! empty( $settings['speed'] ) ? $settings['speed'] : 400,
						'interval'     => ! empty( $settings['interval'] ) ? $settings['interval'] : 3000,
						'autoHeight'   => true,
						'autoplay'     => isset( $settings['autoplay'] ),
						'pauseOnHover' => true,
						'pauseOnFocus' => true,
						'pagination'   => isset( $settings['pagination'] ),
						'arrows'       => $arrows,
					];

					// STEP: Add settings per breakpoints to splide options
					$breakpoints = [];

					foreach ( \Bricks\Breakpoints::$breakpoints as $breakpoint ) {
						foreach ( array_keys( $splide_options ) as $option ) {
							$setting_key      = "$option:{$breakpoint['key']}";
						}
					}

					if ( count( $breakpoints ) ) {
						$splide_options['breakpoints'] = $breakpoints;
					}

					// Buider: Disable splideJS drag to allow for Bricks DnD
					if ( ! $this->is_frontend ) {
						$splide_options['autoplay'] = false;
						$splide_options['noDrag']   = '.bricks-draggable-item';
						// $splide_options['drag'] = false;
					}

					$this->set_attribute( '_root', 'data-splide', trim( wp_json_encode( $splide_options ) ) );

					$attachment_ids = array_merge( [ $product_image ], $attachment_ids );

					if ($product && $product->is_type('variable')) {
						/*$variations = $product->get_available_variations();

						foreach ($variations as $variation) {
							if (!empty($variation['image_id'])) {
								$attachment_ids[] = $variation['image_id'];
							}
						}*/

						$variation_ids = $product->get_children();
						foreach ($variation_ids as $variation_id) {
							$variation = wc_get_product($variation_id);
							$image_id = $variation->get_image_id();
							if ($image_id) {
								$attachment_ids[] = $image_id;
							}
						}
					}

					$attachment_ids = array_unique( $attachment_ids );
					$limit = absint( Helpers::get_value( $settings, 'slidesLimit', 0 ) );
					
					$output .= '<div class="splide__track">';
					$output .= '<div class="splide__list">';

					foreach ( $attachment_ids as $index => $value ) {
						if( empty ( $value ) )
							continue;

						if( $limit > 0 && ( $index >= $limit ) )
							break;

						$this->set_attribute( "flip-image", 'class', 'brxe-block' );

						$output .= "<{$flipTag} {$this->render_attributes("flip-image")} data-image-id='{$value}'>";
						$output .= wp_get_attachment_image( $value, $image_size, false, [] );
						$output .= "</{$flipTag}>";
					}
					
					$output .= '</div>'; // .splide__track
					$output .= '</div>'; // .splide__list

					if ( isset( $settings['arrows'] ) ) {
						$output .= $this->render_arrows();
					}

				} else {
					$output .= "<{$flipTag} {$this->render_attributes('flip-image')}>";
					$output .= $product->get_image( $image_size, [], true );
					$output .= "</{$flipTag}>";
				}
			} else {
				$output .= "<{$flipTag} {$this->render_attributes('flip-image')}>";
				$output .= $product->get_image( $image_size, [], true );

				if( $effect == 'fade' && $attachment_ids ) {
					$output .= "</{$flipTag}>";
					$output .= "<div class='hover-img'><{$flipTag} {$this->render_attributes('flip-image')}>";
				}

				if( $attachment_ids ) {
					$this->set_attribute( '_root', 'class', $effect );
					$output .= wp_get_attachment_image( $attachment_ids[0], $image_size, false, [ 'class' => 'show-on-hover back-image' ] );
				}

				$output .= "</{$flipTag}>";

				if( $effect == 'fade' && $attachment_ids ) {
					$output .= "</div>";
				}
			}
		} else {
			$output .= "<{$flipTag} {$this->render_attributes('flip-image')}>";
			$output .= $product->get_image( $image_size, [], true );
			$output .= "</{$flipTag}>";
		}

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		echo $output;
		echo "</{$this->tag}>";
	}
}