<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooPaymentMethods extends \Bricks\Element {
	public $category = 'checkout';
	public $name 	= 'bu-payment-method';
	public $icon 	= 'ti-wallet';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Payment Methods', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['radio'] = [
			'title' 	=> esc_html__( 'Radio Buttons', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['pmbox'] = [
			'title' 	=> esc_html__( 'Description', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		$this->control_groups['paypal'] = [
			'title' 	=> esc_html__( 'Paypal gateway', 'bricksultimate' ),
			'tab' 		=> 'content'
		];

		/*$this->control_groups['cc'] = [
			'title' 	=> esc_html__( 'Credit card', 'bricksultimate' ),
			'tab' 		=> 'content'
		];*/
	}

	// Set builder controls
	public function set_controls() {
		$selector = 'ul.wc_payment_methods';

		$this->controls['pmwpbg'] = [
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector,
				]
			],
		];

		$this->controls['pmBorderW'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Border width', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'border-width',
					'selector' => $selector
				],
				[
					'property' => 'border-bottom-width',
					'selector' => $selector . ' li'
				],
				[
					'property' => 'border-top-width',
					'selector' => $selector . ' .payment_box'
				]
			],
			'default' => '1px'
		];

		$this->controls['pmBorderColor'] = [
			'type' 	=> 'color',
			'label' => esc_html__( 'Border color', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => '--bricks-border-color'
				]
			]
		];

		$this->controls['pmBorderStyle'] = [
			'type' 	=> 'select',
			'label' => esc_html__( 'Border style', 'bricksultimate' ),
			'options' => [ 'none' => 'none', 'solid' => 'Solid', 'dashed' => 'Dashed', 'dotted' => 'Dotted'],
			'css'	=> [
				[
					'property' => 'border-style',
					'selector' => 'ul.wc_payment_methods, ul.wc_payment_methods li'
				]
			],
			'default' => 'solid',
			'inline' => true
		];

		$this->controls['pmBorderRadius'] = [
			'type' 	=> 'number',
			'label' => esc_html__( 'Border radius', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => '--bricks-border-radius'
				]
			],
			'default' => '4px'
		];

		$this->controls['pmSpacing'] = [
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => 'ul.wc_payment_methods li input[type=radio]',
					'important' => true
				]
			],
		];

		$this->controls['pmImgH'] = [
			'type'  => 'number',
			'label' => esc_html__( 'Icon height', 'bricksultimate' ),
			'units' => true,
			'css' 	=> [
				[
					'selector' 	=> 'label img, label span img',
					'property' 	=> 'height',
				]
			]
		];

		$this->controls['pmImgAlignR'] = [
			'type'  => 'checkbox',
			'label' => esc_html__( 'Icon align right', 'bricksultimate' ),
			'css' 	=> [
				[
					'selector' 	=> 'label img, label span img',
					'property' 	=> 'margin-left',
					'value' 	=> 'auto'
				]
			]
		];


		/**
		 * Radio
		 * ----------------------------------------*/
		$this->controls['pmRadioLabel'] = [
			'group' => 'radio',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Label', 'bricksultimate' ),
			'css'	=> [
				[
					'property' => 'font',
					'selector' => '.wc_payment_method label'
				]
			],
		];

		$this->controls['pmRadioGap'] = [
			'group' => 'radio',
			'type' 	=> 'number',
			'label' => esc_html__( 'Gap (Label & radio button)', 'bricksultimate' ),
			'units' => true,
			'css'	=> [
				[
					'property' => 'margin-left',
					'selector' => '.wc_payment_method label'
				]
			],
		];

		$this->controls['pmRadioSep'] = [
			'group' => 'radio',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Radio button', 'bricksultimate' ),
		];

		$rd_selector = '.wc_payment_method input[type=radio]';

		$this->controls['pmRdsize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'placeholder' => '15px',
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $rd_selector,
				],
				[
					'property' => 'height',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['pmRdbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background Color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rd_selector,
				]
			],
		];

		$this->controls['pmRdbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rd_selector,
				]
			]
		];

		$rdc_checked = '.wc_payment_method input[type=radio]:checked';
		$this->controls['pmRdcbg'] = [
			'group' => 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $rdc_checked,
				]
			],
		];

		$this->controls['pmRdcbrd'] = [
			'group' 	=> 'radio',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border(checked)', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $rdc_checked,
				]
			]
		];

		$bullet = '.wc_payment_method input[type=radio]:checked:after';
		$this->controls['pmRdBulletSize'] = [
			'group' => 'radio',
			'type'  	=> 'number',
			'label' 	=> esc_html__( 'Mini bullet size', 'bricksultimate' ),
			'placeholder' 	=> '6px',
			'min' 		=> 1,
			'max' 		=> 30,
			'step' 		=> 1,
			'units' 	=> true,
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $bullet
				],
				[
					'property' => 'height',
					'selector' => $bullet
				]
			],
		];

		$this->controls['pmRdBulletolor'] = [
			'group' 	=> 'radio',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Mini bullet color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $bullet
				]
			],
		];

		$this->controls['pmRdBulletPos'] = [
			'group' 	=> 'radio',
			'type'  	=> 'text',
			'label' 	=> esc_html__( 'Bullet position(Translate)', 'bricksultimate' ),
			'placeholder' => '-50%,-50%',
			'css'   	=> [
				[
					'property' => '--bullet-position',
				]
			],
		];


		/**
		 * Radio
		 * ----------------------------------------*/
		$selector = '.payment_box';

		$this->controls['pmboxTg'] = [
			'group' 	=> 'pmbox',
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Typography(description)', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector . ' p'
				]
			]
		];

		$this->controls['pmboxBg'] = [
			'group' 	=> 'pmbox',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background color', 'bricksultimate' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			],
		];

		$this->controls['pmboxPad'] = [
			'group' 	=> 'pmbox',
			'type'  	=> 'dimensions',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector
				]
			],
		];

		/**
		 * Radio
		 * ----------------------------------------*/
		$this->controls['ppDisableIT'] = [
			'group' => 'paypal',
			'type'  => 'checkbox',
			'label' => esc_html__( 'Hide icon and text', 'bricksultimate' ),
		];

		$this->controls['pphideImage'] = [
			'group' => 'paypal',
			'type'  => 'checkbox',
			'label' => esc_html__( 'Hide icon', 'bricksultimate' ),
			'css' 	=> [
				[
					'selector' 	=> 'label img',
					'property' 	=> 'display',
					'value' 	=> 'none'
				]
			],
			'required' => ['ppDisableIT', '=', false]
		];

		$this->controls['ppLink'] = [
			'group' => 'paypal',
			'type'  => 'checkbox',
			'label' => esc_html__( 'Hide about link', 'bricksultimate' ),
			'css' 	=> [
				[
					'selector' 	=> '.about_paypal',
					'property' 	=> 'display',
					'value' 	=> 'none'
				]
			],
			'required' => ['ppDisableIT', '=', false]
		];

		$this->controls['ppLinkTg'] = [
			'group' => 'paypal',
			'type'  => 'typography',
			'label' => esc_html__( 'About link typography', 'bricksultimate' ),
			'css' 	=> [
				[
					'selector' 	=> '.about_paypal',
					'property' 	=> 'font',
				]
			],
			'required' => ['ppDisableIT', '=', false]
		];

		$this->controls['ppImg'] = [
			'group' => 'paypal',
			'type'  => 'text',
			'label' => esc_html__( 'Icon url', 'bricksultimate' ),
			'placeholder' => esc_html__('enter image url', 'bricksultimate'),
			'required' => ['ppDisableIT', '=', false]
		];

		/**
		 * CC
		 * ----------------------------------------*/
		$selector = '.payment_box input';

		$this->controls['ccBG'] = [
			'group' 	=> 'cc',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['ccTg'] = [
			'group' 	=> 'cc',
			'type'  	=> 'typography',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'font',
					'selector' => $selector
				]
			]
		];

		$this->controls['ccBrd'] = [
			'group' 	=> 'cc',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];


		$selector = '.payment_box input:focus';
		$this->controls['ccInfo'] = [
			'group' 	=> 'cc',
			'type'  	=> 'separator',
			'label' 	=> esc_html__( 'Focus', 'bricks' ),
		];

		$this->controls['ccFBG'] = [
			'group' 	=> 'cc',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Background', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'background-color',
					'selector' => $selector
				]
			]
		];

		$this->controls['ccFTextColor'] = [
			'group' 	=> 'cc',
			'type'  	=> 'color',
			'label' 	=> esc_html__( 'Text color', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'color',
					'selector' => $selector
				]
			]
		];

		$this->controls['ccFBrd'] = [
			'group' 	=> 'cc',
			'type'  	=> 'border',
			'label' 	=> esc_html__( 'Border', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'border',
					'selector' => $selector
				]
			]
		];
	}

	// Enqueue element styles and scripts
	/*public function enqueue_scripts() {
		if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-checkout', Helpers::get_asset_url('css') . 'checkout.min.css', [], filemtime(Helpers::get_asset_path('css') . 'checkout.min.css') );
		} else {
			wp_enqueue_script( 'bu-checkout', Helpers::get_asset_url('js') . 'checkout.min.js', [], filemtime(Helpers::get_asset_path('js') . 'checkout.min.js') );
		}
	}*/

	public function add_filters() {
		if( ! Helpers::isBricksBuilderActive() || ! bricks_is_builder() ) {
			add_filter('woocommerce_update_order_review_fragments', [$this,'update_order_review_fragments'], 99 );
		}
	}

	public function update_order_review_fragments( $fragments ) {
		parse_str( $_POST['post_data'], $params );

		if( empty( $params ) )
			return $fragments;

		if( empty( $params['pm_element_id'] ) )
			return $fragments;

		$post_id = isset( $params['pm_post_id'] ) ? $params['pm_post_id'] : 0;

		$data = \Bricks\Helpers::get_element_data( $post_id, $params['pm_element_id'] );

		$element_instance = new \BricksUltimate\Elements\WooPaymentMethods( $data['element'] );
		$element_instance->load();
		ob_start();
		$element_instance->init();

		$fragments['.woocommerce-checkout-payment'] = ob_get_clean();

		return $fragments;
	}

	public function bu_gateway_icon( $icon_html, $gateway ) {
		$settings = $this->settings;
		if( ! empty($settings['ppDisableIT']) && $gateway == 'paypal' ) {
			return '';
		} elseif( ! empty($settings['ppImg']) && $gateway == 'paypal' ) {
			$base_country = WC()->countries->get_base_country();
			if ( empty( $base_country ) ) {
				return '';
			}

			$icon_html = '<img src="' . esc_url( $settings['ppImg'] ) . '" alt="' . esc_attr__( 'PayPal acceptance mark', 'woocommerce' ) . '" />';
			$icon_html .= sprintf( '<a href="%1$s" class="about_paypal" onclick="javascript:window.open(\'%1$s\',\'WIPaypal\',\'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, width=1060, height=700\'); return false;">' . esc_attr__( 'What is PayPal?', 'woocommerce' ) . '</a>', esc_url( $this->get_icon_url( $base_country ) ) );

		}
		return $icon_html;
	}

	protected function get_icon_url( $country ) {
		$url           = 'https://www.paypal.com/' . strtolower( $country );
		$home_counties = array( 'BE', 'CZ', 'DK', 'HU', 'IT', 'JP', 'NL', 'NO', 'ES', 'SE', 'TR', 'IN' );
		$countries     = array( 'DZ', 'AU', 'BH', 'BQ', 'BW', 'CA', 'CN', 'CW', 'FI', 'FR', 'DE', 'GR', 'HK', 'ID', 'JO', 'KE', 'KW', 'LU', 'MY', 'MA', 'OM', 'PH', 'PL', 'PT', 'QA', 'IE', 'RU', 'BL', 'SX', 'MF', 'SA', 'SG', 'SK', 'KR', 'SS', 'TW', 'TH', 'AE', 'GB', 'US', 'VN' );

		if ( in_array( $country, $home_counties, true ) ) {
			return $url . '/webapps/mpp/home';
		} elseif ( in_array( $country, $countries, true ) ) {
			return $url . '/webapps/mpp/paypal-popup';
		} else {
			return $url . '/cgi-bin/webscr?cmd=xpt/Marketing/general/WIPaypal-outside';
		}
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ) {
			$available_gateways = WC()->payment_gateways()->get_available_payment_gateways();
			WC()->payment_gateways()->set_current_gateway( $available_gateways );

			$this->set_attribute('_root', 'class', ['woocommerce-checkout-payment']);

			echo "<{$this->tag} {$this->render_attributes('_root')}>";
		?>
				<ul class="wc_payment_methods payment_methods methods">
					<?php
					if ( ! empty( $available_gateways ) ) {
						foreach ( $available_gateways as $gateway ) {
							add_filter( 'woocommerce_gateway_icon', [$this, 'bu_gateway_icon' ], 999, 2 );

							wc_get_template( 'checkout/payment-method.php', array( 'gateway' => $gateway ) );

							remove_filter( 'woocommerce_gateway_icon', [$this, 'bu_gateway_icon' ], 999, 2 );
						}
					} else {
						echo '<li>';
						wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ), 'notice' ); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment
						echo '</li>';
					}
					?>
				</ul>
			<?php
			echo "</{$this->tag}>";
			return;
		}

		if ( ! wp_doing_ajax() ) {
			do_action( 'woocommerce_review_order_before_payment' );
			echo "<input type=\"hidden\" value=\"{$this->id}\" name=\"pm_element_id\" >";
			echo "<input type=\"hidden\" value=\"{$this->post_id}\" name=\"pm_post_id\" >";
		}

		$this->set_attribute('_root', 'class', ['woocommerce-checkout-payment']);

		echo "<{$this->tag} {$this->render_attributes('_root')}>";
			if ( WC()->cart->needs_payment() ) {
				$available_gateways = WC()->payment_gateways()->get_available_payment_gateways();
				WC()->payment_gateways()->set_current_gateway( $available_gateways );
		?>
				<ul class="wc_payment_methods payment_methods methods">
					<?php
					if ( ! empty( $available_gateways ) ) {
						foreach ( $available_gateways as $gateway ) {
							add_filter( 'woocommerce_gateway_icon', [$this, 'bu_gateway_icon' ], 999, 2 );

							wc_get_template( 'checkout/payment-method.php', array( 'gateway' => $gateway ) );

							remove_filter( 'woocommerce_gateway_icon', [$this, 'bu_gateway_icon' ], 999, 2 );
						}
					} else {
						echo '<li>';
						wc_print_notice( apply_filters( 'woocommerce_no_available_payment_methods_message', WC()->customer->get_billing_country() ? esc_html__( 'Sorry, it seems that there are no available payment methods. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) : esc_html__( 'Please fill in your details above to see available payment methods.', 'woocommerce' ) ), 'notice' ); // phpcs:ignore WooCommerce.Commenting.CommentHooks.MissingHookComment
						echo '</li>';
					}
					?>
				</ul>
		<?php
			}
		echo "</{$this->tag}>";
	}
}