<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooNewBadge extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-new-badge';
	public $icon 			= 'ti-medall';
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)New Badge', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['size_layout'] = [
			'title' 	=> esc_html__( 'Size & Layout', 'bricksultimate' ),
			'tab' 		=> 'content'
		];
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['info'] = [
			'tab'       => 'content',
			'content'    => esc_html__( 'Builder editor will show the demo value for editing. You will get the correct data at frontend.', 'bricks' ),
			'type'      => 'info'
		];

		$this->controls['builder_mode'] = [
			'tab' 	=> 'content',
			'type' 	=> 'checkbox',
			'label' => __('Hide In-Builder Editor?', 'bricksultimate')
		];

		$this->controls['usingFor'] = [
			'label'     => esc_html__( 'Using in', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'wc' 		=> 'WooCommerce',
				'wp' 		=> 'WP Post or CPT',
			],
			'default'   => 'wc',
		];

		$this->controls['filterBy'] = [
			'label'     => esc_html__( 'Filter by', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'days' 		=> 'Days',
				'cf' 		=> 'Dynamic data(Custom field)',
			],
			'default'   => 'days',
		];

		$this->controls['days'] = [
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Days', 'bricks' ),
			'min' 		=> 0,
			'max' 		=> 10000,
			'step' 		=> 1,
			'default' 	=> 14,
			'unitless' 	=> true,
			'hasDynamicData' => true,
			'medium' 	=> true,
			'description' => esc_html__('Show badge if the product is less than .. days old', 'bricksultimate'),
			'required' 	=> [ 'filterBy', '=', 'days']
		];

		$this->controls['cf_name'] = [
			'label'     => esc_html__( 'Dynamic data', 'bricks' ),
			'type'      => 'text',
			'hasDynamicData' => true,
			'required' 	=> ['filterBy', '=', 'cf']
		];

		$this->controls['cf_value'] = [
			'label'     => esc_html__( 'Returned value', 'bricks' ),
			'type'      => 'text',
			'placeholder' => "new",
			'default' 	=> "new",
			'inline'    => true,
			'hasDynamicData' => true,
			'required' 	=> [ 'filterBy', '=', 'cf']
		];

		$this->controls['badge'] = [
			'tab' 	=> 'content',
			'type' 	=> 'text',
			'label' => esc_html__( 'Badge Text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'New', 'bricksultimate' ),
			'default' => esc_html__( 'New', 'bricksultimate' ),
			'inline'    => true,
			'hasDynamicData' => true,
		];

		$this->controls['tag'] = [
			'tab'       => 'content',
			'label'     => esc_html__( 'Tag', 'bricks' ),
			'type'      => 'select',
			'options'   => [
				'div' 		=> 'div',
				'span' 		=> 'span',
				'p' 		=> 'p',
				'section' 	=> 'section'
			],
			'inline'    => true,
			'clearable' => false,
			'default'   => 'div',
		];

		$this->controls['product_id'] = [
			'tab' 	=> 'content',
			'type' 	=> 'text',
			'label' => esc_html__( 'Product ID', 'bricksultimate' ),
			'info' 	=> esc_html__('Leave it blank if you are using on single product page or repeater.', 'bricksultimate'),
			'inline'    => true,
			'required' => ['usingFor', '=', 'wc']
		];

		$this->controls['badgeSep'] = [
			'group' 	=> 'size_layout',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Size & Spacing', 'bricksultimate' ),
		];

		$this->controls['width'] = [
			'group' 	=> 'size_layout',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'width',
				]
			]
		];

		$this->controls['height'] = [
			'group' 	=> 'size_layout',
			'type'      => 'number',
			'label'     => esc_html__('Height', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'height',
				]
			]
		];

		$this->controls['margin'] = [
			'group' 	=> 'size_layout',
			'type'      => 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'margin',
				]
			]
		];

		$this->controls['padding'] = [
			'group' 	=> 'size_layout',
			'type'      => 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> '',
					'property'  => 'padding',
				]
			]
		];

		$this->controls['badgeSepColor'] = [
			'group' 	=> 'size_layout',
			'type'      => 'separator',
		];

		$this->controls['backgroundColor'] = [
			'group' 	=> 'size_layout',
			'label' 	=> esc_html__( 'Background Color', 'bricks' ),
			'type' 		=> 'color',
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' => 'background-color',
					'selector' => '',
				],
			]
		];

		$this->controls['typography'] = [
			'group' 	=> 'size_layout',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'property' => 'font',
					'selector' => '',
				],
			]
		];

		$this->controls['sepFlex'] = [
			'group' 	=> 'size_layout',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Layout', 'bricks' ),
		];

		// Display
		$this->controls['display'] = [
			'group' 	=> 'size_layout',
			'label'       => esc_html__( 'Display', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'flex'         => 'flex',
				'block'        => 'block',
				'inline-block' => 'inline-block',
				'inline'       => 'inline'
			],
			'inline'      => true,
			'lowercase'   => true,
			'css'         => [
				[
					'property' => 'display',
					'selector' => '',
				],
			],
			'default' 		=> 'flex',
			'placeholder' 	=> 'flex',
		];

		$this->controls['flexWrap'] = [
			'group' 	=> 'size_layout',
			'label'       => esc_html__( 'Flex wrap', 'bricks' ),
			'tooltip'     => [
				'content'  => 'flex-wrap',
				'position' => 'top-left',
			],
			'type'        => 'select',
			'options'     => $this->control_options['flexWrap'],
			'inline'      => true,
			'css'         => [
				[
					'property' => 'flex-wrap',
				],
			],
			'placeholder' => esc_html__( 'No wrap', 'bricks' ),
			'required'    => [ '_display', '=', [ '', 'flex' ] ],
		];

		$this->controls['justifyContent'] = [
			'group' 	=> 'size_layout',
			'label'    => esc_html__( 'Justify Content', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' => [ '_display', '=', [ '', 'flex' ] ],
		];

		$this->controls['alignItems'] = [
			'group' 	=> 'size_layout',
			'label'    => esc_html__( 'Align items', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' => [ '_display', '=', [ '', 'flex' ] ],
		];

		unset( $this->controls['_spacingSeparator'] );
		unset( $this->controls['_margin'] );
		unset( $this->controls['_padding'] );

		unset( $this->controls['_width'] );
		unset( $this->controls['_height'] );
	}

	public function render() {
		global $product;

		$using_for = Helpers::get_value( $this->settings, 'usingFor', 'wc' );
		$filterBy = Helpers::get_value($this->settings, 'filterBy', 'days');
		if( $using_for == 'wc' ) {
			$product_id = Helpers::get_value( $this->settings, 'product_id', false );

			if( empty( $product_id ) || $product_id === false )
				$product_id = $this->post_id;

			if( ! is_object( $product ) ) {
				$product = WC()->product_factory->get_product( $product_id );
			}

			if( $product === false )
				return;

			$created = strtotime( $product->get_date_created() );
			$post_id = $product->get_id();
		} elseif( $using_for == 'wp' ) {
			$wpost = get_post( $this->post_id );
			$created = strtotime( $wpost->post_date );
			$post_id = $this->post_id;
		}

		if( $filterBy == 'days' && ! empty( $created ) ) {
			$newness_in_days 	= bricks_render_dynamic_data( Helpers::get_value( $this->settings, 'days'), $post_id );
			$newness_timestamp 	= time() - ( 60 * 60 * 24 * $newness_in_days );
			$is_new 			= $newness_timestamp < $created;
		} elseif( $filterBy == 'cf' ) {
			$dynamicvalue 	= bricks_render_dynamic_data( Helpers::get_value( $this->settings, 'cf_name'), $post_id );
			$retunredValue 	= bricks_render_dynamic_data( Helpers::get_value( $this->settings, 'cf_value'), $post_id );
			$is_new = (! empty( $dynamicvalue ) && ! empty( $retunredValue ) && $dynamicvalue === $retunredValue ) ? true : false;
		} else {
			$is_new = false;
		}

		if( $is_new ) {
			echo "<{$this->tag} {$this->render_attributes('_root')}>"; 
			echo bricks_render_dynamic_data( $this->settings['badge'], $product->get_id() );
			echo "</{$this->tag}>";
		}
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-new-badge">
			<component
				:is="tag" 
				v-if="settings.badge&&!settings.builder_mode"
			>
				{{settings.badge}}
			</component>
		</script>
		<?php
	}
}