<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\{Helpers, WooCommerce};

class WooMaEndpoints extends \Bricks\Element {
	public $category 	= 'my-account';
	public $name 		= 'bu-ma-endpoint';
	public $icon 		= 'ti-link';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Navigation', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {

		$endpoints = [];
		// Get items from account menu.
		$endpoints = wc_get_account_menu_items();

		// Include missing lost password.
		$endpoints['lost-password'] = __( 'Lost password', 'woocommerce' );
		$endpoints = apply_filters( 'woocommerce_custom_nav_menu_items', $endpoints );

		$this->controls['endpoint'] = [
			'label'    => esc_html__( 'Endpoint', 'bricksultimate' ),
			'type'     => 'select',
			'options'  => $endpoints,
			'placeholder' 	=> esc_html__( 'Select endpoint', 'bricksultimate' ),
		];

		$this->controls['label'] = [
			'label'    => esc_html__( 'Label', 'bricksultimate' ),
			'type'     => 'text',
		];

		$this->controls['ariaLabel'] = [
			'label'    => esc_html__( 'Aria label', 'bricksultimate' ),
			'type'     => 'text',
		];

		$this->controls['iconSep'] = [
			'label'    => esc_html__( 'Icon', 'bricksultimate' ),
			'type'     => 'separator',
		];

		$this->controls['icon'] = [
			'label' 	=> esc_html__('Icon', 'bricksultimate'),
			'type' 		=> 'icon',
		];

		$selector = '.nav--icon';
		$this->controls['iconSize'] = [
			'label' 	=> esc_html__( 'Size', 'bricksultimate' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'required' 	=> [ 'icon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'font-size',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['iconColor'] = [
			'label' 	=> esc_html__( 'Color', 'bricksultimate' ),
			'type' 		=> 'color',
			'required' 	=> [ 'icon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => $selector
				],
				[
					'property' => 'fill',
					'selector' => $selector
				],
			],
			'rerender' => false
		];

		$this->controls['iconHColor'] = [
			'label' 	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type' 		=> 'color',
			'required' 	=> [ 'icon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '&:hover ' . $selector
				],
				[
					'property' => 'fill',
					'selector' => '&:hover ' . $selector
				],
			],
			'rerender' => false
		];

		$this->controls['iconAColor'] = [
			'label' 	=> esc_html__( 'Active color', 'bricksultimate' ),
			'type' 		=> 'color',
			'required' 	=> [ 'icon.icon', '!=', '' ],
			'css' 		=> [
				[
					'property' => 'color',
					'selector' => '&:hover ' . $selector
				],
				[
					'property' => 'fill',
					'selector' => '&.is-active ' . $selector
				],
			],
			'rerender' => false
		];

		$this->controls['iconPosition'] = [
			'type' 		=> 'select',
			'label' 	=> esc_html__('Icon position', 'bricksultimate' ),
			'default' 	=> 'left',
			'options' 	=> [
				'row' 				=> esc_html__('Left', 'bricks'),
				'row-reverse' 		=> esc_html__('Right', 'bricks'),
				'column-reverse' 	=> esc_html__('Top', 'bricks'),
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'property' => 'flex-direction',
					'selector' => ''
				],
			],
			'required' 	=> [ 'icon.icon', '!=', '' ],
			'rerender' => false
		];

		$this->controls['iconGap'] = [
			'label'       => esc_html__( 'Gap', 'bricks' ),
			'type'        => 'number',
			'units'       => true,
			'css'         => [
				[
					'property' => 'gap',
					'selector' => '',
				],
			],
			'required' 	=> [ 'icon.icon', '!=', '' ],
			'rerender' => false
		];

		$this->controls['iconJustifyContent'] = [
			'label'    => esc_html__( 'Align main axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'justify-content',
				'position' => 'top-left',
			],
			'type'     => 'justify-content',
			'css'      => [
				[
					'property' => 'justify-content',
				],
			],
			'required' 	=> [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconAlignItems'] = [
			'label'    => esc_html__( 'Align cross axis', 'bricks' ),
			'tooltip'  => [
				'content'  => 'align-items',
				'position' => 'top-left',
			],
			'type'     => 'align-items',
			'css'      => [
				[
					'property' => 'align-items',
				],
			],
			'required' 	=> [ 'icon.icon', '!=', '' ],
		];

		$selector = '&:hover';

		$this->controls['hoverSep'] = [
			'label'    => esc_html__( 'Hover', 'bricksultimate' ),
			'type'     => 'separator',
		];

		$this->controls['hoverItemBG'] = [
			'label'    => esc_html__( 'Background', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'background-color',
				],
			]
		];

		$this->controls['hoverItemColor'] = [
			'label'    => esc_html__( 'Text color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'color',
				],
			]
		];

		$this->controls['hoverItemBorder'] = [
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			]
		];

		$this->controls['hoverItemBoxShadow'] = [
			'label'    => esc_html__( 'Box shadow', 'bricks' ),
			'type'     => 'box-shadow',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'box-shadow',
				],
			]
		];

		$selector = '&.is-active';

		$this->controls['activeSep'] = [
			'label'    => esc_html__( 'Active', 'bricksultimate' ),
			'type'     => 'separator',
		];

		$this->controls['activeItemBG'] = [
			'label'    => esc_html__( 'Background', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'background-color',
				],
			]
		];

		$this->controls['activeItemColor'] = [
			'label'    => esc_html__( 'Text color', 'bricks' ),
			'type'     => 'color',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'color',
				],
			]
		];

		$this->controls['activeItemBorder'] = [
			'label'    => esc_html__( 'Border', 'bricks' ),
			'type'     => 'border',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'border',
				],
			]
		];

		$this->controls['activeItemBoxShadow'] = [
			'label'    => esc_html__( 'Box shadow', 'bricks' ),
			'type'     => 'box-shadow',
			'css'      => [
				[
					'selector' => $selector,
					'property' => 'box-shadow',
				],
			]
		];
	}

	// Enqueue element styles and scripts
	/*public function enqueue_scripts() {
		if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-ma-endpoint', Helpers::get_asset_url('css') . 'manav.min.css', [], filemtime(Helpers::get_asset_path('css') . 'manav.min.css'), 'all' );
		}
	}*/

	// Render element HTML
	public function render() {
		$settings = $this->settings;
		$endpoint = Helpers::get_value( $settings, 'endpoint', false );
		$label = Helpers::get_value( $settings, 'label', false );
		$ariaLabel = Helpers::get_value( $settings, 'ariaLabel', false );

		if( $endpoint === false ) {
			return $this->render_element_placeholder(
				[
					'title'       => esc_html__( 'Please select an endpoint.', 'bricksultimate' )
				]
			);
		}

		if( $label === false ) {
			$endpoints = wc_get_account_menu_items();

			// Include missing lost password.
			$endpoints['lost-password'] = __( 'Lost password', 'woocommerce' );
			$endpoints = apply_filters( 'woocommerce_custom_nav_menu_items', $endpoints );

			$label = $endpoints[ $endpoint ];
		}

		if( $endpoint ) {
			$this->set_attribute('_root', 'class', [ wc_get_account_menu_item_classes( $endpoint ) ] );
			
			if( $ariaLabel )
				$this->set_attribute('_root', 'aria-label', esc_html( bricks_render_dynamic_data( $ariaLabel ) ) );

			$this->set_attribute('_root', 'href', esc_url_raw( wc_get_account_endpoint_url( $endpoint ) ) );

			echo "<a {$this->render_attributes('_root')}>";

			if( isset( $settings['icon'] ) ) {
			 echo self::render_icon( $settings['icon'], ['nav--icon'] );
			}

			echo esc_html( bricks_render_dynamic_data( $label ) );
			echo "</a>";
		}
	}
}